/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarCache;
import edu.umass.cs.benchlab.har.HarCustomFields;
import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarEntryTimings;
import edu.umass.cs.benchlab.har.HarRequest;
import edu.umass.cs.benchlab.har.HarResponse;
import edu.umass.cs.benchlab.har.HarWarning;
import edu.umass.cs.benchlab.har.ISO8601DateFormatter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarEntry
implements Comparable<HarEntry> {
    public static String TABLE_NAME = "entries";
    private String pageRef;
    private Date startedDateTime;
    private Long time;
    private HarRequest request;
    private HarResponse response;
    private HarCache cache;
    private HarEntryTimings timings;
    private String serverIPAddress;
    private String connection;
    private String comment;
    private HarCustomFields customFields = new HarCustomFields();

    public HarEntry(Date startedDateTime, long time, HarRequest request, HarResponse response, HarCache cache, HarEntryTimings timings) {
        this.startedDateTime = startedDateTime;
        this.time = time;
        this.request = request;
        this.response = response;
        this.cache = cache;
        this.timings = timings;
    }

    public HarEntry(String pageRef, Date startedDateTime, long time, HarRequest request, HarResponse response, HarCache cache, HarEntryTimings timings, String serverIPAddress, String connection, String comment) {
        this.pageRef = pageRef;
        this.startedDateTime = startedDateTime;
        this.time = time;
        this.request = request;
        this.response = response;
        this.cache = cache;
        this.timings = timings;
        this.serverIPAddress = serverIPAddress;
        this.connection = connection;
        this.comment = comment;
    }

    public HarEntry(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new JsonParseException("{ missing after \"entries\" element", jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            if ("pageref".equals(name)) {
                this.setPageRef(jp.getText());
                continue;
            }
            if ("startedDateTime".equals(name)) {
                try {
                    if (jp.getCurrentName().equals(jp.getText())) {
                        jp.nextToken();
                    }
                    this.setStartedDateTime(ISO8601DateFormatter.parseDate(jp.getText()));
                    continue;
                }
                catch (ParseException e) {
                    throw new JsonParseException("Invalid date format '" + jp.getText() + "'", jp.getCurrentLocation());
                }
            }
            if ("time".equals(name)) {
                this.setTime(jp.getValueAsLong());
                continue;
            }
            if ("request".equals(name)) {
                this.setRequest(new HarRequest(jp, warnings));
                continue;
            }
            if ("response".equals(name)) {
                this.setResponse(new HarResponse(jp, warnings));
                continue;
            }
            if ("cache".equals(name)) {
                this.setCache(new HarCache(jp, warnings));
                continue;
            }
            if ("timings".equals(name)) {
                this.setTimings(new HarEntryTimings(jp, warnings));
                continue;
            }
            if ("serverIPAddress".equals(name)) {
                this.setServerIPAddress(jp.getText());
                continue;
            }
            if ("connection".equals(name)) {
                this.setConnection(jp.getText());
                continue;
            }
            if ("comment".equals(name)) {
                this.setComment(jp.getText());
                continue;
            }
            if (name != null && name.startsWith("_")) {
                this.customFields.addHarCustomFields(name, jp);
                continue;
            }
            throw new JsonParseException("Unrecognized field '" + name + "' in page element", jp.getCurrentLocation());
        }
        if (this.startedDateTime == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing startedDateTime field in entries element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing startedDateTime field in entries element", jp.getCurrentLocation());
            }
        }
        if (this.time == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing time field in entries element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing time field in entries element", jp.getCurrentLocation());
            }
        }
        if (this.request == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing request field in entries element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing request field in entries element", jp.getCurrentLocation());
            }
        }
        if (this.response == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing response field in entries element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing response field in entries element", jp.getCurrentLocation());
            }
        }
        if (this.cache == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing cache field in entries element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing cache field in entries element", jp.getCurrentLocation());
            }
        }
        if (this.timings == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing timings field in entries element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing timings field in entries element", jp.getCurrentLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarEntry(HarDatabaseConfig config, long entryId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + "entries";
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("SELECT page_ref,start_date,time,server_ip,connexion,comment FROM " + tableName + " WHERE entry_id=?");
            ps.setLong(1, entryId);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("No HarEntry for page id " + entryId + " found in database");
            }
            this.setPageRef(rs.getString(1));
            this.setStartedDateTime(rs.getTimestamp(2));
            this.setTime(rs.getLong(3));
            this.setServerIPAddress(rs.getString(4));
            this.setConnection(rs.getString(5));
            this.setComment(rs.getString(6));
            this.request = new HarRequest(config, entryId);
            this.response = new HarResponse(config, entryId);
            try {
                this.cache = new HarCache(config, entryId);
            }
            catch (SQLException e) {
                this.cache = new HarCache();
            }
            this.timings = new HarEntryTimings(config, entryId);
            this.customFields.readCustomFieldsJDBC(config, HarCustomFields.Type.HARENTRY, entryId);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeStartObject();
        if (this.pageRef != null) {
            g.writeStringField("pageref", this.pageRef);
        }
        g.writeStringField("startedDateTime", ISO8601DateFormatter.format(this.startedDateTime));
        g.writeNumberField("time", this.time.longValue());
        this.request.writeHar(g);
        this.response.writeHar(g);
        if (this.cache != null) {
            this.cache.writeHar(g);
        }
        this.timings.writeHar(g);
        if (this.serverIPAddress != null) {
            g.writeStringField("serverIPAddress", this.serverIPAddress);
        }
        if (this.connection != null) {
            g.writeStringField("connection", this.connection);
        }
        if (this.comment != null) {
            g.writeStringField("comment", this.comment);
        }
        this.customFields.writeHar(g);
        g.writeEndObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJDBC(long logId, PreparedStatement entryPs, HarDatabaseConfig config) throws SQLException {
        ResultSet rs = null;
        try {
            entryPs.setString(1, this.pageRef);
            entryPs.setTimestamp(2, new Timestamp(this.startedDateTime.getTime()));
            entryPs.setLong(3, this.time);
            entryPs.setString(4, this.serverIPAddress);
            entryPs.setString(5, this.connection);
            if (this.comment == null) {
                entryPs.setNull(6, -1);
            } else {
                entryPs.setString(6, this.comment);
            }
            entryPs.setLong(7, logId);
            entryPs.executeUpdate();
            rs = entryPs.getGeneratedKeys();
            if (!rs.next()) {
                throw new SQLException("The database did not generate a key for an HarEntry row");
            }
            long entryId = rs.getLong(1);
            this.request.writeJDBC(entryId, config, logId);
            this.response.writeJDBC(entryId, config, logId);
            if (this.cache != null) {
                this.cache.writeJDBC(entryId, config, logId);
            }
            this.timings.writeJDBC(entryId, config, logId);
            this.customFields.writeCustomFieldsJDBC(config, HarCustomFields.Type.HARENTRY, entryId, logId);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void deleteFromJDBC(HarDatabaseConfig config, long logId, boolean dropTables) throws SQLException {
        this.request.deleteFromJDBC(config, logId, dropTables);
        this.response.deleteFromJDBC(config, logId, dropTables);
        if (dropTables) {
            return;
        }
        if (this.cache != null) {
            this.cache.deleteFromJDBC(config, logId);
        }
        this.timings.deleteFromJDBC(config, logId);
    }

    public String getPageRef() {
        return this.pageRef;
    }

    public void setPageRef(String pageRef) {
        this.pageRef = pageRef;
    }

    public Date getStartedDateTime() {
        return this.startedDateTime;
    }

    public void setStartedDateTime(Date startedDateTime) {
        this.startedDateTime = startedDateTime;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public HarRequest getRequest() {
        return this.request;
    }

    public void setRequest(HarRequest request) {
        this.request = request;
    }

    public HarResponse getResponse() {
        return this.response;
    }

    public void setResponse(HarResponse response) {
        this.response = response;
    }

    public HarCache getCache() {
        return this.cache;
    }

    public void setCache(HarCache cache) {
        this.cache = cache;
    }

    public HarEntryTimings getTimings() {
        return this.timings;
    }

    public void setTimings(HarEntryTimings timings) {
        this.timings = timings;
    }

    public String getServerIPAddress() {
        return this.serverIPAddress;
    }

    public void setServerIPAddress(String serverIPAddress) {
        this.serverIPAddress = serverIPAddress;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public HarCustomFields getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(HarCustomFields customFields) {
        this.customFields = customFields;
    }

    public String toString() {
        return "{ \"pageref\": \"" + this.pageRef + "\",  \"startedDateTime\": \"" + ISO8601DateFormatter.format(this.startedDateTime) + "\", \"time\": \"" + this.time + "\", " + this.request + ", " + this.response + ", " + this.cache + ", " + this.timings + ", \"serverIPAddress\": \"" + this.serverIPAddress + "\", \"connection\": \"" + this.connection + "\", \"comment\": \"" + this.comment + "\", " + this.customFields + "}\n";
    }

    @Override
    public int compareTo(HarEntry o) {
        return this.startedDateTime.compareTo(o.getStartedDateTime());
    }
}

