/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.callback;

import java.io.Serializable;

public interface RemoteStatus {
    public void addedDirectory(String var1);

    public void addedFile(String var1);

    public void addedSymlink(String var1);

    public void modifiedDirectory(String var1, boolean var2, boolean var3, Entry var4);

    public void modifiedFile(String var1, boolean var2, boolean var3, Entry var4);

    public void modifiedSymlink(String var1, boolean var2, boolean var3, Entry var4);

    public void deleted(String var1);

    public static class Entry
    implements Comparable<Entry>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String uuid;
        private String author;
        private long revision;
        private long timestamp;

        public Entry(String string, String string2, long l, long l2) {
            this.uuid = string;
            this.author = string2;
            this.revision = l;
            this.timestamp = l2;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getLastAuthor() {
            return this.author;
        }

        public long getCommittedRevision() {
            return this.revision;
        }

        public long getCommittedTimestamp() {
            return this.timestamp;
        }

        @Override
        public int compareTo(Entry entry) {
            if (this == entry) {
                return 0;
            }
            int n = this.uuid.compareTo(entry.uuid);
            if (n == 0 && (n = this.author.compareTo(entry.author)) == 0) {
                int n2 = this.revision < entry.revision ? 1 : (n = this.revision > entry.revision ? -1 : 0);
                if (n == 0) {
                    n = this.timestamp < entry.timestamp ? 1 : (this.timestamp > entry.timestamp ? -1 : 0);
                }
            }
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object) || this.getClass() != object.getClass()) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.uuid == entry.uuid && this.author == entry.author && this.revision == entry.revision && this.timestamp == entry.timestamp;
        }

        public int hashCode() {
            int n = this.uuid == null ? 0 : this.uuid.hashCode();
            n = 33 * n + (this.author == null ? 0 : this.author.hashCode());
            n = 33 * n + (int)(this.revision >> 32) & 0xFFFFFFFF;
            n = 33 * n + (int)this.revision & 0xFFFFFFFF;
            n = 33 * n + (int)(this.timestamp >> 32) & 0xFFFFFFFF;
            n = 33 * n + (int)this.timestamp & 0xFFFFFFFF;
            return n;
        }
    }
}

