/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Iterator;
import java.util.Map;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;

abstract class FieldType
extends AbstractIdentifiedType {
    private static final long serialVersionUID = 1681767054884098122L;
    private final int minimumOccurs;
    private final int maximumOccurs;

    FieldType(Map<String, ?> map, int n, int n2) {
        super(map);
        if (n < 0 || n2 < n) {
            throw new IllegalArgumentException(Errors.format((short)60, n, n2));
        }
        this.minimumOccurs = n;
        this.maximumOccurs = n2;
    }

    public int getMinimumOccurs() {
        return this.minimumOccurs;
    }

    public int getMaximumOccurs() {
        return this.maximumOccurs;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 37 * (this.minimumOccurs + 31 * this.maximumOccurs);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            FieldType fieldType = (FieldType)object;
            return this.minimumOccurs == fieldType.minimumOccurs && this.maximumOccurs == fieldType.maximumOccurs;
        }
        return false;
    }

    static StringBuilder toString(boolean bl, String string, GenericName genericName, Object object) {
        StringBuilder stringBuilder = new StringBuilder(40);
        if (bl) {
            stringBuilder.append("Deprecated");
        }
        stringBuilder.append(string).append('[');
        if (genericName != null) {
            stringBuilder.append('\u201c');
        }
        stringBuilder.append(genericName);
        if (genericName != null) {
            stringBuilder.append("\u201d : ");
        }
        return stringBuilder.append(object).append(']');
    }

    static StringBuilder toString(boolean bl, String string, GenericName genericName, Object object, Iterator<?> iterator) {
        StringBuilder stringBuilder = FieldType.toString(bl, string, genericName, object);
        if (iterator.hasNext()) {
            Object obj = iterator.next();
            boolean bl2 = iterator.hasNext();
            stringBuilder.append(" = ");
            if (bl2) {
                stringBuilder.append('{');
            }
            stringBuilder.append(obj);
            if (bl2) {
                stringBuilder.append(", ").append(iterator.next());
                if (iterator.hasNext()) {
                    stringBuilder.append(", ...");
                }
                stringBuilder.append('}');
            }
        }
        return stringBuilder;
    }
}

