/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import thredds.catalog.ServiceType;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.builder.ThreddsBuilderFactory;
import thredds.catalog2.xml.names.ServiceElementNames;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.PropertyElementParser;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;

class ServiceElementParser
extends AbstractElementParser {
    private final CatalogBuilder parentCatalogBuilder;
    private final ServiceBuilder parentServiceBuilder;
    private final Factory serviceElemParserFactory;
    private final PropertyElementParser.Factory propertyElemParserFactory;
    private ServiceBuilder selfBuilder;

    private ServiceElementParser(QName elementName, XMLEventReader reader, ThreddsBuilderFactory builderFactory, CatalogBuilder parentCatalogBuilder) {
        super(elementName, reader, builderFactory);
        this.parentCatalogBuilder = parentCatalogBuilder;
        this.parentServiceBuilder = null;
        this.serviceElemParserFactory = new Factory();
        this.propertyElemParserFactory = new PropertyElementParser.Factory();
    }

    private ServiceElementParser(QName elementName, XMLEventReader reader, ThreddsBuilderFactory builderFactory, ServiceBuilder parentServiceBuilder) {
        super(elementName, reader, builderFactory);
        this.parentCatalogBuilder = null;
        this.parentServiceBuilder = parentServiceBuilder;
        this.serviceElemParserFactory = new Factory();
        this.propertyElemParserFactory = new PropertyElementParser.Factory();
    }

    @Override
    ServiceBuilder getSelfBuilder() {
        return this.selfBuilder;
    }

    @Override
    void parseStartElement() throws ThreddsXmlParserException {
        Attribute descriptionAtt;
        StartElement startElement = this.getNextEventIfStartElementIsMine();
        Attribute nameAtt = startElement.getAttributeByName(ServiceElementNames.ServiceElement_Name);
        String name = nameAtt.getValue();
        Attribute serviceTypeAtt = startElement.getAttributeByName(ServiceElementNames.ServiceElement_ServiceType);
        ServiceType serviceType = ServiceType.getType(serviceTypeAtt.getValue());
        Attribute baseUriAtt = startElement.getAttributeByName(ServiceElementNames.ServiceElement_Base);
        String baseUriString = baseUriAtt.getValue();
        URI baseUri = null;
        try {
            baseUri = new URI(baseUriString);
        }
        catch (URISyntaxException e) {
            this.log.error("parseElement(): Bad service base URI [" + baseUriString + "]: " + e.getMessage(), (Throwable)e);
            throw new ThreddsXmlParserException("Bad service base URI [" + baseUriString + "]", e);
        }
        if (this.parentCatalogBuilder != null) {
            this.selfBuilder = this.parentCatalogBuilder.addService(name, serviceType, baseUri);
        } else if (this.parentServiceBuilder != null) {
            this.selfBuilder = this.parentServiceBuilder.addService(name, serviceType, baseUri);
        } else {
            throw new ThreddsXmlParserException("");
        }
        Attribute suffixAtt = startElement.getAttributeByName(ServiceElementNames.ServiceElement_Suffix);
        if (suffixAtt != null) {
            this.selfBuilder.setSuffix(suffixAtt.getValue());
        }
        if ((descriptionAtt = startElement.getAttributeByName(ServiceElementNames.ServiceElement_Description)) != null) {
            this.selfBuilder.setSuffix(descriptionAtt.getValue());
        }
    }

    @Override
    void handleChildStartElement() throws ThreddsXmlParserException {
        StartElement startElement = this.peekAtNextEventIfStartElement();
        if (this.serviceElemParserFactory.isEventMyStartElement(startElement)) {
            ServiceElementParser serviceElemParser = this.serviceElemParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder);
            serviceElemParser.parse();
        } else if (this.propertyElemParserFactory.isEventMyStartElement(startElement)) {
            PropertyElementParser parser = this.propertyElemParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder);
            parser.parse();
        } else {
            StaxThreddsXmlParserUtils.consumeElementAndConvertToXmlString(this.reader);
        }
    }

    @Override
    void postProcessingAfterEndElement() throws ThreddsXmlParserException {
    }

    static class Factory {
        private QName elementName = ServiceElementNames.ServiceElement;

        Factory() {
        }

        boolean isEventMyStartElement(XMLEvent event) {
            return StaxThreddsXmlParserUtils.isEventStartOrEndElementWithMatchingName(event, this.elementName);
        }

        ServiceElementParser getNewParser(XMLEventReader reader, ThreddsBuilderFactory builderFactory, CatalogBuilder parentCatalogBuilder) {
            return new ServiceElementParser(this.elementName, reader, builderFactory, parentCatalogBuilder);
        }

        ServiceElementParser getNewParser(XMLEventReader reader, ThreddsBuilderFactory builderFactory, ServiceBuilder parentServiceBuilder) {
            return new ServiceElementParser(this.elementName, reader, builderFactory, parentServiceBuilder);
        }
    }
}

