/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.rules.ImmutableMinusToDistinctRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.immutables.value.Value;

@Value.Enclosing
public class MinusToDistinctRule
extends RelRule<Config>
implements TransformationRule {
    protected MinusToDistinctRule(Config config) {
        super(config);
    }

    @Deprecated
    public MinusToDistinctRule(Class<? extends Minus> minusClass, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(minusClass));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Minus minus = (Minus)call.rel(0);
        if (minus.all) {
            return;
        }
        RelOptCluster cluster = minus.getCluster();
        RelBuilder relBuilder = call.builder();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        int branchCount = minus.getInputs().size();
        for (int i = 0; i < branchCount; ++i) {
            relBuilder.push(minus.getInput(i));
            relBuilder.projectPlus(relBuilder.literal(new BigDecimal(i)));
        }
        relBuilder.union(true, branchCount);
        RelNode union = relBuilder.peek();
        int originalFieldCnt = union.getRowType().getFieldCount() - 1;
        ImmutableList.Builder projects = ImmutableList.builder();
        projects.addAll(Util.first(relBuilder.fields(), originalFieldCnt));
        for (int i = 0; i < branchCount; ++i) {
            projects.add((Object)relBuilder.equals(relBuilder.field(originalFieldCnt), relBuilder.literal(new BigDecimal(i))));
        }
        relBuilder.project((Iterable<? extends RexNode>)projects.build());
        ImmutableList.Builder aggCalls = ImmutableList.builder();
        for (int i = 0; i < branchCount; ++i) {
            aggCalls.add((Object)relBuilder.countStar(null).filter(relBuilder.field(originalFieldCnt + i)));
        }
        ImmutableBitSet groupSet = ImmutableBitSet.range(originalFieldCnt);
        relBuilder.aggregate(relBuilder.groupKey(groupSet), (Iterable<? extends RelBuilder.AggCall>)aggCalls.build());
        ImmutableList.Builder filters = ImmutableList.builder();
        for (int i = 0; i < branchCount; ++i) {
            SqlBinaryOperator operator = i == 0 ? SqlStdOperatorTable.GREATER_THAN : SqlStdOperatorTable.EQUALS;
            filters.add((Object)rexBuilder.makeCall((SqlOperator)operator, relBuilder.field(originalFieldCnt + i), relBuilder.literal(new BigDecimal(0))));
        }
        relBuilder.filter((Iterable<? extends RexNode>)filters.build());
        relBuilder.project(Util.first(relBuilder.fields(), originalFieldCnt));
        call.transformTo(relBuilder.build());
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableMinusToDistinctRule.Config.of().withOperandFor(LogicalMinus.class);

        @Override
        default public MinusToDistinctRule toRule() {
            return new MinusToDistinctRule(this);
        }

        default public Config withOperandFor(Class<? extends Minus> minusClass) {
            return this.withOperandSupplier(b -> b.operand(minusClass).anyInputs()).as(Config.class);
        }
    }
}

