/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.internal.hppc.IntDoubleHashMap;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;

public class CachingDoubleValueSource
extends DoubleValuesSource {
    final DoubleValuesSource source;
    final IntDoubleHashMap cache;

    public CachingDoubleValueSource(DoubleValuesSource source) {
        this.source = source;
        this.cache = new IntDoubleHashMap();
    }

    public String toString() {
        return "Cached[" + this.source.toString() + "]";
    }

    public DoubleValues getValues(LeafReaderContext readerContext, DoubleValues scores) throws IOException {
        final int base = readerContext.docBase;
        final DoubleValues vals = this.source.getValues(readerContext, scores);
        return new DoubleValues(){
            int doc = -1;

            public double doubleValue() throws IOException {
                double v;
                int key = base + this.doc;
                int index = CachingDoubleValueSource.this.cache.indexOf(key);
                if (index < 0) {
                    v = vals.doubleValue();
                    CachingDoubleValueSource.this.cache.indexInsert(index, key, v);
                } else {
                    v = CachingDoubleValueSource.this.cache.indexGet(index);
                }
                return v;
            }

            public boolean advanceExact(int doc) throws IOException {
                this.doc = doc;
                return vals.advanceExact(doc);
            }
        };
    }

    public boolean needsScores() {
        return false;
    }

    public boolean isCacheable(LeafReaderContext ctx) {
        return this.source.isCacheable(ctx);
    }

    public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
        return this.source.explain(ctx, docId, scoreExplanation);
    }

    public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
        return new CachingDoubleValueSource(this.source.rewrite(searcher));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CachingDoubleValueSource that = (CachingDoubleValueSource)((Object)o);
        return !(this.source != null ? !this.source.equals((Object)that.source) : that.source != null);
    }

    public int hashCode() {
        return this.source != null ? this.source.hashCode() : 0;
    }
}

