/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.Http2ClusterStateProvider;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.LBHttp2SolrClient;
import org.apache.solr.client.solrj.impl.SolrZkClientTimeout;
import org.apache.solr.client.solrj.request.RequestWriter;

public class CloudHttp2SolrClient
extends CloudSolrClient {
    private final ClusterStateProvider stateProvider;
    private final LBHttp2SolrClient lbClient;
    private final Http2SolrClient myClient;
    private final boolean clientIsInternal;

    protected CloudHttp2SolrClient(Builder builder) {
        super(builder.shardLeadersOnly, builder.parallelUpdates, builder.directUpdatesToLeadersOnly);
        this.clientIsInternal = builder.httpClient == null;
        this.myClient = this.createOrGetHttpClientFromBuilder(builder);
        this.stateProvider = this.createClusterStateProvider(builder);
        this.retryExpiryTimeNano = builder.retryExpiryTimeNano;
        this.defaultCollection = builder.defaultCollection;
        if (builder.requestWriter != null) {
            this.myClient.requestWriter = builder.requestWriter;
        }
        if (builder.responseParser != null) {
            this.myClient.setParser(builder.responseParser);
        }
        this.collectionStateCache.timeToLiveMs = TimeUnit.MILLISECONDS.convert(builder.timeToLiveSeconds, TimeUnit.SECONDS);
        this.locks = CloudHttp2SolrClient.objectList(builder.parallelCacheRefreshesLocks);
        this.lbClient = new LBHttp2SolrClient.Builder(this.myClient, new String[0]).build();
    }

    private Http2SolrClient createOrGetHttpClientFromBuilder(Builder builder) {
        if (builder.httpClient != null) {
            return builder.httpClient;
        }
        if (builder.internalClientBuilder != null) {
            return builder.internalClientBuilder.build();
        }
        return new Http2SolrClient.Builder().build();
    }

    private ClusterStateProvider createClusterStateProvider(Builder builder) {
        if (builder.stateProvider != null) {
            return builder.stateProvider;
        }
        if (builder.zkHosts.isEmpty()) {
            return this.createHttp2ClusterStateProvider(builder.solrUrls, this.myClient);
        }
        return this.createZkClusterStateProvider(builder);
    }

    private ClusterStateProvider createZkClusterStateProvider(Builder builder) {
        try {
            ClusterStateProvider stateProvider = ClusterStateProvider.newZkClusterStateProvider(builder.zkHosts, builder.zkChroot, builder.canUseZkACLs);
            if (stateProvider instanceof SolrZkClientTimeout.SolrZkClientTimeoutAware) {
                SolrZkClientTimeout.SolrZkClientTimeoutAware timeoutAware = (SolrZkClientTimeout.SolrZkClientTimeoutAware)((Object)stateProvider);
                timeoutAware.setZkClientTimeout(builder.zkClientTimeout);
                timeoutAware.setZkConnectTimeout(builder.zkConnectTimeout);
            }
            return stateProvider;
        }
        catch (Exception e) {
            this.closeMyClientIfNeeded();
            throw e;
        }
    }

    private ClusterStateProvider createHttp2ClusterStateProvider(List<String> solrUrls, Http2SolrClient httpClient) {
        try {
            return new Http2ClusterStateProvider(solrUrls, httpClient);
        }
        catch (Exception e) {
            this.closeMyClientIfNeeded();
            throw new RuntimeException("Couldn't initialize a HttpClusterStateProvider (is/are the Solr server(s), " + String.valueOf(solrUrls) + ", down?)", e);
        }
    }

    private void closeMyClientIfNeeded() {
        try {
            if (this.clientIsInternal && this.myClient != null) {
                this.myClient.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception on closing myClient", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.stateProvider.close();
        this.lbClient.close();
        this.closeMyClientIfNeeded();
        super.close();
    }

    @Override
    public LBHttp2SolrClient getLbClient() {
        return this.lbClient;
    }

    @Override
    public ClusterStateProvider getClusterStateProvider() {
        return this.stateProvider;
    }

    public Http2SolrClient getHttpClient() {
        return this.myClient;
    }

    public static class Builder {
        protected Collection<String> zkHosts = new ArrayList<String>();
        protected List<String> solrUrls = new ArrayList<String>();
        protected String zkChroot;
        protected Http2SolrClient httpClient;
        protected boolean shardLeadersOnly = true;
        protected boolean directUpdatesToLeadersOnly = false;
        protected boolean parallelUpdates = true;
        protected ClusterStateProvider stateProvider;
        protected Http2SolrClient.Builder internalClientBuilder;
        private RequestWriter requestWriter;
        private ResponseParser responseParser;
        private long retryExpiryTimeNano = TimeUnit.NANOSECONDS.convert(3L, TimeUnit.SECONDS);
        private String defaultCollection;
        private long timeToLiveSeconds = 60L;
        private int parallelCacheRefreshesLocks = 3;
        private int zkConnectTimeout = SolrZkClientTimeout.DEFAULT_ZK_CONNECT_TIMEOUT;
        private int zkClientTimeout = SolrZkClientTimeout.DEFAULT_ZK_CLIENT_TIMEOUT;
        private boolean canUseZkACLs = true;

        public Builder(List<String> solrUrls) {
            this.solrUrls = solrUrls;
        }

        public Builder(List<String> zkHosts, Optional<String> zkChroot) {
            this.zkHosts = zkHosts;
            if (zkChroot.isPresent()) {
                this.zkChroot = zkChroot.get();
            }
        }

        public Builder(ClusterStateProvider stateProvider) {
            this.stateProvider = stateProvider;
        }

        public Builder canUseZkACLs(boolean canUseZkACLs) {
            this.canUseZkACLs = canUseZkACLs;
            return this;
        }

        public Builder sendUpdatesOnlyToShardLeaders() {
            this.shardLeadersOnly = true;
            return this;
        }

        public Builder sendUpdatesToAnyReplica() {
            this.shardLeadersOnly = false;
            return this;
        }

        public Builder sendDirectUpdatesToShardLeadersOnly() {
            this.directUpdatesToLeadersOnly = true;
            return this;
        }

        public Builder sendDirectUpdatesToAnyShardReplica() {
            this.directUpdatesToLeadersOnly = false;
            return this;
        }

        public Builder withRequestWriter(RequestWriter requestWriter) {
            this.requestWriter = requestWriter;
            return this;
        }

        public Builder withResponseParser(ResponseParser responseParser) {
            this.responseParser = responseParser;
            return this;
        }

        public Builder withParallelUpdates(boolean parallelUpdates) {
            this.parallelUpdates = parallelUpdates;
            return this;
        }

        @Deprecated(since="9.2")
        public Builder setParallelCacheRefreshes(int parallelCacheRefreshesLocks) {
            this.withParallelCacheRefreshes(parallelCacheRefreshesLocks);
            return this;
        }

        public Builder withParallelCacheRefreshes(int parallelCacheRefreshesLocks) {
            this.parallelCacheRefreshesLocks = parallelCacheRefreshesLocks;
            return this;
        }

        @Deprecated(since="9.2")
        public Builder setRetryExpiryTime(int secs) {
            this.withRetryExpiryTime(secs, TimeUnit.SECONDS);
            return this;
        }

        public Builder withRetryExpiryTime(long expiryTime, TimeUnit unit) {
            this.retryExpiryTimeNano = TimeUnit.NANOSECONDS.convert(expiryTime, unit);
            return this;
        }

        public Builder withDefaultCollection(String defaultCollection) {
            this.defaultCollection = defaultCollection;
            return this;
        }

        @Deprecated(since="9.2")
        public Builder withCollectionCacheTtl(int timeToLiveSeconds) {
            this.withCollectionCacheTtl(timeToLiveSeconds, TimeUnit.SECONDS);
            return this;
        }

        public Builder withCollectionCacheTtl(long timeToLive, TimeUnit unit) {
            assert (timeToLive > 0L);
            this.timeToLiveSeconds = TimeUnit.SECONDS.convert(timeToLive, unit);
            return this;
        }

        @Deprecated(since="9.9")
        public Builder withHttpClient(Http2SolrClient httpSolrClient) {
            if (this.internalClientBuilder != null) {
                throw new IllegalStateException("The builder can't accept an httpClient AND an internalClientBuilder, only one of those can be provided");
            }
            this.httpClient = httpSolrClient;
            return this;
        }

        public Builder withHttpClientBuilder(Http2SolrClient.Builder internalClientBuilder) {
            if (this.httpClient != null) {
                throw new IllegalStateException("The builder can't accept an httpClient AND an internalClientBuilder, only one of those can be provided");
            }
            this.internalClientBuilder = internalClientBuilder;
            return this;
        }

        @Deprecated(since="9.10")
        public Builder withInternalClientBuilder(Http2SolrClient.Builder internalClientBuilder) {
            return this.withHttpClientBuilder(internalClientBuilder);
        }

        public Builder withZkConnectTimeout(int zkConnectTimeout, TimeUnit unit) {
            this.zkConnectTimeout = Math.toIntExact(unit.toMillis(zkConnectTimeout));
            return this;
        }

        public Builder withZkClientTimeout(int zkClientTimeout, TimeUnit unit) {
            this.zkClientTimeout = Math.toIntExact(unit.toMillis(zkClientTimeout));
            return this;
        }

        public CloudHttp2SolrClient build() {
            int providedOptions = 0;
            if (!this.zkHosts.isEmpty()) {
                ++providedOptions;
            }
            if (!this.solrUrls.isEmpty()) {
                ++providedOptions;
            }
            if (this.stateProvider != null) {
                ++providedOptions;
            }
            if (providedOptions > 1) {
                throw new IllegalArgumentException("Only one of zkHost(s), solrUrl(s), or stateProvider should be specified.");
            }
            if (providedOptions == 0) {
                throw new IllegalArgumentException("One of zkHosts, solrUrls, or stateProvider must be specified.");
            }
            return new CloudHttp2SolrClient(this);
        }
    }
}

