/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.options.OptDropdown;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.RunBlockingProblem;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.RunBlockingProblemDescriptor;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.TraceElement;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.rbgraph.CallEdge;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.rbgraph.FunctionNode;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.rbgraph.GraphBuilder;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.rbgraph.RBGraph;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.utils.ElementFilters;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.utils.MyPsiUtils;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016JH\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00070!2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00070!H\u0002J&\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0002J \u0010*\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010\u001c2\u0006\u0010,\u001a\u00020-2\u0006\u0010(\u001a\u00020)H\u0002J,\u0010.\u001a\b\u0012\u0004\u0012\u00020+0/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\u001c2\u0006\u00102\u001a\u0002032\u0006\u0010,\u001a\u00020-H\u0002J \u00104\u001a\b\u0012\u0004\u0012\u00020'0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/RunBlockingInspection;", "Lcom/intellij/codeInspection/GlobalInspectionTool;", "<init>", "()V", "jobDescriptor", "Lcom/intellij/codeInspection/ex/JobDescriptor;", "runInspection", "", "scope", "Lcom/intellij/analysis/AnalysisScope;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "globalContext", "Lcom/intellij/codeInspection/GlobalInspectionContext;", "problemDescriptionsProcessor", "Lcom/intellij/codeInspection/ProblemDescriptionsProcessor;", "explorationLevel", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/RunBlockingInspection$ExplorationLevel;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "getAdditionalJobs", "", "context", "(Lcom/intellij/codeInspection/GlobalInspectionContext;)[Lcom/intellij/codeInspection/ex/JobDescriptor;", "isGraphNeeded", "", "isReadActionNeeded", "analyzeProject", "", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/RunBlockingProblem;", "project", "Lcom/intellij/openapi/project/Project;", "totalFilesTodo", "Lkotlin/Function1;", "", "incrementFilesDone", "", "checkRunBlockingsForFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "rbGraph", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/rbgraph/RBGraph;", "analyzeRunBlocking", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/TraceElement;", "element", "Lcom/intellij/psi/PsiElement;", "generateStackTrace", "", "callEdgeTrace", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/rbgraph/CallEdge;", "funNode", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/rbgraph/FunctionNode;", "getRelevantFiles", "ExplorationLevel", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nRunBlockingInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunBlockingInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/RunBlockingInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1869#2,2:191\n1374#2:193\n1460#2,5:194\n1869#2,2:199\n*S KotlinDebug\n*F\n+ 1 RunBlockingInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/RunBlockingInspection\n*L\n42#1:191,2\n87#1:193\n87#1:194,5\n95#1:199,2\n*E\n"})
public final class RunBlockingInspection
extends GlobalInspectionTool {
    @NotNull
    private final JobDescriptor jobDescriptor = new JobDescriptor(KotlinBundle.message((String)"inspection.runblocking.presentation.descriptor", (Object[])new Object[0]));
    @JvmField
    @NotNull
    public ExplorationLevel explorationLevel = ExplorationLevel.DECLARATION;

    public void runInspection(@NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)globalContext, (String)"globalContext");
        Intrinsics.checkNotNullParameter((Object)problemDescriptionsProcessor, (String)"problemDescriptionsProcessor");
        Project project = manager.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<RunBlockingProblem> runBlockingProblems = this.analyzeProject(project, scope, (Function1<? super Integer, Unit>)((Function1)arg_0 -> RunBlockingInspection.runInspection$lambda$0(this, arg_0)), (Function1<? super String, Unit>)((Function1)arg_0 -> RunBlockingInspection.runInspection$lambda$1(globalContext, this, arg_0)));
        Iterable $this$forEach$iv = runBlockingProblems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RunBlockingProblem it = (RunBlockingProblem)element$iv;
            boolean bl = false;
            ActionsKt.runReadAction(() -> RunBlockingInspection.runInspection$lambda$2$0(it, globalContext, problemDescriptionsProcessor));
        }
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[1];
        OptDropdown.Option[] optionArray = new OptDropdown.Option[]{OptPane.option((Enum)ExplorationLevel.STRICT, (String)KotlinBundle.message((String)"inspection.runblocking.presentation.settings.exploration.option.strict", (Object[])new Object[0])), OptPane.option((Enum)ExplorationLevel.DECLARATION, (String)KotlinBundle.message((String)"inspection.runblocking.presentation.settings.exploration.option.declaration", (Object[])new Object[0])), OptPane.option((Enum)ExplorationLevel.ALL, (String)KotlinBundle.message((String)"inspection.runblocking.presentation.settings.exploration.option.all", (Object[])new Object[0]))};
        optRegularComponentArray[0] = OptPane.dropdown((String)"explorationLevel", (String)KotlinBundle.message((String)"inspection.runblocking.presentation.settings.exploration.title", (Object[])new Object[0]), (OptDropdown.Option[])optionArray);
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @NotNull
    public JobDescriptor[] getAdditionalJobs(@NotNull GlobalInspectionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JobDescriptor[] jobDescriptorArray = new JobDescriptor[]{this.jobDescriptor};
        return jobDescriptorArray;
    }

    public boolean isGraphNeeded() {
        return false;
    }

    public boolean isReadActionNeeded() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RunBlockingProblem> analyzeProject(Project project, AnalysisScope scope, Function1<? super Integer, Unit> totalFilesTodo, Function1<? super String, Unit> incrementFilesDone) {
        void $this$flatMapTo$iv$iv;
        List<VirtualFile> relevantFiles = this.getRelevantFiles(project, scope);
        Set rbFiles = new LinkedHashSet();
        RBGraph rbGraph = new GraphBuilder(project).setRbFileFound((Function1<? super VirtualFile, Unit>)((Function1)arg_0 -> RunBlockingInspection.analyzeProject$lambda$0(rbFiles, arg_0))).setIncrementFilesDoneFunction(incrementFilesDone).setTotalFilesTodo(totalFilesTodo).setRelevantFiles(relevantFiles).setExplorationLevel(this.explorationLevel).buildGraph();
        Iterable $this$flatMap$iv = rbFiles;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.checkRunBlockingsForFile(it, project, rbGraph);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List runBlockingProblems = (List)destination$iv$iv;
        return runBlockingProblems;
    }

    private final List<RunBlockingProblem> checkRunBlockingsForFile(VirtualFile file, Project project, RBGraph rbGraph) {
        List rbs = new ArrayList();
        ActionsKt.runReadAction(() -> RunBlockingInspection.checkRunBlockingsForFile$lambda$0(file, project, this, rbGraph, rbs));
        return rbs;
    }

    private final List<TraceElement> analyzeRunBlocking(PsiElement element, RBGraph rbGraph) {
        PsiElement psiElement = element.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        PsiElement psiFunOrBuilder = MyPsiUtils.Companion.findParent(psiElement, (Function1<? super PsiElement, Boolean>)((Function1)RunBlockingInspection::analyzeRunBlocking$lambda$0), (Function1<? super PsiElement, Boolean>)((Function1)RunBlockingInspection::analyzeRunBlocking$lambda$1));
        if (psiFunOrBuilder instanceof KtNamedFunction) {
            String functionId = FunctionNode.Companion.generateId((KtNamedFunction)psiFunOrBuilder);
            if (rbGraph.containsFun(functionId)) {
                FunctionNode funNode = rbGraph.getFunction(functionId);
                if (funNode.getAsyncContext()) {
                    List<CallEdge> callEdgeTrace = rbGraph.findBuilderBFS(funNode);
                    return this.generateStackTrace(callEdgeTrace, funNode, element);
                }
                return null;
            }
        } else if (psiFunOrBuilder != null && psiFunOrBuilder instanceof KtCallExpression) {
            KtExpression ktExpression = ((KtCallExpression)psiFunOrBuilder).getCalleeExpression();
            Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
            KtNameReferenceExpression callee = (KtNameReferenceExpression)ktExpression;
            PsiReference psiReference = callee.getReference();
            Object object = psiReference != null ? psiReference.resolve() : null;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
            KtNamedFunction ktFun = (KtNamedFunction)object;
            String fqName2 = String.valueOf(ktFun.getFqName());
            Object[] objectArray = new TraceElement[2];
            String string = MyPsiUtils.Companion.getUrl(psiFunOrBuilder);
            if (string == null) {
                string = "";
            }
            objectArray[0] = new TraceElement(fqName2, string, MyPsiUtils.Companion.getFileAndLine(psiFunOrBuilder));
            String string2 = KotlinBundle.message((String)"inspection.runblocking.analysis.found.runblocking", (Object[])new Object[0]);
            String string3 = MyPsiUtils.Companion.getUrl(element);
            if (string3 == null) {
                string3 = "";
            }
            objectArray[1] = new TraceElement(string2, string3, MyPsiUtils.Companion.getFileAndLine(element));
            return CollectionsKt.listOf((Object[])objectArray);
        }
        return null;
    }

    private final List<TraceElement> generateStackTrace(List<CallEdge> callEdgeTrace, FunctionNode funNode, PsiElement element) {
        List list2;
        if (callEdgeTrace.size() != 0) {
            var5_4 = new TraceElement[]{new TraceElement(callEdgeTrace.get(0).getParent().getFqName(), callEdgeTrace.get(0).getParent().getDeclarationSite(), callEdgeTrace.get(0).getParent().getFileAndLine())};
            list2 = CollectionsKt.mutableListOf((Object[])var5_4);
        } else {
            var5_4 = new TraceElement[]{new TraceElement(funNode.getFqName(), funNode.getDeclarationSite(), funNode.getFileAndLine())};
            list2 = CollectionsKt.mutableListOf((Object[])var5_4);
        }
        List stackTrace = list2;
        int n = callEdgeTrace.size();
        for (int i2 = 0; i2 < n; ++i2) {
            stackTrace.add(new TraceElement(callEdgeTrace.get(i2).getChild().getFqName(), callEdgeTrace.get(i2).getCallSite(), callEdgeTrace.get(i2).getFileAndLine()));
        }
        String string = KotlinBundle.message((String)"inspection.runblocking.analysis.found.runblocking", (Object[])new Object[0]);
        String string2 = MyPsiUtils.Companion.getUrl(element);
        if (string2 == null) {
            string2 = "";
        }
        stackTrace.add(new TraceElement(string, string2, MyPsiUtils.Companion.getFileAndLine(element)));
        return stackTrace;
    }

    private final List<VirtualFile> getRelevantFiles(Project project, AnalysisScope scope) {
        List relevantFiles = new ArrayList();
        ProjectFileIndex.getInstance((Project)project).iterateContent(arg_0 -> RunBlockingInspection.getRelevantFiles$lambda$0(scope, relevantFiles, arg_0));
        return relevantFiles;
    }

    private static final Unit runInspection$lambda$0(RunBlockingInspection this$0, int it) {
        this$0.jobDescriptor.setTotalAmount(it);
        return Unit.INSTANCE;
    }

    private static final Unit runInspection$lambda$1(GlobalInspectionContext $globalContext, RunBlockingInspection this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it};
        $globalContext.incrementJobDoneAmount(this$0.jobDescriptor, KotlinBundle.message((String)"inspection.runblocking.analysis.graphbuilding.progress", (Object[])objectArray));
        return Unit.INSTANCE;
    }

    private static final Unit runInspection$lambda$2$0(RunBlockingProblem $it, GlobalInspectionContext $globalContext, ProblemDescriptionsProcessor $problemDescriptionsProcessor) {
        PsiElement el = $it.getElement();
        RefElement refEntity = $globalContext.getRefManager().getReference((PsiElement)el.getContainingFile());
        KtCallExpression ktCallExpression = el instanceof KtCallExpression ? (KtCallExpression)el : null;
        PsiElement expr = ktCallExpression != null && (ktCallExpression = ktCallExpression.getCalleeExpression()) != null ? (PsiElement)ktCallExpression : el;
        CommonProblemDescriptor[] commonProblemDescriptorArray = new CommonProblemDescriptor[]{new RunBlockingProblemDescriptor(expr, $it.getStacTrace())};
        $problemDescriptionsProcessor.addProblemElement((RefEntity)refEntity, commonProblemDescriptorArray);
        return Unit.INSTANCE;
    }

    private static final Unit analyzeProject$lambda$0(Set $rbFiles, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        $rbFiles.add(file);
        return Unit.INSTANCE;
    }

    private static final Unit checkRunBlockingsForFile$lambda$0(VirtualFile $file, Project $project, RunBlockingInspection this$0, RBGraph $rbGraph, List $rbs) {
        Iterable $this$forEach$iv = MyPsiUtils.Companion.findRunBlockings($file, $project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement rb = (PsiElement)element$iv;
            boolean bl = false;
            List<TraceElement> stackTrace = this$0.analyzeRunBlocking(rb, $rbGraph);
            if (stackTrace == null) continue;
            $rbs.add(new RunBlockingProblem(rb, stackTrace));
        }
        return Unit.INSTANCE;
    }

    private static final boolean analyzeRunBlocking$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof KtNamedFunction || ElementFilters.Companion.getLaunchBuilder().isAccepted(it) || ElementFilters.Companion.getAsyncBuilder().isAccepted(it) || ElementFilters.Companion.getRunBlockingBuilderInvocation().isAccepted(it);
    }

    private static final boolean analyzeRunBlocking$lambda$1(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof KtLambdaExpression && !ElementFilters.Companion.getLambdaAsArgForInlineFun().isAccepted(it) && !ElementFilters.Companion.isSuspendLambda().isAccepted(it);
    }

    private static final boolean getRelevantFiles$lambda$0(AnalysisScope $scope, List $relevantFiles, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Boolean)ActionsKt.runReadAction(() -> RunBlockingInspection.getRelevantFiles$lambda$0$0(it, $scope, $relevantFiles));
    }

    private static final boolean getRelevantFiles$lambda$0$0(VirtualFile $it, AnalysisScope $scope, List $relevantFiles) {
        if ($it.getFileType() instanceof KotlinFileType) {
            AnalysisScope analysisScope = $scope;
            if (!(analysisScope != null ? !analysisScope.contains($it) : false)) {
                Intrinsics.checkNotNull((Object)$it);
                $relevantFiles.add($it);
            }
        }
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/RunBlockingInspection$ExplorationLevel;", "", "<init>", "(Ljava/lang/String;I)V", "STRICT", "DECLARATION", "ALL", "kotlin.code-insight.inspections.shared"})
    public static final class ExplorationLevel
    extends Enum<ExplorationLevel> {
        public static final /* enum */ ExplorationLevel STRICT = new ExplorationLevel();
        public static final /* enum */ ExplorationLevel DECLARATION = new ExplorationLevel();
        public static final /* enum */ ExplorationLevel ALL = new ExplorationLevel();
        private static final /* synthetic */ ExplorationLevel[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ExplorationLevel[] values() {
            return (ExplorationLevel[])$VALUES.clone();
        }

        public static ExplorationLevel valueOf(String value) {
            return Enum.valueOf(ExplorationLevel.class, value);
        }

        @NotNull
        public static EnumEntries<ExplorationLevel> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = explorationLevelArray = new ExplorationLevel[]{ExplorationLevel.STRICT, ExplorationLevel.DECLARATION, ExplorationLevel.ALL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

