/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UnsignedValueConstant;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;

public final class UByteValue
extends UnsignedValueConstant<Byte> {
    public UByteValue(byte byteValue) {
        super(byteValue);
    }

    @Override
    @NotNull
    public KotlinType getType(@NotNull ModuleDescriptor module) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(module, StandardNames.FqNames.uByte);
        if (classDescriptor == null) {
            SimpleType simpleType2 = ErrorUtils.createErrorType("Unsigned type UByte not found");
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"createErrorType(\"Unsigned type UByte not found\")");
            kotlinType = simpleType2;
        } else {
            SimpleType simpleType3 = classDescriptor.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"module.findClassAcrossMo\u2026ed type UByte not found\")");
            kotlinType = simpleType3;
        }
        return kotlinType;
    }

    @Override
    @NotNull
    public String toString() {
        return ((Number)this.getValue()).intValue() + ".toUByte()";
    }
}

