/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.internal;

import ghidra.util.ColorUtils;
import ghidra.util.datastruct.IndexRange;
import ghidra.util.datastruct.IndexRangeIterator;
import ghidra.util.datastruct.RangeMap;
import ghidra.util.datastruct.ValueRange;
import java.awt.Color;

public class ColorRangeMap {
    private RangeMap map = new RangeMap();
    private ValueRange valueRange = this.map.getValueRange(0L);
    private Color lastColor;
    private int lastColorValue;

    public void color(long start, long end, Color c) {
        int colorValue = c.getRGB();
        this.map.paintRange(start, end, colorValue);
        this.valueRange = this.map.getValueRange(0L);
    }

    public void clear(long start, long end) {
        this.map.paintRange(start, end, 0);
        this.valueRange = this.map.getValueRange(0L);
    }

    public void clear() {
        this.map.clear();
        this.valueRange = this.map.getValueRange(0L);
    }

    public Color getColor(long index, Color defaultColor) {
        int colorValue;
        if (!this.valueRange.contains(index)) {
            this.valueRange = this.map.getValueRange(index);
        }
        if ((colorValue = this.valueRange.getValue()) == 0) {
            return defaultColor;
        }
        return this.getColor(this.valueRange.getValue());
    }

    private Color getColor(int rgba) {
        if (this.lastColorValue == rgba) {
            return this.lastColor;
        }
        this.lastColorValue = rgba;
        this.lastColor = ColorUtils.getColor((int)rgba);
        return this.lastColor;
    }

    public ColorRangeMap copy() {
        ColorRangeMap newMap = new ColorRangeMap();
        IndexRangeIterator it = this.map.getIndexRangeIterator(-1L);
        while (it.hasNext()) {
            IndexRange ir = it.next();
            int colorValue = this.map.getValue(ir.getStart());
            newMap.map.paintRange(ir.getStart(), ir.getEnd(), colorValue);
        }
        newMap.valueRange = this.map.getValueRange(0L);
        return newMap;
    }
}

