/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.datatype.microsoft.GUID;

public class TypeServer2MsType
extends AbstractMsType {
    public static final int PDB_ID = 5397;
    private GUID signature;
    private long age;
    private String name;

    public TypeServer2MsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.signature = reader.parseGUID();
        this.age = reader.parseUnsignedIntVal();
        this.name = reader.parseString(pdb, StringParseType.StringNt);
    }

    @Override
    public int getPdbId() {
        return 5397;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append(String.format("<<%s %s %s %d>>", this.getClass().getSimpleName(), this.name, this.signature, this.age));
    }
}

