/*
 * Decompiled with CFR 0.152.
 */
package ghidra.launch;

import ghidra.launch.JavaFinder;
import ghidra.launch.JavaVersion;
import ghidra.launch.LaunchProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class AppConfig {
    private static final String LAUNCH_PROPERTIES_NAME = "launch.properties";
    private static final String JAVA_HOME_SAVE_NAME = "java_home.save";
    private static final String PYTHON_COMMAND_SAVE_NAME = "python_command.save";
    private LaunchProperties launchProperties;
    private File javaHomeSaveFile;
    private File pythonCommandSaveFile;
    private String applicationName;
    private String applicationVersion;
    private String applicationReleaseName;
    private String applicationLayoutVersion;
    private int minSupportedJava;
    private int maxSupportedJava;
    private String compilerComplianceLevel;

    public AppConfig(File installDir) throws FileNotFoundException, IOException, ParseException {
        this.initApplicationProperties(installDir);
        this.initLaunchProperties(installDir);
        this.javaHomeSaveFile = this.getSaveFile(installDir, JAVA_HOME_SAVE_NAME);
        this.pythonCommandSaveFile = this.getSaveFile(installDir, PYTHON_COMMAND_SAVE_NAME);
    }

    public LaunchProperties getLaunchProperties() {
        return this.launchProperties;
    }

    public int getMinSupportedJava() {
        return this.minSupportedJava;
    }

    public int getMaxSupportedJava() {
        return this.maxSupportedJava;
    }

    public int getSupportedArchitecture() {
        return 64;
    }

    public String getCompilerComplianceLevel() {
        return this.compilerComplianceLevel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File getSavedJavaHome() throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.javaHomeSaveFile));){
            String line = reader.readLine().trim();
            if (line == null) return null;
            if ((line = line.trim()).isEmpty()) return null;
            File file = new File(line);
            return file;
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public File saveJavaHome(File javaHomeDir) throws IOException {
        if (!this.javaHomeSaveFile.getParentFile().exists() && !this.javaHomeSaveFile.getParentFile().mkdirs()) {
            throw new IOException("Failed to create directory: " + this.javaHomeSaveFile.getParentFile());
        }
        try (PrintWriter writer = new PrintWriter(new FileWriter(this.javaHomeSaveFile));){
            writer.println(javaHomeDir);
        }
        return this.javaHomeSaveFile;
    }

    public boolean isSupportedJavaHomeDir(File dir, JavaFinder.JavaFilter javaFilter) {
        try {
            return this.isJavaVersionSupported(this.getJavaVersion(dir, javaFilter));
        }
        catch (IOException | ParseException e) {
            return false;
        }
    }

    public boolean isJavaVersionSupported(JavaVersion javaVersion) {
        if (javaVersion.getArchitecture() != this.getSupportedArchitecture()) {
            return false;
        }
        int major = javaVersion.getMajor();
        return major >= this.minSupportedJava && (this.maxSupportedJava == 0 || major <= this.maxSupportedJava);
    }

    public JavaVersion getJavaVersion(File javaHomeDir, JavaFinder.JavaFilter javaFilter) throws FileNotFoundException, IOException, ParseException {
        if (javaHomeDir == null) {
            throw new FileNotFoundException("Directory not specified");
        }
        if (!javaHomeDir.isDirectory()) {
            throw new FileNotFoundException("Not a directory");
        }
        File binDir = new File(javaHomeDir, "bin");
        if (!binDir.isDirectory()) {
            throw new FileNotFoundException("Missing bin directory");
        }
        File javaExecutable = null;
        File javacExecutable = null;
        for (File f : binDir.listFiles()) {
            if (f.getName().equals("java") || f.getName().equals("java.exe")) {
                javaExecutable = f;
            }
            if (!f.getName().equals("javac") && !f.getName().equals("javac.exe")) continue;
            javacExecutable = f;
        }
        if (javaExecutable == null) {
            throw new FileNotFoundException("Missing java executable");
        }
        if (javaFilter.equals((Object)JavaFinder.JavaFilter.JDK_ONLY) && javacExecutable == null) {
            throw new FileNotFoundException("JDK is missing javac executable");
        }
        if (javaFilter.equals((Object)JavaFinder.JavaFilter.JRE_ONLY) && javacExecutable != null) {
            throw new FileNotFoundException("JRE should not have javac executable");
        }
        return this.runAndGetJavaVersion(javaExecutable);
    }

    public List<String> getSavedPythonCommand() throws IOException {
        ArrayList<String> arrayList;
        ArrayList<String> command = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(this.pythonCommandSaveFile));
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                command.add(line);
            }
            arrayList = command;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        reader.close();
        return arrayList;
    }

    private JavaVersion runAndGetJavaVersion(File javaExecutable) throws ParseException, IOException {
        String version = "";
        String arch = "";
        Process proc = Runtime.getRuntime().exec(new String[]{javaExecutable.getAbsolutePath(), "-XshowSettings:properties", "-version"});
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));){
            String line;
            while ((version.isEmpty() || arch.isEmpty()) && (line = reader.readLine()) != null) {
                String searchString;
                if ((line = line.trim()).startsWith(searchString = "java.version = ")) {
                    version = line.substring(searchString.length());
                }
                if (!line.startsWith(searchString = "sun.arch.data.model = ")) continue;
                arch = line.substring(searchString.length());
            }
        }
        if (version.isEmpty()) {
            throw new ParseException("Failed to find Java version", 0);
        }
        if (arch.isEmpty()) {
            throw new ParseException("Failed to find Java architecture", 0);
        }
        return new JavaVersion(version, arch);
    }

    private void initApplicationProperties(File installDir) throws FileNotFoundException, IOException, ParseException {
        File applicationPropertiesFile = new File(installDir, "Ghidra/application.properties");
        if (!applicationPropertiesFile.isFile()) {
            throw new FileNotFoundException("Application properties file does not exist: " + applicationPropertiesFile);
        }
        Properties applicationProperties = new Properties();
        try (FileInputStream fin = new FileInputStream(applicationPropertiesFile);){
            applicationProperties.load(fin);
        }
        this.applicationName = this.getDefinedProperty(applicationProperties, "application.name");
        this.applicationVersion = this.getDefinedProperty(applicationProperties, "application.version");
        this.applicationReleaseName = this.getDefinedProperty(applicationProperties, "application.release.name");
        this.applicationLayoutVersion = this.getDefinedProperty(applicationProperties, "application.layout.version");
        this.compilerComplianceLevel = this.getDefinedProperty(applicationProperties, "application.java.compiler");
        try {
            this.minSupportedJava = Integer.parseInt(this.getDefinedProperty(applicationProperties, "application.java.min"));
        }
        catch (NumberFormatException e) {
            throw new ParseException("Failed to parse application's minimum supported Java major verison", 0);
        }
        String max = applicationProperties.getProperty("application.java.max");
        if (max != null && !max.isEmpty()) {
            try {
                this.maxSupportedJava = Integer.parseInt(max);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Failed to parse application's maximum supported Java major verison", 0);
            }
        } else {
            this.maxSupportedJava = 0;
        }
    }

    private void initLaunchProperties(File installDir) throws FileNotFoundException, IOException, ParseException {
        boolean isDev = new File(installDir, "build.gradle").isFile();
        File launchPropertiesFile = new File(installDir, (isDev ? "Ghidra/RuntimeScripts/Common/" : "") + "support/" + LAUNCH_PROPERTIES_NAME);
        if (!launchPropertiesFile.isFile()) {
            throw new FileNotFoundException("Launch properties file does not exist: " + launchPropertiesFile);
        }
        this.launchProperties = new LaunchProperties(launchPropertiesFile);
    }

    private File getSaveFile(File installDir, String saveFileName) throws FileNotFoundException {
        String userHomeDirPath;
        boolean isDev = new File(installDir, "build.gradle").isFile();
        String appName = this.applicationName.replaceAll("\\s", "").toLowerCase();
        String userSettingsDirName = appName + "_" + this.applicationVersion + "_" + this.applicationReleaseName.replaceAll("\\s", "").toUpperCase();
        if (isDev) {
            String dirName = new File(installDir, "ghidra.repos.config").isFile() ? installDir.getParentFile().getName() : installDir.getName();
            userSettingsDirName = userSettingsDirName + "_location_" + dirName;
        }
        if ((userHomeDirPath = System.getProperty("user.home")) == null || userHomeDirPath.isEmpty()) {
            throw new FileNotFoundException("User home directory is not known.");
        }
        File userHomeDir = new File(userHomeDirPath);
        if (!userHomeDir.isDirectory()) {
            throw new FileNotFoundException("User home directory does not exist: " + userHomeDir);
        }
        File userSettingsDir = null;
        if (this.applicationLayoutVersion.equals("1")) {
            userSettingsDir = new File(userHomeDir, "." + appName + "/." + userSettingsDirName);
            return new File(userSettingsDir, saveFileName);
        }
        String xdgConfigHomeDirStr = System.getenv("XDG_CONFIG_HOME");
        if (xdgConfigHomeDirStr != null && !xdgConfigHomeDirStr.isEmpty()) {
            userSettingsDir = new File(xdgConfigHomeDirStr, appName + "/" + userSettingsDirName);
            return new File(userSettingsDir, saveFileName);
        }
        switch (JavaFinder.getCurrentPlatform()) {
            case WINDOWS: {
                String localAppDataDirPath = System.getenv("APPDATA");
                if (localAppDataDirPath == null || localAppDataDirPath.trim().isEmpty()) {
                    throw new FileNotFoundException("\"APPDATA\" environment variable is not set");
                }
                userSettingsDir = new File(localAppDataDirPath, appName + "/" + userSettingsDirName);
                break;
            }
            case LINUX: {
                userSettingsDir = new File(userHomeDir, ".config/" + appName + "/" + userSettingsDirName);
                break;
            }
            case MACOS: {
                userSettingsDir = new File(userHomeDir, "Library/" + appName + "/" + userSettingsDirName);
                break;
            }
            default: {
                throw new FileNotFoundException("Failed to find the user settings directory: Unsupported operating system.");
            }
        }
        return new File(userSettingsDir, saveFileName);
    }

    private String getDefinedProperty(Properties properties, String key) throws ParseException {
        String value = properties.getProperty(key);
        if (value == null || value.isEmpty()) {
            throw new ParseException("Property \"" + key + "\" is not defined.", 0);
        }
        return value;
    }
}

