/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.session;

import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.wizard.session.NewSessionData;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Program;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CreateNewSessionTask
extends Task {
    private final NewSessionData data;
    private final VTController controller;

    public CreateNewSessionTask(VTController controller, NewSessionData data) {
        super("Create New Version Tracking Session", true, true, true);
        this.controller = controller;
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) {
        VTSessionDB session = null;
        String name = null;
        try {
            Program sourceProgram = this.data.getSourceProgram();
            Program destinationProgram = this.data.getDestinationProgram();
            session = new VTSessionDB("New Session", sourceProgram, destinationProgram, (Object)this);
            sourceProgram.release((Object)this.controller.getTool());
            destinationProgram.release((Object)this.controller.getTool());
            name = this.data.getSessionName();
            DomainFolder folder = this.data.getSessionFolder();
            try {
                folder.createFile(name, (DomainObject)session, monitor);
            }
            catch (InvalidNameException e) {
                Msg.showError((Object)((Object)this), null, (String)"Invalid Domain Object Name", (Object)"Please report this error; the name should have been checked already");
            }
            this.controller.openVersionTrackingSession(session);
        }
        catch (CancelledException sourceProgram) {
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)"Failed to Create Session", (Object)("Failed to create db file: " + name), (Throwable)e);
        }
        finally {
            if (session != null) {
                session.release((Object)this);
            }
        }
    }
}

