/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.format.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.util.viewer.format.FieldHeader;
import ghidra.app.util.viewer.format.FieldHeaderLocation;
import ghidra.util.HelpLocation;
import java.awt.Component;

public class ResetFormatAction
extends DockingAction {
    private FieldHeader panel;

    public ResetFormatAction(String owner, FieldHeader panel) {
        super("Reset Format", owner, false);
        this.panel = panel;
        this.setPopupMenuData(new MenuData(new String[]{"Reset Format"}, null, "format"));
        this.setEnabled(true);
        this.setHelpLocation(new HelpLocation("CodeBrowserPlugin", "Reset Format"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        return context.getContextObject() instanceof FieldHeaderLocation;
    }

    public void actionPerformed(ActionContext context) {
        int userChoice = OptionDialog.showOptionDialog((Component)this.panel, (String)"Reset Format?", (String)"There is no undo for this action.\nAre you sure you want to reset the current format?", (String)"Continue", (int)2);
        if (userChoice == 0) {
            return;
        }
        this.panel.setTabLock(true);
        this.panel.resetFormat();
        this.panel.getHeaderTab().update();
    }
}

