/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Constants;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Protocol;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ObjectiveC2_ProtocolList
implements StructConverter {
    public static final String NAME = "protocol_list_t";
    private ObjectiveC2_State _state;
    private long _index;
    private List<ObjectiveC2_Protocol> protocols = new ArrayList<ObjectiveC2_Protocol>();

    public ObjectiveC2_ProtocolList(ObjectiveC2_State state, BinaryReader reader) throws IOException {
        this._state = state;
        this._index = reader.getPointerIndex();
        long count = state.is32bit ? reader.readNextUnsignedInt() : reader.readNextLong();
        for (long i = 0L; i < count; ++i) {
            long protocolIndex = ObjectiveC1_Utilities.readNextIndex(reader, state.is32bit);
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(protocolIndex);
            this.protocols.add(new ObjectiveC2_Protocol(state, reader));
            reader.setPointerIndex(originalIndex);
        }
    }

    public long getCount() {
        return this.protocols.size();
    }

    public long getIndex() {
        return this._index;
    }

    public List<ObjectiveC2_Protocol> getProtocols() {
        return this.protocols;
    }

    public static DataType toGenericDataType(ObjectiveC2_State state) throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        if (state.is32bit) {
            struct.add(DWORD, "count", null);
        } else {
            struct.add(QWORD, "count", null);
        }
        struct.setCategoryPath(ObjectiveC2_Constants.CATEGORY_PATH);
        return struct;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("protocol_list_t_" + this.protocols.size() + "_", 0);
        if (this._state.is32bit) {
            struct.add(DWORD, "count", null);
        } else {
            struct.add(QWORD, "count", null);
        }
        for (int i = 0; i < this.protocols.size(); ++i) {
            DataType dataType = this.protocols.get(i).toDataType();
            struct.add((DataType)new PointerDataType(dataType), this._state.pointerSize, "protocol" + i, null);
        }
        struct.setCategoryPath(ObjectiveC2_Constants.CATEGORY_PATH);
        return struct;
    }

    public void applyTo(Namespace namespace) throws Exception {
        Address address = ObjectiveC1_Utilities.toAddress(this._state.program, this.getIndex());
        try {
            ObjectiveC1_Utilities.applyData(this._state.program, this.toDataType(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Namespace protocolListNamespace = ObjectiveC1_Utilities.createNamespace(this._state.program, "objc", NAME);
            ObjectiveC1_Utilities.createSymbol(this._state.program, protocolListNamespace, namespace.getName(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ObjectiveC2_Protocol protocol : this.getProtocols()) {
            protocol.applyTo(namespace);
        }
    }
}

