/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug.dbtable;

import db.BooleanField;
import db.DBRecord;
import docking.widgets.table.GBooleanCellRenderer;
import ghidra.app.plugin.debug.dbtable.AbstractColumnAdapter;
import ghidra.docking.settings.Settings;
import ghidra.util.table.column.GColumnRenderer;

public class BooleanColumnAdapter
extends AbstractColumnAdapter {
    private BooleanRenderer renderer = new BooleanRenderer();

    BooleanColumnAdapter(String columnName, int column) {
        super(columnName, column);
    }

    public int getColumnPreferredWidth() {
        return 75;
    }

    @Override
    Class<?> getValueClass() {
        return Boolean.class;
    }

    @Override
    Object getKeyValue(DBRecord rec) {
        return ((BooleanField)rec.getKeyField()).getBooleanValue();
    }

    @Override
    Object getValue(DBRecord rec, int dbColumn) {
        return rec.getBooleanValue(dbColumn);
    }

    public BooleanRenderer getColumnRenderer() {
        return this.renderer;
    }

    private class BooleanRenderer
    extends GBooleanCellRenderer
    implements GColumnRenderer<Object> {
        private BooleanRenderer() {
        }

        public String getFilterString(Object t, Settings settings) {
            Boolean b = (Boolean)t;
            if (b == null) {
                return Boolean.FALSE.toString();
            }
            return b.toString();
        }
    }
}

