/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import ghidra.features.base.codecompare.panel.CodeComparisonActionContext;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;

public abstract class AbstractFunctionComparisonApplyAction
extends DockingAction {
    protected static final String MENU_PARENT = "Apply From Other Function";
    protected static final String MENU_GROUP = "A0_ApplyFunction";
    protected static final String HELP_TOPIC = "FunctionComparison";

    public AbstractFunctionComparisonApplyAction(String name, String owner) {
        super(name, owner);
    }

    public boolean isValidContext(ActionContext context) {
        return context instanceof CodeComparisonActionContext;
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (context instanceof CodeComparisonActionContext) {
            CodeComparisonActionContext comparisonContext = (CodeComparisonActionContext)context;
            return this.isEnabledForContext(comparisonContext);
        }
        return false;
    }

    private boolean isEnabledForContext(CodeComparisonActionContext context) {
        Function source = context.getSourceFunction();
        Function target = context.getTargetFunction();
        if (source == null || target == null) {
            return false;
        }
        return !target.getProgram().getDomainFile().isReadOnly();
    }

    public void actionPerformed(ActionContext context) {
        if (context instanceof CodeComparisonActionContext) {
            CodeComparisonActionContext comparisonContext = (CodeComparisonActionContext)context;
            this.doActionPerformed(comparisonContext);
        }
    }

    private void doActionPerformed(CodeComparisonActionContext context) {
        Function source = context.getSourceFunction();
        Function target = context.getTargetFunction();
        Program program = target.getProgram();
        try {
            program.withTransaction(this.getName(), () -> this.applyFunctionData(source, target));
        }
        catch (Exception e) {
            String message = "Failed to apply " + source.getName() + " to " + target.getName() + " @ " + target.getEntryPoint().toString() + ". " + e.getMessage();
            Msg.showError((Object)((Object)this), null, (String)this.getName(), (Object)message, (Throwable)e);
        }
    }

    protected abstract void applyFunctionData(Function var1, Function var2) throws Exception;
}

