/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CodeUnitLocation;

public class SpacerFieldLocation
extends CodeUnitLocation {
    private String text;

    public SpacerFieldLocation(Program program, Address addr, int[] componentPath, int charOffset, String text) {
        super(program, addr, componentPath, 0, 0, charOffset);
        this.text = text;
    }

    public SpacerFieldLocation() {
    }

    public String getText() {
        return this.text;
    }

    @Override
    public String toString() {
        return super.toString() + ", Spacer text = " + this.text;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpacerFieldLocation other = (SpacerFieldLocation)obj;
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.text = obj.getString("_TEXT", "");
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putString("_TEXT", this.text);
    }
}

