/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.AudioPlayer;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;

public class AIFFDataType
extends BuiltIn
implements Dynamic {
    public static byte[] MAGIC_AIFF = new byte[]{70, 79, 82, 77, 0, 0, 0, 0, 65, 73, 70, 70};
    public static byte[] MAGIC_AIFC = new byte[]{70, 79, 82, 77, 0, 0, 0, 0, 65, 73, 70, 67};
    public static byte[] MAGIC_MASK = new byte[]{-1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1};

    public AIFFDataType() {
        this(null);
    }

    public AIFFDataType(DataTypeManager dtm) {
        super(null, "AIFF-Sound", dtm);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public int getLength(MemBuffer buf, int maxLength) {
        try {
            if (!this.checkMagic(buf, MAGIC_AIFF) && !this.checkMagic(buf, MAGIC_AIFC)) {
                return -1;
            }
            int dataSize = buf.getInt(4);
            if (dataSize <= 0) {
                return -1;
            }
            return dataSize + 8;
        }
        catch (Exception e) {
            Msg.debug((Object)this, (Object)("Invalid AIFF data at " + String.valueOf(buf.getAddress())));
            return -1;
        }
    }

    private boolean checkMagic(MemBuffer buf, byte[] magicBytes) throws MemoryAccessException {
        for (int i = 0; i < magicBytes.length; ++i) {
            if (magicBytes[i] == (buf.getByte(i) & MAGIC_MASK[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canSpecifyLength() {
        return false;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new AIFFDataType(dtm);
    }

    @Override
    public String getDescription() {
        return "AIFF sound stored within program";
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "AIFF";
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "<AIFF-Representation>";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        byte[] data = new byte[length];
        if (buf.getBytes(data, 0) != length) {
            Msg.error((Object)this, (Object)"AIFF-Sound error: Not enough bytes in memory");
            return null;
        }
        return new AudioPlayer(data);
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return AudioPlayer.class;
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        return "AIFF";
    }

    @Override
    public DataType getReplacementBaseType() {
        return ByteDataType.dataType;
    }
}

