/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.correlate;

import generic.hash.SimpleCRC32;
import ghidra.program.model.correlate.HashCalculator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.mem.MemoryAccessException;

public class AllBytesHashCalculator
implements HashCalculator {
    @Override
    public int calcHash(int startHash, Instruction inst) throws MemoryAccessException {
        byte[] bytes = inst.getParsedBytes();
        for (int i = 0; i < bytes.length; ++i) {
            startHash = SimpleCRC32.hashOneByte((int)startHash, (int)bytes[i]);
        }
        return startHash;
    }
}

