/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.job;

import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import ghidra.graph.job.AbstractGraphTransitionJob;
import ghidra.graph.job.RelayoutFunctionGraphJob;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import java.awt.Point;
import java.awt.geom.Point2D;

public class RelayoutAndCenterVertexGraphJob<V extends VisualVertex, E extends VisualEdge<V>>
extends RelayoutFunctionGraphJob<V, E> {
    private V vertex;
    private Point2D destination;
    private Point2D lastPoint = new Point2D.Double(0.0, 0.0);

    public RelayoutAndCenterVertexGraphJob(GraphViewer<V, E> viewer, V vertex, boolean useAnimation) {
        super(viewer, useAnimation);
        this.vertex = vertex;
    }

    @Override
    protected void initializeVertexLocations() {
        super.initializeVertexLocations();
        AbstractGraphTransitionJob.TransitionPoints transitionPoints = (AbstractGraphTransitionJob.TransitionPoints)this.vertexLocations.get(this.vertex);
        Point2D centerPoint = transitionPoints.destinationPoint;
        Point p = new Point((int)centerPoint.getX(), (int)centerPoint.getY());
        this.destination = GraphViewerUtils.getOffsetFromCenterInLayoutSpace(this.viewer, p);
    }

    @Override
    public void setPercentComplete(double percentComplete) {
        super.setPercentComplete(percentComplete);
        double finalX = this.destination.getX();
        double finalY = this.destination.getY();
        double lastX = this.lastPoint.getX();
        double lastY = this.lastPoint.getY();
        double deltaX = percentComplete * finalX - lastX;
        double deltaY = percentComplete * finalY - lastY;
        this.lastPoint.setLocation(lastX + deltaX, lastY + deltaY);
        if (deltaX == 0.0 && deltaY == 0.0) {
            return;
        }
        RenderContext renderContext = this.viewer.getRenderContext();
        MultiLayerTransformer xform = renderContext.getMultiLayerTransformer();
        xform.getTransformer(Layer.LAYOUT).translate(deltaX, deltaY);
        this.viewer.repaint();
    }

    @Override
    protected void finished() {
        if (this.isShortcut) {
            this.destination = GraphViewerUtils.getVertexOffsetFromLayoutCenter(this.viewer, this.vertex);
        }
        super.finished();
    }
}

