/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.Tool;
import edu.uci.ics.jung.visualization.picking.PickedState;
import ghidra.framework.options.SaveState;
import ghidra.graph.VisualGraph;
import ghidra.graph.featurette.VgSatelliteFeaturette;
import ghidra.graph.featurette.VisualGraphFeaturette;
import ghidra.graph.viewer.GraphComponent;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphView;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.actions.VgActionContext;
import ghidra.graph.viewer.actions.VgSatelliteContext;
import ghidra.graph.viewer.actions.VgVertexContext;
import ghidra.graph.viewer.event.mouse.VertexMouseInfo;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class VisualGraphComponentProvider<V extends VisualVertex, E extends VisualEdge<V>, G extends VisualGraph<V, E>>
extends ComponentProvider {
    private List<VisualGraphFeaturette<V, E, G>> subFeatures = new ArrayList<VisualGraphFeaturette<V, E, G>>();

    protected VisualGraphComponentProvider(Tool tool, String name, String owner) {
        super(tool, name, owner);
    }

    protected VisualGraphComponentProvider(Tool tool, String name, String owner, Class<?> contextType) {
        super(tool, name, owner, contextType);
    }

    public abstract VisualGraphView<V, E, G> getView();

    public void componentHidden() {
        this.subFeatures.forEach(f -> f.providerClosed(this));
    }

    public void componentShown() {
        this.subFeatures.forEach(f -> f.providerOpened(this));
    }

    public boolean isSatelliteShowing() {
        GraphComponent<V, E, G> graphComponent = this.getView().getGraphComponent();
        return graphComponent.isSatelliteShowing();
    }

    public boolean isSatelliteDocked() {
        return this.getView().isSatelliteDocked();
    }

    public Set<V> getSelectedVertices() {
        VisualGraphView<V, E, G> view = this.getView();
        GraphViewer<V, E> viewer = view.getPrimaryGraphViewer();
        if (viewer == null) {
            return Collections.emptySet();
        }
        PickedState pickedState = viewer.getPickedVertexState();
        return pickedState.getPicked();
    }

    protected ComponentProvider getSatelliteProvider() {
        VgSatelliteFeaturette<V, E, G> feature = this.getSatelliteFeature();
        if (feature == null) {
            return null;
        }
        return feature.getSatelliteProvider();
    }

    private VgSatelliteFeaturette<V, E, G> getSatelliteFeature() {
        for (VisualGraphFeaturette<V, E, G> feature : this.subFeatures) {
            if (!(feature instanceof VgSatelliteFeaturette)) continue;
            return (VgSatelliteFeaturette)feature;
        }
        return null;
    }

    protected void addSatelliteFeature() {
        this.addSatelliteFeature(true, GraphComponent.SatellitePosition.LOWER_RIGHT);
    }

    protected void addSatelliteFeature(boolean satelliteVisible, GraphComponent.SatellitePosition position) {
        VgSatelliteFeaturette satelliteFeature = new VgSatelliteFeaturette();
        satelliteFeature.init(this);
        this.subFeatures.add(satelliteFeature);
        satelliteFeature.setSatellitePosition(position);
        satelliteFeature.setSatelliteVisible(satelliteVisible);
    }

    public void dispose() {
        this.subFeatures.forEach(f -> f.remove());
        this.subFeatures.clear();
    }

    public void writeConfigState(SaveState saveState) {
        this.subFeatures.forEach(f -> f.writeConfigState(saveState));
    }

    public void readConfigState(SaveState saveState) {
        this.subFeatures.forEach(f -> f.readConfigState(saveState));
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (event == null) {
            VisualGraphView<V, E, G> view = this.getView();
            V v = view.getFocusedVertex();
            if (v != null) {
                return new VgVertexContext<V>((ComponentProvider)this, v);
            }
            return new VgActionContext(this);
        }
        V v = this.getVertexUnderMouse(event);
        if (v != null) {
            return new VgVertexContext<V>((ComponentProvider)this, v);
        }
        Component c = event.getComponent();
        if (this.getView().isSatelliteComponent(c)) {
            return new VgSatelliteContext(this);
        }
        return new VgActionContext(this, c);
    }

    private V getVertexUnderMouse(MouseEvent event) {
        Object source = event.getSource();
        GraphViewer<V, E> viewer = this.getPrimaryGraphViewer(source);
        if (viewer == null) {
            return null;
        }
        VertexMouseInfo<V, E> info = GraphViewerUtils.convertMouseEventToVertexMouseEvent(viewer, event);
        if (info == null) {
            return null;
        }
        V vertex = info.getVertex();
        return vertex;
    }

    private GraphViewer<V, E> getPrimaryGraphViewer(Object source) {
        GraphViewer<V, E> primaryGraphViewer = this.getView().getPrimaryGraphViewer();
        if (source == primaryGraphViewer) {
            return primaryGraphViewer;
        }
        return null;
    }
}

