/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.DebuggerGoToDialog;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.async.AsyncUtils;
import ghidra.debug.api.action.GoToInput;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.pcode.exec.DebuggerPcodeUtils;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExpression;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.guest.TracePlatform;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public abstract class DebuggerGoToTrait {
    protected DockingAction action;
    protected final PluginTool tool;
    protected final Plugin plugin;
    protected final ComponentProvider provider;
    protected DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;

    public DebuggerGoToTrait(PluginTool tool, Plugin plugin, ComponentProvider provider) {
        this.tool = tool;
        this.plugin = plugin;
        this.provider = provider;
    }

    protected abstract GoToInput getDefaultInput();

    protected abstract boolean goToAddress(Address var1);

    public void goToCoordinates(DebuggerCoordinates coordinates) {
        this.current = coordinates;
    }

    public DockingAction installAction() {
        this.action = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.GoToAction.builder(this.plugin).enabledWhen(ctx -> this.current.getView() != null)).onAction(this::activatedGoTo)).buildAndInstallLocal(this.provider);
        this.action.setEnabled(false);
        return this.action;
    }

    private void activatedGoTo(ActionContext context) {
        DebuggerGoToDialog goToDialog = new DebuggerGoToDialog(this);
        TracePlatform platform = this.current.getPlatform();
        goToDialog.show(platform.getAddressFactory(), this.getDefaultInput());
    }

    public CompletableFuture<GoToResult> goTo(String spaceName, String offset) {
        TracePlatform platform = this.current.getPlatform();
        Language language = platform.getLanguage();
        AddressSpace space = language.getAddressFactory().getAddressSpace(spaceName);
        if (space == null) {
            throw new IllegalArgumentException("No such address space: " + spaceName);
        }
        try {
            Address address = space.getAddress(offset);
            if (address == null) {
                address = language.getAddressFactory().getAddress(offset);
            }
            if (address != null) {
                return CompletableFuture.completedFuture(new GoToResult(address, this.goToAddress(address)));
            }
        }
        catch (AddressFormatException addressFormatException) {
            // empty catch block
        }
        return this.goToSleigh(spaceName, offset);
    }

    protected CompletableFuture<GoToResult> goToSleigh(String spaceName, String expression) {
        TracePlatform platform = this.current.getPlatform();
        Language language = platform.getLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalStateException("Current trace does not use Sleigh");
        }
        AddressSpace space = language.getAddressFactory().getAddressSpace(spaceName);
        if (space == null) {
            throw new IllegalArgumentException("No such address space: " + spaceName);
        }
        PcodeExpression expr = DebuggerPcodeUtils.compileExpression((ServiceProvider)this.tool, this.current, expression);
        return this.goToSleigh(platform, space, expr);
    }

    protected CompletableFuture<GoToResult> goToSleigh(TracePlatform platform, AddressSpace space, PcodeExpression expression) {
        PcodeExecutor<byte[]> executor = DebuggerPcodeUtils.executorForCoordinates((ServiceProvider)this.tool, this.current);
        CompletableFuture<byte[]> result = CompletableFuture.supplyAsync(() -> (byte[])expression.evaluate(executor));
        return result.thenApplyAsync(offset -> {
            Address address = space.getAddress(Utils.bytesToLong((byte[])offset, (int)((byte[])offset).length, (boolean)expression.getLanguage().isBigEndian()));
            return new GoToResult(address, this.goToAddress(platform.mapGuestToHost(address)));
        }, (Executor)AsyncUtils.SWING_EXECUTOR);
    }

    public record GoToResult(Address address, Boolean success) {
    }
}

