/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.MultiGraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public class DirectedOrderedSparseMultigraph<V, E>
extends DirectedSparseMultigraph<V, E>
implements DirectedGraph<V, E>,
MultiGraph<V, E> {
    public static <V, E> Supplier<DirectedGraph<V, E>> getFactory() {
        return new Supplier<DirectedGraph<V, E>>(){

            public DirectedGraph<V, E> get() {
                return new DirectedOrderedSparseMultigraph();
            }
        };
    }

    public DirectedOrderedSparseMultigraph() {
        this.vertices = new LinkedHashMap();
        this.edges = new LinkedHashMap();
    }

    @Override
    public boolean addVertex(V vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("vertex may not be null");
        }
        if (!this.containsVertex(vertex)) {
            this.vertices.put(vertex, new Pair(new LinkedHashSet(), new LinkedHashSet()));
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> getPredecessors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        LinkedHashSet preds = new LinkedHashSet();
        for (Object edge : this.getIncoming_internal(vertex)) {
            preds.add(this.getSource(edge));
        }
        return Collections.unmodifiableCollection(preds);
    }

    @Override
    public Collection<V> getSuccessors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        LinkedHashSet succs = new LinkedHashSet();
        for (Object edge : this.getOutgoing_internal(vertex)) {
            succs.add(this.getDest(edge));
        }
        return Collections.unmodifiableCollection(succs);
    }

    @Override
    public Collection<V> getNeighbors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        LinkedHashSet neighbors = new LinkedHashSet();
        for (Object edge : this.getIncoming_internal(vertex)) {
            neighbors.add(this.getSource(edge));
        }
        for (Object edge : this.getOutgoing_internal(vertex)) {
            neighbors.add(this.getDest(edge));
        }
        return Collections.unmodifiableCollection(neighbors);
    }

    @Override
    public Collection<E> getIncidentEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        LinkedHashSet incident = new LinkedHashSet();
        incident.addAll(this.getIncoming_internal(vertex));
        incident.addAll(this.getOutgoing_internal(vertex));
        return incident;
    }
}

