/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.util;

import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.EventType;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class TypedEventDispatcher {
    private Map<TraceEvent<?, ?>, EventRecordHandler<?, ?>> typedMap = new HashMap();
    private Map<EventType, Consumer<DomainObjectChangeRecord>> untypedMap = new HashMap<EventType, Consumer<DomainObjectChangeRecord>>();
    protected Consumer<DomainObjectChangeRecord> restoredHandler = null;

    protected <T, U> void listenFor(TraceEvent<T, U> type, EventRecordHandler<T, U> handler) {
        this.typedMap.put(type, handler);
    }

    protected <T, U> void listenFor(TraceEvent<T, U> type, FullEventRecordHandler<? super T, ? super U> handler) {
        this.typedMap.put(type, handler);
    }

    protected <T, U> void listenFor(TraceEvent<T, U> type, AffectedObjectHandler<? super T> handler) {
        this.typedMap.put(type, handler);
    }

    protected <T, U> void listenFor(TraceEvent<T, U> type, AffectedObjectOnlyHandler<? super T> handler) {
        this.typedMap.put(type, handler);
    }

    protected <T, U> void listenFor(TraceEvent<T, U> type, AffectedAndValuesOnlyHandler<? super T, ? super U> handler) {
        this.typedMap.put(type, handler);
    }

    protected <T, U> void listenFor(TraceEvent<T, U> type, ValuesOnlyHandler<? super U> handler) {
        this.typedMap.put(type, handler);
    }

    protected <T, U> void listenFor(TraceEvent<T, U> type, SpaceValuesHandler<? super U> handler) {
        this.typedMap.put(type, handler);
    }

    protected void listenFor(TraceEvent<?, ?> type, IgnoreValuesHandler handler) {
        this.typedMap.put(type, handler);
    }

    protected void listenFor(TraceEvent<?, ?> type, IgnoreAllHandler handler) {
        this.typedMap.put(type, handler);
    }

    protected void listenForUntyped(EventType type, Consumer<DomainObjectChangeRecord> handler) {
        if (type == DomainObjectEvent.RESTORED) {
            this.restoredHandler = handler;
        } else {
            this.untypedMap.put(type, handler);
        }
    }

    public void handleChangeRecord(DomainObjectChangeRecord rec) {
        if (rec.getEventType() == DomainObjectEvent.RESTORED && this.restoredHandler != null) {
            this.restoredHandler.accept(rec);
            return;
        }
        if (rec instanceof TraceChangeRecord) {
            TraceChangeRecord cr = (TraceChangeRecord)rec;
            this.handleTraceChangeRecord(cr);
            return;
        }
        Consumer<DomainObjectChangeRecord> handler = this.untypedMap.get(rec.getEventType());
        if (null != handler) {
            handler.accept(rec);
            return;
        }
        this.unhandled(rec);
    }

    public void handleTraceChangeRecord(TraceChangeRecord<?, ?> rec) {
        EventRecordHandler<?, ?> handler = this.typedMap.get(rec.getEventType());
        if (handler != null) {
            handler.handle(rec);
        }
    }

    protected void unhandled(DomainObjectChangeRecord rec) {
    }

    public static interface EventRecordHandler<T, U> {
        public void handle(TraceChangeRecord<T, U> var1);
    }

    public static interface IgnoreAllHandler
    extends EventRecordHandler<Object, Object> {
        public void handle();

        @Override
        default public void handle(TraceChangeRecord<Object, Object> record) {
            this.handle();
        }
    }

    public static interface IgnoreValuesHandler
    extends EventRecordHandler<Object, Object> {
        public void handle(AddressSpace var1);

        @Override
        default public void handle(TraceChangeRecord<Object, Object> record) {
            this.handle(record.getAddressSpace());
        }
    }

    public static interface ValuesOnlyHandler<U>
    extends EventRecordHandler<Void, U> {
        public void handle(U var1, U var2);

        @Override
        default public void handle(TraceChangeRecord<Void, U> record) {
            this.handle(record.getOldValue(), record.getNewValue());
        }
    }

    public static interface SpaceValuesHandler<U>
    extends EventRecordHandler<Void, U> {
        public void handle(AddressSpace var1, U var2, U var3);

        @Override
        default public void handle(TraceChangeRecord<Void, U> record) {
            this.handle(record.getAddressSpace(), record.getOldValue(), record.getNewValue());
        }
    }

    public static interface AffectedAndValuesOnlyHandler<T, U>
    extends EventRecordHandler<T, U> {
        public void handle(T var1, U var2, U var3);

        @Override
        default public void handle(TraceChangeRecord<T, U> record) {
            this.handle(record.getAffectedObject(), record.getOldValue(), record.getNewValue());
        }
    }

    public static interface AffectedObjectOnlyHandler<T>
    extends EventRecordHandler<T, Void> {
        public void handle(T var1);

        @Override
        default public void handle(TraceChangeRecord<T, Void> record) {
            this.handle(record.getAffectedObject());
        }
    }

    public static interface AffectedObjectHandler<T>
    extends EventRecordHandler<T, Void> {
        public void handle(AddressSpace var1, T var2);

        @Override
        default public void handle(TraceChangeRecord<T, Void> record) {
            this.handle(record.getAddressSpace(), record.getAffectedObject());
        }
    }

    public static interface FullEventRecordHandler<T, U>
    extends EventRecordHandler<T, U> {
        public void handle(AddressSpace var1, T var2, U var3, U var4);

        @Override
        default public void handle(TraceChangeRecord<T, U> record) {
            this.handle(record.getAddressSpace(), record.getAffectedObject(), record.getOldValue(), record.getNewValue());
        }
    }
}

