/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial.hyper;

import ghidra.util.database.spatial.hyper.HyperBox;
import ghidra.util.database.spatial.hyper.HyperPoint;

public interface Dimension<T, P extends HyperPoint, B extends HyperBox<P, B>> {
    public T value(P var1);

    default public T lower(B box) {
        return this.value(box.lCorner());
    }

    default public T upper(B box) {
        return this.value(box.uCorner());
    }

    public int compare(T var1, T var2);

    public double distance(T var1, T var2);

    public T mid(T var1, T var2);

    default public T boxMid(B box) {
        return this.mid(this.lower(box), this.upper(box));
    }

    default public T min(T a, T b) {
        return this.compare(a, b) < 0 ? a : b;
    }

    default public T max(T a, T b) {
        return this.compare(a, b) > 0 ? a : b;
    }

    public T absoluteMin();

    public T absoluteMax();

    default public double pointDistance(P a, P b) {
        return this.distance(this.value(a), this.value(b));
    }

    default public boolean contains(B box, P point) {
        T value = this.value(point);
        if (this.compare(value, this.lower(box)) < 0) {
            return false;
        }
        return this.compare(value, this.upper(box)) <= 0;
    }

    default public boolean intersect(B a, B b) {
        if (this.compare(this.lower(a), this.upper(b)) > 0) {
            return false;
        }
        return this.compare(this.upper(a), this.lower(b)) >= 0;
    }

    default public boolean encloses(B outer, B inner) {
        if (this.compare(this.lower(outer), this.lower(inner)) > 0) {
            return false;
        }
        return this.compare(this.upper(outer), this.upper(inner)) >= 0;
    }

    default public T intersectionLower(B a, B b) {
        return this.max(this.lower(a), this.lower(b));
    }

    default public T intersectionUpper(B a, B b) {
        return this.min(this.upper(a), this.upper(b));
    }

    default public T unionLower(B a, B b) {
        return this.min(this.lower(a), this.lower(b));
    }

    default public T unionUpper(B a, B b) {
        return this.max(this.upper(a), this.upper(b));
    }

    default public double measure(B box) {
        return this.distance(this.upper(box), this.lower(box));
    }
}

