/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.ingest;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.ModuleInitializer;
import ghidra.util.classfinder.ClassSearcher;
import java.io.File;
import java.util.List;

public class HeadlessBSimApplicationConfiguration
extends ApplicationConfiguration {
    protected void initializeApplication() {
        super.initializeApplication();
        this.locateCACertsFile();
        this.monitor.setMessage("Performing module initialization...");
        this.performModuleInitialization();
        this.monitor.setMessage("Done initializing");
    }

    private void locateCACertsFile() {
        for (ResourceFile appRoot : Application.getApplicationRootDirectories()) {
            File cacertsFile = new File(appRoot.getAbsolutePath(), "cacerts");
            if (!cacertsFile.isFile()) continue;
            System.setProperty("ghidra.cacerts", cacertsFile.getAbsolutePath());
            break;
        }
    }

    private void performModuleInitialization() {
        List instances = ClassSearcher.getInstances(ModuleInitializer.class);
        for (ModuleInitializer initializer : instances) {
            this.monitor.setMessage("Initializing " + initializer.getName() + "...");
            initializer.run();
        }
    }
}

