﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/panorama/PanoramaRequest.h>
#include <aws/panorama/Panorama_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace Panorama {
namespace Model {

/**
 */
class ListApplicationInstanceNodeInstancesRequest : public PanoramaRequest {
 public:
  AWS_PANORAMA_API ListApplicationInstanceNodeInstancesRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ListApplicationInstanceNodeInstances"; }

  AWS_PANORAMA_API Aws::String SerializePayload() const override;

  AWS_PANORAMA_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The node instances' application instance ID.</p>
   */
  inline const Aws::String& GetApplicationInstanceId() const { return m_applicationInstanceId; }
  inline bool ApplicationInstanceIdHasBeenSet() const { return m_applicationInstanceIdHasBeenSet; }
  template <typename ApplicationInstanceIdT = Aws::String>
  void SetApplicationInstanceId(ApplicationInstanceIdT&& value) {
    m_applicationInstanceIdHasBeenSet = true;
    m_applicationInstanceId = std::forward<ApplicationInstanceIdT>(value);
  }
  template <typename ApplicationInstanceIdT = Aws::String>
  ListApplicationInstanceNodeInstancesRequest& WithApplicationInstanceId(ApplicationInstanceIdT&& value) {
    SetApplicationInstanceId(std::forward<ApplicationInstanceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of node instances to return in one page of results.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline ListApplicationInstanceNodeInstancesRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specify the pagination token from a previous request to retrieve the next
   * page of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListApplicationInstanceNodeInstancesRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_applicationInstanceId;

  int m_maxResults{0};

  Aws::String m_nextToken;
  bool m_applicationInstanceIdHasBeenSet = false;
  bool m_maxResultsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace Panorama
}  // namespace Aws
