/* VpnInterface.c generated by valac 0.56.17, the Vala compiler
 * generated from VpnInterface.vala, do not modify */

/*
* SPDX-License-Identifier: LGPL-2.1-or-later
* SPDX-FileCopyrightText: 2017-2023 elementary, Inc. (https://elementary.io)
*/

#include "network.h"
#include <NetworkManager.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_VPN_INTERFACE_0_PROPERTY,
	NETWORK_VPN_INTERFACE_NM_CLIENT_PROPERTY,
	NETWORK_VPN_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* network_vpn_interface_properties[NETWORK_VPN_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _NetworkVpnInterfacePrivate {
	NMClient* _nm_client;
	GtkFlowBox* vpn_list;
};

struct _Block5Data {
	int _ref_count_;
	NetworkVpnInterface* self;
	NetworkVpnMenuItem* item;
};

static gint NetworkVpnInterface_private_offset;
static gpointer network_vpn_interface_parent_class = NULL;

static void network_vpn_interface_check_vpn_availability (NetworkVpnInterface* self);
static void network_vpn_interface_show_vpn (NetworkVpnInterface* self,
                                     gboolean show);
static void network_vpn_interface_active_connected_added_cb (NetworkVpnInterface* self,
                                                      NMActiveConnection* active_connection);
static NetworkVpnMenuItem* network_vpn_interface_get_item_for_active_connection (NetworkVpnInterface* self,
                                                                          NMActiveConnection* active_connection);
static void network_vpn_interface_active_connected_removed_cb (NetworkVpnInterface* self,
                                                        NMActiveConnection* active_connection);
static void network_vpn_interface_vpn_activate_cb (NetworkVpnInterface* self,
                                            NetworkVpnMenuItem* item);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda25_ (Block5Data* _data5_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda25__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda26_ (Block5Data* _data5_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda26__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void network_vpn_interface_vpn_added_cb (NetworkVpnInterface* self,
                                         GObject* obj);
static void network_vpn_interface_vpn_removed_cb (NetworkVpnInterface* self,
                                           NMRemoteConnection* connection);
static GObject * network_vpn_interface_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void _network_vpn_interface___lambda27_ (NetworkVpnInterface* self,
                                         NMRemoteConnection* connection);
static void __network_vpn_interface___lambda27__gfunc (gconstpointer data,
                                                gpointer self);
static void _network_vpn_interface___lambda28_ (NetworkVpnInterface* self,
                                         NMActiveConnection* connection);
static void __network_vpn_interface___lambda28__gfunc (gconstpointer data,
                                                gpointer self);
static void _network_vpn_interface_check_vpn_availability_gtk_container_add (GtkContainer* _sender,
                                                                      GtkWidget* widget,
                                                                      gpointer self);
static void _network_vpn_interface_check_vpn_availability_gtk_container_remove (GtkContainer* _sender,
                                                                         GtkWidget* widget,
                                                                         gpointer self);
static void _network_vpn_interface_vpn_added_cb_nm_client_connection_added (NMClient* _sender,
                                                                     NMRemoteConnection* connection,
                                                                     gpointer self);
static void _network_vpn_interface_vpn_removed_cb_nm_client_connection_removed (NMClient* _sender,
                                                                         NMRemoteConnection* connection,
                                                                         gpointer self);
static void _network_vpn_interface_active_connected_added_cb_nm_client_active_connection_added (NMClient* _sender,
                                                                                         NMActiveConnection* active_connection,
                                                                                         gpointer self);
static void _network_vpn_interface_active_connected_removed_cb_nm_client_active_connection_removed (NMClient* _sender,
                                                                                             NMActiveConnection* active_connection,
                                                                                             gpointer self);
static void _network_vpn_interface___lambda29_ (NetworkVpnInterface* self,
                                         GtkFlowBoxChild* child);
static void __network_vpn_interface___lambda29__gtk_flow_box_child_activated (GtkFlowBox* _sender,
                                                                       GtkFlowBoxChild* child,
                                                                       gpointer self);
static void network_vpn_interface_finalize (GObject * obj);
static GType network_vpn_interface_get_type_once (void);
static void _vala_network_vpn_interface_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_network_vpn_interface_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
network_vpn_interface_get_instance_private (NetworkVpnInterface* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkVpnInterface_private_offset);
}

NetworkVpnInterface*
network_vpn_interface_construct (GType object_type,
                                 NMClient* nm_client)
{
	NetworkVpnInterface * self = NULL;
	g_return_val_if_fail (nm_client != NULL, NULL);
	self = (NetworkVpnInterface*) g_object_new (object_type, "nm-client", nm_client, NULL);
	return self;
}

NetworkVpnInterface*
network_vpn_interface_new (NMClient* nm_client)
{
	return network_vpn_interface_construct (NETWORK_TYPE_VPN_INTERFACE, nm_client);
}

static void
network_vpn_interface_check_vpn_availability (NetworkVpnInterface* self)
{
	GtkFlowBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->vpn_list;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	_tmp2_ = _tmp1_;
	network_vpn_interface_show_vpn (self, g_list_length (_tmp2_) > ((guint) 0));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
}

static void
network_vpn_interface_show_vpn (NetworkVpnInterface* self,
                                gboolean show)
{
	GtkSeparator* _tmp0_;
	GtkSeparator* _tmp1_;
	GtkSeparator* _tmp2_;
	GtkSeparator* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = network_widget_nm_interface_get_sep ((NetworkWidgetNMInterface*) self);
	_tmp1_ = _tmp0_;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp1_, !show);
	gtk_widget_set_no_show_all ((GtkWidget*) self, !show);
	_tmp2_ = network_widget_nm_interface_get_sep ((NetworkWidgetNMInterface*) self);
	_tmp3_ = _tmp2_;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, show);
	gtk_widget_set_visible ((GtkWidget*) self, show);
}

static void
network_vpn_interface_active_connected_added_cb (NetworkVpnInterface* self,
                                                 NMActiveConnection* active_connection)
{
	const gchar* connection_type = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	NetworkVpnMenuItem* menu_item = NULL;
	NetworkVpnMenuItem* _tmp4_;
	NetworkVpnMenuItem* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (active_connection != NULL);
	_tmp0_ = nm_active_connection_get_connection_type (active_connection);
	connection_type = _tmp0_;
	_tmp2_ = connection_type;
	if (g_strcmp0 (_tmp2_, NM_SETTING_VPN_SETTING_NAME) != 0) {
		const gchar* _tmp3_;
		_tmp3_ = connection_type;
		_tmp1_ = g_strcmp0 (_tmp3_, NM_SETTING_WIREGUARD_SETTING_NAME) != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		return;
	}
	_tmp4_ = network_vpn_interface_get_item_for_active_connection (self, active_connection);
	menu_item = _tmp4_;
	_tmp5_ = menu_item;
	if (_tmp5_ != NULL) {
		NetworkVpnMenuItem* _tmp6_;
		_tmp6_ = menu_item;
		network_vpn_menu_item_set_vpn_connection (_tmp6_, active_connection);
	}
	_g_object_unref0 (menu_item);
}

static void
network_vpn_interface_active_connected_removed_cb (NetworkVpnInterface* self,
                                                   NMActiveConnection* active_connection)
{
	NetworkVpnMenuItem* menu_item = NULL;
	NetworkVpnMenuItem* _tmp0_;
	NetworkVpnMenuItem* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (active_connection != NULL);
	_tmp0_ = network_vpn_interface_get_item_for_active_connection (self, active_connection);
	menu_item = _tmp0_;
	_tmp1_ = menu_item;
	if (_tmp1_ != NULL) {
		NetworkVpnMenuItem* _tmp2_;
		_tmp2_ = menu_item;
		network_vpn_menu_item_set_vpn_connection (_tmp2_, NULL);
	}
	_g_object_unref0 (menu_item);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		NetworkVpnInterface* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->item);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
___lambda25_ (Block5Data* _data5_,
              GObject* obj,
              GAsyncResult* res)
{
	NetworkVpnInterface* self;
	GError* _inner_error0_ = NULL;
	self = _data5_->self;
	g_return_if_fail (res != NULL);
	{
		nm_client_deactivate_connection_finish (G_TYPE_CHECK_INSTANCE_CAST (obj, nm_client_get_type (), NMClient), res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data5_->item->cancellable);
		_data5_->item->cancellable = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_critical ("VpnInterface.vala:90: Unable to deactivate VPN or Wireguard: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda25__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda25_ (self, source_object, res);
	block5_data_unref (self);
}

static void
___lambda26_ (Block5Data* _data5_,
              GObject* obj,
              GAsyncResult* res)
{
	NetworkVpnInterface* self;
	GError* _inner_error0_ = NULL;
	self = _data5_->self;
	g_return_if_fail (res != NULL);
	{
		NMActiveConnection* _tmp0_;
		NMActiveConnection* _tmp1_;
		_tmp0_ = nm_client_activate_connection_finish (G_TYPE_CHECK_INSTANCE_CAST (obj, nm_client_get_type (), NMClient), res, &_inner_error0_);
		_tmp1_ = _tmp0_;
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data5_->item->cancellable);
		_data5_->item->cancellable = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("VpnInterface.vala:99: Unable to activate VPN or Wireguard: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda26__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda26_ (self, source_object, res);
	block5_data_unref (self);
}

static void
network_vpn_interface_vpn_activate_cb (NetworkVpnInterface* self,
                                       NetworkVpnMenuItem* item)
{
	Block5Data* _data5_;
	NetworkVpnMenuItem* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp3_;
	gboolean _tmp4_ = FALSE;
	NMActiveConnection* _tmp5_;
	NMActiveConnection* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (item);
	_g_object_unref0 (_data5_->item);
	_data5_->item = _tmp0_;
	_tmp1_ = _data5_->item->cancellable;
	if (_tmp1_ != NULL) {
		GCancellable* _tmp2_;
		_tmp2_ = _data5_->item->cancellable;
		g_cancellable_cancel (_tmp2_);
	}
	_tmp3_ = g_cancellable_new ();
	_g_object_unref0 (_data5_->item->cancellable);
	_data5_->item->cancellable = _tmp3_;
	_tmp5_ = network_vpn_menu_item_get_vpn_connection (_data5_->item);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		NMActiveConnection* _tmp7_;
		NMActiveConnection* _tmp8_;
		_tmp7_ = network_vpn_menu_item_get_vpn_connection (_data5_->item);
		_tmp8_ = _tmp7_;
		_tmp4_ = nm_active_connection_get_state (_tmp8_) == NM_ACTIVE_CONNECTION_STATE_ACTIVATED;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		NMClient* _tmp9_;
		NMActiveConnection* _tmp10_;
		NMActiveConnection* _tmp11_;
		GCancellable* _tmp12_;
		_tmp9_ = self->priv->_nm_client;
		_tmp10_ = network_vpn_menu_item_get_vpn_connection (_data5_->item);
		_tmp11_ = _tmp10_;
		_tmp12_ = _data5_->item->cancellable;
		nm_client_deactivate_connection_async (_tmp9_, _tmp11_, _tmp12_, ____lambda25__gasync_ready_callback, block5_data_ref (_data5_));
	} else {
		NMClient* _tmp13_;
		NMRemoteConnection* _tmp14_;
		NMRemoteConnection* _tmp15_;
		GCancellable* _tmp16_;
		_tmp13_ = self->priv->_nm_client;
		_tmp14_ = network_vpn_menu_item_get_remote_connection (_data5_->item);
		_tmp15_ = _tmp14_;
		_tmp16_ = _data5_->item->cancellable;
		nm_client_activate_connection_async (_tmp13_, (NMConnection*) _tmp15_, NULL, NULL, _tmp16_, ____lambda26__gasync_ready_callback, block5_data_ref (_data5_));
	}
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
network_vpn_interface_vpn_added_cb (NetworkVpnInterface* self,
                                    GObject* obj)
{
	NMRemoteConnection* remote_connection = NULL;
	NMRemoteConnection* _tmp0_;
	const gchar* connection_type = NULL;
	NMRemoteConnection* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, nm_remote_connection_get_type (), NMRemoteConnection));
	remote_connection = _tmp0_;
	_tmp1_ = remote_connection;
	_tmp2_ = nm_connection_get_connection_type ((NMConnection*) _tmp1_);
	connection_type = _tmp2_;
	_tmp4_ = connection_type;
	if (g_strcmp0 (_tmp4_, NM_SETTING_VPN_SETTING_NAME) == 0) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = connection_type;
		_tmp3_ = g_strcmp0 (_tmp5_, NM_SETTING_WIREGUARD_SETTING_NAME) == 0;
	}
	if (_tmp3_) {
		NetworkVpnMenuItem* item = NULL;
		NMRemoteConnection* _tmp6_;
		NetworkVpnMenuItem* _tmp7_;
		GtkFlowBox* _tmp8_;
		NetworkVpnMenuItem* _tmp9_;
		_tmp6_ = remote_connection;
		_tmp7_ = network_vpn_menu_item_new (_tmp6_);
		g_object_ref_sink (_tmp7_);
		item = _tmp7_;
		_tmp8_ = self->priv->vpn_list;
		_tmp9_ = item;
		gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
		network_vpn_interface_check_vpn_availability (self);
		_g_object_unref0 (item);
	}
	_g_object_unref0 (remote_connection);
}

static void
network_vpn_interface_vpn_removed_cb (NetworkVpnInterface* self,
                                      NMRemoteConnection* connection)
{
	GtkFlowBox* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	_tmp0_ = self->priv->vpn_list;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				NetworkVpnMenuItem* menu_item = NULL;
				GtkWidget* _tmp2_;
				NetworkVpnMenuItem* _tmp3_;
				NMRemoteConnection* _tmp4_;
				NMRemoteConnection* _tmp5_;
				_tmp2_ = child;
				menu_item = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVpnMenuItem);
				_tmp3_ = menu_item;
				_tmp4_ = network_vpn_menu_item_get_remote_connection (_tmp3_);
				_tmp5_ = _tmp4_;
				if (_tmp5_ == connection) {
					NetworkVpnMenuItem* _tmp6_;
					_tmp6_ = menu_item;
					gtk_widget_destroy ((GtkWidget*) _tmp6_);
					network_vpn_interface_check_vpn_availability (self);
					(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
					return;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

static NetworkVpnMenuItem*
network_vpn_interface_get_item_for_active_connection (NetworkVpnInterface* self,
                                                      NMActiveConnection* active_connection)
{
	GtkFlowBox* _tmp0_;
	GList* _tmp1_;
	NetworkVpnMenuItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (active_connection != NULL, NULL);
	_tmp0_ = self->priv->vpn_list;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				NetworkVpnMenuItem* menu_item = NULL;
				GtkWidget* _tmp2_;
				NetworkVpnMenuItem* _tmp3_;
				NMRemoteConnection* _tmp4_;
				NMRemoteConnection* _tmp5_;
				NMRemoteConnection* _tmp6_;
				NMRemoteConnection* _tmp7_;
				_tmp2_ = child;
				menu_item = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVpnMenuItem);
				_tmp3_ = menu_item;
				_tmp4_ = network_vpn_menu_item_get_remote_connection (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = nm_active_connection_get_connection (active_connection);
				_tmp7_ = _tmp6_;
				if (_tmp5_ == _tmp7_) {
					NetworkVpnMenuItem* _tmp8_;
					NetworkVpnMenuItem* _tmp9_;
					_tmp8_ = menu_item;
					_tmp9_ = _g_object_ref0 (_tmp8_);
					result = _tmp9_;
					(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
					return result;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	result = NULL;
	return result;
}

NMClient*
network_vpn_interface_get_nm_client (NetworkVpnInterface* self)
{
	NMClient* result;
	NMClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nm_client;
	result = _tmp0_;
	return result;
}

static void
network_vpn_interface_set_nm_client (NetworkVpnInterface* self,
                                     NMClient* value)
{
	NMClient* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_vpn_interface_get_nm_client (self);
	if (old_value != value) {
		NMClient* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_nm_client);
		self->priv->_nm_client = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_vpn_interface_properties[NETWORK_VPN_INTERFACE_NM_CLIENT_PROPERTY]);
	}
}

static void
_network_vpn_interface___lambda27_ (NetworkVpnInterface* self,
                                    NMRemoteConnection* connection)
{
	g_return_if_fail (connection != NULL);
	network_vpn_interface_vpn_added_cb (self, (GObject*) connection);
}

static void
__network_vpn_interface___lambda27__gfunc (gconstpointer data,
                                           gpointer self)
{
	_network_vpn_interface___lambda27_ ((NetworkVpnInterface*) self, (NMRemoteConnection*) data);
}

static void
_network_vpn_interface___lambda28_ (NetworkVpnInterface* self,
                                    NMActiveConnection* connection)
{
	g_return_if_fail (connection != NULL);
	network_vpn_interface_active_connected_added_cb (self, connection);
}

static void
__network_vpn_interface___lambda28__gfunc (gconstpointer data,
                                           gpointer self)
{
	_network_vpn_interface___lambda28_ ((NetworkVpnInterface*) self, (NMActiveConnection*) data);
}

static void
_network_vpn_interface_check_vpn_availability_gtk_container_add (GtkContainer* _sender,
                                                                 GtkWidget* widget,
                                                                 gpointer self)
{
	network_vpn_interface_check_vpn_availability ((NetworkVpnInterface*) self);
}

static void
_network_vpn_interface_check_vpn_availability_gtk_container_remove (GtkContainer* _sender,
                                                                    GtkWidget* widget,
                                                                    gpointer self)
{
	network_vpn_interface_check_vpn_availability ((NetworkVpnInterface*) self);
}

static void
_network_vpn_interface_vpn_added_cb_nm_client_connection_added (NMClient* _sender,
                                                                NMRemoteConnection* connection,
                                                                gpointer self)
{
	network_vpn_interface_vpn_added_cb ((NetworkVpnInterface*) self, connection);
}

static void
_network_vpn_interface_vpn_removed_cb_nm_client_connection_removed (NMClient* _sender,
                                                                    NMRemoteConnection* connection,
                                                                    gpointer self)
{
	network_vpn_interface_vpn_removed_cb ((NetworkVpnInterface*) self, connection);
}

static void
_network_vpn_interface_active_connected_added_cb_nm_client_active_connection_added (NMClient* _sender,
                                                                                    NMActiveConnection* active_connection,
                                                                                    gpointer self)
{
	network_vpn_interface_active_connected_added_cb ((NetworkVpnInterface*) self, active_connection);
}

static void
_network_vpn_interface_active_connected_removed_cb_nm_client_active_connection_removed (NMClient* _sender,
                                                                                        NMActiveConnection* active_connection,
                                                                                        gpointer self)
{
	network_vpn_interface_active_connected_removed_cb ((NetworkVpnInterface*) self, active_connection);
}

static void
_network_vpn_interface___lambda29_ (NetworkVpnInterface* self,
                                    GtkFlowBoxChild* child)
{
	g_return_if_fail (child != NULL);
	network_vpn_interface_vpn_activate_cb (self, G_TYPE_CHECK_INSTANCE_CAST (child, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVpnMenuItem));
}

static void
__network_vpn_interface___lambda29__gtk_flow_box_child_activated (GtkFlowBox* _sender,
                                                                  GtkFlowBoxChild* child,
                                                                  gpointer self)
{
	_network_vpn_interface___lambda29_ ((NetworkVpnInterface*) self, child);
}

static GObject *
network_vpn_interface_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkVpnInterface * self;
	GtkFlowBox* _tmp0_ = NULL;
	GtkFlowBox* _tmp1_;
	NMClient* _tmp2_;
	GPtrArray* _tmp3_;
	NMClient* _tmp4_;
	GPtrArray* _tmp5_;
	GtkFlowBox* _tmp6_;
	GtkFlowBox* _tmp7_;
	NMClient* _tmp8_;
	NMClient* _tmp9_;
	NMClient* _tmp10_;
	NMClient* _tmp11_;
	GtkFlowBox* _tmp12_;
	parent_class = G_OBJECT_CLASS (network_vpn_interface_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_VPN_INTERFACE, NetworkVpnInterface);
	_tmp0_ = (GtkFlowBox*) gtk_flow_box_new ();
	gtk_flow_box_set_column_spacing (_tmp0_, (guint) 6);
	gtk_flow_box_set_row_spacing (_tmp0_, (guint) 12);
	gtk_flow_box_set_homogeneous (_tmp0_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp0_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp0_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp0_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp0_, 12);
	gtk_flow_box_set_max_children_per_line (_tmp0_, (guint) 3);
	gtk_flow_box_set_selection_mode (_tmp0_, GTK_SELECTION_NONE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->vpn_list);
	self->priv->vpn_list = _tmp0_;
	_tmp1_ = self->priv->vpn_list;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->_nm_client;
	_tmp3_ = nm_client_get_connections (_tmp2_);
	g_ptr_array_foreach (_tmp3_, __network_vpn_interface___lambda27__gfunc, self);
	_tmp4_ = self->priv->_nm_client;
	_tmp5_ = nm_client_get_active_connections (_tmp4_);
	g_ptr_array_foreach (_tmp5_, __network_vpn_interface___lambda28__gfunc, self);
	network_vpn_interface_check_vpn_availability (self);
	_tmp6_ = self->priv->vpn_list;
	g_signal_connect_object ((GtkContainer*) _tmp6_, "add", (GCallback) _network_vpn_interface_check_vpn_availability_gtk_container_add, self, 0);
	_tmp7_ = self->priv->vpn_list;
	g_signal_connect_object ((GtkContainer*) _tmp7_, "remove", (GCallback) _network_vpn_interface_check_vpn_availability_gtk_container_remove, self, 0);
	_tmp8_ = self->priv->_nm_client;
	g_signal_connect_object (_tmp8_, "connection-added", (GCallback) _network_vpn_interface_vpn_added_cb_nm_client_connection_added, self, 0);
	_tmp9_ = self->priv->_nm_client;
	g_signal_connect_object (_tmp9_, "connection-removed", (GCallback) _network_vpn_interface_vpn_removed_cb_nm_client_connection_removed, self, 0);
	_tmp10_ = self->priv->_nm_client;
	g_signal_connect_object (_tmp10_, "active-connection-added", (GCallback) _network_vpn_interface_active_connected_added_cb_nm_client_active_connection_added, self, 0);
	_tmp11_ = self->priv->_nm_client;
	g_signal_connect_object (_tmp11_, "active-connection-removed", (GCallback) _network_vpn_interface_active_connected_removed_cb_nm_client_active_connection_removed, self, 0);
	_tmp12_ = self->priv->vpn_list;
	g_signal_connect_object (_tmp12_, "child-activated", (GCallback) __network_vpn_interface___lambda29__gtk_flow_box_child_activated, self, 0);
	return obj;
}

static void
network_vpn_interface_class_init (NetworkVpnInterfaceClass * klass,
                                  gpointer klass_data)
{
	network_vpn_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkVpnInterface_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_network_vpn_interface_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_vpn_interface_set_property;
	G_OBJECT_CLASS (klass)->constructor = network_vpn_interface_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_vpn_interface_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_VPN_INTERFACE_NM_CLIENT_PROPERTY, network_vpn_interface_properties[NETWORK_VPN_INTERFACE_NM_CLIENT_PROPERTY] = g_param_spec_object ("nm-client", "nm-client", "nm-client", nm_client_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
network_vpn_interface_instance_init (NetworkVpnInterface * self,
                                     gpointer klass)
{
	self->priv = network_vpn_interface_get_instance_private (self);
}

static void
network_vpn_interface_finalize (GObject * obj)
{
	NetworkVpnInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_VPN_INTERFACE, NetworkVpnInterface);
	_g_object_unref0 (self->priv->_nm_client);
	_g_object_unref0 (self->priv->vpn_list);
	G_OBJECT_CLASS (network_vpn_interface_parent_class)->finalize (obj);
}

static GType
network_vpn_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkVpnInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_vpn_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkVpnInterface), 0, (GInstanceInitFunc) network_vpn_interface_instance_init, NULL };
	GType network_vpn_interface_type_id;
	network_vpn_interface_type_id = g_type_register_static (NETWORK_TYPE_WIDGET_NM_INTERFACE, "NetworkVpnInterface", &g_define_type_info, 0);
	NetworkVpnInterface_private_offset = g_type_add_instance_private (network_vpn_interface_type_id, sizeof (NetworkVpnInterfacePrivate));
	return network_vpn_interface_type_id;
}

GType
network_vpn_interface_get_type (void)
{
	static volatile gsize network_vpn_interface_type_id__once = 0;
	if (g_once_init_enter (&network_vpn_interface_type_id__once)) {
		GType network_vpn_interface_type_id;
		network_vpn_interface_type_id = network_vpn_interface_get_type_once ();
		g_once_init_leave (&network_vpn_interface_type_id__once, network_vpn_interface_type_id);
	}
	return network_vpn_interface_type_id__once;
}

static void
_vala_network_vpn_interface_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	NetworkVpnInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_VPN_INTERFACE, NetworkVpnInterface);
	switch (property_id) {
		case NETWORK_VPN_INTERFACE_NM_CLIENT_PROPERTY:
		g_value_set_object (value, network_vpn_interface_get_nm_client (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_vpn_interface_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	NetworkVpnInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_VPN_INTERFACE, NetworkVpnInterface);
	switch (property_id) {
		case NETWORK_VPN_INTERFACE_NM_CLIENT_PROPERTY:
		network_vpn_interface_set_nm_client (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

