#include <wayland-server-protocol-unstable.hpp>

using namespace wayland;
using namespace wayland::detail;
using namespace wayland::server;
using namespace wayland::server::detail;

const wl_interface* zwp_fullscreen_shell_v1_interface_release_request_server[0] = {
};

const wl_interface* zwp_fullscreen_shell_v1_interface_present_surface_request_server[3] = {
  &surface_interface,
  nullptr,
  &output_interface,
};

const wl_interface* zwp_fullscreen_shell_v1_interface_present_surface_for_mode_request_server[4] = {
  &surface_interface,
  &output_interface,
  nullptr,
  &zwp_fullscreen_shell_mode_feedback_v1_interface,
};

const wl_interface* zwp_fullscreen_shell_v1_interface_capability_event_server[1] = {
  nullptr,
};

const wl_message zwp_fullscreen_shell_v1_interface_requests_server[3] = {
  {
    "release",
    "",
    zwp_fullscreen_shell_v1_interface_release_request_server,
  },
  {
    "present_surface",
    "?ou?o",
    zwp_fullscreen_shell_v1_interface_present_surface_request_server,
  },
  {
    "present_surface_for_mode",
    "ooin",
    zwp_fullscreen_shell_v1_interface_present_surface_for_mode_request_server,
  },
};

const wl_message zwp_fullscreen_shell_v1_interface_events_server[1] = {
  {
    "capability",
    "u",
    zwp_fullscreen_shell_v1_interface_capability_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_fullscreen_shell_v1_interface =
  {
    "zwp_fullscreen_shell_v1",
    1,
    3,
    zwp_fullscreen_shell_v1_interface_requests_server,
    1,
    zwp_fullscreen_shell_v1_interface_events_server,
  };

const wl_interface* zwp_fullscreen_shell_mode_feedback_v1_interface_mode_successful_event_server[0] = {
};

const wl_interface* zwp_fullscreen_shell_mode_feedback_v1_interface_mode_failed_event_server[0] = {
};

const wl_interface* zwp_fullscreen_shell_mode_feedback_v1_interface_present_cancelled_event_server[0] = {
};

const wl_message zwp_fullscreen_shell_mode_feedback_v1_interface_requests_server[0] = {
};

const wl_message zwp_fullscreen_shell_mode_feedback_v1_interface_events_server[3] = {
  {
    "mode_successful",
    "",
    zwp_fullscreen_shell_mode_feedback_v1_interface_mode_successful_event_server,
  },
  {
    "mode_failed",
    "",
    zwp_fullscreen_shell_mode_feedback_v1_interface_mode_failed_event_server,
  },
  {
    "present_cancelled",
    "",
    zwp_fullscreen_shell_mode_feedback_v1_interface_present_cancelled_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_fullscreen_shell_mode_feedback_v1_interface =
  {
    "zwp_fullscreen_shell_mode_feedback_v1",
    1,
    0,
    zwp_fullscreen_shell_mode_feedback_v1_interface_requests_server,
    3,
    zwp_fullscreen_shell_mode_feedback_v1_interface_events_server,
  };

const wl_interface* zwp_idle_inhibit_manager_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_idle_inhibit_manager_v1_interface_create_inhibitor_request_server[2] = {
  &zwp_idle_inhibitor_v1_interface,
  &surface_interface,
};

const wl_message zwp_idle_inhibit_manager_v1_interface_requests_server[2] = {
  {
    "destroy",
    "",
    zwp_idle_inhibit_manager_v1_interface_destroy_request_server,
  },
  {
    "create_inhibitor",
    "no",
    zwp_idle_inhibit_manager_v1_interface_create_inhibitor_request_server,
  },
};

const wl_message zwp_idle_inhibit_manager_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zwp_idle_inhibit_manager_v1_interface =
  {
    "zwp_idle_inhibit_manager_v1",
    1,
    2,
    zwp_idle_inhibit_manager_v1_interface_requests_server,
    0,
    zwp_idle_inhibit_manager_v1_interface_events_server,
  };

const wl_interface* zwp_idle_inhibitor_v1_interface_destroy_request_server[0] = {
};

const wl_message zwp_idle_inhibitor_v1_interface_requests_server[1] = {
  {
    "destroy",
    "",
    zwp_idle_inhibitor_v1_interface_destroy_request_server,
  },
};

const wl_message zwp_idle_inhibitor_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zwp_idle_inhibitor_v1_interface =
  {
    "zwp_idle_inhibitor_v1",
    1,
    1,
    zwp_idle_inhibitor_v1_interface_requests_server,
    0,
    zwp_idle_inhibitor_v1_interface_events_server,
  };

const wl_interface* zwp_input_method_context_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_input_method_context_v1_interface_commit_string_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_preedit_string_request_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_preedit_styling_request_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_preedit_cursor_request_server[1] = {
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_delete_surrounding_text_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_cursor_position_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_modifiers_map_request_server[1] = {
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_keysym_request_server[5] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_grab_keyboard_request_server[1] = {
  &keyboard_interface,
};

const wl_interface* zwp_input_method_context_v1_interface_key_request_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_modifiers_request_server[5] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_language_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_text_direction_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_surrounding_text_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_reset_event_server[0] = {
};

const wl_interface* zwp_input_method_context_v1_interface_content_type_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_invoke_action_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_commit_state_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_preferred_language_event_server[1] = {
  nullptr,
};

const wl_message zwp_input_method_context_v1_interface_requests_server[14] = {
  {
    "destroy",
    "",
    zwp_input_method_context_v1_interface_destroy_request_server,
  },
  {
    "commit_string",
    "us",
    zwp_input_method_context_v1_interface_commit_string_request_server,
  },
  {
    "preedit_string",
    "uss",
    zwp_input_method_context_v1_interface_preedit_string_request_server,
  },
  {
    "preedit_styling",
    "uuu",
    zwp_input_method_context_v1_interface_preedit_styling_request_server,
  },
  {
    "preedit_cursor",
    "i",
    zwp_input_method_context_v1_interface_preedit_cursor_request_server,
  },
  {
    "delete_surrounding_text",
    "iu",
    zwp_input_method_context_v1_interface_delete_surrounding_text_request_server,
  },
  {
    "cursor_position",
    "ii",
    zwp_input_method_context_v1_interface_cursor_position_request_server,
  },
  {
    "modifiers_map",
    "a",
    zwp_input_method_context_v1_interface_modifiers_map_request_server,
  },
  {
    "keysym",
    "uuuuu",
    zwp_input_method_context_v1_interface_keysym_request_server,
  },
  {
    "grab_keyboard",
    "n",
    zwp_input_method_context_v1_interface_grab_keyboard_request_server,
  },
  {
    "key",
    "uuuu",
    zwp_input_method_context_v1_interface_key_request_server,
  },
  {
    "modifiers",
    "uuuuu",
    zwp_input_method_context_v1_interface_modifiers_request_server,
  },
  {
    "language",
    "us",
    zwp_input_method_context_v1_interface_language_request_server,
  },
  {
    "text_direction",
    "uu",
    zwp_input_method_context_v1_interface_text_direction_request_server,
  },
};

const wl_message zwp_input_method_context_v1_interface_events_server[6] = {
  {
    "surrounding_text",
    "suu",
    zwp_input_method_context_v1_interface_surrounding_text_event_server,
  },
  {
    "reset",
    "",
    zwp_input_method_context_v1_interface_reset_event_server,
  },
  {
    "content_type",
    "uu",
    zwp_input_method_context_v1_interface_content_type_event_server,
  },
  {
    "invoke_action",
    "uu",
    zwp_input_method_context_v1_interface_invoke_action_event_server,
  },
  {
    "commit_state",
    "u",
    zwp_input_method_context_v1_interface_commit_state_event_server,
  },
  {
    "preferred_language",
    "s",
    zwp_input_method_context_v1_interface_preferred_language_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_input_method_context_v1_interface =
  {
    "zwp_input_method_context_v1",
    1,
    14,
    zwp_input_method_context_v1_interface_requests_server,
    6,
    zwp_input_method_context_v1_interface_events_server,
  };

const wl_interface* zwp_input_method_v1_interface_activate_event_server[1] = {
  &zwp_input_method_context_v1_interface,
};

const wl_interface* zwp_input_method_v1_interface_deactivate_event_server[1] = {
  &zwp_input_method_context_v1_interface,
};

const wl_message zwp_input_method_v1_interface_requests_server[0] = {
};

const wl_message zwp_input_method_v1_interface_events_server[2] = {
  {
    "activate",
    "n",
    zwp_input_method_v1_interface_activate_event_server,
  },
  {
    "deactivate",
    "o",
    zwp_input_method_v1_interface_deactivate_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_input_method_v1_interface =
  {
    "zwp_input_method_v1",
    1,
    0,
    zwp_input_method_v1_interface_requests_server,
    2,
    zwp_input_method_v1_interface_events_server,
  };

const wl_interface* zwp_input_panel_v1_interface_get_input_panel_surface_request_server[2] = {
  &zwp_input_panel_surface_v1_interface,
  &surface_interface,
};

const wl_message zwp_input_panel_v1_interface_requests_server[1] = {
  {
    "get_input_panel_surface",
    "no",
    zwp_input_panel_v1_interface_get_input_panel_surface_request_server,
  },
};

const wl_message zwp_input_panel_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zwp_input_panel_v1_interface =
  {
    "zwp_input_panel_v1",
    1,
    1,
    zwp_input_panel_v1_interface_requests_server,
    0,
    zwp_input_panel_v1_interface_events_server,
  };

const wl_interface* zwp_input_panel_surface_v1_interface_set_toplevel_request_server[2] = {
  &output_interface,
  nullptr,
};

const wl_interface* zwp_input_panel_surface_v1_interface_set_overlay_panel_request_server[0] = {
};

const wl_message zwp_input_panel_surface_v1_interface_requests_server[2] = {
  {
    "set_toplevel",
    "ou",
    zwp_input_panel_surface_v1_interface_set_toplevel_request_server,
  },
  {
    "set_overlay_panel",
    "",
    zwp_input_panel_surface_v1_interface_set_overlay_panel_request_server,
  },
};

const wl_message zwp_input_panel_surface_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zwp_input_panel_surface_v1_interface =
  {
    "zwp_input_panel_surface_v1",
    1,
    2,
    zwp_input_panel_surface_v1_interface_requests_server,
    0,
    zwp_input_panel_surface_v1_interface_events_server,
  };

const wl_interface* zwp_input_timestamps_manager_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_input_timestamps_manager_v1_interface_get_keyboard_timestamps_request_server[2] = {
  &zwp_input_timestamps_v1_interface,
  &keyboard_interface,
};

const wl_interface* zwp_input_timestamps_manager_v1_interface_get_pointer_timestamps_request_server[2] = {
  &zwp_input_timestamps_v1_interface,
  &pointer_interface,
};

const wl_interface* zwp_input_timestamps_manager_v1_interface_get_touch_timestamps_request_server[2] = {
  &zwp_input_timestamps_v1_interface,
  &touch_interface,
};

const wl_message zwp_input_timestamps_manager_v1_interface_requests_server[4] = {
  {
    "destroy",
    "",
    zwp_input_timestamps_manager_v1_interface_destroy_request_server,
  },
  {
    "get_keyboard_timestamps",
    "no",
    zwp_input_timestamps_manager_v1_interface_get_keyboard_timestamps_request_server,
  },
  {
    "get_pointer_timestamps",
    "no",
    zwp_input_timestamps_manager_v1_interface_get_pointer_timestamps_request_server,
  },
  {
    "get_touch_timestamps",
    "no",
    zwp_input_timestamps_manager_v1_interface_get_touch_timestamps_request_server,
  },
};

const wl_message zwp_input_timestamps_manager_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zwp_input_timestamps_manager_v1_interface =
  {
    "zwp_input_timestamps_manager_v1",
    1,
    4,
    zwp_input_timestamps_manager_v1_interface_requests_server,
    0,
    zwp_input_timestamps_manager_v1_interface_events_server,
  };

const wl_interface* zwp_input_timestamps_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_input_timestamps_v1_interface_timestamp_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_message zwp_input_timestamps_v1_interface_requests_server[1] = {
  {
    "destroy",
    "",
    zwp_input_timestamps_v1_interface_destroy_request_server,
  },
};

const wl_message zwp_input_timestamps_v1_interface_events_server[1] = {
  {
    "timestamp",
    "uuu",
    zwp_input_timestamps_v1_interface_timestamp_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_input_timestamps_v1_interface =
  {
    "zwp_input_timestamps_v1",
    1,
    1,
    zwp_input_timestamps_v1_interface_requests_server,
    1,
    zwp_input_timestamps_v1_interface_events_server,
  };

const wl_interface* zwp_keyboard_shortcuts_inhibit_manager_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_keyboard_shortcuts_inhibit_manager_v1_interface_inhibit_shortcuts_request_server[3] = {
  &zwp_keyboard_shortcuts_inhibitor_v1_interface,
  &surface_interface,
  &seat_interface,
};

const wl_message zwp_keyboard_shortcuts_inhibit_manager_v1_interface_requests_server[2] = {
  {
    "destroy",
    "",
    zwp_keyboard_shortcuts_inhibit_manager_v1_interface_destroy_request_server,
  },
  {
    "inhibit_shortcuts",
    "noo",
    zwp_keyboard_shortcuts_inhibit_manager_v1_interface_inhibit_shortcuts_request_server,
  },
};

const wl_message zwp_keyboard_shortcuts_inhibit_manager_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zwp_keyboard_shortcuts_inhibit_manager_v1_interface =
  {
    "zwp_keyboard_shortcuts_inhibit_manager_v1",
    1,
    2,
    zwp_keyboard_shortcuts_inhibit_manager_v1_interface_requests_server,
    0,
    zwp_keyboard_shortcuts_inhibit_manager_v1_interface_events_server,
  };

const wl_interface* zwp_keyboard_shortcuts_inhibitor_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_keyboard_shortcuts_inhibitor_v1_interface_active_event_server[0] = {
};

const wl_interface* zwp_keyboard_shortcuts_inhibitor_v1_interface_inactive_event_server[0] = {
};

const wl_message zwp_keyboard_shortcuts_inhibitor_v1_interface_requests_server[1] = {
  {
    "destroy",
    "",
    zwp_keyboard_shortcuts_inhibitor_v1_interface_destroy_request_server,
  },
};

const wl_message zwp_keyboard_shortcuts_inhibitor_v1_interface_events_server[2] = {
  {
    "active",
    "",
    zwp_keyboard_shortcuts_inhibitor_v1_interface_active_event_server,
  },
  {
    "inactive",
    "",
    zwp_keyboard_shortcuts_inhibitor_v1_interface_inactive_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_keyboard_shortcuts_inhibitor_v1_interface =
  {
    "zwp_keyboard_shortcuts_inhibitor_v1",
    1,
    1,
    zwp_keyboard_shortcuts_inhibitor_v1_interface_requests_server,
    2,
    zwp_keyboard_shortcuts_inhibitor_v1_interface_events_server,
  };

const wl_interface* zwp_linux_dmabuf_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_linux_dmabuf_v1_interface_create_params_request_server[1] = {
  &zwp_linux_buffer_params_v1_interface,
};

const wl_interface* zwp_linux_dmabuf_v1_interface_get_default_feedback_request_server[1] = {
  &zwp_linux_dmabuf_feedback_v1_interface,
};

const wl_interface* zwp_linux_dmabuf_v1_interface_get_surface_feedback_request_server[2] = {
  &zwp_linux_dmabuf_feedback_v1_interface,
  &surface_interface,
};

const wl_interface* zwp_linux_dmabuf_v1_interface_format_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_linux_dmabuf_v1_interface_modifier_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_message zwp_linux_dmabuf_v1_interface_requests_server[4] = {
  {
    "destroy",
    "",
    zwp_linux_dmabuf_v1_interface_destroy_request_server,
  },
  {
    "create_params",
    "n",
    zwp_linux_dmabuf_v1_interface_create_params_request_server,
  },
  {
    "get_default_feedback",
    "4n",
    zwp_linux_dmabuf_v1_interface_get_default_feedback_request_server,
  },
  {
    "get_surface_feedback",
    "4no",
    zwp_linux_dmabuf_v1_interface_get_surface_feedback_request_server,
  },
};

const wl_message zwp_linux_dmabuf_v1_interface_events_server[2] = {
  {
    "format",
    "u",
    zwp_linux_dmabuf_v1_interface_format_event_server,
  },
  {
    "modifier",
    "3uuu",
    zwp_linux_dmabuf_v1_interface_modifier_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_linux_dmabuf_v1_interface =
  {
    "zwp_linux_dmabuf_v1",
    4,
    4,
    zwp_linux_dmabuf_v1_interface_requests_server,
    2,
    zwp_linux_dmabuf_v1_interface_events_server,
  };

const wl_interface* zwp_linux_buffer_params_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_linux_buffer_params_v1_interface_add_request_server[6] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_linux_buffer_params_v1_interface_create_request_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_linux_buffer_params_v1_interface_create_immed_request_server[5] = {
  &buffer_interface,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_linux_buffer_params_v1_interface_created_event_server[1] = {
  &buffer_interface,
};

const wl_interface* zwp_linux_buffer_params_v1_interface_failed_event_server[0] = {
};

const wl_message zwp_linux_buffer_params_v1_interface_requests_server[4] = {
  {
    "destroy",
    "",
    zwp_linux_buffer_params_v1_interface_destroy_request_server,
  },
  {
    "add",
    "huuuuu",
    zwp_linux_buffer_params_v1_interface_add_request_server,
  },
  {
    "create",
    "iiuu",
    zwp_linux_buffer_params_v1_interface_create_request_server,
  },
  {
    "create_immed",
    "2niiuu",
    zwp_linux_buffer_params_v1_interface_create_immed_request_server,
  },
};

const wl_message zwp_linux_buffer_params_v1_interface_events_server[2] = {
  {
    "created",
    "n",
    zwp_linux_buffer_params_v1_interface_created_event_server,
  },
  {
    "failed",
    "",
    zwp_linux_buffer_params_v1_interface_failed_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_linux_buffer_params_v1_interface =
  {
    "zwp_linux_buffer_params_v1",
    4,
    4,
    zwp_linux_buffer_params_v1_interface_requests_server,
    2,
    zwp_linux_buffer_params_v1_interface_events_server,
  };

const wl_interface* zwp_linux_dmabuf_feedback_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_linux_dmabuf_feedback_v1_interface_done_event_server[0] = {
};

const wl_interface* zwp_linux_dmabuf_feedback_v1_interface_format_table_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_linux_dmabuf_feedback_v1_interface_main_device_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_linux_dmabuf_feedback_v1_interface_tranche_done_event_server[0] = {
};

const wl_interface* zwp_linux_dmabuf_feedback_v1_interface_tranche_target_device_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_linux_dmabuf_feedback_v1_interface_tranche_formats_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_linux_dmabuf_feedback_v1_interface_tranche_flags_event_server[1] = {
  nullptr,
};

const wl_message zwp_linux_dmabuf_feedback_v1_interface_requests_server[1] = {
  {
    "destroy",
    "",
    zwp_linux_dmabuf_feedback_v1_interface_destroy_request_server,
  },
};

const wl_message zwp_linux_dmabuf_feedback_v1_interface_events_server[7] = {
  {
    "done",
    "",
    zwp_linux_dmabuf_feedback_v1_interface_done_event_server,
  },
  {
    "format_table",
    "hu",
    zwp_linux_dmabuf_feedback_v1_interface_format_table_event_server,
  },
  {
    "main_device",
    "a",
    zwp_linux_dmabuf_feedback_v1_interface_main_device_event_server,
  },
  {
    "tranche_done",
    "",
    zwp_linux_dmabuf_feedback_v1_interface_tranche_done_event_server,
  },
  {
    "tranche_target_device",
    "a",
    zwp_linux_dmabuf_feedback_v1_interface_tranche_target_device_event_server,
  },
  {
    "tranche_formats",
    "a",
    zwp_linux_dmabuf_feedback_v1_interface_tranche_formats_event_server,
  },
  {
    "tranche_flags",
    "u",
    zwp_linux_dmabuf_feedback_v1_interface_tranche_flags_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_linux_dmabuf_feedback_v1_interface =
  {
    "zwp_linux_dmabuf_feedback_v1",
    4,
    1,
    zwp_linux_dmabuf_feedback_v1_interface_requests_server,
    7,
    zwp_linux_dmabuf_feedback_v1_interface_events_server,
  };

const wl_interface* zwp_linux_explicit_synchronization_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_linux_explicit_synchronization_v1_interface_get_synchronization_request_server[2] = {
  &zwp_linux_surface_synchronization_v1_interface,
  &surface_interface,
};

const wl_message zwp_linux_explicit_synchronization_v1_interface_requests_server[2] = {
  {
    "destroy",
    "",
    zwp_linux_explicit_synchronization_v1_interface_destroy_request_server,
  },
  {
    "get_synchronization",
    "no",
    zwp_linux_explicit_synchronization_v1_interface_get_synchronization_request_server,
  },
};

const wl_message zwp_linux_explicit_synchronization_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zwp_linux_explicit_synchronization_v1_interface =
  {
    "zwp_linux_explicit_synchronization_v1",
    2,
    2,
    zwp_linux_explicit_synchronization_v1_interface_requests_server,
    0,
    zwp_linux_explicit_synchronization_v1_interface_events_server,
  };

const wl_interface* zwp_linux_surface_synchronization_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_linux_surface_synchronization_v1_interface_set_acquire_fence_request_server[1] = {
  nullptr,
};

const wl_interface* zwp_linux_surface_synchronization_v1_interface_get_release_request_server[1] = {
  &zwp_linux_buffer_release_v1_interface,
};

const wl_message zwp_linux_surface_synchronization_v1_interface_requests_server[3] = {
  {
    "destroy",
    "",
    zwp_linux_surface_synchronization_v1_interface_destroy_request_server,
  },
  {
    "set_acquire_fence",
    "h",
    zwp_linux_surface_synchronization_v1_interface_set_acquire_fence_request_server,
  },
  {
    "get_release",
    "n",
    zwp_linux_surface_synchronization_v1_interface_get_release_request_server,
  },
};

const wl_message zwp_linux_surface_synchronization_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zwp_linux_surface_synchronization_v1_interface =
  {
    "zwp_linux_surface_synchronization_v1",
    2,
    3,
    zwp_linux_surface_synchronization_v1_interface_requests_server,
    0,
    zwp_linux_surface_synchronization_v1_interface_events_server,
  };

const wl_interface* zwp_linux_buffer_release_v1_interface_fenced_release_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_linux_buffer_release_v1_interface_immediate_release_event_server[0] = {
};

const wl_message zwp_linux_buffer_release_v1_interface_requests_server[0] = {
};

const wl_message zwp_linux_buffer_release_v1_interface_events_server[2] = {
  {
    "fenced_release",
    "h",
    zwp_linux_buffer_release_v1_interface_fenced_release_event_server,
  },
  {
    "immediate_release",
    "",
    zwp_linux_buffer_release_v1_interface_immediate_release_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_linux_buffer_release_v1_interface =
  {
    "zwp_linux_buffer_release_v1",
    1,
    0,
    zwp_linux_buffer_release_v1_interface_requests_server,
    2,
    zwp_linux_buffer_release_v1_interface_events_server,
  };

const wl_interface* zwp_pointer_constraints_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_pointer_constraints_v1_interface_lock_pointer_request_server[5] = {
  &zwp_locked_pointer_v1_interface,
  &surface_interface,
  &pointer_interface,
  &region_interface,
  nullptr,
};

const wl_interface* zwp_pointer_constraints_v1_interface_confine_pointer_request_server[5] = {
  &zwp_confined_pointer_v1_interface,
  &surface_interface,
  &pointer_interface,
  &region_interface,
  nullptr,
};

const wl_message zwp_pointer_constraints_v1_interface_requests_server[3] = {
  {
    "destroy",
    "",
    zwp_pointer_constraints_v1_interface_destroy_request_server,
  },
  {
    "lock_pointer",
    "noo?ou",
    zwp_pointer_constraints_v1_interface_lock_pointer_request_server,
  },
  {
    "confine_pointer",
    "noo?ou",
    zwp_pointer_constraints_v1_interface_confine_pointer_request_server,
  },
};

const wl_message zwp_pointer_constraints_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zwp_pointer_constraints_v1_interface =
  {
    "zwp_pointer_constraints_v1",
    1,
    3,
    zwp_pointer_constraints_v1_interface_requests_server,
    0,
    zwp_pointer_constraints_v1_interface_events_server,
  };

const wl_interface* zwp_locked_pointer_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_locked_pointer_v1_interface_set_cursor_position_hint_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_locked_pointer_v1_interface_set_region_request_server[1] = {
  &region_interface,
};

const wl_interface* zwp_locked_pointer_v1_interface_locked_event_server[0] = {
};

const wl_interface* zwp_locked_pointer_v1_interface_unlocked_event_server[0] = {
};

const wl_message zwp_locked_pointer_v1_interface_requests_server[3] = {
  {
    "destroy",
    "",
    zwp_locked_pointer_v1_interface_destroy_request_server,
  },
  {
    "set_cursor_position_hint",
    "ff",
    zwp_locked_pointer_v1_interface_set_cursor_position_hint_request_server,
  },
  {
    "set_region",
    "?o",
    zwp_locked_pointer_v1_interface_set_region_request_server,
  },
};

const wl_message zwp_locked_pointer_v1_interface_events_server[2] = {
  {
    "locked",
    "",
    zwp_locked_pointer_v1_interface_locked_event_server,
  },
  {
    "unlocked",
    "",
    zwp_locked_pointer_v1_interface_unlocked_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_locked_pointer_v1_interface =
  {
    "zwp_locked_pointer_v1",
    1,
    3,
    zwp_locked_pointer_v1_interface_requests_server,
    2,
    zwp_locked_pointer_v1_interface_events_server,
  };

const wl_interface* zwp_confined_pointer_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_confined_pointer_v1_interface_set_region_request_server[1] = {
  &region_interface,
};

const wl_interface* zwp_confined_pointer_v1_interface_confined_event_server[0] = {
};

const wl_interface* zwp_confined_pointer_v1_interface_unconfined_event_server[0] = {
};

const wl_message zwp_confined_pointer_v1_interface_requests_server[2] = {
  {
    "destroy",
    "",
    zwp_confined_pointer_v1_interface_destroy_request_server,
  },
  {
    "set_region",
    "?o",
    zwp_confined_pointer_v1_interface_set_region_request_server,
  },
};

const wl_message zwp_confined_pointer_v1_interface_events_server[2] = {
  {
    "confined",
    "",
    zwp_confined_pointer_v1_interface_confined_event_server,
  },
  {
    "unconfined",
    "",
    zwp_confined_pointer_v1_interface_unconfined_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_confined_pointer_v1_interface =
  {
    "zwp_confined_pointer_v1",
    1,
    2,
    zwp_confined_pointer_v1_interface_requests_server,
    2,
    zwp_confined_pointer_v1_interface_events_server,
  };

const wl_interface* zwp_pointer_gestures_v1_interface_get_swipe_gesture_request_server[2] = {
  &zwp_pointer_gesture_swipe_v1_interface,
  &pointer_interface,
};

const wl_interface* zwp_pointer_gestures_v1_interface_get_pinch_gesture_request_server[2] = {
  &zwp_pointer_gesture_pinch_v1_interface,
  &pointer_interface,
};

const wl_interface* zwp_pointer_gestures_v1_interface_release_request_server[0] = {
};

const wl_interface* zwp_pointer_gestures_v1_interface_get_hold_gesture_request_server[2] = {
  &zwp_pointer_gesture_hold_v1_interface,
  &pointer_interface,
};

const wl_message zwp_pointer_gestures_v1_interface_requests_server[4] = {
  {
    "get_swipe_gesture",
    "no",
    zwp_pointer_gestures_v1_interface_get_swipe_gesture_request_server,
  },
  {
    "get_pinch_gesture",
    "no",
    zwp_pointer_gestures_v1_interface_get_pinch_gesture_request_server,
  },
  {
    "release",
    "2",
    zwp_pointer_gestures_v1_interface_release_request_server,
  },
  {
    "get_hold_gesture",
    "3no",
    zwp_pointer_gestures_v1_interface_get_hold_gesture_request_server,
  },
};

const wl_message zwp_pointer_gestures_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zwp_pointer_gestures_v1_interface =
  {
    "zwp_pointer_gestures_v1",
    3,
    4,
    zwp_pointer_gestures_v1_interface_requests_server,
    0,
    zwp_pointer_gestures_v1_interface_events_server,
  };

const wl_interface* zwp_pointer_gesture_swipe_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_pointer_gesture_swipe_v1_interface_begin_event_server[4] = {
  nullptr,
  nullptr,
  &surface_interface,
  nullptr,
};

const wl_interface* zwp_pointer_gesture_swipe_v1_interface_update_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_pointer_gesture_swipe_v1_interface_end_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_message zwp_pointer_gesture_swipe_v1_interface_requests_server[1] = {
  {
    "destroy",
    "",
    zwp_pointer_gesture_swipe_v1_interface_destroy_request_server,
  },
};

const wl_message zwp_pointer_gesture_swipe_v1_interface_events_server[3] = {
  {
    "begin",
    "uuou",
    zwp_pointer_gesture_swipe_v1_interface_begin_event_server,
  },
  {
    "update",
    "uff",
    zwp_pointer_gesture_swipe_v1_interface_update_event_server,
  },
  {
    "end",
    "uui",
    zwp_pointer_gesture_swipe_v1_interface_end_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_pointer_gesture_swipe_v1_interface =
  {
    "zwp_pointer_gesture_swipe_v1",
    2,
    1,
    zwp_pointer_gesture_swipe_v1_interface_requests_server,
    3,
    zwp_pointer_gesture_swipe_v1_interface_events_server,
  };

const wl_interface* zwp_pointer_gesture_pinch_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_pointer_gesture_pinch_v1_interface_begin_event_server[4] = {
  nullptr,
  nullptr,
  &surface_interface,
  nullptr,
};

const wl_interface* zwp_pointer_gesture_pinch_v1_interface_update_event_server[5] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_pointer_gesture_pinch_v1_interface_end_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_message zwp_pointer_gesture_pinch_v1_interface_requests_server[1] = {
  {
    "destroy",
    "",
    zwp_pointer_gesture_pinch_v1_interface_destroy_request_server,
  },
};

const wl_message zwp_pointer_gesture_pinch_v1_interface_events_server[3] = {
  {
    "begin",
    "uuou",
    zwp_pointer_gesture_pinch_v1_interface_begin_event_server,
  },
  {
    "update",
    "uffff",
    zwp_pointer_gesture_pinch_v1_interface_update_event_server,
  },
  {
    "end",
    "uui",
    zwp_pointer_gesture_pinch_v1_interface_end_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_pointer_gesture_pinch_v1_interface =
  {
    "zwp_pointer_gesture_pinch_v1",
    2,
    1,
    zwp_pointer_gesture_pinch_v1_interface_requests_server,
    3,
    zwp_pointer_gesture_pinch_v1_interface_events_server,
  };

const wl_interface* zwp_pointer_gesture_hold_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_pointer_gesture_hold_v1_interface_begin_event_server[4] = {
  nullptr,
  nullptr,
  &surface_interface,
  nullptr,
};

const wl_interface* zwp_pointer_gesture_hold_v1_interface_end_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_message zwp_pointer_gesture_hold_v1_interface_requests_server[1] = {
  {
    "destroy",
    "3",
    zwp_pointer_gesture_hold_v1_interface_destroy_request_server,
  },
};

const wl_message zwp_pointer_gesture_hold_v1_interface_events_server[2] = {
  {
    "begin",
    "3uuou",
    zwp_pointer_gesture_hold_v1_interface_begin_event_server,
  },
  {
    "end",
    "3uui",
    zwp_pointer_gesture_hold_v1_interface_end_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_pointer_gesture_hold_v1_interface =
  {
    "zwp_pointer_gesture_hold_v1",
    3,
    1,
    zwp_pointer_gesture_hold_v1_interface_requests_server,
    2,
    zwp_pointer_gesture_hold_v1_interface_events_server,
  };

const wl_interface* zwp_primary_selection_device_manager_v1_interface_create_source_request_server[1] = {
  &zwp_primary_selection_source_v1_interface,
};

const wl_interface* zwp_primary_selection_device_manager_v1_interface_get_device_request_server[2] = {
  &zwp_primary_selection_device_v1_interface,
  &seat_interface,
};

const wl_interface* zwp_primary_selection_device_manager_v1_interface_destroy_request_server[0] = {
};

const wl_message zwp_primary_selection_device_manager_v1_interface_requests_server[3] = {
  {
    "create_source",
    "n",
    zwp_primary_selection_device_manager_v1_interface_create_source_request_server,
  },
  {
    "get_device",
    "no",
    zwp_primary_selection_device_manager_v1_interface_get_device_request_server,
  },
  {
    "destroy",
    "",
    zwp_primary_selection_device_manager_v1_interface_destroy_request_server,
  },
};

const wl_message zwp_primary_selection_device_manager_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zwp_primary_selection_device_manager_v1_interface =
  {
    "zwp_primary_selection_device_manager_v1",
    1,
    3,
    zwp_primary_selection_device_manager_v1_interface_requests_server,
    0,
    zwp_primary_selection_device_manager_v1_interface_events_server,
  };

const wl_interface* zwp_primary_selection_device_v1_interface_set_selection_request_server[2] = {
  &zwp_primary_selection_source_v1_interface,
  nullptr,
};

const wl_interface* zwp_primary_selection_device_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_primary_selection_device_v1_interface_data_offer_event_server[1] = {
  &zwp_primary_selection_offer_v1_interface,
};

const wl_interface* zwp_primary_selection_device_v1_interface_selection_event_server[1] = {
  &zwp_primary_selection_offer_v1_interface,
};

const wl_message zwp_primary_selection_device_v1_interface_requests_server[2] = {
  {
    "set_selection",
    "?ou",
    zwp_primary_selection_device_v1_interface_set_selection_request_server,
  },
  {
    "destroy",
    "",
    zwp_primary_selection_device_v1_interface_destroy_request_server,
  },
};

const wl_message zwp_primary_selection_device_v1_interface_events_server[2] = {
  {
    "data_offer",
    "n",
    zwp_primary_selection_device_v1_interface_data_offer_event_server,
  },
  {
    "selection",
    "?o",
    zwp_primary_selection_device_v1_interface_selection_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_primary_selection_device_v1_interface =
  {
    "zwp_primary_selection_device_v1",
    1,
    2,
    zwp_primary_selection_device_v1_interface_requests_server,
    2,
    zwp_primary_selection_device_v1_interface_events_server,
  };

const wl_interface* zwp_primary_selection_offer_v1_interface_receive_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_primary_selection_offer_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_primary_selection_offer_v1_interface_offer_event_server[1] = {
  nullptr,
};

const wl_message zwp_primary_selection_offer_v1_interface_requests_server[2] = {
  {
    "receive",
    "sh",
    zwp_primary_selection_offer_v1_interface_receive_request_server,
  },
  {
    "destroy",
    "",
    zwp_primary_selection_offer_v1_interface_destroy_request_server,
  },
};

const wl_message zwp_primary_selection_offer_v1_interface_events_server[1] = {
  {
    "offer",
    "s",
    zwp_primary_selection_offer_v1_interface_offer_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_primary_selection_offer_v1_interface =
  {
    "zwp_primary_selection_offer_v1",
    1,
    2,
    zwp_primary_selection_offer_v1_interface_requests_server,
    1,
    zwp_primary_selection_offer_v1_interface_events_server,
  };

const wl_interface* zwp_primary_selection_source_v1_interface_offer_request_server[1] = {
  nullptr,
};

const wl_interface* zwp_primary_selection_source_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_primary_selection_source_v1_interface_send_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_primary_selection_source_v1_interface_cancelled_event_server[0] = {
};

const wl_message zwp_primary_selection_source_v1_interface_requests_server[2] = {
  {
    "offer",
    "s",
    zwp_primary_selection_source_v1_interface_offer_request_server,
  },
  {
    "destroy",
    "",
    zwp_primary_selection_source_v1_interface_destroy_request_server,
  },
};

const wl_message zwp_primary_selection_source_v1_interface_events_server[2] = {
  {
    "send",
    "sh",
    zwp_primary_selection_source_v1_interface_send_event_server,
  },
  {
    "cancelled",
    "",
    zwp_primary_selection_source_v1_interface_cancelled_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_primary_selection_source_v1_interface =
  {
    "zwp_primary_selection_source_v1",
    1,
    2,
    zwp_primary_selection_source_v1_interface_requests_server,
    2,
    zwp_primary_selection_source_v1_interface_events_server,
  };

const wl_interface* zwp_relative_pointer_manager_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_relative_pointer_manager_v1_interface_get_relative_pointer_request_server[2] = {
  &zwp_relative_pointer_v1_interface,
  &pointer_interface,
};

const wl_message zwp_relative_pointer_manager_v1_interface_requests_server[2] = {
  {
    "destroy",
    "",
    zwp_relative_pointer_manager_v1_interface_destroy_request_server,
  },
  {
    "get_relative_pointer",
    "no",
    zwp_relative_pointer_manager_v1_interface_get_relative_pointer_request_server,
  },
};

const wl_message zwp_relative_pointer_manager_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zwp_relative_pointer_manager_v1_interface =
  {
    "zwp_relative_pointer_manager_v1",
    1,
    2,
    zwp_relative_pointer_manager_v1_interface_requests_server,
    0,
    zwp_relative_pointer_manager_v1_interface_events_server,
  };

const wl_interface* zwp_relative_pointer_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_relative_pointer_v1_interface_relative_motion_event_server[6] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_message zwp_relative_pointer_v1_interface_requests_server[1] = {
  {
    "destroy",
    "",
    zwp_relative_pointer_v1_interface_destroy_request_server,
  },
};

const wl_message zwp_relative_pointer_v1_interface_events_server[1] = {
  {
    "relative_motion",
    "uuffff",
    zwp_relative_pointer_v1_interface_relative_motion_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_relative_pointer_v1_interface =
  {
    "zwp_relative_pointer_v1",
    1,
    1,
    zwp_relative_pointer_v1_interface_requests_server,
    1,
    zwp_relative_pointer_v1_interface_events_server,
  };

const wl_interface* zwp_tablet_manager_v1_interface_get_tablet_seat_request_server[2] = {
  &zwp_tablet_seat_v1_interface,
  &seat_interface,
};

const wl_interface* zwp_tablet_manager_v1_interface_destroy_request_server[0] = {
};

const wl_message zwp_tablet_manager_v1_interface_requests_server[2] = {
  {
    "get_tablet_seat",
    "no",
    zwp_tablet_manager_v1_interface_get_tablet_seat_request_server,
  },
  {
    "destroy",
    "",
    zwp_tablet_manager_v1_interface_destroy_request_server,
  },
};

const wl_message zwp_tablet_manager_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zwp_tablet_manager_v1_interface =
  {
    "zwp_tablet_manager_v1",
    1,
    2,
    zwp_tablet_manager_v1_interface_requests_server,
    0,
    zwp_tablet_manager_v1_interface_events_server,
  };

const wl_interface* zwp_tablet_seat_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_tablet_seat_v1_interface_tablet_added_event_server[1] = {
  &zwp_tablet_v1_interface,
};

const wl_interface* zwp_tablet_seat_v1_interface_tool_added_event_server[1] = {
  &zwp_tablet_tool_v1_interface,
};

const wl_message zwp_tablet_seat_v1_interface_requests_server[1] = {
  {
    "destroy",
    "",
    zwp_tablet_seat_v1_interface_destroy_request_server,
  },
};

const wl_message zwp_tablet_seat_v1_interface_events_server[2] = {
  {
    "tablet_added",
    "n",
    zwp_tablet_seat_v1_interface_tablet_added_event_server,
  },
  {
    "tool_added",
    "n",
    zwp_tablet_seat_v1_interface_tool_added_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_tablet_seat_v1_interface =
  {
    "zwp_tablet_seat_v1",
    1,
    1,
    zwp_tablet_seat_v1_interface_requests_server,
    2,
    zwp_tablet_seat_v1_interface_events_server,
  };

const wl_interface* zwp_tablet_tool_v1_interface_set_cursor_request_server[4] = {
  nullptr,
  &surface_interface,
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_tablet_tool_v1_interface_type_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_hardware_serial_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_hardware_id_wacom_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_capability_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_done_event_server[0] = {
};

const wl_interface* zwp_tablet_tool_v1_interface_removed_event_server[0] = {
};

const wl_interface* zwp_tablet_tool_v1_interface_proximity_in_event_server[3] = {
  nullptr,
  &zwp_tablet_v1_interface,
  &surface_interface,
};

const wl_interface* zwp_tablet_tool_v1_interface_proximity_out_event_server[0] = {
};

const wl_interface* zwp_tablet_tool_v1_interface_down_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_up_event_server[0] = {
};

const wl_interface* zwp_tablet_tool_v1_interface_motion_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_pressure_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_distance_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_tilt_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_rotation_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_slider_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_wheel_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_button_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_frame_event_server[1] = {
  nullptr,
};

const wl_message zwp_tablet_tool_v1_interface_requests_server[2] = {
  {
    "set_cursor",
    "u?oii",
    zwp_tablet_tool_v1_interface_set_cursor_request_server,
  },
  {
    "destroy",
    "",
    zwp_tablet_tool_v1_interface_destroy_request_server,
  },
};

const wl_message zwp_tablet_tool_v1_interface_events_server[19] = {
  {
    "type",
    "u",
    zwp_tablet_tool_v1_interface_type_event_server,
  },
  {
    "hardware_serial",
    "uu",
    zwp_tablet_tool_v1_interface_hardware_serial_event_server,
  },
  {
    "hardware_id_wacom",
    "uu",
    zwp_tablet_tool_v1_interface_hardware_id_wacom_event_server,
  },
  {
    "capability",
    "u",
    zwp_tablet_tool_v1_interface_capability_event_server,
  },
  {
    "done",
    "",
    zwp_tablet_tool_v1_interface_done_event_server,
  },
  {
    "removed",
    "",
    zwp_tablet_tool_v1_interface_removed_event_server,
  },
  {
    "proximity_in",
    "uoo",
    zwp_tablet_tool_v1_interface_proximity_in_event_server,
  },
  {
    "proximity_out",
    "",
    zwp_tablet_tool_v1_interface_proximity_out_event_server,
  },
  {
    "down",
    "u",
    zwp_tablet_tool_v1_interface_down_event_server,
  },
  {
    "up",
    "",
    zwp_tablet_tool_v1_interface_up_event_server,
  },
  {
    "motion",
    "ff",
    zwp_tablet_tool_v1_interface_motion_event_server,
  },
  {
    "pressure",
    "u",
    zwp_tablet_tool_v1_interface_pressure_event_server,
  },
  {
    "distance",
    "u",
    zwp_tablet_tool_v1_interface_distance_event_server,
  },
  {
    "tilt",
    "ii",
    zwp_tablet_tool_v1_interface_tilt_event_server,
  },
  {
    "rotation",
    "i",
    zwp_tablet_tool_v1_interface_rotation_event_server,
  },
  {
    "slider",
    "i",
    zwp_tablet_tool_v1_interface_slider_event_server,
  },
  {
    "wheel",
    "ii",
    zwp_tablet_tool_v1_interface_wheel_event_server,
  },
  {
    "button",
    "uuu",
    zwp_tablet_tool_v1_interface_button_event_server,
  },
  {
    "frame",
    "u",
    zwp_tablet_tool_v1_interface_frame_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_tablet_tool_v1_interface =
  {
    "zwp_tablet_tool_v1",
    1,
    2,
    zwp_tablet_tool_v1_interface_requests_server,
    19,
    zwp_tablet_tool_v1_interface_events_server,
  };

const wl_interface* zwp_tablet_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_tablet_v1_interface_name_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_v1_interface_id_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_v1_interface_path_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_v1_interface_done_event_server[0] = {
};

const wl_interface* zwp_tablet_v1_interface_removed_event_server[0] = {
};

const wl_message zwp_tablet_v1_interface_requests_server[1] = {
  {
    "destroy",
    "",
    zwp_tablet_v1_interface_destroy_request_server,
  },
};

const wl_message zwp_tablet_v1_interface_events_server[5] = {
  {
    "name",
    "s",
    zwp_tablet_v1_interface_name_event_server,
  },
  {
    "id",
    "uu",
    zwp_tablet_v1_interface_id_event_server,
  },
  {
    "path",
    "s",
    zwp_tablet_v1_interface_path_event_server,
  },
  {
    "done",
    "",
    zwp_tablet_v1_interface_done_event_server,
  },
  {
    "removed",
    "",
    zwp_tablet_v1_interface_removed_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_tablet_v1_interface =
  {
    "zwp_tablet_v1",
    1,
    1,
    zwp_tablet_v1_interface_requests_server,
    5,
    zwp_tablet_v1_interface_events_server,
  };

const wl_interface* zwp_tablet_manager_v2_interface_get_tablet_seat_request_server[2] = {
  &zwp_tablet_seat_v2_interface,
  &seat_interface,
};

const wl_interface* zwp_tablet_manager_v2_interface_destroy_request_server[0] = {
};

const wl_message zwp_tablet_manager_v2_interface_requests_server[2] = {
  {
    "get_tablet_seat",
    "no",
    zwp_tablet_manager_v2_interface_get_tablet_seat_request_server,
  },
  {
    "destroy",
    "",
    zwp_tablet_manager_v2_interface_destroy_request_server,
  },
};

const wl_message zwp_tablet_manager_v2_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zwp_tablet_manager_v2_interface =
  {
    "zwp_tablet_manager_v2",
    1,
    2,
    zwp_tablet_manager_v2_interface_requests_server,
    0,
    zwp_tablet_manager_v2_interface_events_server,
  };

const wl_interface* zwp_tablet_seat_v2_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_tablet_seat_v2_interface_tablet_added_event_server[1] = {
  &zwp_tablet_v2_interface,
};

const wl_interface* zwp_tablet_seat_v2_interface_tool_added_event_server[1] = {
  &zwp_tablet_tool_v2_interface,
};

const wl_interface* zwp_tablet_seat_v2_interface_pad_added_event_server[1] = {
  &zwp_tablet_pad_v2_interface,
};

const wl_message zwp_tablet_seat_v2_interface_requests_server[1] = {
  {
    "destroy",
    "",
    zwp_tablet_seat_v2_interface_destroy_request_server,
  },
};

const wl_message zwp_tablet_seat_v2_interface_events_server[3] = {
  {
    "tablet_added",
    "n",
    zwp_tablet_seat_v2_interface_tablet_added_event_server,
  },
  {
    "tool_added",
    "n",
    zwp_tablet_seat_v2_interface_tool_added_event_server,
  },
  {
    "pad_added",
    "n",
    zwp_tablet_seat_v2_interface_pad_added_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_tablet_seat_v2_interface =
  {
    "zwp_tablet_seat_v2",
    1,
    1,
    zwp_tablet_seat_v2_interface_requests_server,
    3,
    zwp_tablet_seat_v2_interface_events_server,
  };

const wl_interface* zwp_tablet_tool_v2_interface_set_cursor_request_server[4] = {
  nullptr,
  &surface_interface,
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_tablet_tool_v2_interface_type_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_hardware_serial_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_hardware_id_wacom_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_capability_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_done_event_server[0] = {
};

const wl_interface* zwp_tablet_tool_v2_interface_removed_event_server[0] = {
};

const wl_interface* zwp_tablet_tool_v2_interface_proximity_in_event_server[3] = {
  nullptr,
  &zwp_tablet_v2_interface,
  &surface_interface,
};

const wl_interface* zwp_tablet_tool_v2_interface_proximity_out_event_server[0] = {
};

const wl_interface* zwp_tablet_tool_v2_interface_down_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_up_event_server[0] = {
};

const wl_interface* zwp_tablet_tool_v2_interface_motion_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_pressure_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_distance_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_tilt_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_rotation_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_slider_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_wheel_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_button_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_frame_event_server[1] = {
  nullptr,
};

const wl_message zwp_tablet_tool_v2_interface_requests_server[2] = {
  {
    "set_cursor",
    "u?oii",
    zwp_tablet_tool_v2_interface_set_cursor_request_server,
  },
  {
    "destroy",
    "",
    zwp_tablet_tool_v2_interface_destroy_request_server,
  },
};

const wl_message zwp_tablet_tool_v2_interface_events_server[19] = {
  {
    "type",
    "u",
    zwp_tablet_tool_v2_interface_type_event_server,
  },
  {
    "hardware_serial",
    "uu",
    zwp_tablet_tool_v2_interface_hardware_serial_event_server,
  },
  {
    "hardware_id_wacom",
    "uu",
    zwp_tablet_tool_v2_interface_hardware_id_wacom_event_server,
  },
  {
    "capability",
    "u",
    zwp_tablet_tool_v2_interface_capability_event_server,
  },
  {
    "done",
    "",
    zwp_tablet_tool_v2_interface_done_event_server,
  },
  {
    "removed",
    "",
    zwp_tablet_tool_v2_interface_removed_event_server,
  },
  {
    "proximity_in",
    "uoo",
    zwp_tablet_tool_v2_interface_proximity_in_event_server,
  },
  {
    "proximity_out",
    "",
    zwp_tablet_tool_v2_interface_proximity_out_event_server,
  },
  {
    "down",
    "u",
    zwp_tablet_tool_v2_interface_down_event_server,
  },
  {
    "up",
    "",
    zwp_tablet_tool_v2_interface_up_event_server,
  },
  {
    "motion",
    "ff",
    zwp_tablet_tool_v2_interface_motion_event_server,
  },
  {
    "pressure",
    "u",
    zwp_tablet_tool_v2_interface_pressure_event_server,
  },
  {
    "distance",
    "u",
    zwp_tablet_tool_v2_interface_distance_event_server,
  },
  {
    "tilt",
    "ff",
    zwp_tablet_tool_v2_interface_tilt_event_server,
  },
  {
    "rotation",
    "f",
    zwp_tablet_tool_v2_interface_rotation_event_server,
  },
  {
    "slider",
    "i",
    zwp_tablet_tool_v2_interface_slider_event_server,
  },
  {
    "wheel",
    "fi",
    zwp_tablet_tool_v2_interface_wheel_event_server,
  },
  {
    "button",
    "uuu",
    zwp_tablet_tool_v2_interface_button_event_server,
  },
  {
    "frame",
    "u",
    zwp_tablet_tool_v2_interface_frame_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_tablet_tool_v2_interface =
  {
    "zwp_tablet_tool_v2",
    1,
    2,
    zwp_tablet_tool_v2_interface_requests_server,
    19,
    zwp_tablet_tool_v2_interface_events_server,
  };

const wl_interface* zwp_tablet_v2_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_tablet_v2_interface_name_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_v2_interface_id_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_v2_interface_path_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_v2_interface_done_event_server[0] = {
};

const wl_interface* zwp_tablet_v2_interface_removed_event_server[0] = {
};

const wl_message zwp_tablet_v2_interface_requests_server[1] = {
  {
    "destroy",
    "",
    zwp_tablet_v2_interface_destroy_request_server,
  },
};

const wl_message zwp_tablet_v2_interface_events_server[5] = {
  {
    "name",
    "s",
    zwp_tablet_v2_interface_name_event_server,
  },
  {
    "id",
    "uu",
    zwp_tablet_v2_interface_id_event_server,
  },
  {
    "path",
    "s",
    zwp_tablet_v2_interface_path_event_server,
  },
  {
    "done",
    "",
    zwp_tablet_v2_interface_done_event_server,
  },
  {
    "removed",
    "",
    zwp_tablet_v2_interface_removed_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_tablet_v2_interface =
  {
    "zwp_tablet_v2",
    1,
    1,
    zwp_tablet_v2_interface_requests_server,
    5,
    zwp_tablet_v2_interface_events_server,
  };

const wl_interface* zwp_tablet_pad_ring_v2_interface_set_feedback_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_pad_ring_v2_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_tablet_pad_ring_v2_interface_source_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_pad_ring_v2_interface_angle_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_pad_ring_v2_interface_stop_event_server[0] = {
};

const wl_interface* zwp_tablet_pad_ring_v2_interface_frame_event_server[1] = {
  nullptr,
};

const wl_message zwp_tablet_pad_ring_v2_interface_requests_server[2] = {
  {
    "set_feedback",
    "su",
    zwp_tablet_pad_ring_v2_interface_set_feedback_request_server,
  },
  {
    "destroy",
    "",
    zwp_tablet_pad_ring_v2_interface_destroy_request_server,
  },
};

const wl_message zwp_tablet_pad_ring_v2_interface_events_server[4] = {
  {
    "source",
    "u",
    zwp_tablet_pad_ring_v2_interface_source_event_server,
  },
  {
    "angle",
    "f",
    zwp_tablet_pad_ring_v2_interface_angle_event_server,
  },
  {
    "stop",
    "",
    zwp_tablet_pad_ring_v2_interface_stop_event_server,
  },
  {
    "frame",
    "u",
    zwp_tablet_pad_ring_v2_interface_frame_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_tablet_pad_ring_v2_interface =
  {
    "zwp_tablet_pad_ring_v2",
    1,
    2,
    zwp_tablet_pad_ring_v2_interface_requests_server,
    4,
    zwp_tablet_pad_ring_v2_interface_events_server,
  };

const wl_interface* zwp_tablet_pad_strip_v2_interface_set_feedback_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_pad_strip_v2_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_tablet_pad_strip_v2_interface_source_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_pad_strip_v2_interface_position_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_pad_strip_v2_interface_stop_event_server[0] = {
};

const wl_interface* zwp_tablet_pad_strip_v2_interface_frame_event_server[1] = {
  nullptr,
};

const wl_message zwp_tablet_pad_strip_v2_interface_requests_server[2] = {
  {
    "set_feedback",
    "su",
    zwp_tablet_pad_strip_v2_interface_set_feedback_request_server,
  },
  {
    "destroy",
    "",
    zwp_tablet_pad_strip_v2_interface_destroy_request_server,
  },
};

const wl_message zwp_tablet_pad_strip_v2_interface_events_server[4] = {
  {
    "source",
    "u",
    zwp_tablet_pad_strip_v2_interface_source_event_server,
  },
  {
    "position",
    "u",
    zwp_tablet_pad_strip_v2_interface_position_event_server,
  },
  {
    "stop",
    "",
    zwp_tablet_pad_strip_v2_interface_stop_event_server,
  },
  {
    "frame",
    "u",
    zwp_tablet_pad_strip_v2_interface_frame_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_tablet_pad_strip_v2_interface =
  {
    "zwp_tablet_pad_strip_v2",
    1,
    2,
    zwp_tablet_pad_strip_v2_interface_requests_server,
    4,
    zwp_tablet_pad_strip_v2_interface_events_server,
  };

const wl_interface* zwp_tablet_pad_group_v2_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_tablet_pad_group_v2_interface_buttons_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_pad_group_v2_interface_ring_event_server[1] = {
  &zwp_tablet_pad_ring_v2_interface,
};

const wl_interface* zwp_tablet_pad_group_v2_interface_strip_event_server[1] = {
  &zwp_tablet_pad_strip_v2_interface,
};

const wl_interface* zwp_tablet_pad_group_v2_interface_modes_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_pad_group_v2_interface_done_event_server[0] = {
};

const wl_interface* zwp_tablet_pad_group_v2_interface_mode_switch_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_message zwp_tablet_pad_group_v2_interface_requests_server[1] = {
  {
    "destroy",
    "",
    zwp_tablet_pad_group_v2_interface_destroy_request_server,
  },
};

const wl_message zwp_tablet_pad_group_v2_interface_events_server[6] = {
  {
    "buttons",
    "a",
    zwp_tablet_pad_group_v2_interface_buttons_event_server,
  },
  {
    "ring",
    "n",
    zwp_tablet_pad_group_v2_interface_ring_event_server,
  },
  {
    "strip",
    "n",
    zwp_tablet_pad_group_v2_interface_strip_event_server,
  },
  {
    "modes",
    "u",
    zwp_tablet_pad_group_v2_interface_modes_event_server,
  },
  {
    "done",
    "",
    zwp_tablet_pad_group_v2_interface_done_event_server,
  },
  {
    "mode_switch",
    "uuu",
    zwp_tablet_pad_group_v2_interface_mode_switch_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_tablet_pad_group_v2_interface =
  {
    "zwp_tablet_pad_group_v2",
    1,
    1,
    zwp_tablet_pad_group_v2_interface_requests_server,
    6,
    zwp_tablet_pad_group_v2_interface_events_server,
  };

const wl_interface* zwp_tablet_pad_v2_interface_set_feedback_request_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_pad_v2_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_tablet_pad_v2_interface_group_event_server[1] = {
  &zwp_tablet_pad_group_v2_interface,
};

const wl_interface* zwp_tablet_pad_v2_interface_path_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_pad_v2_interface_buttons_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_pad_v2_interface_done_event_server[0] = {
};

const wl_interface* zwp_tablet_pad_v2_interface_button_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_pad_v2_interface_enter_event_server[3] = {
  nullptr,
  &zwp_tablet_v2_interface,
  &surface_interface,
};

const wl_interface* zwp_tablet_pad_v2_interface_leave_event_server[2] = {
  nullptr,
  &surface_interface,
};

const wl_interface* zwp_tablet_pad_v2_interface_removed_event_server[0] = {
};

const wl_message zwp_tablet_pad_v2_interface_requests_server[2] = {
  {
    "set_feedback",
    "usu",
    zwp_tablet_pad_v2_interface_set_feedback_request_server,
  },
  {
    "destroy",
    "",
    zwp_tablet_pad_v2_interface_destroy_request_server,
  },
};

const wl_message zwp_tablet_pad_v2_interface_events_server[8] = {
  {
    "group",
    "n",
    zwp_tablet_pad_v2_interface_group_event_server,
  },
  {
    "path",
    "s",
    zwp_tablet_pad_v2_interface_path_event_server,
  },
  {
    "buttons",
    "u",
    zwp_tablet_pad_v2_interface_buttons_event_server,
  },
  {
    "done",
    "",
    zwp_tablet_pad_v2_interface_done_event_server,
  },
  {
    "button",
    "uuu",
    zwp_tablet_pad_v2_interface_button_event_server,
  },
  {
    "enter",
    "uoo",
    zwp_tablet_pad_v2_interface_enter_event_server,
  },
  {
    "leave",
    "uo",
    zwp_tablet_pad_v2_interface_leave_event_server,
  },
  {
    "removed",
    "",
    zwp_tablet_pad_v2_interface_removed_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_tablet_pad_v2_interface =
  {
    "zwp_tablet_pad_v2",
    1,
    2,
    zwp_tablet_pad_v2_interface_requests_server,
    8,
    zwp_tablet_pad_v2_interface_events_server,
  };

const wl_interface* zwp_text_input_v1_interface_activate_request_server[2] = {
  &seat_interface,
  &surface_interface,
};

const wl_interface* zwp_text_input_v1_interface_deactivate_request_server[1] = {
  &seat_interface,
};

const wl_interface* zwp_text_input_v1_interface_show_input_panel_request_server[0] = {
};

const wl_interface* zwp_text_input_v1_interface_hide_input_panel_request_server[0] = {
};

const wl_interface* zwp_text_input_v1_interface_reset_request_server[0] = {
};

const wl_interface* zwp_text_input_v1_interface_set_surrounding_text_request_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_set_content_type_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_set_cursor_rectangle_request_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_set_preferred_language_request_server[1] = {
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_commit_state_request_server[1] = {
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_invoke_action_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_enter_event_server[1] = {
  &surface_interface,
};

const wl_interface* zwp_text_input_v1_interface_leave_event_server[0] = {
};

const wl_interface* zwp_text_input_v1_interface_modifiers_map_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_input_panel_state_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_preedit_string_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_preedit_styling_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_preedit_cursor_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_commit_string_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_cursor_position_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_delete_surrounding_text_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_keysym_event_server[5] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_language_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_text_direction_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_message zwp_text_input_v1_interface_requests_server[11] = {
  {
    "activate",
    "oo",
    zwp_text_input_v1_interface_activate_request_server,
  },
  {
    "deactivate",
    "o",
    zwp_text_input_v1_interface_deactivate_request_server,
  },
  {
    "show_input_panel",
    "",
    zwp_text_input_v1_interface_show_input_panel_request_server,
  },
  {
    "hide_input_panel",
    "",
    zwp_text_input_v1_interface_hide_input_panel_request_server,
  },
  {
    "reset",
    "",
    zwp_text_input_v1_interface_reset_request_server,
  },
  {
    "set_surrounding_text",
    "suu",
    zwp_text_input_v1_interface_set_surrounding_text_request_server,
  },
  {
    "set_content_type",
    "uu",
    zwp_text_input_v1_interface_set_content_type_request_server,
  },
  {
    "set_cursor_rectangle",
    "iiii",
    zwp_text_input_v1_interface_set_cursor_rectangle_request_server,
  },
  {
    "set_preferred_language",
    "s",
    zwp_text_input_v1_interface_set_preferred_language_request_server,
  },
  {
    "commit_state",
    "u",
    zwp_text_input_v1_interface_commit_state_request_server,
  },
  {
    "invoke_action",
    "uu",
    zwp_text_input_v1_interface_invoke_action_request_server,
  },
};

const wl_message zwp_text_input_v1_interface_events_server[13] = {
  {
    "enter",
    "o",
    zwp_text_input_v1_interface_enter_event_server,
  },
  {
    "leave",
    "",
    zwp_text_input_v1_interface_leave_event_server,
  },
  {
    "modifiers_map",
    "a",
    zwp_text_input_v1_interface_modifiers_map_event_server,
  },
  {
    "input_panel_state",
    "u",
    zwp_text_input_v1_interface_input_panel_state_event_server,
  },
  {
    "preedit_string",
    "uss",
    zwp_text_input_v1_interface_preedit_string_event_server,
  },
  {
    "preedit_styling",
    "uuu",
    zwp_text_input_v1_interface_preedit_styling_event_server,
  },
  {
    "preedit_cursor",
    "i",
    zwp_text_input_v1_interface_preedit_cursor_event_server,
  },
  {
    "commit_string",
    "us",
    zwp_text_input_v1_interface_commit_string_event_server,
  },
  {
    "cursor_position",
    "ii",
    zwp_text_input_v1_interface_cursor_position_event_server,
  },
  {
    "delete_surrounding_text",
    "iu",
    zwp_text_input_v1_interface_delete_surrounding_text_event_server,
  },
  {
    "keysym",
    "uuuuu",
    zwp_text_input_v1_interface_keysym_event_server,
  },
  {
    "language",
    "us",
    zwp_text_input_v1_interface_language_event_server,
  },
  {
    "text_direction",
    "uu",
    zwp_text_input_v1_interface_text_direction_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_text_input_v1_interface =
  {
    "zwp_text_input_v1",
    1,
    11,
    zwp_text_input_v1_interface_requests_server,
    13,
    zwp_text_input_v1_interface_events_server,
  };

const wl_interface* zwp_text_input_manager_v1_interface_create_text_input_request_server[1] = {
  &zwp_text_input_v1_interface,
};

const wl_message zwp_text_input_manager_v1_interface_requests_server[1] = {
  {
    "create_text_input",
    "n",
    zwp_text_input_manager_v1_interface_create_text_input_request_server,
  },
};

const wl_message zwp_text_input_manager_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zwp_text_input_manager_v1_interface =
  {
    "zwp_text_input_manager_v1",
    1,
    1,
    zwp_text_input_manager_v1_interface_requests_server,
    0,
    zwp_text_input_manager_v1_interface_events_server,
  };

const wl_interface* zwp_text_input_v3_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_text_input_v3_interface_enable_request_server[0] = {
};

const wl_interface* zwp_text_input_v3_interface_disable_request_server[0] = {
};

const wl_interface* zwp_text_input_v3_interface_set_surrounding_text_request_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v3_interface_set_text_change_cause_request_server[1] = {
  nullptr,
};

const wl_interface* zwp_text_input_v3_interface_set_content_type_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v3_interface_set_cursor_rectangle_request_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v3_interface_commit_request_server[0] = {
};

const wl_interface* zwp_text_input_v3_interface_enter_event_server[1] = {
  &surface_interface,
};

const wl_interface* zwp_text_input_v3_interface_leave_event_server[1] = {
  &surface_interface,
};

const wl_interface* zwp_text_input_v3_interface_preedit_string_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v3_interface_commit_string_event_server[1] = {
  nullptr,
};

const wl_interface* zwp_text_input_v3_interface_delete_surrounding_text_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v3_interface_done_event_server[1] = {
  nullptr,
};

const wl_message zwp_text_input_v3_interface_requests_server[8] = {
  {
    "destroy",
    "",
    zwp_text_input_v3_interface_destroy_request_server,
  },
  {
    "enable",
    "",
    zwp_text_input_v3_interface_enable_request_server,
  },
  {
    "disable",
    "",
    zwp_text_input_v3_interface_disable_request_server,
  },
  {
    "set_surrounding_text",
    "sii",
    zwp_text_input_v3_interface_set_surrounding_text_request_server,
  },
  {
    "set_text_change_cause",
    "u",
    zwp_text_input_v3_interface_set_text_change_cause_request_server,
  },
  {
    "set_content_type",
    "uu",
    zwp_text_input_v3_interface_set_content_type_request_server,
  },
  {
    "set_cursor_rectangle",
    "iiii",
    zwp_text_input_v3_interface_set_cursor_rectangle_request_server,
  },
  {
    "commit",
    "",
    zwp_text_input_v3_interface_commit_request_server,
  },
};

const wl_message zwp_text_input_v3_interface_events_server[6] = {
  {
    "enter",
    "o",
    zwp_text_input_v3_interface_enter_event_server,
  },
  {
    "leave",
    "o",
    zwp_text_input_v3_interface_leave_event_server,
  },
  {
    "preedit_string",
    "?sii",
    zwp_text_input_v3_interface_preedit_string_event_server,
  },
  {
    "commit_string",
    "?s",
    zwp_text_input_v3_interface_commit_string_event_server,
  },
  {
    "delete_surrounding_text",
    "uu",
    zwp_text_input_v3_interface_delete_surrounding_text_event_server,
  },
  {
    "done",
    "u",
    zwp_text_input_v3_interface_done_event_server,
  },
};

const wl_interface wayland::server::detail::zwp_text_input_v3_interface =
  {
    "zwp_text_input_v3",
    1,
    8,
    zwp_text_input_v3_interface_requests_server,
    6,
    zwp_text_input_v3_interface_events_server,
  };

const wl_interface* zwp_text_input_manager_v3_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_text_input_manager_v3_interface_get_text_input_request_server[2] = {
  &zwp_text_input_v3_interface,
  &seat_interface,
};

const wl_message zwp_text_input_manager_v3_interface_requests_server[2] = {
  {
    "destroy",
    "",
    zwp_text_input_manager_v3_interface_destroy_request_server,
  },
  {
    "get_text_input",
    "no",
    zwp_text_input_manager_v3_interface_get_text_input_request_server,
  },
};

const wl_message zwp_text_input_manager_v3_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zwp_text_input_manager_v3_interface =
  {
    "zwp_text_input_manager_v3",
    1,
    2,
    zwp_text_input_manager_v3_interface_requests_server,
    0,
    zwp_text_input_manager_v3_interface_events_server,
  };

const wl_interface* xdg_activation_v1_interface_destroy_request_server[0] = {
};

const wl_interface* xdg_activation_v1_interface_get_activation_token_request_server[1] = {
  &xdg_activation_token_v1_interface,
};

const wl_interface* xdg_activation_v1_interface_activate_request_server[2] = {
  nullptr,
  &surface_interface,
};

const wl_message xdg_activation_v1_interface_requests_server[3] = {
  {
    "destroy",
    "",
    xdg_activation_v1_interface_destroy_request_server,
  },
  {
    "get_activation_token",
    "n",
    xdg_activation_v1_interface_get_activation_token_request_server,
  },
  {
    "activate",
    "so",
    xdg_activation_v1_interface_activate_request_server,
  },
};

const wl_message xdg_activation_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::xdg_activation_v1_interface =
  {
    "xdg_activation_v1",
    1,
    3,
    xdg_activation_v1_interface_requests_server,
    0,
    xdg_activation_v1_interface_events_server,
  };

const wl_interface* xdg_activation_token_v1_interface_set_serial_request_server[2] = {
  nullptr,
  &seat_interface,
};

const wl_interface* xdg_activation_token_v1_interface_set_app_id_request_server[1] = {
  nullptr,
};

const wl_interface* xdg_activation_token_v1_interface_set_surface_request_server[1] = {
  &surface_interface,
};

const wl_interface* xdg_activation_token_v1_interface_commit_request_server[0] = {
};

const wl_interface* xdg_activation_token_v1_interface_destroy_request_server[0] = {
};

const wl_interface* xdg_activation_token_v1_interface_done_event_server[1] = {
  nullptr,
};

const wl_message xdg_activation_token_v1_interface_requests_server[5] = {
  {
    "set_serial",
    "uo",
    xdg_activation_token_v1_interface_set_serial_request_server,
  },
  {
    "set_app_id",
    "s",
    xdg_activation_token_v1_interface_set_app_id_request_server,
  },
  {
    "set_surface",
    "o",
    xdg_activation_token_v1_interface_set_surface_request_server,
  },
  {
    "commit",
    "",
    xdg_activation_token_v1_interface_commit_request_server,
  },
  {
    "destroy",
    "",
    xdg_activation_token_v1_interface_destroy_request_server,
  },
};

const wl_message xdg_activation_token_v1_interface_events_server[1] = {
  {
    "done",
    "s",
    xdg_activation_token_v1_interface_done_event_server,
  },
};

const wl_interface wayland::server::detail::xdg_activation_token_v1_interface =
  {
    "xdg_activation_token_v1",
    1,
    5,
    xdg_activation_token_v1_interface_requests_server,
    1,
    xdg_activation_token_v1_interface_events_server,
  };

const wl_interface* zxdg_decoration_manager_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zxdg_decoration_manager_v1_interface_get_toplevel_decoration_request_server[2] = {
  &zxdg_toplevel_decoration_v1_interface,
  &xdg_toplevel_interface,
};

const wl_message zxdg_decoration_manager_v1_interface_requests_server[2] = {
  {
    "destroy",
    "",
    zxdg_decoration_manager_v1_interface_destroy_request_server,
  },
  {
    "get_toplevel_decoration",
    "no",
    zxdg_decoration_manager_v1_interface_get_toplevel_decoration_request_server,
  },
};

const wl_message zxdg_decoration_manager_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zxdg_decoration_manager_v1_interface =
  {
    "zxdg_decoration_manager_v1",
    1,
    2,
    zxdg_decoration_manager_v1_interface_requests_server,
    0,
    zxdg_decoration_manager_v1_interface_events_server,
  };

const wl_interface* zxdg_toplevel_decoration_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zxdg_toplevel_decoration_v1_interface_set_mode_request_server[1] = {
  nullptr,
};

const wl_interface* zxdg_toplevel_decoration_v1_interface_unset_mode_request_server[0] = {
};

const wl_interface* zxdg_toplevel_decoration_v1_interface_configure_event_server[1] = {
  nullptr,
};

const wl_message zxdg_toplevel_decoration_v1_interface_requests_server[3] = {
  {
    "destroy",
    "",
    zxdg_toplevel_decoration_v1_interface_destroy_request_server,
  },
  {
    "set_mode",
    "u",
    zxdg_toplevel_decoration_v1_interface_set_mode_request_server,
  },
  {
    "unset_mode",
    "",
    zxdg_toplevel_decoration_v1_interface_unset_mode_request_server,
  },
};

const wl_message zxdg_toplevel_decoration_v1_interface_events_server[1] = {
  {
    "configure",
    "u",
    zxdg_toplevel_decoration_v1_interface_configure_event_server,
  },
};

const wl_interface wayland::server::detail::zxdg_toplevel_decoration_v1_interface =
  {
    "zxdg_toplevel_decoration_v1",
    1,
    3,
    zxdg_toplevel_decoration_v1_interface_requests_server,
    1,
    zxdg_toplevel_decoration_v1_interface_events_server,
  };

const wl_interface* zxdg_exporter_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zxdg_exporter_v1_interface_export_request_server[2] = {
  &zxdg_exported_v1_interface,
  &surface_interface,
};

const wl_message zxdg_exporter_v1_interface_requests_server[2] = {
  {
    "destroy",
    "",
    zxdg_exporter_v1_interface_destroy_request_server,
  },
  {
    "export",
    "no",
    zxdg_exporter_v1_interface_export_request_server,
  },
};

const wl_message zxdg_exporter_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zxdg_exporter_v1_interface =
  {
    "zxdg_exporter_v1",
    1,
    2,
    zxdg_exporter_v1_interface_requests_server,
    0,
    zxdg_exporter_v1_interface_events_server,
  };

const wl_interface* zxdg_importer_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zxdg_importer_v1_interface_import_request_server[2] = {
  &zxdg_imported_v1_interface,
  nullptr,
};

const wl_message zxdg_importer_v1_interface_requests_server[2] = {
  {
    "destroy",
    "",
    zxdg_importer_v1_interface_destroy_request_server,
  },
  {
    "import",
    "ns",
    zxdg_importer_v1_interface_import_request_server,
  },
};

const wl_message zxdg_importer_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zxdg_importer_v1_interface =
  {
    "zxdg_importer_v1",
    1,
    2,
    zxdg_importer_v1_interface_requests_server,
    0,
    zxdg_importer_v1_interface_events_server,
  };

const wl_interface* zxdg_exported_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zxdg_exported_v1_interface_handle_event_server[1] = {
  nullptr,
};

const wl_message zxdg_exported_v1_interface_requests_server[1] = {
  {
    "destroy",
    "",
    zxdg_exported_v1_interface_destroy_request_server,
  },
};

const wl_message zxdg_exported_v1_interface_events_server[1] = {
  {
    "handle",
    "s",
    zxdg_exported_v1_interface_handle_event_server,
  },
};

const wl_interface wayland::server::detail::zxdg_exported_v1_interface =
  {
    "zxdg_exported_v1",
    1,
    1,
    zxdg_exported_v1_interface_requests_server,
    1,
    zxdg_exported_v1_interface_events_server,
  };

const wl_interface* zxdg_imported_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zxdg_imported_v1_interface_set_parent_of_request_server[1] = {
  &surface_interface,
};

const wl_interface* zxdg_imported_v1_interface_destroyed_event_server[0] = {
};

const wl_message zxdg_imported_v1_interface_requests_server[2] = {
  {
    "destroy",
    "",
    zxdg_imported_v1_interface_destroy_request_server,
  },
  {
    "set_parent_of",
    "o",
    zxdg_imported_v1_interface_set_parent_of_request_server,
  },
};

const wl_message zxdg_imported_v1_interface_events_server[1] = {
  {
    "destroyed",
    "",
    zxdg_imported_v1_interface_destroyed_event_server,
  },
};

const wl_interface wayland::server::detail::zxdg_imported_v1_interface =
  {
    "zxdg_imported_v1",
    1,
    2,
    zxdg_imported_v1_interface_requests_server,
    1,
    zxdg_imported_v1_interface_events_server,
  };

const wl_interface* zxdg_exporter_v2_interface_destroy_request_server[0] = {
};

const wl_interface* zxdg_exporter_v2_interface_export_toplevel_request_server[2] = {
  &zxdg_exported_v2_interface,
  &surface_interface,
};

const wl_message zxdg_exporter_v2_interface_requests_server[2] = {
  {
    "destroy",
    "",
    zxdg_exporter_v2_interface_destroy_request_server,
  },
  {
    "export_toplevel",
    "no",
    zxdg_exporter_v2_interface_export_toplevel_request_server,
  },
};

const wl_message zxdg_exporter_v2_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zxdg_exporter_v2_interface =
  {
    "zxdg_exporter_v2",
    1,
    2,
    zxdg_exporter_v2_interface_requests_server,
    0,
    zxdg_exporter_v2_interface_events_server,
  };

const wl_interface* zxdg_importer_v2_interface_destroy_request_server[0] = {
};

const wl_interface* zxdg_importer_v2_interface_import_toplevel_request_server[2] = {
  &zxdg_imported_v2_interface,
  nullptr,
};

const wl_message zxdg_importer_v2_interface_requests_server[2] = {
  {
    "destroy",
    "",
    zxdg_importer_v2_interface_destroy_request_server,
  },
  {
    "import_toplevel",
    "ns",
    zxdg_importer_v2_interface_import_toplevel_request_server,
  },
};

const wl_message zxdg_importer_v2_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zxdg_importer_v2_interface =
  {
    "zxdg_importer_v2",
    1,
    2,
    zxdg_importer_v2_interface_requests_server,
    0,
    zxdg_importer_v2_interface_events_server,
  };

const wl_interface* zxdg_exported_v2_interface_destroy_request_server[0] = {
};

const wl_interface* zxdg_exported_v2_interface_handle_event_server[1] = {
  nullptr,
};

const wl_message zxdg_exported_v2_interface_requests_server[1] = {
  {
    "destroy",
    "",
    zxdg_exported_v2_interface_destroy_request_server,
  },
};

const wl_message zxdg_exported_v2_interface_events_server[1] = {
  {
    "handle",
    "s",
    zxdg_exported_v2_interface_handle_event_server,
  },
};

const wl_interface wayland::server::detail::zxdg_exported_v2_interface =
  {
    "zxdg_exported_v2",
    1,
    1,
    zxdg_exported_v2_interface_requests_server,
    1,
    zxdg_exported_v2_interface_events_server,
  };

const wl_interface* zxdg_imported_v2_interface_destroy_request_server[0] = {
};

const wl_interface* zxdg_imported_v2_interface_set_parent_of_request_server[1] = {
  &surface_interface,
};

const wl_interface* zxdg_imported_v2_interface_destroyed_event_server[0] = {
};

const wl_message zxdg_imported_v2_interface_requests_server[2] = {
  {
    "destroy",
    "",
    zxdg_imported_v2_interface_destroy_request_server,
  },
  {
    "set_parent_of",
    "o",
    zxdg_imported_v2_interface_set_parent_of_request_server,
  },
};

const wl_message zxdg_imported_v2_interface_events_server[1] = {
  {
    "destroyed",
    "",
    zxdg_imported_v2_interface_destroyed_event_server,
  },
};

const wl_interface wayland::server::detail::zxdg_imported_v2_interface =
  {
    "zxdg_imported_v2",
    1,
    2,
    zxdg_imported_v2_interface_requests_server,
    1,
    zxdg_imported_v2_interface_events_server,
  };

const wl_interface* zxdg_output_manager_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zxdg_output_manager_v1_interface_get_xdg_output_request_server[2] = {
  &zxdg_output_v1_interface,
  &output_interface,
};

const wl_message zxdg_output_manager_v1_interface_requests_server[2] = {
  {
    "destroy",
    "",
    zxdg_output_manager_v1_interface_destroy_request_server,
  },
  {
    "get_xdg_output",
    "no",
    zxdg_output_manager_v1_interface_get_xdg_output_request_server,
  },
};

const wl_message zxdg_output_manager_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zxdg_output_manager_v1_interface =
  {
    "zxdg_output_manager_v1",
    3,
    2,
    zxdg_output_manager_v1_interface_requests_server,
    0,
    zxdg_output_manager_v1_interface_events_server,
  };

const wl_interface* zxdg_output_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zxdg_output_v1_interface_logical_position_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zxdg_output_v1_interface_logical_size_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zxdg_output_v1_interface_done_event_server[0] = {
};

const wl_interface* zxdg_output_v1_interface_name_event_server[1] = {
  nullptr,
};

const wl_interface* zxdg_output_v1_interface_description_event_server[1] = {
  nullptr,
};

const wl_message zxdg_output_v1_interface_requests_server[1] = {
  {
    "destroy",
    "",
    zxdg_output_v1_interface_destroy_request_server,
  },
};

const wl_message zxdg_output_v1_interface_events_server[5] = {
  {
    "logical_position",
    "ii",
    zxdg_output_v1_interface_logical_position_event_server,
  },
  {
    "logical_size",
    "ii",
    zxdg_output_v1_interface_logical_size_event_server,
  },
  {
    "done",
    "",
    zxdg_output_v1_interface_done_event_server,
  },
  {
    "name",
    "2s",
    zxdg_output_v1_interface_name_event_server,
  },
  {
    "description",
    "2s",
    zxdg_output_v1_interface_description_event_server,
  },
};

const wl_interface wayland::server::detail::zxdg_output_v1_interface =
  {
    "zxdg_output_v1",
    3,
    1,
    zxdg_output_v1_interface_requests_server,
    5,
    zxdg_output_v1_interface_events_server,
  };

const wl_interface* zxdg_shell_v6_interface_destroy_request_server[0] = {
};

const wl_interface* zxdg_shell_v6_interface_create_positioner_request_server[1] = {
  &zxdg_positioner_v6_interface,
};

const wl_interface* zxdg_shell_v6_interface_get_xdg_surface_request_server[2] = {
  &zxdg_surface_v6_interface,
  &surface_interface,
};

const wl_interface* zxdg_shell_v6_interface_pong_request_server[1] = {
  nullptr,
};

const wl_interface* zxdg_shell_v6_interface_ping_event_server[1] = {
  nullptr,
};

const wl_message zxdg_shell_v6_interface_requests_server[4] = {
  {
    "destroy",
    "",
    zxdg_shell_v6_interface_destroy_request_server,
  },
  {
    "create_positioner",
    "n",
    zxdg_shell_v6_interface_create_positioner_request_server,
  },
  {
    "get_xdg_surface",
    "no",
    zxdg_shell_v6_interface_get_xdg_surface_request_server,
  },
  {
    "pong",
    "u",
    zxdg_shell_v6_interface_pong_request_server,
  },
};

const wl_message zxdg_shell_v6_interface_events_server[1] = {
  {
    "ping",
    "u",
    zxdg_shell_v6_interface_ping_event_server,
  },
};

const wl_interface wayland::server::detail::zxdg_shell_v6_interface =
  {
    "zxdg_shell_v6",
    1,
    4,
    zxdg_shell_v6_interface_requests_server,
    1,
    zxdg_shell_v6_interface_events_server,
  };

const wl_interface* zxdg_positioner_v6_interface_destroy_request_server[0] = {
};

const wl_interface* zxdg_positioner_v6_interface_set_size_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zxdg_positioner_v6_interface_set_anchor_rect_request_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zxdg_positioner_v6_interface_set_anchor_request_server[1] = {
  nullptr,
};

const wl_interface* zxdg_positioner_v6_interface_set_gravity_request_server[1] = {
  nullptr,
};

const wl_interface* zxdg_positioner_v6_interface_set_constraint_adjustment_request_server[1] = {
  nullptr,
};

const wl_interface* zxdg_positioner_v6_interface_set_offset_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_message zxdg_positioner_v6_interface_requests_server[7] = {
  {
    "destroy",
    "",
    zxdg_positioner_v6_interface_destroy_request_server,
  },
  {
    "set_size",
    "ii",
    zxdg_positioner_v6_interface_set_size_request_server,
  },
  {
    "set_anchor_rect",
    "iiii",
    zxdg_positioner_v6_interface_set_anchor_rect_request_server,
  },
  {
    "set_anchor",
    "u",
    zxdg_positioner_v6_interface_set_anchor_request_server,
  },
  {
    "set_gravity",
    "u",
    zxdg_positioner_v6_interface_set_gravity_request_server,
  },
  {
    "set_constraint_adjustment",
    "u",
    zxdg_positioner_v6_interface_set_constraint_adjustment_request_server,
  },
  {
    "set_offset",
    "ii",
    zxdg_positioner_v6_interface_set_offset_request_server,
  },
};

const wl_message zxdg_positioner_v6_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zxdg_positioner_v6_interface =
  {
    "zxdg_positioner_v6",
    1,
    7,
    zxdg_positioner_v6_interface_requests_server,
    0,
    zxdg_positioner_v6_interface_events_server,
  };

const wl_interface* zxdg_surface_v6_interface_destroy_request_server[0] = {
};

const wl_interface* zxdg_surface_v6_interface_get_toplevel_request_server[1] = {
  &zxdg_toplevel_v6_interface,
};

const wl_interface* zxdg_surface_v6_interface_get_popup_request_server[3] = {
  &zxdg_popup_v6_interface,
  &zxdg_surface_v6_interface,
  &zxdg_positioner_v6_interface,
};

const wl_interface* zxdg_surface_v6_interface_set_window_geometry_request_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zxdg_surface_v6_interface_ack_configure_request_server[1] = {
  nullptr,
};

const wl_interface* zxdg_surface_v6_interface_configure_event_server[1] = {
  nullptr,
};

const wl_message zxdg_surface_v6_interface_requests_server[5] = {
  {
    "destroy",
    "",
    zxdg_surface_v6_interface_destroy_request_server,
  },
  {
    "get_toplevel",
    "n",
    zxdg_surface_v6_interface_get_toplevel_request_server,
  },
  {
    "get_popup",
    "noo",
    zxdg_surface_v6_interface_get_popup_request_server,
  },
  {
    "set_window_geometry",
    "iiii",
    zxdg_surface_v6_interface_set_window_geometry_request_server,
  },
  {
    "ack_configure",
    "u",
    zxdg_surface_v6_interface_ack_configure_request_server,
  },
};

const wl_message zxdg_surface_v6_interface_events_server[1] = {
  {
    "configure",
    "u",
    zxdg_surface_v6_interface_configure_event_server,
  },
};

const wl_interface wayland::server::detail::zxdg_surface_v6_interface =
  {
    "zxdg_surface_v6",
    1,
    5,
    zxdg_surface_v6_interface_requests_server,
    1,
    zxdg_surface_v6_interface_events_server,
  };

const wl_interface* zxdg_toplevel_v6_interface_destroy_request_server[0] = {
};

const wl_interface* zxdg_toplevel_v6_interface_set_parent_request_server[1] = {
  &zxdg_toplevel_v6_interface,
};

const wl_interface* zxdg_toplevel_v6_interface_set_title_request_server[1] = {
  nullptr,
};

const wl_interface* zxdg_toplevel_v6_interface_set_app_id_request_server[1] = {
  nullptr,
};

const wl_interface* zxdg_toplevel_v6_interface_show_window_menu_request_server[4] = {
  &seat_interface,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zxdg_toplevel_v6_interface_move_request_server[2] = {
  &seat_interface,
  nullptr,
};

const wl_interface* zxdg_toplevel_v6_interface_resize_request_server[3] = {
  &seat_interface,
  nullptr,
  nullptr,
};

const wl_interface* zxdg_toplevel_v6_interface_set_max_size_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zxdg_toplevel_v6_interface_set_min_size_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zxdg_toplevel_v6_interface_set_maximized_request_server[0] = {
};

const wl_interface* zxdg_toplevel_v6_interface_unset_maximized_request_server[0] = {
};

const wl_interface* zxdg_toplevel_v6_interface_set_fullscreen_request_server[1] = {
  &output_interface,
};

const wl_interface* zxdg_toplevel_v6_interface_unset_fullscreen_request_server[0] = {
};

const wl_interface* zxdg_toplevel_v6_interface_set_minimized_request_server[0] = {
};

const wl_interface* zxdg_toplevel_v6_interface_configure_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zxdg_toplevel_v6_interface_close_event_server[0] = {
};

const wl_message zxdg_toplevel_v6_interface_requests_server[14] = {
  {
    "destroy",
    "",
    zxdg_toplevel_v6_interface_destroy_request_server,
  },
  {
    "set_parent",
    "?o",
    zxdg_toplevel_v6_interface_set_parent_request_server,
  },
  {
    "set_title",
    "s",
    zxdg_toplevel_v6_interface_set_title_request_server,
  },
  {
    "set_app_id",
    "s",
    zxdg_toplevel_v6_interface_set_app_id_request_server,
  },
  {
    "show_window_menu",
    "ouii",
    zxdg_toplevel_v6_interface_show_window_menu_request_server,
  },
  {
    "move",
    "ou",
    zxdg_toplevel_v6_interface_move_request_server,
  },
  {
    "resize",
    "ouu",
    zxdg_toplevel_v6_interface_resize_request_server,
  },
  {
    "set_max_size",
    "ii",
    zxdg_toplevel_v6_interface_set_max_size_request_server,
  },
  {
    "set_min_size",
    "ii",
    zxdg_toplevel_v6_interface_set_min_size_request_server,
  },
  {
    "set_maximized",
    "",
    zxdg_toplevel_v6_interface_set_maximized_request_server,
  },
  {
    "unset_maximized",
    "",
    zxdg_toplevel_v6_interface_unset_maximized_request_server,
  },
  {
    "set_fullscreen",
    "?o",
    zxdg_toplevel_v6_interface_set_fullscreen_request_server,
  },
  {
    "unset_fullscreen",
    "",
    zxdg_toplevel_v6_interface_unset_fullscreen_request_server,
  },
  {
    "set_minimized",
    "",
    zxdg_toplevel_v6_interface_set_minimized_request_server,
  },
};

const wl_message zxdg_toplevel_v6_interface_events_server[2] = {
  {
    "configure",
    "iia",
    zxdg_toplevel_v6_interface_configure_event_server,
  },
  {
    "close",
    "",
    zxdg_toplevel_v6_interface_close_event_server,
  },
};

const wl_interface wayland::server::detail::zxdg_toplevel_v6_interface =
  {
    "zxdg_toplevel_v6",
    1,
    14,
    zxdg_toplevel_v6_interface_requests_server,
    2,
    zxdg_toplevel_v6_interface_events_server,
  };

const wl_interface* zxdg_popup_v6_interface_destroy_request_server[0] = {
};

const wl_interface* zxdg_popup_v6_interface_grab_request_server[2] = {
  &seat_interface,
  nullptr,
};

const wl_interface* zxdg_popup_v6_interface_configure_event_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zxdg_popup_v6_interface_popup_done_event_server[0] = {
};

const wl_message zxdg_popup_v6_interface_requests_server[2] = {
  {
    "destroy",
    "",
    zxdg_popup_v6_interface_destroy_request_server,
  },
  {
    "grab",
    "ou",
    zxdg_popup_v6_interface_grab_request_server,
  },
};

const wl_message zxdg_popup_v6_interface_events_server[2] = {
  {
    "configure",
    "iiii",
    zxdg_popup_v6_interface_configure_event_server,
  },
  {
    "popup_done",
    "",
    zxdg_popup_v6_interface_popup_done_event_server,
  },
};

const wl_interface wayland::server::detail::zxdg_popup_v6_interface =
  {
    "zxdg_popup_v6",
    1,
    2,
    zxdg_popup_v6_interface_requests_server,
    2,
    zxdg_popup_v6_interface_events_server,
  };

const wl_interface* zwp_xwayland_keyboard_grab_manager_v1_interface_destroy_request_server[0] = {
};

const wl_interface* zwp_xwayland_keyboard_grab_manager_v1_interface_grab_keyboard_request_server[3] = {
  &zwp_xwayland_keyboard_grab_v1_interface,
  &surface_interface,
  &seat_interface,
};

const wl_message zwp_xwayland_keyboard_grab_manager_v1_interface_requests_server[2] = {
  {
    "destroy",
    "",
    zwp_xwayland_keyboard_grab_manager_v1_interface_destroy_request_server,
  },
  {
    "grab_keyboard",
    "noo",
    zwp_xwayland_keyboard_grab_manager_v1_interface_grab_keyboard_request_server,
  },
};

const wl_message zwp_xwayland_keyboard_grab_manager_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zwp_xwayland_keyboard_grab_manager_v1_interface =
  {
    "zwp_xwayland_keyboard_grab_manager_v1",
    1,
    2,
    zwp_xwayland_keyboard_grab_manager_v1_interface_requests_server,
    0,
    zwp_xwayland_keyboard_grab_manager_v1_interface_events_server,
  };

const wl_interface* zwp_xwayland_keyboard_grab_v1_interface_destroy_request_server[0] = {
};

const wl_message zwp_xwayland_keyboard_grab_v1_interface_requests_server[1] = {
  {
    "destroy",
    "",
    zwp_xwayland_keyboard_grab_v1_interface_destroy_request_server,
  },
};

const wl_message zwp_xwayland_keyboard_grab_v1_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::zwp_xwayland_keyboard_grab_v1_interface =
  {
    "zwp_xwayland_keyboard_grab_v1",
    1,
    1,
    zwp_xwayland_keyboard_grab_v1_interface_requests_server,
    0,
    zwp_xwayland_keyboard_grab_v1_interface_events_server,
  };

zwp_fullscreen_shell_v1_t::zwp_fullscreen_shell_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_fullscreen_shell_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_fullscreen_shell_v1_t::zwp_fullscreen_shell_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_fullscreen_shell_v1_t::interface_name = "zwp_fullscreen_shell_v1";

zwp_fullscreen_shell_v1_t::operator zwp_fullscreen_shell_v1*() const
{
  return reinterpret_cast<zwp_fullscreen_shell_v1*> (c_ptr());
}

std::function<void()> &zwp_fullscreen_shell_v1_t::on_release()
{
  return std::static_pointer_cast<events_t>(get_events())->release;
}


std::function<void(surface_t, zwp_fullscreen_shell_v1_present_method, output_t)> &zwp_fullscreen_shell_v1_t::on_present_surface()
{
  return std::static_pointer_cast<events_t>(get_events())->present_surface;
}


std::function<void(surface_t, output_t, int32_t, zwp_fullscreen_shell_mode_feedback_v1_t)> &zwp_fullscreen_shell_v1_t::on_present_surface_for_mode()
{
  return std::static_pointer_cast<events_t>(get_events())->present_surface_for_mode;
}


void zwp_fullscreen_shell_v1_t::capability(zwp_fullscreen_shell_v1_capability const& capability, bool post)
{
  send_event(post, 0, static_cast<uint32_t>(capability));
}

void zwp_fullscreen_shell_v1_t::post_invalid_method(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_fullscreen_shell_v1_error::invalid_method), msg);
}

void zwp_fullscreen_shell_v1_t::post_role(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_fullscreen_shell_v1_error::role), msg);
}

int zwp_fullscreen_shell_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->release) events->release();
      break;
    case 1:
      if(events->present_surface) events->present_surface(surface_t(args[0].get<resource_t>()), zwp_fullscreen_shell_v1_present_method(args[1].get<uint32_t>()), output_t(args[2].get<resource_t>()));
      break;
    case 2:
      if(events->present_surface_for_mode) events->present_surface_for_mode(surface_t(args[0].get<resource_t>()), output_t(args[1].get<resource_t>()), args[2].get<int32_t>(), zwp_fullscreen_shell_mode_feedback_v1_t(args[3].get<resource_t>()));
      break;
    }
  return 0;
}




zwp_fullscreen_shell_mode_feedback_v1_t::zwp_fullscreen_shell_mode_feedback_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_fullscreen_shell_mode_feedback_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_fullscreen_shell_mode_feedback_v1_t::zwp_fullscreen_shell_mode_feedback_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_fullscreen_shell_mode_feedback_v1_t::interface_name = "zwp_fullscreen_shell_mode_feedback_v1";

zwp_fullscreen_shell_mode_feedback_v1_t::operator zwp_fullscreen_shell_mode_feedback_v1*() const
{
  return reinterpret_cast<zwp_fullscreen_shell_mode_feedback_v1*> (c_ptr());
}

void zwp_fullscreen_shell_mode_feedback_v1_t::mode_successful(bool post)
{
  send_event(post, 0);
}

void zwp_fullscreen_shell_mode_feedback_v1_t::mode_failed(bool post)
{
  send_event(post, 1);
}

void zwp_fullscreen_shell_mode_feedback_v1_t::present_cancelled(bool post)
{
  send_event(post, 2);
}

int zwp_fullscreen_shell_mode_feedback_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  return 0;
}

zwp_idle_inhibit_manager_v1_t::zwp_idle_inhibit_manager_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_idle_inhibit_manager_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_idle_inhibit_manager_v1_t::zwp_idle_inhibit_manager_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_idle_inhibit_manager_v1_t::interface_name = "zwp_idle_inhibit_manager_v1";

zwp_idle_inhibit_manager_v1_t::operator zwp_idle_inhibit_manager_v1*() const
{
  return reinterpret_cast<zwp_idle_inhibit_manager_v1*> (c_ptr());
}

std::function<void()> &zwp_idle_inhibit_manager_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zwp_idle_inhibitor_v1_t, surface_t)> &zwp_idle_inhibit_manager_v1_t::on_create_inhibitor()
{
  return std::static_pointer_cast<events_t>(get_events())->create_inhibitor;
}


int zwp_idle_inhibit_manager_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->create_inhibitor) events->create_inhibitor(zwp_idle_inhibitor_v1_t(args[0].get<resource_t>()), surface_t(args[1].get<resource_t>()));
      break;
    }
  return 0;
}

zwp_idle_inhibitor_v1_t::zwp_idle_inhibitor_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_idle_inhibitor_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_idle_inhibitor_v1_t::zwp_idle_inhibitor_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_idle_inhibitor_v1_t::interface_name = "zwp_idle_inhibitor_v1";

zwp_idle_inhibitor_v1_t::operator zwp_idle_inhibitor_v1*() const
{
  return reinterpret_cast<zwp_idle_inhibitor_v1*> (c_ptr());
}

std::function<void()> &zwp_idle_inhibitor_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


int zwp_idle_inhibitor_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zwp_input_method_context_v1_t::zwp_input_method_context_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_input_method_context_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_input_method_context_v1_t::zwp_input_method_context_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_input_method_context_v1_t::interface_name = "zwp_input_method_context_v1";

zwp_input_method_context_v1_t::operator zwp_input_method_context_v1*() const
{
  return reinterpret_cast<zwp_input_method_context_v1*> (c_ptr());
}

std::function<void()> &zwp_input_method_context_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(uint32_t, std::string)> &zwp_input_method_context_v1_t::on_commit_string()
{
  return std::static_pointer_cast<events_t>(get_events())->commit_string;
}


std::function<void(uint32_t, std::string, std::string)> &zwp_input_method_context_v1_t::on_preedit_string()
{
  return std::static_pointer_cast<events_t>(get_events())->preedit_string;
}


std::function<void(uint32_t, uint32_t, zwp_text_input_v1_preedit_style)> &zwp_input_method_context_v1_t::on_preedit_styling()
{
  return std::static_pointer_cast<events_t>(get_events())->preedit_styling;
}


std::function<void(int32_t)> &zwp_input_method_context_v1_t::on_preedit_cursor()
{
  return std::static_pointer_cast<events_t>(get_events())->preedit_cursor;
}


std::function<void(int32_t, uint32_t)> &zwp_input_method_context_v1_t::on_delete_surrounding_text()
{
  return std::static_pointer_cast<events_t>(get_events())->delete_surrounding_text;
}


std::function<void(int32_t, int32_t)> &zwp_input_method_context_v1_t::on_cursor_position()
{
  return std::static_pointer_cast<events_t>(get_events())->cursor_position;
}


std::function<void(array_t)> &zwp_input_method_context_v1_t::on_modifiers_map()
{
  return std::static_pointer_cast<events_t>(get_events())->modifiers_map;
}


std::function<void(uint32_t, uint32_t, uint32_t, keyboard_key_state, uint32_t)> &zwp_input_method_context_v1_t::on_keysym()
{
  return std::static_pointer_cast<events_t>(get_events())->keysym;
}


std::function<void(keyboard_t)> &zwp_input_method_context_v1_t::on_grab_keyboard()
{
  return std::static_pointer_cast<events_t>(get_events())->grab_keyboard;
}


std::function<void(uint32_t, uint32_t, uint32_t, keyboard_key_state)> &zwp_input_method_context_v1_t::on_key()
{
  return std::static_pointer_cast<events_t>(get_events())->key;
}


std::function<void(uint32_t, uint32_t, uint32_t, uint32_t, uint32_t)> &zwp_input_method_context_v1_t::on_modifiers()
{
  return std::static_pointer_cast<events_t>(get_events())->modifiers;
}


std::function<void(uint32_t, std::string)> &zwp_input_method_context_v1_t::on_language()
{
  return std::static_pointer_cast<events_t>(get_events())->language;
}


std::function<void(uint32_t, uint32_t)> &zwp_input_method_context_v1_t::on_text_direction()
{
  return std::static_pointer_cast<events_t>(get_events())->text_direction;
}


void zwp_input_method_context_v1_t::surrounding_text(std::string const& text, uint32_t cursor, uint32_t anchor, bool post)
{
  send_event(post, 0, text, cursor, anchor);
}

void zwp_input_method_context_v1_t::reset(bool post)
{
  send_event(post, 1);
}

void zwp_input_method_context_v1_t::content_type(zwp_text_input_v1_content_hint const& hint, zwp_text_input_v1_content_purpose const& purpose, bool post)
{
  send_event(post, 2, static_cast<uint32_t>(hint), static_cast<uint32_t>(purpose));
}

void zwp_input_method_context_v1_t::invoke_action(uint32_t button, uint32_t index, bool post)
{
  send_event(post, 3, button, index);
}

void zwp_input_method_context_v1_t::commit_state(uint32_t serial, bool post)
{
  send_event(post, 4, serial);
}

void zwp_input_method_context_v1_t::preferred_language(std::string const& language, bool post)
{
  send_event(post, 5, language);
}

int zwp_input_method_context_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->commit_string) events->commit_string(args[0].get<uint32_t>(), args[1].get<std::string>());
      break;
    case 2:
      if(events->preedit_string) events->preedit_string(args[0].get<uint32_t>(), args[1].get<std::string>(), args[2].get<std::string>());
      break;
    case 3:
      if(events->preedit_styling) events->preedit_styling(args[0].get<uint32_t>(), args[1].get<uint32_t>(), zwp_text_input_v1_preedit_style(args[2].get<uint32_t>()));
      break;
    case 4:
      if(events->preedit_cursor) events->preedit_cursor(args[0].get<int32_t>());
      break;
    case 5:
      if(events->delete_surrounding_text) events->delete_surrounding_text(args[0].get<int32_t>(), args[1].get<uint32_t>());
      break;
    case 6:
      if(events->cursor_position) events->cursor_position(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    case 7:
      if(events->modifiers_map) events->modifiers_map(args[0].get<array_t>());
      break;
    case 8:
      if(events->keysym) events->keysym(args[0].get<uint32_t>(), args[1].get<uint32_t>(), args[2].get<uint32_t>(), keyboard_key_state(args[3].get<uint32_t>()), args[4].get<uint32_t>());
      break;
    case 9:
      if(events->grab_keyboard) events->grab_keyboard(keyboard_t(args[0].get<resource_t>()));
      break;
    case 10:
      if(events->key) events->key(args[0].get<uint32_t>(), args[1].get<uint32_t>(), args[2].get<uint32_t>(), keyboard_key_state(args[3].get<uint32_t>()));
      break;
    case 11:
      if(events->modifiers) events->modifiers(args[0].get<uint32_t>(), args[1].get<uint32_t>(), args[2].get<uint32_t>(), args[3].get<uint32_t>(), args[4].get<uint32_t>());
      break;
    case 12:
      if(events->language) events->language(args[0].get<uint32_t>(), args[1].get<std::string>());
      break;
    case 13:
      if(events->text_direction) events->text_direction(args[0].get<uint32_t>(), args[1].get<uint32_t>());
      break;
    }
  return 0;
}

zwp_input_method_v1_t::zwp_input_method_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_input_method_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_input_method_v1_t::zwp_input_method_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_input_method_v1_t::interface_name = "zwp_input_method_v1";

zwp_input_method_v1_t::operator zwp_input_method_v1*() const
{
  return reinterpret_cast<zwp_input_method_v1*> (c_ptr());
}

void zwp_input_method_v1_t::activate(bool post)
{
  send_event(post, 0, nullptr);
}

void zwp_input_method_v1_t::deactivate(zwp_input_method_context_v1_t const& context, bool post)
{
  send_event(post, 1, context.proxy_has_object() ? reinterpret_cast<wl_object*>(context.c_ptr()) : nullptr);
}

int zwp_input_method_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  return 0;
}

zwp_input_panel_v1_t::zwp_input_panel_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_input_panel_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_input_panel_v1_t::zwp_input_panel_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_input_panel_v1_t::interface_name = "zwp_input_panel_v1";

zwp_input_panel_v1_t::operator zwp_input_panel_v1*() const
{
  return reinterpret_cast<zwp_input_panel_v1*> (c_ptr());
}

std::function<void(zwp_input_panel_surface_v1_t, surface_t)> &zwp_input_panel_v1_t::on_get_input_panel_surface()
{
  return std::static_pointer_cast<events_t>(get_events())->get_input_panel_surface;
}


int zwp_input_panel_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->get_input_panel_surface) events->get_input_panel_surface(zwp_input_panel_surface_v1_t(args[0].get<resource_t>()), surface_t(args[1].get<resource_t>()));
      break;
    }
  return 0;
}

zwp_input_panel_surface_v1_t::zwp_input_panel_surface_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_input_panel_surface_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_input_panel_surface_v1_t::zwp_input_panel_surface_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_input_panel_surface_v1_t::interface_name = "zwp_input_panel_surface_v1";

zwp_input_panel_surface_v1_t::operator zwp_input_panel_surface_v1*() const
{
  return reinterpret_cast<zwp_input_panel_surface_v1*> (c_ptr());
}

std::function<void(output_t, zwp_input_panel_surface_v1_position)> &zwp_input_panel_surface_v1_t::on_set_toplevel()
{
  return std::static_pointer_cast<events_t>(get_events())->set_toplevel;
}


std::function<void()> &zwp_input_panel_surface_v1_t::on_set_overlay_panel()
{
  return std::static_pointer_cast<events_t>(get_events())->set_overlay_panel;
}


int zwp_input_panel_surface_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->set_toplevel) events->set_toplevel(output_t(args[0].get<resource_t>()), zwp_input_panel_surface_v1_position(args[1].get<uint32_t>()));
      break;
    case 1:
      if(events->set_overlay_panel) events->set_overlay_panel();
      break;
    }
  return 0;
}


zwp_input_timestamps_manager_v1_t::zwp_input_timestamps_manager_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_input_timestamps_manager_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_input_timestamps_manager_v1_t::zwp_input_timestamps_manager_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_input_timestamps_manager_v1_t::interface_name = "zwp_input_timestamps_manager_v1";

zwp_input_timestamps_manager_v1_t::operator zwp_input_timestamps_manager_v1*() const
{
  return reinterpret_cast<zwp_input_timestamps_manager_v1*> (c_ptr());
}

std::function<void()> &zwp_input_timestamps_manager_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zwp_input_timestamps_v1_t, keyboard_t)> &zwp_input_timestamps_manager_v1_t::on_get_keyboard_timestamps()
{
  return std::static_pointer_cast<events_t>(get_events())->get_keyboard_timestamps;
}


std::function<void(zwp_input_timestamps_v1_t, pointer_t)> &zwp_input_timestamps_manager_v1_t::on_get_pointer_timestamps()
{
  return std::static_pointer_cast<events_t>(get_events())->get_pointer_timestamps;
}


std::function<void(zwp_input_timestamps_v1_t, touch_t)> &zwp_input_timestamps_manager_v1_t::on_get_touch_timestamps()
{
  return std::static_pointer_cast<events_t>(get_events())->get_touch_timestamps;
}


int zwp_input_timestamps_manager_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->get_keyboard_timestamps) events->get_keyboard_timestamps(zwp_input_timestamps_v1_t(args[0].get<resource_t>()), keyboard_t(args[1].get<resource_t>()));
      break;
    case 2:
      if(events->get_pointer_timestamps) events->get_pointer_timestamps(zwp_input_timestamps_v1_t(args[0].get<resource_t>()), pointer_t(args[1].get<resource_t>()));
      break;
    case 3:
      if(events->get_touch_timestamps) events->get_touch_timestamps(zwp_input_timestamps_v1_t(args[0].get<resource_t>()), touch_t(args[1].get<resource_t>()));
      break;
    }
  return 0;
}

zwp_input_timestamps_v1_t::zwp_input_timestamps_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_input_timestamps_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_input_timestamps_v1_t::zwp_input_timestamps_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_input_timestamps_v1_t::interface_name = "zwp_input_timestamps_v1";

zwp_input_timestamps_v1_t::operator zwp_input_timestamps_v1*() const
{
  return reinterpret_cast<zwp_input_timestamps_v1*> (c_ptr());
}

std::function<void()> &zwp_input_timestamps_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_input_timestamps_v1_t::timestamp(uint32_t tv_sec_hi, uint32_t tv_sec_lo, uint32_t tv_nsec, bool post)
{
  send_event(post, 0, tv_sec_hi, tv_sec_lo, tv_nsec);
}

int zwp_input_timestamps_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zwp_keyboard_shortcuts_inhibit_manager_v1_t::zwp_keyboard_shortcuts_inhibit_manager_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_keyboard_shortcuts_inhibit_manager_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_keyboard_shortcuts_inhibit_manager_v1_t::zwp_keyboard_shortcuts_inhibit_manager_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_keyboard_shortcuts_inhibit_manager_v1_t::interface_name = "zwp_keyboard_shortcuts_inhibit_manager_v1";

zwp_keyboard_shortcuts_inhibit_manager_v1_t::operator zwp_keyboard_shortcuts_inhibit_manager_v1*() const
{
  return reinterpret_cast<zwp_keyboard_shortcuts_inhibit_manager_v1*> (c_ptr());
}

std::function<void()> &zwp_keyboard_shortcuts_inhibit_manager_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zwp_keyboard_shortcuts_inhibitor_v1_t, surface_t, seat_t)> &zwp_keyboard_shortcuts_inhibit_manager_v1_t::on_inhibit_shortcuts()
{
  return std::static_pointer_cast<events_t>(get_events())->inhibit_shortcuts;
}


void zwp_keyboard_shortcuts_inhibit_manager_v1_t::post_already_inhibited(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_keyboard_shortcuts_inhibit_manager_v1_error::already_inhibited), msg);
}

int zwp_keyboard_shortcuts_inhibit_manager_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->inhibit_shortcuts) events->inhibit_shortcuts(zwp_keyboard_shortcuts_inhibitor_v1_t(args[0].get<resource_t>()), surface_t(args[1].get<resource_t>()), seat_t(args[2].get<resource_t>()));
      break;
    }
  return 0;
}


zwp_keyboard_shortcuts_inhibitor_v1_t::zwp_keyboard_shortcuts_inhibitor_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_keyboard_shortcuts_inhibitor_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_keyboard_shortcuts_inhibitor_v1_t::zwp_keyboard_shortcuts_inhibitor_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_keyboard_shortcuts_inhibitor_v1_t::interface_name = "zwp_keyboard_shortcuts_inhibitor_v1";

zwp_keyboard_shortcuts_inhibitor_v1_t::operator zwp_keyboard_shortcuts_inhibitor_v1*() const
{
  return reinterpret_cast<zwp_keyboard_shortcuts_inhibitor_v1*> (c_ptr());
}

std::function<void()> &zwp_keyboard_shortcuts_inhibitor_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_keyboard_shortcuts_inhibitor_v1_t::active(bool post)
{
  send_event(post, 0);
}

void zwp_keyboard_shortcuts_inhibitor_v1_t::inactive(bool post)
{
  send_event(post, 1);
}

int zwp_keyboard_shortcuts_inhibitor_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zwp_linux_dmabuf_v1_t::zwp_linux_dmabuf_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_linux_dmabuf_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_linux_dmabuf_v1_t::zwp_linux_dmabuf_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_linux_dmabuf_v1_t::interface_name = "zwp_linux_dmabuf_v1";

zwp_linux_dmabuf_v1_t::operator zwp_linux_dmabuf_v1*() const
{
  return reinterpret_cast<zwp_linux_dmabuf_v1*> (c_ptr());
}

std::function<void()> &zwp_linux_dmabuf_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zwp_linux_buffer_params_v1_t)> &zwp_linux_dmabuf_v1_t::on_create_params()
{
  return std::static_pointer_cast<events_t>(get_events())->create_params;
}


std::function<void(zwp_linux_dmabuf_feedback_v1_t)> &zwp_linux_dmabuf_v1_t::on_get_default_feedback()
{
  return std::static_pointer_cast<events_t>(get_events())->get_default_feedback;
}


std::function<void(zwp_linux_dmabuf_feedback_v1_t, surface_t)> &zwp_linux_dmabuf_v1_t::on_get_surface_feedback()
{
  return std::static_pointer_cast<events_t>(get_events())->get_surface_feedback;
}


void zwp_linux_dmabuf_v1_t::format(uint32_t format, bool post)
{
  send_event(post, 0, format);
}

void zwp_linux_dmabuf_v1_t::modifier(uint32_t format, uint32_t modifier_hi, uint32_t modifier_lo, bool post)
{
  send_event(post, 1, format, modifier_hi, modifier_lo);
}

bool zwp_linux_dmabuf_v1_t::can_modifier() const
{
  return (get_version() >= modifier_since_version);
}

int zwp_linux_dmabuf_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->create_params) events->create_params(zwp_linux_buffer_params_v1_t(args[0].get<resource_t>()));
      break;
    case 2:
      if(events->get_default_feedback) events->get_default_feedback(zwp_linux_dmabuf_feedback_v1_t(args[0].get<resource_t>()));
      break;
    case 3:
      if(events->get_surface_feedback) events->get_surface_feedback(zwp_linux_dmabuf_feedback_v1_t(args[0].get<resource_t>()), surface_t(args[1].get<resource_t>()));
      break;
    }
  return 0;
}

zwp_linux_buffer_params_v1_t::zwp_linux_buffer_params_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_linux_buffer_params_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_linux_buffer_params_v1_t::zwp_linux_buffer_params_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_linux_buffer_params_v1_t::interface_name = "zwp_linux_buffer_params_v1";

zwp_linux_buffer_params_v1_t::operator zwp_linux_buffer_params_v1*() const
{
  return reinterpret_cast<zwp_linux_buffer_params_v1*> (c_ptr());
}

std::function<void()> &zwp_linux_buffer_params_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(int, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t)> &zwp_linux_buffer_params_v1_t::on_add()
{
  return std::static_pointer_cast<events_t>(get_events())->add;
}


std::function<void(int32_t, int32_t, uint32_t, zwp_linux_buffer_params_v1_flags)> &zwp_linux_buffer_params_v1_t::on_create()
{
  return std::static_pointer_cast<events_t>(get_events())->create;
}


std::function<void(buffer_t, int32_t, int32_t, uint32_t, zwp_linux_buffer_params_v1_flags)> &zwp_linux_buffer_params_v1_t::on_create_immed()
{
  return std::static_pointer_cast<events_t>(get_events())->create_immed;
}


void zwp_linux_buffer_params_v1_t::created(bool post)
{
  send_event(post, 0, nullptr);
}

void zwp_linux_buffer_params_v1_t::failed(bool post)
{
  send_event(post, 1);
}

void zwp_linux_buffer_params_v1_t::post_already_used(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_linux_buffer_params_v1_error::already_used), msg);
}

void zwp_linux_buffer_params_v1_t::post_plane_idx(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_linux_buffer_params_v1_error::plane_idx), msg);
}

void zwp_linux_buffer_params_v1_t::post_plane_set(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_linux_buffer_params_v1_error::plane_set), msg);
}

void zwp_linux_buffer_params_v1_t::post_incomplete(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_linux_buffer_params_v1_error::incomplete), msg);
}

void zwp_linux_buffer_params_v1_t::post_invalid_format(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_linux_buffer_params_v1_error::invalid_format), msg);
}

void zwp_linux_buffer_params_v1_t::post_invalid_dimensions(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_linux_buffer_params_v1_error::invalid_dimensions), msg);
}

void zwp_linux_buffer_params_v1_t::post_out_of_bounds(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_linux_buffer_params_v1_error::out_of_bounds), msg);
}

void zwp_linux_buffer_params_v1_t::post_invalid_wl_buffer(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_linux_buffer_params_v1_error::invalid_wl_buffer), msg);
}

int zwp_linux_buffer_params_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->add) events->add(args[0].get<int>(), args[1].get<uint32_t>(), args[2].get<uint32_t>(), args[3].get<uint32_t>(), args[4].get<uint32_t>(), args[5].get<uint32_t>());
      break;
    case 2:
      if(events->create) events->create(args[0].get<int32_t>(), args[1].get<int32_t>(), args[2].get<uint32_t>(), zwp_linux_buffer_params_v1_flags(args[3].get<uint32_t>()));
      break;
    case 3:
      if(events->create_immed) events->create_immed(buffer_t(args[0].get<resource_t>()), args[1].get<int32_t>(), args[2].get<int32_t>(), args[3].get<uint32_t>(), zwp_linux_buffer_params_v1_flags(args[4].get<uint32_t>()));
      break;
    }
  return 0;
}

const bitfield<3, 6> zwp_linux_buffer_params_v1_flags::y_invert{1};
const bitfield<3, 6> zwp_linux_buffer_params_v1_flags::interlaced{2};
const bitfield<3, 6> zwp_linux_buffer_params_v1_flags::bottom_first{4};


zwp_linux_dmabuf_feedback_v1_t::zwp_linux_dmabuf_feedback_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_linux_dmabuf_feedback_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_linux_dmabuf_feedback_v1_t::zwp_linux_dmabuf_feedback_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_linux_dmabuf_feedback_v1_t::interface_name = "zwp_linux_dmabuf_feedback_v1";

zwp_linux_dmabuf_feedback_v1_t::operator zwp_linux_dmabuf_feedback_v1*() const
{
  return reinterpret_cast<zwp_linux_dmabuf_feedback_v1*> (c_ptr());
}

std::function<void()> &zwp_linux_dmabuf_feedback_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_linux_dmabuf_feedback_v1_t::done(bool post)
{
  send_event(post, 0);
}

void zwp_linux_dmabuf_feedback_v1_t::format_table(int fd, uint32_t size, bool post)
{
  send_event(post, 1, argument_t::fd(fd), size);
}

void zwp_linux_dmabuf_feedback_v1_t::main_device(array_t const& device, bool post)
{
  send_event(post, 2, device);
}

void zwp_linux_dmabuf_feedback_v1_t::tranche_done(bool post)
{
  send_event(post, 3);
}

void zwp_linux_dmabuf_feedback_v1_t::tranche_target_device(array_t const& device, bool post)
{
  send_event(post, 4, device);
}

void zwp_linux_dmabuf_feedback_v1_t::tranche_formats(array_t const& indices, bool post)
{
  send_event(post, 5, indices);
}

void zwp_linux_dmabuf_feedback_v1_t::tranche_flags(zwp_linux_dmabuf_feedback_v1_tranche_flags const& flags, bool post)
{
  send_event(post, 6, static_cast<uint32_t>(flags));
}

int zwp_linux_dmabuf_feedback_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}
const bitfield<1, 7> zwp_linux_dmabuf_feedback_v1_tranche_flags::scanout{1};


zwp_linux_explicit_synchronization_v1_t::zwp_linux_explicit_synchronization_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_linux_explicit_synchronization_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_linux_explicit_synchronization_v1_t::zwp_linux_explicit_synchronization_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_linux_explicit_synchronization_v1_t::interface_name = "zwp_linux_explicit_synchronization_v1";

zwp_linux_explicit_synchronization_v1_t::operator zwp_linux_explicit_synchronization_v1*() const
{
  return reinterpret_cast<zwp_linux_explicit_synchronization_v1*> (c_ptr());
}

std::function<void()> &zwp_linux_explicit_synchronization_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zwp_linux_surface_synchronization_v1_t, surface_t)> &zwp_linux_explicit_synchronization_v1_t::on_get_synchronization()
{
  return std::static_pointer_cast<events_t>(get_events())->get_synchronization;
}


void zwp_linux_explicit_synchronization_v1_t::post_synchronization_exists(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_linux_explicit_synchronization_v1_error::synchronization_exists), msg);
}

int zwp_linux_explicit_synchronization_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->get_synchronization) events->get_synchronization(zwp_linux_surface_synchronization_v1_t(args[0].get<resource_t>()), surface_t(args[1].get<resource_t>()));
      break;
    }
  return 0;
}


zwp_linux_surface_synchronization_v1_t::zwp_linux_surface_synchronization_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_linux_surface_synchronization_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_linux_surface_synchronization_v1_t::zwp_linux_surface_synchronization_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_linux_surface_synchronization_v1_t::interface_name = "zwp_linux_surface_synchronization_v1";

zwp_linux_surface_synchronization_v1_t::operator zwp_linux_surface_synchronization_v1*() const
{
  return reinterpret_cast<zwp_linux_surface_synchronization_v1*> (c_ptr());
}

std::function<void()> &zwp_linux_surface_synchronization_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(int)> &zwp_linux_surface_synchronization_v1_t::on_set_acquire_fence()
{
  return std::static_pointer_cast<events_t>(get_events())->set_acquire_fence;
}


std::function<void(zwp_linux_buffer_release_v1_t)> &zwp_linux_surface_synchronization_v1_t::on_get_release()
{
  return std::static_pointer_cast<events_t>(get_events())->get_release;
}


void zwp_linux_surface_synchronization_v1_t::post_invalid_fence(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_linux_surface_synchronization_v1_error::invalid_fence), msg);
}

void zwp_linux_surface_synchronization_v1_t::post_duplicate_fence(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_linux_surface_synchronization_v1_error::duplicate_fence), msg);
}

void zwp_linux_surface_synchronization_v1_t::post_duplicate_release(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_linux_surface_synchronization_v1_error::duplicate_release), msg);
}

void zwp_linux_surface_synchronization_v1_t::post_no_surface(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_linux_surface_synchronization_v1_error::no_surface), msg);
}

void zwp_linux_surface_synchronization_v1_t::post_unsupported_buffer(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_linux_surface_synchronization_v1_error::unsupported_buffer), msg);
}

void zwp_linux_surface_synchronization_v1_t::post_no_buffer(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_linux_surface_synchronization_v1_error::no_buffer), msg);
}

int zwp_linux_surface_synchronization_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->set_acquire_fence) events->set_acquire_fence(args[0].get<int>());
      break;
    case 2:
      if(events->get_release) events->get_release(zwp_linux_buffer_release_v1_t(args[0].get<resource_t>()));
      break;
    }
  return 0;
}


zwp_linux_buffer_release_v1_t::zwp_linux_buffer_release_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_linux_buffer_release_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_linux_buffer_release_v1_t::zwp_linux_buffer_release_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_linux_buffer_release_v1_t::interface_name = "zwp_linux_buffer_release_v1";

zwp_linux_buffer_release_v1_t::operator zwp_linux_buffer_release_v1*() const
{
  return reinterpret_cast<zwp_linux_buffer_release_v1*> (c_ptr());
}

void zwp_linux_buffer_release_v1_t::fenced_release(int fence, bool post)
{
  send_event(post, 0, argument_t::fd(fence));
}

void zwp_linux_buffer_release_v1_t::immediate_release(bool post)
{
  send_event(post, 1);
}

int zwp_linux_buffer_release_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  return 0;
}

zwp_pointer_constraints_v1_t::zwp_pointer_constraints_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_pointer_constraints_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_pointer_constraints_v1_t::zwp_pointer_constraints_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_pointer_constraints_v1_t::interface_name = "zwp_pointer_constraints_v1";

zwp_pointer_constraints_v1_t::operator zwp_pointer_constraints_v1*() const
{
  return reinterpret_cast<zwp_pointer_constraints_v1*> (c_ptr());
}

std::function<void()> &zwp_pointer_constraints_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zwp_locked_pointer_v1_t, surface_t, pointer_t, region_t, zwp_pointer_constraints_v1_lifetime)> &zwp_pointer_constraints_v1_t::on_lock_pointer()
{
  return std::static_pointer_cast<events_t>(get_events())->lock_pointer;
}


std::function<void(zwp_confined_pointer_v1_t, surface_t, pointer_t, region_t, zwp_pointer_constraints_v1_lifetime)> &zwp_pointer_constraints_v1_t::on_confine_pointer()
{
  return std::static_pointer_cast<events_t>(get_events())->confine_pointer;
}


void zwp_pointer_constraints_v1_t::post_already_constrained(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_pointer_constraints_v1_error::already_constrained), msg);
}

int zwp_pointer_constraints_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->lock_pointer) events->lock_pointer(zwp_locked_pointer_v1_t(args[0].get<resource_t>()), surface_t(args[1].get<resource_t>()), pointer_t(args[2].get<resource_t>()), region_t(args[3].get<resource_t>()), zwp_pointer_constraints_v1_lifetime(args[4].get<uint32_t>()));
      break;
    case 2:
      if(events->confine_pointer) events->confine_pointer(zwp_confined_pointer_v1_t(args[0].get<resource_t>()), surface_t(args[1].get<resource_t>()), pointer_t(args[2].get<resource_t>()), region_t(args[3].get<resource_t>()), zwp_pointer_constraints_v1_lifetime(args[4].get<uint32_t>()));
      break;
    }
  return 0;
}



zwp_locked_pointer_v1_t::zwp_locked_pointer_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_locked_pointer_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_locked_pointer_v1_t::zwp_locked_pointer_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_locked_pointer_v1_t::interface_name = "zwp_locked_pointer_v1";

zwp_locked_pointer_v1_t::operator zwp_locked_pointer_v1*() const
{
  return reinterpret_cast<zwp_locked_pointer_v1*> (c_ptr());
}

std::function<void()> &zwp_locked_pointer_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(double, double)> &zwp_locked_pointer_v1_t::on_set_cursor_position_hint()
{
  return std::static_pointer_cast<events_t>(get_events())->set_cursor_position_hint;
}


std::function<void(region_t)> &zwp_locked_pointer_v1_t::on_set_region()
{
  return std::static_pointer_cast<events_t>(get_events())->set_region;
}


void zwp_locked_pointer_v1_t::locked(bool post)
{
  send_event(post, 0);
}

void zwp_locked_pointer_v1_t::unlocked(bool post)
{
  send_event(post, 1);
}

int zwp_locked_pointer_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->set_cursor_position_hint) events->set_cursor_position_hint(args[0].get<double>(), args[1].get<double>());
      break;
    case 2:
      if(events->set_region) events->set_region(region_t(args[0].get<resource_t>()));
      break;
    }
  return 0;
}

zwp_confined_pointer_v1_t::zwp_confined_pointer_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_confined_pointer_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_confined_pointer_v1_t::zwp_confined_pointer_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_confined_pointer_v1_t::interface_name = "zwp_confined_pointer_v1";

zwp_confined_pointer_v1_t::operator zwp_confined_pointer_v1*() const
{
  return reinterpret_cast<zwp_confined_pointer_v1*> (c_ptr());
}

std::function<void()> &zwp_confined_pointer_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(region_t)> &zwp_confined_pointer_v1_t::on_set_region()
{
  return std::static_pointer_cast<events_t>(get_events())->set_region;
}


void zwp_confined_pointer_v1_t::confined(bool post)
{
  send_event(post, 0);
}

void zwp_confined_pointer_v1_t::unconfined(bool post)
{
  send_event(post, 1);
}

int zwp_confined_pointer_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->set_region) events->set_region(region_t(args[0].get<resource_t>()));
      break;
    }
  return 0;
}

zwp_pointer_gestures_v1_t::zwp_pointer_gestures_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_pointer_gestures_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_pointer_gestures_v1_t::zwp_pointer_gestures_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_pointer_gestures_v1_t::interface_name = "zwp_pointer_gestures_v1";

zwp_pointer_gestures_v1_t::operator zwp_pointer_gestures_v1*() const
{
  return reinterpret_cast<zwp_pointer_gestures_v1*> (c_ptr());
}

std::function<void(zwp_pointer_gesture_swipe_v1_t, pointer_t)> &zwp_pointer_gestures_v1_t::on_get_swipe_gesture()
{
  return std::static_pointer_cast<events_t>(get_events())->get_swipe_gesture;
}


std::function<void(zwp_pointer_gesture_pinch_v1_t, pointer_t)> &zwp_pointer_gestures_v1_t::on_get_pinch_gesture()
{
  return std::static_pointer_cast<events_t>(get_events())->get_pinch_gesture;
}


std::function<void()> &zwp_pointer_gestures_v1_t::on_release()
{
  return std::static_pointer_cast<events_t>(get_events())->release;
}


std::function<void(zwp_pointer_gesture_hold_v1_t, pointer_t)> &zwp_pointer_gestures_v1_t::on_get_hold_gesture()
{
  return std::static_pointer_cast<events_t>(get_events())->get_hold_gesture;
}


int zwp_pointer_gestures_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->get_swipe_gesture) events->get_swipe_gesture(zwp_pointer_gesture_swipe_v1_t(args[0].get<resource_t>()), pointer_t(args[1].get<resource_t>()));
      break;
    case 1:
      if(events->get_pinch_gesture) events->get_pinch_gesture(zwp_pointer_gesture_pinch_v1_t(args[0].get<resource_t>()), pointer_t(args[1].get<resource_t>()));
      break;
    case 2:
      if(events->release) events->release();
      break;
    case 3:
      if(events->get_hold_gesture) events->get_hold_gesture(zwp_pointer_gesture_hold_v1_t(args[0].get<resource_t>()), pointer_t(args[1].get<resource_t>()));
      break;
    }
  return 0;
}

zwp_pointer_gesture_swipe_v1_t::zwp_pointer_gesture_swipe_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_pointer_gesture_swipe_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_pointer_gesture_swipe_v1_t::zwp_pointer_gesture_swipe_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_pointer_gesture_swipe_v1_t::interface_name = "zwp_pointer_gesture_swipe_v1";

zwp_pointer_gesture_swipe_v1_t::operator zwp_pointer_gesture_swipe_v1*() const
{
  return reinterpret_cast<zwp_pointer_gesture_swipe_v1*> (c_ptr());
}

std::function<void()> &zwp_pointer_gesture_swipe_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_pointer_gesture_swipe_v1_t::begin(uint32_t serial, uint32_t time, surface_t const& surface, uint32_t fingers, bool post)
{
  send_event(post, 0, serial, time, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr, fingers);
}

void zwp_pointer_gesture_swipe_v1_t::update(uint32_t time, double dx, double dy, bool post)
{
  send_event(post, 1, time, dx, dy);
}

void zwp_pointer_gesture_swipe_v1_t::end(uint32_t serial, uint32_t time, int32_t cancelled, bool post)
{
  send_event(post, 2, serial, time, cancelled);
}

int zwp_pointer_gesture_swipe_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zwp_pointer_gesture_pinch_v1_t::zwp_pointer_gesture_pinch_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_pointer_gesture_pinch_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_pointer_gesture_pinch_v1_t::zwp_pointer_gesture_pinch_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_pointer_gesture_pinch_v1_t::interface_name = "zwp_pointer_gesture_pinch_v1";

zwp_pointer_gesture_pinch_v1_t::operator zwp_pointer_gesture_pinch_v1*() const
{
  return reinterpret_cast<zwp_pointer_gesture_pinch_v1*> (c_ptr());
}

std::function<void()> &zwp_pointer_gesture_pinch_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_pointer_gesture_pinch_v1_t::begin(uint32_t serial, uint32_t time, surface_t const& surface, uint32_t fingers, bool post)
{
  send_event(post, 0, serial, time, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr, fingers);
}

void zwp_pointer_gesture_pinch_v1_t::update(uint32_t time, double dx, double dy, double scale, double rotation, bool post)
{
  send_event(post, 1, time, dx, dy, scale, rotation);
}

void zwp_pointer_gesture_pinch_v1_t::end(uint32_t serial, uint32_t time, int32_t cancelled, bool post)
{
  send_event(post, 2, serial, time, cancelled);
}

int zwp_pointer_gesture_pinch_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zwp_pointer_gesture_hold_v1_t::zwp_pointer_gesture_hold_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_pointer_gesture_hold_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_pointer_gesture_hold_v1_t::zwp_pointer_gesture_hold_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_pointer_gesture_hold_v1_t::interface_name = "zwp_pointer_gesture_hold_v1";

zwp_pointer_gesture_hold_v1_t::operator zwp_pointer_gesture_hold_v1*() const
{
  return reinterpret_cast<zwp_pointer_gesture_hold_v1*> (c_ptr());
}

std::function<void()> &zwp_pointer_gesture_hold_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_pointer_gesture_hold_v1_t::begin(uint32_t serial, uint32_t time, surface_t const& surface, uint32_t fingers, bool post)
{
  send_event(post, 0, serial, time, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr, fingers);
}

bool zwp_pointer_gesture_hold_v1_t::can_begin() const
{
  return (get_version() >= begin_since_version);
}

void zwp_pointer_gesture_hold_v1_t::end(uint32_t serial, uint32_t time, int32_t cancelled, bool post)
{
  send_event(post, 1, serial, time, cancelled);
}

bool zwp_pointer_gesture_hold_v1_t::can_end() const
{
  return (get_version() >= end_since_version);
}

int zwp_pointer_gesture_hold_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zwp_primary_selection_device_manager_v1_t::zwp_primary_selection_device_manager_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_primary_selection_device_manager_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_primary_selection_device_manager_v1_t::zwp_primary_selection_device_manager_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_primary_selection_device_manager_v1_t::interface_name = "zwp_primary_selection_device_manager_v1";

zwp_primary_selection_device_manager_v1_t::operator zwp_primary_selection_device_manager_v1*() const
{
  return reinterpret_cast<zwp_primary_selection_device_manager_v1*> (c_ptr());
}

std::function<void(zwp_primary_selection_source_v1_t)> &zwp_primary_selection_device_manager_v1_t::on_create_source()
{
  return std::static_pointer_cast<events_t>(get_events())->create_source;
}


std::function<void(zwp_primary_selection_device_v1_t, seat_t)> &zwp_primary_selection_device_manager_v1_t::on_get_device()
{
  return std::static_pointer_cast<events_t>(get_events())->get_device;
}


std::function<void()> &zwp_primary_selection_device_manager_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


int zwp_primary_selection_device_manager_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->create_source) events->create_source(zwp_primary_selection_source_v1_t(args[0].get<resource_t>()));
      break;
    case 1:
      if(events->get_device) events->get_device(zwp_primary_selection_device_v1_t(args[0].get<resource_t>()), seat_t(args[1].get<resource_t>()));
      break;
    case 2:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zwp_primary_selection_device_v1_t::zwp_primary_selection_device_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_primary_selection_device_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_primary_selection_device_v1_t::zwp_primary_selection_device_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_primary_selection_device_v1_t::interface_name = "zwp_primary_selection_device_v1";

zwp_primary_selection_device_v1_t::operator zwp_primary_selection_device_v1*() const
{
  return reinterpret_cast<zwp_primary_selection_device_v1*> (c_ptr());
}

std::function<void(zwp_primary_selection_source_v1_t, uint32_t)> &zwp_primary_selection_device_v1_t::on_set_selection()
{
  return std::static_pointer_cast<events_t>(get_events())->set_selection;
}


std::function<void()> &zwp_primary_selection_device_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_primary_selection_device_v1_t::data_offer(bool post)
{
  send_event(post, 0, nullptr);
}

void zwp_primary_selection_device_v1_t::selection(zwp_primary_selection_offer_v1_t const& id, bool post)
{
  send_event(post, 1, id.proxy_has_object() ? reinterpret_cast<wl_object*>(id.c_ptr()) : nullptr);
}

int zwp_primary_selection_device_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->set_selection) events->set_selection(zwp_primary_selection_source_v1_t(args[0].get<resource_t>()), args[1].get<uint32_t>());
      break;
    case 1:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zwp_primary_selection_offer_v1_t::zwp_primary_selection_offer_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_primary_selection_offer_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_primary_selection_offer_v1_t::zwp_primary_selection_offer_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_primary_selection_offer_v1_t::interface_name = "zwp_primary_selection_offer_v1";

zwp_primary_selection_offer_v1_t::operator zwp_primary_selection_offer_v1*() const
{
  return reinterpret_cast<zwp_primary_selection_offer_v1*> (c_ptr());
}

std::function<void(std::string, int)> &zwp_primary_selection_offer_v1_t::on_receive()
{
  return std::static_pointer_cast<events_t>(get_events())->receive;
}


std::function<void()> &zwp_primary_selection_offer_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_primary_selection_offer_v1_t::offer(std::string const& mime_type, bool post)
{
  send_event(post, 0, mime_type);
}

int zwp_primary_selection_offer_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->receive) events->receive(args[0].get<std::string>(), args[1].get<int>());
      break;
    case 1:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zwp_primary_selection_source_v1_t::zwp_primary_selection_source_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_primary_selection_source_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_primary_selection_source_v1_t::zwp_primary_selection_source_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_primary_selection_source_v1_t::interface_name = "zwp_primary_selection_source_v1";

zwp_primary_selection_source_v1_t::operator zwp_primary_selection_source_v1*() const
{
  return reinterpret_cast<zwp_primary_selection_source_v1*> (c_ptr());
}

std::function<void(std::string)> &zwp_primary_selection_source_v1_t::on_offer()
{
  return std::static_pointer_cast<events_t>(get_events())->offer;
}


std::function<void()> &zwp_primary_selection_source_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_primary_selection_source_v1_t::send(std::string const& mime_type, int fd, bool post)
{
  send_event(post, 0, mime_type, argument_t::fd(fd));
}

void zwp_primary_selection_source_v1_t::cancelled(bool post)
{
  send_event(post, 1);
}

int zwp_primary_selection_source_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->offer) events->offer(args[0].get<std::string>());
      break;
    case 1:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zwp_relative_pointer_manager_v1_t::zwp_relative_pointer_manager_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_relative_pointer_manager_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_relative_pointer_manager_v1_t::zwp_relative_pointer_manager_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_relative_pointer_manager_v1_t::interface_name = "zwp_relative_pointer_manager_v1";

zwp_relative_pointer_manager_v1_t::operator zwp_relative_pointer_manager_v1*() const
{
  return reinterpret_cast<zwp_relative_pointer_manager_v1*> (c_ptr());
}

std::function<void()> &zwp_relative_pointer_manager_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zwp_relative_pointer_v1_t, pointer_t)> &zwp_relative_pointer_manager_v1_t::on_get_relative_pointer()
{
  return std::static_pointer_cast<events_t>(get_events())->get_relative_pointer;
}


int zwp_relative_pointer_manager_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->get_relative_pointer) events->get_relative_pointer(zwp_relative_pointer_v1_t(args[0].get<resource_t>()), pointer_t(args[1].get<resource_t>()));
      break;
    }
  return 0;
}

zwp_relative_pointer_v1_t::zwp_relative_pointer_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_relative_pointer_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_relative_pointer_v1_t::zwp_relative_pointer_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_relative_pointer_v1_t::interface_name = "zwp_relative_pointer_v1";

zwp_relative_pointer_v1_t::operator zwp_relative_pointer_v1*() const
{
  return reinterpret_cast<zwp_relative_pointer_v1*> (c_ptr());
}

std::function<void()> &zwp_relative_pointer_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_relative_pointer_v1_t::relative_motion(uint32_t utime_hi, uint32_t utime_lo, double dx, double dy, double dx_unaccel, double dy_unaccel, bool post)
{
  send_event(post, 0, utime_hi, utime_lo, dx, dy, dx_unaccel, dy_unaccel);
}

int zwp_relative_pointer_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zwp_tablet_manager_v1_t::zwp_tablet_manager_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_tablet_manager_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_tablet_manager_v1_t::zwp_tablet_manager_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_tablet_manager_v1_t::interface_name = "zwp_tablet_manager_v1";

zwp_tablet_manager_v1_t::operator zwp_tablet_manager_v1*() const
{
  return reinterpret_cast<zwp_tablet_manager_v1*> (c_ptr());
}

std::function<void(zwp_tablet_seat_v1_t, seat_t)> &zwp_tablet_manager_v1_t::on_get_tablet_seat()
{
  return std::static_pointer_cast<events_t>(get_events())->get_tablet_seat;
}


std::function<void()> &zwp_tablet_manager_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


int zwp_tablet_manager_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->get_tablet_seat) events->get_tablet_seat(zwp_tablet_seat_v1_t(args[0].get<resource_t>()), seat_t(args[1].get<resource_t>()));
      break;
    case 1:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zwp_tablet_seat_v1_t::zwp_tablet_seat_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_tablet_seat_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_tablet_seat_v1_t::zwp_tablet_seat_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_tablet_seat_v1_t::interface_name = "zwp_tablet_seat_v1";

zwp_tablet_seat_v1_t::operator zwp_tablet_seat_v1*() const
{
  return reinterpret_cast<zwp_tablet_seat_v1*> (c_ptr());
}

std::function<void()> &zwp_tablet_seat_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_tablet_seat_v1_t::tablet_added(bool post)
{
  send_event(post, 0, nullptr);
}

void zwp_tablet_seat_v1_t::tool_added(bool post)
{
  send_event(post, 1, nullptr);
}

int zwp_tablet_seat_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zwp_tablet_tool_v1_t::zwp_tablet_tool_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_tablet_tool_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_tablet_tool_v1_t::zwp_tablet_tool_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_tablet_tool_v1_t::interface_name = "zwp_tablet_tool_v1";

zwp_tablet_tool_v1_t::operator zwp_tablet_tool_v1*() const
{
  return reinterpret_cast<zwp_tablet_tool_v1*> (c_ptr());
}

std::function<void(uint32_t, surface_t, int32_t, int32_t)> &zwp_tablet_tool_v1_t::on_set_cursor()
{
  return std::static_pointer_cast<events_t>(get_events())->set_cursor;
}


std::function<void()> &zwp_tablet_tool_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_tablet_tool_v1_t::type(zwp_tablet_tool_v1_type const& tool_type, bool post)
{
  send_event(post, 0, static_cast<uint32_t>(tool_type));
}

void zwp_tablet_tool_v1_t::hardware_serial(uint32_t hardware_serial_hi, uint32_t hardware_serial_lo, bool post)
{
  send_event(post, 1, hardware_serial_hi, hardware_serial_lo);
}

void zwp_tablet_tool_v1_t::hardware_id_wacom(uint32_t hardware_id_hi, uint32_t hardware_id_lo, bool post)
{
  send_event(post, 2, hardware_id_hi, hardware_id_lo);
}

void zwp_tablet_tool_v1_t::capability(zwp_tablet_tool_v1_capability const& capability, bool post)
{
  send_event(post, 3, static_cast<uint32_t>(capability));
}

void zwp_tablet_tool_v1_t::done(bool post)
{
  send_event(post, 4);
}

void zwp_tablet_tool_v1_t::removed(bool post)
{
  send_event(post, 5);
}

void zwp_tablet_tool_v1_t::proximity_in(uint32_t serial, zwp_tablet_v1_t const& tablet, surface_t const& surface, bool post)
{
  send_event(post, 6, serial, tablet.proxy_has_object() ? reinterpret_cast<wl_object*>(tablet.c_ptr()) : nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
}

void zwp_tablet_tool_v1_t::proximity_out(bool post)
{
  send_event(post, 7);
}

void zwp_tablet_tool_v1_t::down(uint32_t serial, bool post)
{
  send_event(post, 8, serial);
}

void zwp_tablet_tool_v1_t::up(bool post)
{
  send_event(post, 9);
}

void zwp_tablet_tool_v1_t::motion(double x, double y, bool post)
{
  send_event(post, 10, x, y);
}

void zwp_tablet_tool_v1_t::pressure(uint32_t pressure, bool post)
{
  send_event(post, 11, pressure);
}

void zwp_tablet_tool_v1_t::distance(uint32_t distance, bool post)
{
  send_event(post, 12, distance);
}

void zwp_tablet_tool_v1_t::tilt(int32_t tilt_x, int32_t tilt_y, bool post)
{
  send_event(post, 13, tilt_x, tilt_y);
}

void zwp_tablet_tool_v1_t::rotation(int32_t degrees, bool post)
{
  send_event(post, 14, degrees);
}

void zwp_tablet_tool_v1_t::slider(int32_t position, bool post)
{
  send_event(post, 15, position);
}

void zwp_tablet_tool_v1_t::wheel(int32_t degrees, int32_t clicks, bool post)
{
  send_event(post, 16, degrees, clicks);
}

void zwp_tablet_tool_v1_t::button(uint32_t serial, uint32_t button, zwp_tablet_tool_v1_button_state const& state, bool post)
{
  send_event(post, 17, serial, button, static_cast<uint32_t>(state));
}

void zwp_tablet_tool_v1_t::frame(uint32_t time, bool post)
{
  send_event(post, 18, time);
}

void zwp_tablet_tool_v1_t::post_role(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_tablet_tool_v1_error::role), msg);
}

int zwp_tablet_tool_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->set_cursor) events->set_cursor(args[0].get<uint32_t>(), surface_t(args[1].get<resource_t>()), args[2].get<int32_t>(), args[3].get<int32_t>());
      break;
    case 1:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}





zwp_tablet_v1_t::zwp_tablet_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_tablet_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_tablet_v1_t::zwp_tablet_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_tablet_v1_t::interface_name = "zwp_tablet_v1";

zwp_tablet_v1_t::operator zwp_tablet_v1*() const
{
  return reinterpret_cast<zwp_tablet_v1*> (c_ptr());
}

std::function<void()> &zwp_tablet_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_tablet_v1_t::name(std::string const& name, bool post)
{
  send_event(post, 0, name);
}

void zwp_tablet_v1_t::id(uint32_t vid, uint32_t pid, bool post)
{
  send_event(post, 1, vid, pid);
}

void zwp_tablet_v1_t::path(std::string const& path, bool post)
{
  send_event(post, 2, path);
}

void zwp_tablet_v1_t::done(bool post)
{
  send_event(post, 3);
}

void zwp_tablet_v1_t::removed(bool post)
{
  send_event(post, 4);
}

int zwp_tablet_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zwp_tablet_manager_v2_t::zwp_tablet_manager_v2_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_tablet_manager_v2_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_tablet_manager_v2_t::zwp_tablet_manager_v2_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_tablet_manager_v2_t::interface_name = "zwp_tablet_manager_v2";

zwp_tablet_manager_v2_t::operator zwp_tablet_manager_v2*() const
{
  return reinterpret_cast<zwp_tablet_manager_v2*> (c_ptr());
}

std::function<void(zwp_tablet_seat_v2_t, seat_t)> &zwp_tablet_manager_v2_t::on_get_tablet_seat()
{
  return std::static_pointer_cast<events_t>(get_events())->get_tablet_seat;
}


std::function<void()> &zwp_tablet_manager_v2_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


int zwp_tablet_manager_v2_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->get_tablet_seat) events->get_tablet_seat(zwp_tablet_seat_v2_t(args[0].get<resource_t>()), seat_t(args[1].get<resource_t>()));
      break;
    case 1:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zwp_tablet_seat_v2_t::zwp_tablet_seat_v2_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_tablet_seat_v2_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_tablet_seat_v2_t::zwp_tablet_seat_v2_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_tablet_seat_v2_t::interface_name = "zwp_tablet_seat_v2";

zwp_tablet_seat_v2_t::operator zwp_tablet_seat_v2*() const
{
  return reinterpret_cast<zwp_tablet_seat_v2*> (c_ptr());
}

std::function<void()> &zwp_tablet_seat_v2_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_tablet_seat_v2_t::tablet_added(bool post)
{
  send_event(post, 0, nullptr);
}

void zwp_tablet_seat_v2_t::tool_added(bool post)
{
  send_event(post, 1, nullptr);
}

void zwp_tablet_seat_v2_t::pad_added(bool post)
{
  send_event(post, 2, nullptr);
}

int zwp_tablet_seat_v2_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zwp_tablet_tool_v2_t::zwp_tablet_tool_v2_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_tablet_tool_v2_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_tablet_tool_v2_t::zwp_tablet_tool_v2_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_tablet_tool_v2_t::interface_name = "zwp_tablet_tool_v2";

zwp_tablet_tool_v2_t::operator zwp_tablet_tool_v2*() const
{
  return reinterpret_cast<zwp_tablet_tool_v2*> (c_ptr());
}

std::function<void(uint32_t, surface_t, int32_t, int32_t)> &zwp_tablet_tool_v2_t::on_set_cursor()
{
  return std::static_pointer_cast<events_t>(get_events())->set_cursor;
}


std::function<void()> &zwp_tablet_tool_v2_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_tablet_tool_v2_t::type(zwp_tablet_tool_v2_type const& tool_type, bool post)
{
  send_event(post, 0, static_cast<uint32_t>(tool_type));
}

void zwp_tablet_tool_v2_t::hardware_serial(uint32_t hardware_serial_hi, uint32_t hardware_serial_lo, bool post)
{
  send_event(post, 1, hardware_serial_hi, hardware_serial_lo);
}

void zwp_tablet_tool_v2_t::hardware_id_wacom(uint32_t hardware_id_hi, uint32_t hardware_id_lo, bool post)
{
  send_event(post, 2, hardware_id_hi, hardware_id_lo);
}

void zwp_tablet_tool_v2_t::capability(zwp_tablet_tool_v2_capability const& capability, bool post)
{
  send_event(post, 3, static_cast<uint32_t>(capability));
}

void zwp_tablet_tool_v2_t::done(bool post)
{
  send_event(post, 4);
}

void zwp_tablet_tool_v2_t::removed(bool post)
{
  send_event(post, 5);
}

void zwp_tablet_tool_v2_t::proximity_in(uint32_t serial, zwp_tablet_v2_t const& tablet, surface_t const& surface, bool post)
{
  send_event(post, 6, serial, tablet.proxy_has_object() ? reinterpret_cast<wl_object*>(tablet.c_ptr()) : nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
}

void zwp_tablet_tool_v2_t::proximity_out(bool post)
{
  send_event(post, 7);
}

void zwp_tablet_tool_v2_t::down(uint32_t serial, bool post)
{
  send_event(post, 8, serial);
}

void zwp_tablet_tool_v2_t::up(bool post)
{
  send_event(post, 9);
}

void zwp_tablet_tool_v2_t::motion(double x, double y, bool post)
{
  send_event(post, 10, x, y);
}

void zwp_tablet_tool_v2_t::pressure(uint32_t pressure, bool post)
{
  send_event(post, 11, pressure);
}

void zwp_tablet_tool_v2_t::distance(uint32_t distance, bool post)
{
  send_event(post, 12, distance);
}

void zwp_tablet_tool_v2_t::tilt(double tilt_x, double tilt_y, bool post)
{
  send_event(post, 13, tilt_x, tilt_y);
}

void zwp_tablet_tool_v2_t::rotation(double degrees, bool post)
{
  send_event(post, 14, degrees);
}

void zwp_tablet_tool_v2_t::slider(int32_t position, bool post)
{
  send_event(post, 15, position);
}

void zwp_tablet_tool_v2_t::wheel(double degrees, int32_t clicks, bool post)
{
  send_event(post, 16, degrees, clicks);
}

void zwp_tablet_tool_v2_t::button(uint32_t serial, uint32_t button, zwp_tablet_tool_v2_button_state const& state, bool post)
{
  send_event(post, 17, serial, button, static_cast<uint32_t>(state));
}

void zwp_tablet_tool_v2_t::frame(uint32_t time, bool post)
{
  send_event(post, 18, time);
}

void zwp_tablet_tool_v2_t::post_role(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zwp_tablet_tool_v2_error::role), msg);
}

int zwp_tablet_tool_v2_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->set_cursor) events->set_cursor(args[0].get<uint32_t>(), surface_t(args[1].get<resource_t>()), args[2].get<int32_t>(), args[3].get<int32_t>());
      break;
    case 1:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}





zwp_tablet_v2_t::zwp_tablet_v2_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_tablet_v2_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_tablet_v2_t::zwp_tablet_v2_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_tablet_v2_t::interface_name = "zwp_tablet_v2";

zwp_tablet_v2_t::operator zwp_tablet_v2*() const
{
  return reinterpret_cast<zwp_tablet_v2*> (c_ptr());
}

std::function<void()> &zwp_tablet_v2_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_tablet_v2_t::name(std::string const& name, bool post)
{
  send_event(post, 0, name);
}

void zwp_tablet_v2_t::id(uint32_t vid, uint32_t pid, bool post)
{
  send_event(post, 1, vid, pid);
}

void zwp_tablet_v2_t::path(std::string const& path, bool post)
{
  send_event(post, 2, path);
}

void zwp_tablet_v2_t::done(bool post)
{
  send_event(post, 3);
}

void zwp_tablet_v2_t::removed(bool post)
{
  send_event(post, 4);
}

int zwp_tablet_v2_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zwp_tablet_pad_ring_v2_t::zwp_tablet_pad_ring_v2_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_tablet_pad_ring_v2_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_tablet_pad_ring_v2_t::zwp_tablet_pad_ring_v2_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_tablet_pad_ring_v2_t::interface_name = "zwp_tablet_pad_ring_v2";

zwp_tablet_pad_ring_v2_t::operator zwp_tablet_pad_ring_v2*() const
{
  return reinterpret_cast<zwp_tablet_pad_ring_v2*> (c_ptr());
}

std::function<void(std::string, uint32_t)> &zwp_tablet_pad_ring_v2_t::on_set_feedback()
{
  return std::static_pointer_cast<events_t>(get_events())->set_feedback;
}


std::function<void()> &zwp_tablet_pad_ring_v2_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_tablet_pad_ring_v2_t::source(zwp_tablet_pad_ring_v2_source const& source, bool post)
{
  send_event(post, 0, static_cast<uint32_t>(source));
}

void zwp_tablet_pad_ring_v2_t::angle(double degrees, bool post)
{
  send_event(post, 1, degrees);
}

void zwp_tablet_pad_ring_v2_t::stop(bool post)
{
  send_event(post, 2);
}

void zwp_tablet_pad_ring_v2_t::frame(uint32_t time, bool post)
{
  send_event(post, 3, time);
}

int zwp_tablet_pad_ring_v2_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->set_feedback) events->set_feedback(args[0].get<std::string>(), args[1].get<uint32_t>());
      break;
    case 1:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}


zwp_tablet_pad_strip_v2_t::zwp_tablet_pad_strip_v2_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_tablet_pad_strip_v2_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_tablet_pad_strip_v2_t::zwp_tablet_pad_strip_v2_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_tablet_pad_strip_v2_t::interface_name = "zwp_tablet_pad_strip_v2";

zwp_tablet_pad_strip_v2_t::operator zwp_tablet_pad_strip_v2*() const
{
  return reinterpret_cast<zwp_tablet_pad_strip_v2*> (c_ptr());
}

std::function<void(std::string, uint32_t)> &zwp_tablet_pad_strip_v2_t::on_set_feedback()
{
  return std::static_pointer_cast<events_t>(get_events())->set_feedback;
}


std::function<void()> &zwp_tablet_pad_strip_v2_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_tablet_pad_strip_v2_t::source(zwp_tablet_pad_strip_v2_source const& source, bool post)
{
  send_event(post, 0, static_cast<uint32_t>(source));
}

void zwp_tablet_pad_strip_v2_t::position(uint32_t position, bool post)
{
  send_event(post, 1, position);
}

void zwp_tablet_pad_strip_v2_t::stop(bool post)
{
  send_event(post, 2);
}

void zwp_tablet_pad_strip_v2_t::frame(uint32_t time, bool post)
{
  send_event(post, 3, time);
}

int zwp_tablet_pad_strip_v2_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->set_feedback) events->set_feedback(args[0].get<std::string>(), args[1].get<uint32_t>());
      break;
    case 1:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}


zwp_tablet_pad_group_v2_t::zwp_tablet_pad_group_v2_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_tablet_pad_group_v2_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_tablet_pad_group_v2_t::zwp_tablet_pad_group_v2_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_tablet_pad_group_v2_t::interface_name = "zwp_tablet_pad_group_v2";

zwp_tablet_pad_group_v2_t::operator zwp_tablet_pad_group_v2*() const
{
  return reinterpret_cast<zwp_tablet_pad_group_v2*> (c_ptr());
}

std::function<void()> &zwp_tablet_pad_group_v2_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_tablet_pad_group_v2_t::buttons(array_t const& buttons, bool post)
{
  send_event(post, 0, buttons);
}

void zwp_tablet_pad_group_v2_t::ring(bool post)
{
  send_event(post, 1, nullptr);
}

void zwp_tablet_pad_group_v2_t::strip(bool post)
{
  send_event(post, 2, nullptr);
}

void zwp_tablet_pad_group_v2_t::modes(uint32_t modes, bool post)
{
  send_event(post, 3, modes);
}

void zwp_tablet_pad_group_v2_t::done(bool post)
{
  send_event(post, 4);
}

void zwp_tablet_pad_group_v2_t::mode_switch(uint32_t time, uint32_t serial, uint32_t mode, bool post)
{
  send_event(post, 5, time, serial, mode);
}

int zwp_tablet_pad_group_v2_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zwp_tablet_pad_v2_t::zwp_tablet_pad_v2_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_tablet_pad_v2_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_tablet_pad_v2_t::zwp_tablet_pad_v2_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_tablet_pad_v2_t::interface_name = "zwp_tablet_pad_v2";

zwp_tablet_pad_v2_t::operator zwp_tablet_pad_v2*() const
{
  return reinterpret_cast<zwp_tablet_pad_v2*> (c_ptr());
}

std::function<void(uint32_t, std::string, uint32_t)> &zwp_tablet_pad_v2_t::on_set_feedback()
{
  return std::static_pointer_cast<events_t>(get_events())->set_feedback;
}


std::function<void()> &zwp_tablet_pad_v2_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zwp_tablet_pad_v2_t::group(bool post)
{
  send_event(post, 0, nullptr);
}

void zwp_tablet_pad_v2_t::path(std::string const& path, bool post)
{
  send_event(post, 1, path);
}

void zwp_tablet_pad_v2_t::buttons(uint32_t buttons, bool post)
{
  send_event(post, 2, buttons);
}

void zwp_tablet_pad_v2_t::done(bool post)
{
  send_event(post, 3);
}

void zwp_tablet_pad_v2_t::button(uint32_t time, uint32_t button, zwp_tablet_pad_v2_button_state const& state, bool post)
{
  send_event(post, 4, time, button, static_cast<uint32_t>(state));
}

void zwp_tablet_pad_v2_t::enter(uint32_t serial, zwp_tablet_v2_t const& tablet, surface_t const& surface, bool post)
{
  send_event(post, 5, serial, tablet.proxy_has_object() ? reinterpret_cast<wl_object*>(tablet.c_ptr()) : nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
}

void zwp_tablet_pad_v2_t::leave(uint32_t serial, surface_t const& surface, bool post)
{
  send_event(post, 6, serial, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
}

void zwp_tablet_pad_v2_t::removed(bool post)
{
  send_event(post, 7);
}

int zwp_tablet_pad_v2_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->set_feedback) events->set_feedback(args[0].get<uint32_t>(), args[1].get<std::string>(), args[2].get<uint32_t>());
      break;
    case 1:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}


zwp_text_input_v1_t::zwp_text_input_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_text_input_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_text_input_v1_t::zwp_text_input_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_text_input_v1_t::interface_name = "zwp_text_input_v1";

zwp_text_input_v1_t::operator zwp_text_input_v1*() const
{
  return reinterpret_cast<zwp_text_input_v1*> (c_ptr());
}

std::function<void(seat_t, surface_t)> &zwp_text_input_v1_t::on_activate()
{
  return std::static_pointer_cast<events_t>(get_events())->activate;
}


std::function<void(seat_t)> &zwp_text_input_v1_t::on_deactivate()
{
  return std::static_pointer_cast<events_t>(get_events())->deactivate;
}


std::function<void()> &zwp_text_input_v1_t::on_show_input_panel()
{
  return std::static_pointer_cast<events_t>(get_events())->show_input_panel;
}


std::function<void()> &zwp_text_input_v1_t::on_hide_input_panel()
{
  return std::static_pointer_cast<events_t>(get_events())->hide_input_panel;
}


std::function<void()> &zwp_text_input_v1_t::on_reset()
{
  return std::static_pointer_cast<events_t>(get_events())->reset;
}


std::function<void(std::string, uint32_t, uint32_t)> &zwp_text_input_v1_t::on_set_surrounding_text()
{
  return std::static_pointer_cast<events_t>(get_events())->set_surrounding_text;
}


std::function<void(zwp_text_input_v1_content_hint, zwp_text_input_v1_content_purpose)> &zwp_text_input_v1_t::on_set_content_type()
{
  return std::static_pointer_cast<events_t>(get_events())->set_content_type;
}


std::function<void(int32_t, int32_t, int32_t, int32_t)> &zwp_text_input_v1_t::on_set_cursor_rectangle()
{
  return std::static_pointer_cast<events_t>(get_events())->set_cursor_rectangle;
}


std::function<void(std::string)> &zwp_text_input_v1_t::on_set_preferred_language()
{
  return std::static_pointer_cast<events_t>(get_events())->set_preferred_language;
}


std::function<void(uint32_t)> &zwp_text_input_v1_t::on_commit_state()
{
  return std::static_pointer_cast<events_t>(get_events())->commit_state;
}


std::function<void(uint32_t, uint32_t)> &zwp_text_input_v1_t::on_invoke_action()
{
  return std::static_pointer_cast<events_t>(get_events())->invoke_action;
}


void zwp_text_input_v1_t::enter(surface_t const& surface, bool post)
{
  send_event(post, 0, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
}

void zwp_text_input_v1_t::leave(bool post)
{
  send_event(post, 1);
}

void zwp_text_input_v1_t::modifiers_map(array_t const& map, bool post)
{
  send_event(post, 2, map);
}

void zwp_text_input_v1_t::input_panel_state(uint32_t state, bool post)
{
  send_event(post, 3, state);
}

void zwp_text_input_v1_t::preedit_string(uint32_t serial, std::string const& text, std::string const& commit, bool post)
{
  send_event(post, 4, serial, text, commit);
}

void zwp_text_input_v1_t::preedit_styling(uint32_t index, uint32_t length, zwp_text_input_v1_preedit_style const& style, bool post)
{
  send_event(post, 5, index, length, static_cast<uint32_t>(style));
}

void zwp_text_input_v1_t::preedit_cursor(int32_t index, bool post)
{
  send_event(post, 6, index);
}

void zwp_text_input_v1_t::commit_string(uint32_t serial, std::string const& text, bool post)
{
  send_event(post, 7, serial, text);
}

void zwp_text_input_v1_t::cursor_position(int32_t index, int32_t anchor, bool post)
{
  send_event(post, 8, index, anchor);
}

void zwp_text_input_v1_t::delete_surrounding_text(int32_t index, uint32_t length, bool post)
{
  send_event(post, 9, index, length);
}

void zwp_text_input_v1_t::keysym(uint32_t serial, uint32_t time, uint32_t sym, keyboard_key_state const& state, uint32_t modifiers, bool post)
{
  send_event(post, 10, serial, time, sym, static_cast<uint32_t>(state), modifiers);
}

void zwp_text_input_v1_t::language(uint32_t serial, std::string const& language, bool post)
{
  send_event(post, 11, serial, language);
}

void zwp_text_input_v1_t::text_direction(uint32_t serial, zwp_text_input_v1_text_direction const& direction, bool post)
{
  send_event(post, 12, serial, static_cast<uint32_t>(direction));
}

int zwp_text_input_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->activate) events->activate(seat_t(args[0].get<resource_t>()), surface_t(args[1].get<resource_t>()));
      break;
    case 1:
      if(events->deactivate) events->deactivate(seat_t(args[0].get<resource_t>()));
      break;
    case 2:
      if(events->show_input_panel) events->show_input_panel();
      break;
    case 3:
      if(events->hide_input_panel) events->hide_input_panel();
      break;
    case 4:
      if(events->reset) events->reset();
      break;
    case 5:
      if(events->set_surrounding_text) events->set_surrounding_text(args[0].get<std::string>(), args[1].get<uint32_t>(), args[2].get<uint32_t>());
      break;
    case 6:
      if(events->set_content_type) events->set_content_type(zwp_text_input_v1_content_hint(args[0].get<uint32_t>()), zwp_text_input_v1_content_purpose(args[1].get<uint32_t>()));
      break;
    case 7:
      if(events->set_cursor_rectangle) events->set_cursor_rectangle(args[0].get<int32_t>(), args[1].get<int32_t>(), args[2].get<int32_t>(), args[3].get<int32_t>());
      break;
    case 8:
      if(events->set_preferred_language) events->set_preferred_language(args[0].get<std::string>());
      break;
    case 9:
      if(events->commit_state) events->commit_state(args[0].get<uint32_t>());
      break;
    case 10:
      if(events->invoke_action) events->invoke_action(args[0].get<uint32_t>(), args[1].get<uint32_t>());
      break;
    }
  return 0;
}
const bitfield<10, 23> zwp_text_input_v1_content_hint::none{0x0};
const bitfield<10, 23> zwp_text_input_v1_content_hint::_default{0x7};
const bitfield<10, 23> zwp_text_input_v1_content_hint::password{0xc0};
const bitfield<10, 23> zwp_text_input_v1_content_hint::auto_completion{0x1};
const bitfield<10, 23> zwp_text_input_v1_content_hint::auto_correction{0x2};
const bitfield<10, 23> zwp_text_input_v1_content_hint::auto_capitalization{0x4};
const bitfield<10, 23> zwp_text_input_v1_content_hint::lowercase{0x8};
const bitfield<10, 23> zwp_text_input_v1_content_hint::uppercase{0x10};
const bitfield<10, 23> zwp_text_input_v1_content_hint::titlecase{0x20};
const bitfield<10, 23> zwp_text_input_v1_content_hint::hidden_text{0x40};
const bitfield<10, 23> zwp_text_input_v1_content_hint::sensitive_data{0x80};
const bitfield<10, 23> zwp_text_input_v1_content_hint::latin{0x100};
const bitfield<10, 23> zwp_text_input_v1_content_hint::multiline{0x200};





zwp_text_input_manager_v1_t::zwp_text_input_manager_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_text_input_manager_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_text_input_manager_v1_t::zwp_text_input_manager_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_text_input_manager_v1_t::interface_name = "zwp_text_input_manager_v1";

zwp_text_input_manager_v1_t::operator zwp_text_input_manager_v1*() const
{
  return reinterpret_cast<zwp_text_input_manager_v1*> (c_ptr());
}

std::function<void(zwp_text_input_v1_t)> &zwp_text_input_manager_v1_t::on_create_text_input()
{
  return std::static_pointer_cast<events_t>(get_events())->create_text_input;
}


int zwp_text_input_manager_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->create_text_input) events->create_text_input(zwp_text_input_v1_t(args[0].get<resource_t>()));
      break;
    }
  return 0;
}

zwp_text_input_v3_t::zwp_text_input_v3_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_text_input_v3_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_text_input_v3_t::zwp_text_input_v3_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_text_input_v3_t::interface_name = "zwp_text_input_v3";

zwp_text_input_v3_t::operator zwp_text_input_v3*() const
{
  return reinterpret_cast<zwp_text_input_v3*> (c_ptr());
}

std::function<void()> &zwp_text_input_v3_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void()> &zwp_text_input_v3_t::on_enable()
{
  return std::static_pointer_cast<events_t>(get_events())->enable;
}


std::function<void()> &zwp_text_input_v3_t::on_disable()
{
  return std::static_pointer_cast<events_t>(get_events())->disable;
}


std::function<void(std::string, int32_t, int32_t)> &zwp_text_input_v3_t::on_set_surrounding_text()
{
  return std::static_pointer_cast<events_t>(get_events())->set_surrounding_text;
}


std::function<void(zwp_text_input_v3_change_cause)> &zwp_text_input_v3_t::on_set_text_change_cause()
{
  return std::static_pointer_cast<events_t>(get_events())->set_text_change_cause;
}


std::function<void(zwp_text_input_v3_content_hint, zwp_text_input_v3_content_purpose)> &zwp_text_input_v3_t::on_set_content_type()
{
  return std::static_pointer_cast<events_t>(get_events())->set_content_type;
}


std::function<void(int32_t, int32_t, int32_t, int32_t)> &zwp_text_input_v3_t::on_set_cursor_rectangle()
{
  return std::static_pointer_cast<events_t>(get_events())->set_cursor_rectangle;
}


std::function<void()> &zwp_text_input_v3_t::on_commit()
{
  return std::static_pointer_cast<events_t>(get_events())->commit;
}


void zwp_text_input_v3_t::enter(surface_t const& surface, bool post)
{
  send_event(post, 0, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
}

void zwp_text_input_v3_t::leave(surface_t const& surface, bool post)
{
  send_event(post, 1, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
}

void zwp_text_input_v3_t::preedit_string(std::string const& text, int32_t cursor_begin, int32_t cursor_end, bool post)
{
  send_event(post, 2, text, cursor_begin, cursor_end);
}

void zwp_text_input_v3_t::commit_string(std::string const& text, bool post)
{
  send_event(post, 3, text);
}

void zwp_text_input_v3_t::delete_surrounding_text(uint32_t before_length, uint32_t after_length, bool post)
{
  send_event(post, 4, before_length, after_length);
}

void zwp_text_input_v3_t::done(uint32_t serial, bool post)
{
  send_event(post, 5, serial);
}

int zwp_text_input_v3_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->enable) events->enable();
      break;
    case 2:
      if(events->disable) events->disable();
      break;
    case 3:
      if(events->set_surrounding_text) events->set_surrounding_text(args[0].get<std::string>(), args[1].get<int32_t>(), args[2].get<int32_t>());
      break;
    case 4:
      if(events->set_text_change_cause) events->set_text_change_cause(zwp_text_input_v3_change_cause(args[0].get<uint32_t>()));
      break;
    case 5:
      if(events->set_content_type) events->set_content_type(zwp_text_input_v3_content_hint(args[0].get<uint32_t>()), zwp_text_input_v3_content_purpose(args[1].get<uint32_t>()));
      break;
    case 6:
      if(events->set_cursor_rectangle) events->set_cursor_rectangle(args[0].get<int32_t>(), args[1].get<int32_t>(), args[2].get<int32_t>(), args[3].get<int32_t>());
      break;
    case 7:
      if(events->commit) events->commit();
      break;
    }
  return 0;
}

const bitfield<10, 28> zwp_text_input_v3_content_hint::none{0x0};
const bitfield<10, 28> zwp_text_input_v3_content_hint::completion{0x1};
const bitfield<10, 28> zwp_text_input_v3_content_hint::spellcheck{0x2};
const bitfield<10, 28> zwp_text_input_v3_content_hint::auto_capitalization{0x4};
const bitfield<10, 28> zwp_text_input_v3_content_hint::lowercase{0x8};
const bitfield<10, 28> zwp_text_input_v3_content_hint::uppercase{0x10};
const bitfield<10, 28> zwp_text_input_v3_content_hint::titlecase{0x20};
const bitfield<10, 28> zwp_text_input_v3_content_hint::hidden_text{0x40};
const bitfield<10, 28> zwp_text_input_v3_content_hint::sensitive_data{0x80};
const bitfield<10, 28> zwp_text_input_v3_content_hint::latin{0x100};
const bitfield<10, 28> zwp_text_input_v3_content_hint::multiline{0x200};



zwp_text_input_manager_v3_t::zwp_text_input_manager_v3_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_text_input_manager_v3_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_text_input_manager_v3_t::zwp_text_input_manager_v3_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_text_input_manager_v3_t::interface_name = "zwp_text_input_manager_v3";

zwp_text_input_manager_v3_t::operator zwp_text_input_manager_v3*() const
{
  return reinterpret_cast<zwp_text_input_manager_v3*> (c_ptr());
}

std::function<void()> &zwp_text_input_manager_v3_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zwp_text_input_v3_t, seat_t)> &zwp_text_input_manager_v3_t::on_get_text_input()
{
  return std::static_pointer_cast<events_t>(get_events())->get_text_input;
}


int zwp_text_input_manager_v3_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->get_text_input) events->get_text_input(zwp_text_input_v3_t(args[0].get<resource_t>()), seat_t(args[1].get<resource_t>()));
      break;
    }
  return 0;
}

xdg_activation_v1_t::xdg_activation_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::xdg_activation_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

xdg_activation_v1_t::xdg_activation_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string xdg_activation_v1_t::interface_name = "xdg_activation_v1";

xdg_activation_v1_t::operator xdg_activation_v1*() const
{
  return reinterpret_cast<xdg_activation_v1*> (c_ptr());
}

std::function<void()> &xdg_activation_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(xdg_activation_token_v1_t)> &xdg_activation_v1_t::on_get_activation_token()
{
  return std::static_pointer_cast<events_t>(get_events())->get_activation_token;
}


std::function<void(std::string, surface_t)> &xdg_activation_v1_t::on_activate()
{
  return std::static_pointer_cast<events_t>(get_events())->activate;
}


int xdg_activation_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->get_activation_token) events->get_activation_token(xdg_activation_token_v1_t(args[0].get<resource_t>()));
      break;
    case 2:
      if(events->activate) events->activate(args[0].get<std::string>(), surface_t(args[1].get<resource_t>()));
      break;
    }
  return 0;
}

xdg_activation_token_v1_t::xdg_activation_token_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::xdg_activation_token_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

xdg_activation_token_v1_t::xdg_activation_token_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string xdg_activation_token_v1_t::interface_name = "xdg_activation_token_v1";

xdg_activation_token_v1_t::operator xdg_activation_token_v1*() const
{
  return reinterpret_cast<xdg_activation_token_v1*> (c_ptr());
}

std::function<void(uint32_t, seat_t)> &xdg_activation_token_v1_t::on_set_serial()
{
  return std::static_pointer_cast<events_t>(get_events())->set_serial;
}


std::function<void(std::string)> &xdg_activation_token_v1_t::on_set_app_id()
{
  return std::static_pointer_cast<events_t>(get_events())->set_app_id;
}


std::function<void(surface_t)> &xdg_activation_token_v1_t::on_set_surface()
{
  return std::static_pointer_cast<events_t>(get_events())->set_surface;
}


std::function<void()> &xdg_activation_token_v1_t::on_commit()
{
  return std::static_pointer_cast<events_t>(get_events())->commit;
}


std::function<void()> &xdg_activation_token_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void xdg_activation_token_v1_t::done(std::string const& token, bool post)
{
  send_event(post, 0, token);
}

void xdg_activation_token_v1_t::post_already_used(std::string const& msg)
{
  post_error(static_cast<uint32_t>(xdg_activation_token_v1_error::already_used), msg);
}

int xdg_activation_token_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->set_serial) events->set_serial(args[0].get<uint32_t>(), seat_t(args[1].get<resource_t>()));
      break;
    case 1:
      if(events->set_app_id) events->set_app_id(args[0].get<std::string>());
      break;
    case 2:
      if(events->set_surface) events->set_surface(surface_t(args[0].get<resource_t>()));
      break;
    case 3:
      if(events->commit) events->commit();
      break;
    case 4:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}


zxdg_decoration_manager_v1_t::zxdg_decoration_manager_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zxdg_decoration_manager_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zxdg_decoration_manager_v1_t::zxdg_decoration_manager_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zxdg_decoration_manager_v1_t::interface_name = "zxdg_decoration_manager_v1";

zxdg_decoration_manager_v1_t::operator zxdg_decoration_manager_v1*() const
{
  return reinterpret_cast<zxdg_decoration_manager_v1*> (c_ptr());
}

std::function<void()> &zxdg_decoration_manager_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zxdg_toplevel_decoration_v1_t, xdg_toplevel_t)> &zxdg_decoration_manager_v1_t::on_get_toplevel_decoration()
{
  return std::static_pointer_cast<events_t>(get_events())->get_toplevel_decoration;
}


int zxdg_decoration_manager_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->get_toplevel_decoration) events->get_toplevel_decoration(zxdg_toplevel_decoration_v1_t(args[0].get<resource_t>()), xdg_toplevel_t(args[1].get<resource_t>()));
      break;
    }
  return 0;
}

zxdg_toplevel_decoration_v1_t::zxdg_toplevel_decoration_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zxdg_toplevel_decoration_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zxdg_toplevel_decoration_v1_t::zxdg_toplevel_decoration_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zxdg_toplevel_decoration_v1_t::interface_name = "zxdg_toplevel_decoration_v1";

zxdg_toplevel_decoration_v1_t::operator zxdg_toplevel_decoration_v1*() const
{
  return reinterpret_cast<zxdg_toplevel_decoration_v1*> (c_ptr());
}

std::function<void()> &zxdg_toplevel_decoration_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zxdg_toplevel_decoration_v1_mode)> &zxdg_toplevel_decoration_v1_t::on_set_mode()
{
  return std::static_pointer_cast<events_t>(get_events())->set_mode;
}


std::function<void()> &zxdg_toplevel_decoration_v1_t::on_unset_mode()
{
  return std::static_pointer_cast<events_t>(get_events())->unset_mode;
}


void zxdg_toplevel_decoration_v1_t::configure(zxdg_toplevel_decoration_v1_mode const& mode, bool post)
{
  send_event(post, 0, static_cast<uint32_t>(mode));
}

void zxdg_toplevel_decoration_v1_t::post_unconfigured_buffer(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zxdg_toplevel_decoration_v1_error::unconfigured_buffer), msg);
}

void zxdg_toplevel_decoration_v1_t::post_already_constructed(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zxdg_toplevel_decoration_v1_error::already_constructed), msg);
}

void zxdg_toplevel_decoration_v1_t::post_orphaned(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zxdg_toplevel_decoration_v1_error::orphaned), msg);
}

int zxdg_toplevel_decoration_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->set_mode) events->set_mode(zxdg_toplevel_decoration_v1_mode(args[0].get<uint32_t>()));
      break;
    case 2:
      if(events->unset_mode) events->unset_mode();
      break;
    }
  return 0;
}



zxdg_exporter_v1_t::zxdg_exporter_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zxdg_exporter_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zxdg_exporter_v1_t::zxdg_exporter_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zxdg_exporter_v1_t::interface_name = "zxdg_exporter_v1";

zxdg_exporter_v1_t::operator zxdg_exporter_v1*() const
{
  return reinterpret_cast<zxdg_exporter_v1*> (c_ptr());
}

std::function<void()> &zxdg_exporter_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zxdg_exported_v1_t, surface_t)> &zxdg_exporter_v1_t::on_export()
{
  return std::static_pointer_cast<events_t>(get_events())->_export;
}


int zxdg_exporter_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->_export) events->_export(zxdg_exported_v1_t(args[0].get<resource_t>()), surface_t(args[1].get<resource_t>()));
      break;
    }
  return 0;
}

zxdg_importer_v1_t::zxdg_importer_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zxdg_importer_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zxdg_importer_v1_t::zxdg_importer_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zxdg_importer_v1_t::interface_name = "zxdg_importer_v1";

zxdg_importer_v1_t::operator zxdg_importer_v1*() const
{
  return reinterpret_cast<zxdg_importer_v1*> (c_ptr());
}

std::function<void()> &zxdg_importer_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zxdg_imported_v1_t, std::string)> &zxdg_importer_v1_t::on_import()
{
  return std::static_pointer_cast<events_t>(get_events())->import;
}


int zxdg_importer_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->import) events->import(zxdg_imported_v1_t(args[0].get<resource_t>()), args[1].get<std::string>());
      break;
    }
  return 0;
}

zxdg_exported_v1_t::zxdg_exported_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zxdg_exported_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zxdg_exported_v1_t::zxdg_exported_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zxdg_exported_v1_t::interface_name = "zxdg_exported_v1";

zxdg_exported_v1_t::operator zxdg_exported_v1*() const
{
  return reinterpret_cast<zxdg_exported_v1*> (c_ptr());
}

std::function<void()> &zxdg_exported_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zxdg_exported_v1_t::handle(std::string const& handle, bool post)
{
  send_event(post, 0, handle);
}

int zxdg_exported_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zxdg_imported_v1_t::zxdg_imported_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zxdg_imported_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zxdg_imported_v1_t::zxdg_imported_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zxdg_imported_v1_t::interface_name = "zxdg_imported_v1";

zxdg_imported_v1_t::operator zxdg_imported_v1*() const
{
  return reinterpret_cast<zxdg_imported_v1*> (c_ptr());
}

std::function<void()> &zxdg_imported_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(surface_t)> &zxdg_imported_v1_t::on_set_parent_of()
{
  return std::static_pointer_cast<events_t>(get_events())->set_parent_of;
}


void zxdg_imported_v1_t::destroyed(bool post)
{
  send_event(post, 0);
}

int zxdg_imported_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->set_parent_of) events->set_parent_of(surface_t(args[0].get<resource_t>()));
      break;
    }
  return 0;
}

zxdg_exporter_v2_t::zxdg_exporter_v2_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zxdg_exporter_v2_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zxdg_exporter_v2_t::zxdg_exporter_v2_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zxdg_exporter_v2_t::interface_name = "zxdg_exporter_v2";

zxdg_exporter_v2_t::operator zxdg_exporter_v2*() const
{
  return reinterpret_cast<zxdg_exporter_v2*> (c_ptr());
}

std::function<void()> &zxdg_exporter_v2_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zxdg_exported_v2_t, surface_t)> &zxdg_exporter_v2_t::on_export_toplevel()
{
  return std::static_pointer_cast<events_t>(get_events())->export_toplevel;
}


void zxdg_exporter_v2_t::post_invalid_surface(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zxdg_exporter_v2_error::invalid_surface), msg);
}

int zxdg_exporter_v2_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->export_toplevel) events->export_toplevel(zxdg_exported_v2_t(args[0].get<resource_t>()), surface_t(args[1].get<resource_t>()));
      break;
    }
  return 0;
}


zxdg_importer_v2_t::zxdg_importer_v2_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zxdg_importer_v2_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zxdg_importer_v2_t::zxdg_importer_v2_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zxdg_importer_v2_t::interface_name = "zxdg_importer_v2";

zxdg_importer_v2_t::operator zxdg_importer_v2*() const
{
  return reinterpret_cast<zxdg_importer_v2*> (c_ptr());
}

std::function<void()> &zxdg_importer_v2_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zxdg_imported_v2_t, std::string)> &zxdg_importer_v2_t::on_import_toplevel()
{
  return std::static_pointer_cast<events_t>(get_events())->import_toplevel;
}


int zxdg_importer_v2_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->import_toplevel) events->import_toplevel(zxdg_imported_v2_t(args[0].get<resource_t>()), args[1].get<std::string>());
      break;
    }
  return 0;
}

zxdg_exported_v2_t::zxdg_exported_v2_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zxdg_exported_v2_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zxdg_exported_v2_t::zxdg_exported_v2_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zxdg_exported_v2_t::interface_name = "zxdg_exported_v2";

zxdg_exported_v2_t::operator zxdg_exported_v2*() const
{
  return reinterpret_cast<zxdg_exported_v2*> (c_ptr());
}

std::function<void()> &zxdg_exported_v2_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zxdg_exported_v2_t::handle(std::string const& handle, bool post)
{
  send_event(post, 0, handle);
}

int zxdg_exported_v2_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zxdg_imported_v2_t::zxdg_imported_v2_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zxdg_imported_v2_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zxdg_imported_v2_t::zxdg_imported_v2_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zxdg_imported_v2_t::interface_name = "zxdg_imported_v2";

zxdg_imported_v2_t::operator zxdg_imported_v2*() const
{
  return reinterpret_cast<zxdg_imported_v2*> (c_ptr());
}

std::function<void()> &zxdg_imported_v2_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(surface_t)> &zxdg_imported_v2_t::on_set_parent_of()
{
  return std::static_pointer_cast<events_t>(get_events())->set_parent_of;
}


void zxdg_imported_v2_t::destroyed(bool post)
{
  send_event(post, 0);
}

void zxdg_imported_v2_t::post_invalid_surface(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zxdg_imported_v2_error::invalid_surface), msg);
}

int zxdg_imported_v2_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->set_parent_of) events->set_parent_of(surface_t(args[0].get<resource_t>()));
      break;
    }
  return 0;
}


zxdg_output_manager_v1_t::zxdg_output_manager_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zxdg_output_manager_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zxdg_output_manager_v1_t::zxdg_output_manager_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zxdg_output_manager_v1_t::interface_name = "zxdg_output_manager_v1";

zxdg_output_manager_v1_t::operator zxdg_output_manager_v1*() const
{
  return reinterpret_cast<zxdg_output_manager_v1*> (c_ptr());
}

std::function<void()> &zxdg_output_manager_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zxdg_output_v1_t, output_t)> &zxdg_output_manager_v1_t::on_get_xdg_output()
{
  return std::static_pointer_cast<events_t>(get_events())->get_xdg_output;
}


int zxdg_output_manager_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->get_xdg_output) events->get_xdg_output(zxdg_output_v1_t(args[0].get<resource_t>()), output_t(args[1].get<resource_t>()));
      break;
    }
  return 0;
}

zxdg_output_v1_t::zxdg_output_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zxdg_output_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zxdg_output_v1_t::zxdg_output_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zxdg_output_v1_t::interface_name = "zxdg_output_v1";

zxdg_output_v1_t::operator zxdg_output_v1*() const
{
  return reinterpret_cast<zxdg_output_v1*> (c_ptr());
}

std::function<void()> &zxdg_output_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void zxdg_output_v1_t::logical_position(int32_t x, int32_t y, bool post)
{
  send_event(post, 0, x, y);
}

void zxdg_output_v1_t::logical_size(int32_t width, int32_t height, bool post)
{
  send_event(post, 1, width, height);
}

void zxdg_output_v1_t::done(bool post)
{
  send_event(post, 2);
}

void zxdg_output_v1_t::name(std::string const& name, bool post)
{
  send_event(post, 3, name);
}

bool zxdg_output_v1_t::can_name() const
{
  return (get_version() >= name_since_version);
}

void zxdg_output_v1_t::description(std::string const& description, bool post)
{
  send_event(post, 4, description);
}

bool zxdg_output_v1_t::can_description() const
{
  return (get_version() >= description_since_version);
}

int zxdg_output_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

zxdg_shell_v6_t::zxdg_shell_v6_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zxdg_shell_v6_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zxdg_shell_v6_t::zxdg_shell_v6_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zxdg_shell_v6_t::interface_name = "zxdg_shell_v6";

zxdg_shell_v6_t::operator zxdg_shell_v6*() const
{
  return reinterpret_cast<zxdg_shell_v6*> (c_ptr());
}

std::function<void()> &zxdg_shell_v6_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zxdg_positioner_v6_t)> &zxdg_shell_v6_t::on_create_positioner()
{
  return std::static_pointer_cast<events_t>(get_events())->create_positioner;
}


std::function<void(zxdg_surface_v6_t, surface_t)> &zxdg_shell_v6_t::on_get_xdg_surface()
{
  return std::static_pointer_cast<events_t>(get_events())->get_xdg_surface;
}


std::function<void(uint32_t)> &zxdg_shell_v6_t::on_pong()
{
  return std::static_pointer_cast<events_t>(get_events())->pong;
}


void zxdg_shell_v6_t::ping(uint32_t serial, bool post)
{
  send_event(post, 0, serial);
}

void zxdg_shell_v6_t::post_role(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zxdg_shell_v6_error::role), msg);
}

void zxdg_shell_v6_t::post_defunct_surfaces(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zxdg_shell_v6_error::defunct_surfaces), msg);
}

void zxdg_shell_v6_t::post_not_the_topmost_popup(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zxdg_shell_v6_error::not_the_topmost_popup), msg);
}

void zxdg_shell_v6_t::post_invalid_popup_parent(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zxdg_shell_v6_error::invalid_popup_parent), msg);
}

void zxdg_shell_v6_t::post_invalid_surface_state(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zxdg_shell_v6_error::invalid_surface_state), msg);
}

void zxdg_shell_v6_t::post_invalid_positioner(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zxdg_shell_v6_error::invalid_positioner), msg);
}

int zxdg_shell_v6_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->create_positioner) events->create_positioner(zxdg_positioner_v6_t(args[0].get<resource_t>()));
      break;
    case 2:
      if(events->get_xdg_surface) events->get_xdg_surface(zxdg_surface_v6_t(args[0].get<resource_t>()), surface_t(args[1].get<resource_t>()));
      break;
    case 3:
      if(events->pong) events->pong(args[0].get<uint32_t>());
      break;
    }
  return 0;
}


zxdg_positioner_v6_t::zxdg_positioner_v6_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zxdg_positioner_v6_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zxdg_positioner_v6_t::zxdg_positioner_v6_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zxdg_positioner_v6_t::interface_name = "zxdg_positioner_v6";

zxdg_positioner_v6_t::operator zxdg_positioner_v6*() const
{
  return reinterpret_cast<zxdg_positioner_v6*> (c_ptr());
}

std::function<void()> &zxdg_positioner_v6_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(int32_t, int32_t)> &zxdg_positioner_v6_t::on_set_size()
{
  return std::static_pointer_cast<events_t>(get_events())->set_size;
}


std::function<void(int32_t, int32_t, int32_t, int32_t)> &zxdg_positioner_v6_t::on_set_anchor_rect()
{
  return std::static_pointer_cast<events_t>(get_events())->set_anchor_rect;
}


std::function<void(zxdg_positioner_v6_anchor)> &zxdg_positioner_v6_t::on_set_anchor()
{
  return std::static_pointer_cast<events_t>(get_events())->set_anchor;
}


std::function<void(zxdg_positioner_v6_gravity)> &zxdg_positioner_v6_t::on_set_gravity()
{
  return std::static_pointer_cast<events_t>(get_events())->set_gravity;
}


std::function<void(zxdg_positioner_v6_constraint_adjustment)> &zxdg_positioner_v6_t::on_set_constraint_adjustment()
{
  return std::static_pointer_cast<events_t>(get_events())->set_constraint_adjustment;
}


std::function<void(int32_t, int32_t)> &zxdg_positioner_v6_t::on_set_offset()
{
  return std::static_pointer_cast<events_t>(get_events())->set_offset;
}


void zxdg_positioner_v6_t::post_invalid_input(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zxdg_positioner_v6_error::invalid_input), msg);
}

int zxdg_positioner_v6_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->set_size) events->set_size(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    case 2:
      if(events->set_anchor_rect) events->set_anchor_rect(args[0].get<int32_t>(), args[1].get<int32_t>(), args[2].get<int32_t>(), args[3].get<int32_t>());
      break;
    case 3:
      if(events->set_anchor) events->set_anchor(zxdg_positioner_v6_anchor(args[0].get<uint32_t>()));
      break;
    case 4:
      if(events->set_gravity) events->set_gravity(zxdg_positioner_v6_gravity(args[0].get<uint32_t>()));
      break;
    case 5:
      if(events->set_constraint_adjustment) events->set_constraint_adjustment(zxdg_positioner_v6_constraint_adjustment(args[0].get<uint32_t>()));
      break;
    case 6:
      if(events->set_offset) events->set_offset(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    }
  return 0;
}

const bitfield<4, 37> zxdg_positioner_v6_anchor::none{0};
const bitfield<4, 37> zxdg_positioner_v6_anchor::top{1};
const bitfield<4, 37> zxdg_positioner_v6_anchor::bottom{2};
const bitfield<4, 37> zxdg_positioner_v6_anchor::left{4};
const bitfield<4, 37> zxdg_positioner_v6_anchor::right{8};

const bitfield<4, 38> zxdg_positioner_v6_gravity::none{0};
const bitfield<4, 38> zxdg_positioner_v6_gravity::top{1};
const bitfield<4, 38> zxdg_positioner_v6_gravity::bottom{2};
const bitfield<4, 38> zxdg_positioner_v6_gravity::left{4};
const bitfield<4, 38> zxdg_positioner_v6_gravity::right{8};

const bitfield<6, 39> zxdg_positioner_v6_constraint_adjustment::none{0};
const bitfield<6, 39> zxdg_positioner_v6_constraint_adjustment::slide_x{1};
const bitfield<6, 39> zxdg_positioner_v6_constraint_adjustment::slide_y{2};
const bitfield<6, 39> zxdg_positioner_v6_constraint_adjustment::flip_x{4};
const bitfield<6, 39> zxdg_positioner_v6_constraint_adjustment::flip_y{8};
const bitfield<6, 39> zxdg_positioner_v6_constraint_adjustment::resize_x{16};
const bitfield<6, 39> zxdg_positioner_v6_constraint_adjustment::resize_y{32};


zxdg_surface_v6_t::zxdg_surface_v6_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zxdg_surface_v6_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zxdg_surface_v6_t::zxdg_surface_v6_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zxdg_surface_v6_t::interface_name = "zxdg_surface_v6";

zxdg_surface_v6_t::operator zxdg_surface_v6*() const
{
  return reinterpret_cast<zxdg_surface_v6*> (c_ptr());
}

std::function<void()> &zxdg_surface_v6_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zxdg_toplevel_v6_t)> &zxdg_surface_v6_t::on_get_toplevel()
{
  return std::static_pointer_cast<events_t>(get_events())->get_toplevel;
}


std::function<void(zxdg_popup_v6_t, zxdg_surface_v6_t, zxdg_positioner_v6_t)> &zxdg_surface_v6_t::on_get_popup()
{
  return std::static_pointer_cast<events_t>(get_events())->get_popup;
}


std::function<void(int32_t, int32_t, int32_t, int32_t)> &zxdg_surface_v6_t::on_set_window_geometry()
{
  return std::static_pointer_cast<events_t>(get_events())->set_window_geometry;
}


std::function<void(uint32_t)> &zxdg_surface_v6_t::on_ack_configure()
{
  return std::static_pointer_cast<events_t>(get_events())->ack_configure;
}


void zxdg_surface_v6_t::configure(uint32_t serial, bool post)
{
  send_event(post, 0, serial);
}

void zxdg_surface_v6_t::post_not_constructed(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zxdg_surface_v6_error::not_constructed), msg);
}

void zxdg_surface_v6_t::post_already_constructed(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zxdg_surface_v6_error::already_constructed), msg);
}

void zxdg_surface_v6_t::post_unconfigured_buffer(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zxdg_surface_v6_error::unconfigured_buffer), msg);
}

int zxdg_surface_v6_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->get_toplevel) events->get_toplevel(zxdg_toplevel_v6_t(args[0].get<resource_t>()));
      break;
    case 2:
      if(events->get_popup) events->get_popup(zxdg_popup_v6_t(args[0].get<resource_t>()), zxdg_surface_v6_t(args[1].get<resource_t>()), zxdg_positioner_v6_t(args[2].get<resource_t>()));
      break;
    case 3:
      if(events->set_window_geometry) events->set_window_geometry(args[0].get<int32_t>(), args[1].get<int32_t>(), args[2].get<int32_t>(), args[3].get<int32_t>());
      break;
    case 4:
      if(events->ack_configure) events->ack_configure(args[0].get<uint32_t>());
      break;
    }
  return 0;
}


zxdg_toplevel_v6_t::zxdg_toplevel_v6_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zxdg_toplevel_v6_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zxdg_toplevel_v6_t::zxdg_toplevel_v6_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zxdg_toplevel_v6_t::interface_name = "zxdg_toplevel_v6";

zxdg_toplevel_v6_t::operator zxdg_toplevel_v6*() const
{
  return reinterpret_cast<zxdg_toplevel_v6*> (c_ptr());
}

std::function<void()> &zxdg_toplevel_v6_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zxdg_toplevel_v6_t)> &zxdg_toplevel_v6_t::on_set_parent()
{
  return std::static_pointer_cast<events_t>(get_events())->set_parent;
}


std::function<void(std::string)> &zxdg_toplevel_v6_t::on_set_title()
{
  return std::static_pointer_cast<events_t>(get_events())->set_title;
}


std::function<void(std::string)> &zxdg_toplevel_v6_t::on_set_app_id()
{
  return std::static_pointer_cast<events_t>(get_events())->set_app_id;
}


std::function<void(seat_t, uint32_t, int32_t, int32_t)> &zxdg_toplevel_v6_t::on_show_window_menu()
{
  return std::static_pointer_cast<events_t>(get_events())->show_window_menu;
}


std::function<void(seat_t, uint32_t)> &zxdg_toplevel_v6_t::on_move()
{
  return std::static_pointer_cast<events_t>(get_events())->move;
}


std::function<void(seat_t, uint32_t, zxdg_toplevel_v6_resize_edge)> &zxdg_toplevel_v6_t::on_resize()
{
  return std::static_pointer_cast<events_t>(get_events())->resize;
}


std::function<void(int32_t, int32_t)> &zxdg_toplevel_v6_t::on_set_max_size()
{
  return std::static_pointer_cast<events_t>(get_events())->set_max_size;
}


std::function<void(int32_t, int32_t)> &zxdg_toplevel_v6_t::on_set_min_size()
{
  return std::static_pointer_cast<events_t>(get_events())->set_min_size;
}


std::function<void()> &zxdg_toplevel_v6_t::on_set_maximized()
{
  return std::static_pointer_cast<events_t>(get_events())->set_maximized;
}


std::function<void()> &zxdg_toplevel_v6_t::on_unset_maximized()
{
  return std::static_pointer_cast<events_t>(get_events())->unset_maximized;
}


std::function<void(output_t)> &zxdg_toplevel_v6_t::on_set_fullscreen()
{
  return std::static_pointer_cast<events_t>(get_events())->set_fullscreen;
}


std::function<void()> &zxdg_toplevel_v6_t::on_unset_fullscreen()
{
  return std::static_pointer_cast<events_t>(get_events())->unset_fullscreen;
}


std::function<void()> &zxdg_toplevel_v6_t::on_set_minimized()
{
  return std::static_pointer_cast<events_t>(get_events())->set_minimized;
}


void zxdg_toplevel_v6_t::configure(int32_t width, int32_t height, array_t const& states, bool post)
{
  send_event(post, 0, width, height, states);
}

void zxdg_toplevel_v6_t::close(bool post)
{
  send_event(post, 1);
}

int zxdg_toplevel_v6_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->set_parent) events->set_parent(zxdg_toplevel_v6_t(args[0].get<resource_t>()));
      break;
    case 2:
      if(events->set_title) events->set_title(args[0].get<std::string>());
      break;
    case 3:
      if(events->set_app_id) events->set_app_id(args[0].get<std::string>());
      break;
    case 4:
      if(events->show_window_menu) events->show_window_menu(seat_t(args[0].get<resource_t>()), args[1].get<uint32_t>(), args[2].get<int32_t>(), args[3].get<int32_t>());
      break;
    case 5:
      if(events->move) events->move(seat_t(args[0].get<resource_t>()), args[1].get<uint32_t>());
      break;
    case 6:
      if(events->resize) events->resize(seat_t(args[0].get<resource_t>()), args[1].get<uint32_t>(), zxdg_toplevel_v6_resize_edge(args[2].get<uint32_t>()));
      break;
    case 7:
      if(events->set_max_size) events->set_max_size(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    case 8:
      if(events->set_min_size) events->set_min_size(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    case 9:
      if(events->set_maximized) events->set_maximized();
      break;
    case 10:
      if(events->unset_maximized) events->unset_maximized();
      break;
    case 11:
      if(events->set_fullscreen) events->set_fullscreen(output_t(args[0].get<resource_t>()));
      break;
    case 12:
      if(events->unset_fullscreen) events->unset_fullscreen();
      break;
    case 13:
      if(events->set_minimized) events->set_minimized();
      break;
    }
  return 0;
}
const bitfield<4, 41> zxdg_toplevel_v6_resize_edge::none{0};
const bitfield<4, 41> zxdg_toplevel_v6_resize_edge::top{1};
const bitfield<4, 41> zxdg_toplevel_v6_resize_edge::bottom{2};
const bitfield<4, 41> zxdg_toplevel_v6_resize_edge::left{4};
const bitfield<4, 41> zxdg_toplevel_v6_resize_edge::top_left{5};
const bitfield<4, 41> zxdg_toplevel_v6_resize_edge::bottom_left{6};
const bitfield<4, 41> zxdg_toplevel_v6_resize_edge::right{8};
const bitfield<4, 41> zxdg_toplevel_v6_resize_edge::top_right{9};
const bitfield<4, 41> zxdg_toplevel_v6_resize_edge::bottom_right{10};



zxdg_popup_v6_t::zxdg_popup_v6_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zxdg_popup_v6_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zxdg_popup_v6_t::zxdg_popup_v6_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zxdg_popup_v6_t::interface_name = "zxdg_popup_v6";

zxdg_popup_v6_t::operator zxdg_popup_v6*() const
{
  return reinterpret_cast<zxdg_popup_v6*> (c_ptr());
}

std::function<void()> &zxdg_popup_v6_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(seat_t, uint32_t)> &zxdg_popup_v6_t::on_grab()
{
  return std::static_pointer_cast<events_t>(get_events())->grab;
}


void zxdg_popup_v6_t::configure(int32_t x, int32_t y, int32_t width, int32_t height, bool post)
{
  send_event(post, 0, x, y, width, height);
}

void zxdg_popup_v6_t::popup_done(bool post)
{
  send_event(post, 1);
}

void zxdg_popup_v6_t::post_invalid_grab(std::string const& msg)
{
  post_error(static_cast<uint32_t>(zxdg_popup_v6_error::invalid_grab), msg);
}

int zxdg_popup_v6_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->grab) events->grab(seat_t(args[0].get<resource_t>()), args[1].get<uint32_t>());
      break;
    }
  return 0;
}


zwp_xwayland_keyboard_grab_manager_v1_t::zwp_xwayland_keyboard_grab_manager_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_xwayland_keyboard_grab_manager_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_xwayland_keyboard_grab_manager_v1_t::zwp_xwayland_keyboard_grab_manager_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_xwayland_keyboard_grab_manager_v1_t::interface_name = "zwp_xwayland_keyboard_grab_manager_v1";

zwp_xwayland_keyboard_grab_manager_v1_t::operator zwp_xwayland_keyboard_grab_manager_v1*() const
{
  return reinterpret_cast<zwp_xwayland_keyboard_grab_manager_v1*> (c_ptr());
}

std::function<void()> &zwp_xwayland_keyboard_grab_manager_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(zwp_xwayland_keyboard_grab_v1_t, surface_t, seat_t)> &zwp_xwayland_keyboard_grab_manager_v1_t::on_grab_keyboard()
{
  return std::static_pointer_cast<events_t>(get_events())->grab_keyboard;
}


int zwp_xwayland_keyboard_grab_manager_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->grab_keyboard) events->grab_keyboard(zwp_xwayland_keyboard_grab_v1_t(args[0].get<resource_t>()), surface_t(args[1].get<resource_t>()), seat_t(args[2].get<resource_t>()));
      break;
    }
  return 0;
}

zwp_xwayland_keyboard_grab_v1_t::zwp_xwayland_keyboard_grab_v1_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::zwp_xwayland_keyboard_grab_v1_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

zwp_xwayland_keyboard_grab_v1_t::zwp_xwayland_keyboard_grab_v1_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string zwp_xwayland_keyboard_grab_v1_t::interface_name = "zwp_xwayland_keyboard_grab_v1";

zwp_xwayland_keyboard_grab_v1_t::operator zwp_xwayland_keyboard_grab_v1*() const
{
  return reinterpret_cast<zwp_xwayland_keyboard_grab_v1*> (c_ptr());
}

std::function<void()> &zwp_xwayland_keyboard_grab_v1_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


int zwp_xwayland_keyboard_grab_v1_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}


