// java wrapper for vtkViewport object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkViewport.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkViewport_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkViewport",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkViewport_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkViewport_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkViewport_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkViewport_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_AddViewProp_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddViewProp(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkViewport_GetViewProps_15(JNIEnv* env, jobject obj)
{
  vtkPropCollection * temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewProps();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkViewport_HasViewProp_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  int   temp20;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasViewProp(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_RemoveViewProp_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveViewProp(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_RemoveAllViewProps_18(JNIEnv* env, jobject obj)
{

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllViewProps();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_AddActor2D_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddActor2D(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_RemoveActor2D_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveActor2D(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkViewport_GetActors2D_111(JNIEnv* env, jobject obj)
{
  vtkActor2DCollection * temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActors2D();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetBackground_112(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackground(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetBackground_113(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackground(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkViewport_GetBackground_114(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackground();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetBackground2_115(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackground2(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetBackground2_116(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackground2(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkViewport_GetBackground2_117(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackground2();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetBackgroundAlpha_118(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackgroundAlpha(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkViewport_GetBackgroundAlphaMinValue_119(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackgroundAlphaMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkViewport_GetBackgroundAlphaMaxValue_120(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackgroundAlphaMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkViewport_GetBackgroundAlpha_121(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackgroundAlpha();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetGradientBackground_122(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGradientBackground(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkViewport_GetGradientBackground_123(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGradientBackground();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_GradientBackgroundOn_124(JNIEnv* env, jobject obj)
{

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->GradientBackgroundOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_GradientBackgroundOff_125(JNIEnv* env, jobject obj)
{

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->GradientBackgroundOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetDitherGradient_126(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDitherGradient(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkViewport_GetDitherGradient_127(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDitherGradient();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_DitherGradientOn_128(JNIEnv* env, jobject obj)
{

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->DitherGradientOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_DitherGradientOff_129(JNIEnv* env, jobject obj)
{

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->DitherGradientOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetGradientMode_130(JNIEnv* env, jobject obj,jint id0)
{
  vtkViewport::GradientModes   temp0;
  temp0 = static_cast<vtkViewport::GradientModes>(id0);

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGradientMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkViewport_GetGradientMode_131(JNIEnv* env, jobject obj)
{
  vtkViewport::GradientModes   temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGradientMode();
  return static_cast<jint>(temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetAspect_132(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAspect(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetAspect_133(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAspect(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkViewport_GetAspect_134(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAspect();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_ComputeAspect_135(JNIEnv* env, jobject obj)
{

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeAspect();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetPixelAspect_136(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPixelAspect(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetPixelAspect_137(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPixelAspect(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkViewport_GetPixelAspect_138(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPixelAspect();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetViewport_139(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetViewport(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetViewport_140(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetViewport(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkViewport_GetViewport_141(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewport();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetDisplayPoint_142(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplayPoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetDisplayPoint_143(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplayPoint(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkViewport_GetDisplayPoint_144(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplayPoint();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetViewPoint_145(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetViewPoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetViewPoint_146(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetViewPoint(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkViewport_GetViewPoint_147(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewPoint();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetWorldPoint_148(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWorldPoint(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetWorldPoint_149(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWorldPoint(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkViewport_GetWorldPoint_150(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWorldPoint();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkViewport_GetCenter_151(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCenter();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkViewport_IsInViewport_152(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsInViewport(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkViewport_GetVTKWindow_153(JNIEnv* env, jobject obj)
{
  vtkWindow * temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVTKWindow();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_DisplayToView_154(JNIEnv* env, jobject obj)
{

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisplayToView();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_ViewToDisplay_155(JNIEnv* env, jobject obj)
{

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->ViewToDisplay();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_WorldToView_156(JNIEnv* env, jobject obj)
{

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->WorldToView();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_ViewToWorld_157(JNIEnv* env, jobject obj)
{

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->ViewToWorld();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_DisplayToWorld_158(JNIEnv* env, jobject obj)
{

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisplayToWorld();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_WorldToDisplay_159(JNIEnv* env, jobject obj)
{

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->WorldToDisplay();

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkViewport_GetSize_160(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkViewport_GetOrigin_161(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrigin();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkViewport_PickProp_162(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  vtkAssemblyPath * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PickProp(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkViewport_PickProp_163(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  vtkAssemblyPath * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PickProp(temp0,temp1,temp2,temp3);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkViewport_PickPropFrom_164(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jobject id2)
{
  double   temp0;
  double   temp1;
  vtkPropCollection * temp2;
  vtkAssemblyPath * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id2));

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PickPropFrom(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkViewport_PickPropFrom_165(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jobject id4)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  vtkPropCollection * temp4;
  vtkAssemblyPath * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id4));

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PickPropFrom(temp0,temp1,temp2,temp3,temp4);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkViewport_GetPickX_166(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickX();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkViewport_GetPickY_167(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickY();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkViewport_GetPickWidth_168(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickWidth();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkViewport_GetPickHeight_169(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickHeight();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkViewport_GetPickX1_170(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickX1();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkViewport_GetPickY1_171(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickY1();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkViewport_GetPickX2_172(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickX2();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkViewport_GetPickY2_173(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickY2();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkViewport_GetPickResultProps_174(JNIEnv* env, jobject obj)
{
  vtkPropCollection * temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickResultProps();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkViewport_GetPickedZ_175(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickedZ();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetEnvironmentalBG_176(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnvironmentalBG(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetEnvironmentalBG_177(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnvironmentalBG(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkViewport_GetEnvironmentalBG_178(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnvironmentalBG();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetEnvironmentalBG2_179(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnvironmentalBG2(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetEnvironmentalBG2_180(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnvironmentalBG2(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkViewport_GetEnvironmentalBG2_181(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnvironmentalBG2();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_SetGradientEnvironmentalBG_182(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGradientEnvironmentalBG(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkViewport_GetGradientEnvironmentalBG_183(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGradientEnvironmentalBG();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_GradientEnvironmentalBGOn_184(JNIEnv* env, jobject obj)
{

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->GradientEnvironmentalBGOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkViewport_GradientEnvironmentalBGOff_185(JNIEnv* env, jobject obj)
{

  vtkViewport* op = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, obj));
  op->GradientEnvironmentalBGOff();

}
