// java wrapper for vtkAxisActor object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkAxisActor.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkActor_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkAxisActor_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkAxisActor",dType)) { return me; }
  if ((res= vtkActor_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetPoint1Coordinate_14(JNIEnv* env, jobject obj)
{
  vtkCoordinate * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint1Coordinate();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetPoint1_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint1(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetPoint1_16(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint1(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetPoint2Coordinate_17(JNIEnv* env, jobject obj)
{
  vtkCoordinate * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint2Coordinate();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetPoint2_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint2(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetPoint2_19(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint2(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetRange_110(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetRange_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRange(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAxisActor_GetRange_112(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetBounds_113(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBounds(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetBounds_114(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAxisActor_GetBounds_115(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_GetBounds_116(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetLabelFormat_117(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelFormat(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAxisActor_GetLabelFormat_118(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelFormat();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetUseTextActor3D_119(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseTextActor3D(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor_GetUseTextActor3D_120(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseTextActor3D();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetMinorTicksVisible_121(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinorTicksVisible(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor_GetMinorTicksVisible_122(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinorTicksVisible();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_MinorTicksVisibleOn_123(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->MinorTicksVisibleOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_MinorTicksVisibleOff_124(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->MinorTicksVisibleOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetTitle_125(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitle(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAxisActor_GetTitle_126(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitle();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetExponent_127(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExponent(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAxisActor_GetExponent_128(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExponent();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetMajorTickSize_129(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMajorTickSize(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_GetMajorTickSize_130(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMajorTickSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetMinorTickSize_131(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinorTickSize(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_GetMinorTickSize_132(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinorTickSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetTickLocation_133(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTickLocation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_GetTickLocationMinValue_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickLocationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_GetTickLocationMaxValue_135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickLocationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_GetTickLocation_136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickLocation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetTickLocationToInside_137(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTickLocationToInside();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetTickLocationToOutside_138(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTickLocationToOutside();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetTickLocationToBoth_139(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTickLocationToBoth();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisVisibility_140(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor_GetAxisVisibility_141(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_AxisVisibilityOn_142(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AxisVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_AxisVisibilityOff_143(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AxisVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetTickVisibility_144(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTickVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor_GetTickVisibility_145(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_TickVisibilityOn_146(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->TickVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_TickVisibilityOff_147(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->TickVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetLabelVisibility_148(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor_GetLabelVisibility_149(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_LabelVisibilityOn_150(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->LabelVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_LabelVisibilityOff_151(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->LabelVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetTitleVisibility_152(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor_GetTitleVisibility_153(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_TitleVisibilityOn_154(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->TitleVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_TitleVisibilityOff_155(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->TitleVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetExponentVisibility_156(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExponentVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor_GetExponentVisibility_157(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExponentVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_ExponentVisibilityOn_158(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ExponentVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_ExponentVisibilityOff_159(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ExponentVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetLastMajorTickPointCorrection_160(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLastMajorTickPointCorrection(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor_GetLastMajorTickPointCorrection_161(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastMajorTickPointCorrection();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_LastMajorTickPointCorrectionOn_162(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->LastMajorTickPointCorrectionOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_LastMajorTickPointCorrectionOff_163(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->LastMajorTickPointCorrectionOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetTitleAlignLocation_164(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleAlignLocation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_GetTitleAlignLocation_165(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleAlignLocation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetExponentLocation_166(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExponentLocation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_GetExponentLocation_167(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExponentLocation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetTitleTextProperty_168(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetTitleTextProperty_169(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetLabelTextProperty_170(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetLabelTextProperty_171(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisLinesProperty_172(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisLinesProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetAxisLinesProperty_173(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisLinesProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisMainLineProperty_174(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisMainLineProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetAxisMainLineProperty_175(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisMainLineProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisMajorTicksProperty_176(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisMajorTicksProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetAxisMajorTicksProperty_177(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisMajorTicksProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisMinorTicksProperty_178(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisMinorTicksProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetAxisMinorTicksProperty_179(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisMinorTicksProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetGridlinesProperty_180(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridlinesProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetGridlinesProperty_181(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridlinesProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetInnerGridlinesProperty_182(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInnerGridlinesProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetInnerGridlinesProperty_183(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInnerGridlinesProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetGridpolysProperty_184(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridpolysProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetGridpolysProperty_185(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridpolysProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetDrawGridlines_186(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawGridlines(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor_GetDrawGridlines_187(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawGridlines();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_DrawGridlinesOn_188(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawGridlinesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_DrawGridlinesOff_189(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawGridlinesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetDrawGridlinesOnly_190(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawGridlinesOnly(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor_GetDrawGridlinesOnly_191(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawGridlinesOnly();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_DrawGridlinesOnlyOn_192(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawGridlinesOnlyOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_DrawGridlinesOnlyOff_193(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawGridlinesOnlyOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetDrawGridlinesLocation_194(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawGridlinesLocation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_GetDrawGridlinesLocation_195(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawGridlinesLocation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetDrawInnerGridlines_196(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawInnerGridlines(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor_GetDrawInnerGridlines_197(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawInnerGridlines();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_DrawInnerGridlinesOn_198(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawInnerGridlinesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_DrawInnerGridlinesOff_199(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawInnerGridlinesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetGridlineXLength_1100(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridlineXLength(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_GetGridlineXLength_1101(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridlineXLength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetGridlineYLength_1102(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridlineYLength(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_GetGridlineYLength_1103(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridlineYLength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetGridlineZLength_1104(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridlineZLength(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_GetGridlineZLength_1105(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridlineZLength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetDrawGridpolys_1106(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawGridpolys(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor_GetDrawGridpolys_1107(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawGridpolys();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_DrawGridpolysOn_1108(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawGridpolysOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_DrawGridpolysOff_1109(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawGridpolysOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisType_1110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_GetAxisTypeMinValue_1111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisTypeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_GetAxisTypeMaxValue_1112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisTypeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_GetAxisType_1113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisTypeToX_1114(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisTypeToX();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisTypeToY_1115(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisTypeToY();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisTypeToZ_1116(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisTypeToZ();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetLog_1117(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLog(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor_GetLog_1118(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLog();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_LogOn_1119(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->LogOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_LogOff_1120(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->LogOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisPosition_1121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisPosition(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_GetAxisPositionMinValue_1122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisPositionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_GetAxisPositionMaxValue_1123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisPositionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_GetAxisPosition_1124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisPosition();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisPositionToMinMin_1125(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisPositionToMinMin();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisPositionToMinMax_1126(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisPositionToMinMax();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisPositionToMaxMax_1127(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisPositionToMaxMax();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisPositionToMaxMin_1128(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisPositionToMaxMin();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetCamera_1129(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCamera * temp0;
  temp0 = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCamera(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetCamera_1130(JNIEnv* env, jobject obj)
{
  vtkCamera * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCamera();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_RenderOpaqueGeometry_1131(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_RenderTranslucentGeometry_1132(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_RenderTranslucentPolygonalGeometry_1133(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_RenderOverlay_1134(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOverlay(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_HasTranslucentPolygonalGeometry_1135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_ReleaseGraphicsResources_1136(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_ComputeMaxLabelLength_1137(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeMaxLabelLength(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_ComputeMaxLabelLength_1138(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeMaxLabelLength();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_ComputeTitleLength_1139(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeTitleLength(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_ComputeTitleLength_1140(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeTitleLength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetLabelScale_1141(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelScale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetLabelScale_1142(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelScale(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetTitleScale_1143(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleScale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetExponentScale_1144(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExponentScale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetMinorStart_1145(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinorStart(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_GetMinorStart_1146(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinorStart();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_GetMajorStart_1147(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMajorStart(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetMajorStart_1148(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMajorStart(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetDeltaMinor_1149(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDeltaMinor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_GetDeltaMinor_1150(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDeltaMinor();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_GetDeltaMajor_1151(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDeltaMajor(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetDeltaMajor_1152(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDeltaMajor(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetMinorRangeStart_1153(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinorRangeStart(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_GetMinorRangeStart_1154(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinorRangeStart();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetMajorRangeStart_1155(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMajorRangeStart(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_GetMajorRangeStart_1156(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMajorRangeStart();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetDeltaRangeMinor_1157(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDeltaRangeMinor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_GetDeltaRangeMinor_1158(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDeltaRangeMinor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetDeltaRangeMajor_1159(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDeltaRangeMajor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_GetDeltaRangeMajor_1160(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDeltaRangeMajor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetLabels_1161(JNIEnv* env, jobject obj,jobject id0)
{
  vtkStringArray * temp0;
  temp0 = static_cast<vtkStringArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabels(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_BuildAxis_1162(JNIEnv* env, jobject obj,jobject id0,jboolean id1)
{
  vtkViewport * temp0;
  bool   temp1;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = (id1 != 0) ? true : false;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildAxis(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetTitleActor_1163(JNIEnv* env, jobject obj)
{
  vtkAxisFollower * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleActor();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetExponentActor_1164(JNIEnv* env, jobject obj)
{
  vtkAxisFollower * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExponentActor();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetLabelFollower_1165(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkAxisFollower * temp20;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelFollower(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_GetNumberOfLabelFollowers_1166(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLabelFollowers();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetTitleProp3D_1167(JNIEnv* env, jobject obj)
{
  vtkProp3DAxisFollower * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleProp3D();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetLabelFollower3D_1168(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkProp3DAxisFollower * temp20;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelFollower3D(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_GetNumberOfLabelFollower3D_1169(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLabelFollower3D();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor_GetExponentProp3D_1170(JNIEnv* env, jobject obj)
{
  vtkProp3DAxisFollower * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExponentProp3D();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_GetNumberOfLabelsBuilt_1171(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLabelsBuilt();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetCalculateTitleOffset_1172(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCalculateTitleOffset(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor_GetCalculateTitleOffset_1173(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCalculateTitleOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_CalculateTitleOffsetOn_1174(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->CalculateTitleOffsetOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_CalculateTitleOffsetOff_1175(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->CalculateTitleOffsetOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetCalculateLabelOffset_1176(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCalculateLabelOffset(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor_GetCalculateLabelOffset_1177(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCalculateLabelOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_CalculateLabelOffsetOn_1178(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->CalculateLabelOffsetOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_CalculateLabelOffsetOff_1179(JNIEnv* env, jobject obj)
{

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->CalculateLabelOffsetOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetUse2DMode_1180(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUse2DMode(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor_GetUse2DMode_1181(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUse2DMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetVerticalOffsetXTitle2D_1182(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVerticalOffsetXTitle2D(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_GetVerticalOffsetXTitle2D_1183(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVerticalOffsetXTitle2D();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetHorizontalOffsetYTitle2D_1184(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHorizontalOffsetYTitle2D(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_GetHorizontalOffsetYTitle2D_1185(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHorizontalOffsetYTitle2D();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetSaveTitlePosition_1186(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSaveTitlePosition(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor_GetSaveTitlePosition_1187(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSaveTitlePosition();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisBaseForX_1188(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisBaseForX(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisBaseForX_1189(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisBaseForX(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAxisActor_GetAxisBaseForX_1190(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisBaseForX();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisBaseForY_1191(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisBaseForY(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisBaseForY_1192(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisBaseForY(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAxisActor_GetAxisBaseForY_1193(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisBaseForY();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisBaseForZ_1194(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisBaseForZ(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisBaseForZ_1195(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisBaseForZ(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAxisActor_GetAxisBaseForZ_1196(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisBaseForZ();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetAxisOnOrigin_1197(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisOnOrigin(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor_GetAxisOnOrigin_1198(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisOnOrigin();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetScreenSize_1199(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScreenSize(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_GetScreenSize_1200(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScreenSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetLabelOffset_1201(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelOffset(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_GetLabelOffset_1202(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetExponentOffset_1203(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExponentOffset(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor_GetExponentOffset_1204(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExponentOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetTitleOffset_1205(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleOffset(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor_SetTitleOffset_1206(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleOffset(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAxisActor_GetTitleOffset_1207(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAxisActor* op = static_cast<vtkAxisActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleOffset();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkAxisActor_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkAxisActor::New());
}
