// java wrapper for vtkImageGridSource object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageGridSource.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageGridSource_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageGridSource",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageGridSource_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageGridSource_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageGridSource_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageGridSource_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageGridSource_SetGridSpacing_14(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridSpacing(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageGridSource_SetGridSpacing_15(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridSpacing(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageGridSource_GetGridSpacing_16(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridSpacing();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageGridSource_SetGridOrigin_17(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageGridSource_SetGridOrigin_18(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridOrigin(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageGridSource_GetGridOrigin_19(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridOrigin();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageGridSource_SetLineValue_110(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLineValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageGridSource_GetLineValue_111(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageGridSource_SetFillValue_112(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFillValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageGridSource_GetFillValue_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFillValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageGridSource_SetDataScalarType_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarType(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageGridSource_SetDataScalarTypeToDouble_115(JNIEnv* env, jobject obj)
{

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToDouble();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageGridSource_SetDataScalarTypeToInt_116(JNIEnv* env, jobject obj)
{

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToInt();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageGridSource_SetDataScalarTypeToShort_117(JNIEnv* env, jobject obj)
{

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToShort();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageGridSource_SetDataScalarTypeToUnsignedShort_118(JNIEnv* env, jobject obj)
{

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToUnsignedShort();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageGridSource_SetDataScalarTypeToUnsignedChar_119(JNIEnv* env, jobject obj)
{

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToUnsignedChar();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageGridSource_GetDataScalarType_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataScalarType();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageGridSource_GetDataScalarTypeAsString_121(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataScalarTypeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageGridSource_SetDataExtent_122(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageGridSource_SetDataExtent_123(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataExtent(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageGridSource_GetDataExtent_124(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageGridSource_SetDataSpacing_125(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSpacing(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageGridSource_SetDataSpacing_126(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSpacing(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageGridSource_GetDataSpacing_127(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSpacing();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageGridSource_SetDataOrigin_128(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageGridSource_SetDataOrigin_129(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataOrigin(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageGridSource_GetDataOrigin_130(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageGridSource* op = static_cast<vtkImageGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageGridSource_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageGridSource::New());
}
