// java wrapper for vtkCGNSReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCGNSReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkMultiBlockDataSetAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCGNSReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCGNSReader",dType)) { return me; }
  if ((res= vtkMultiBlockDataSetAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCGNSReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCGNSReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetDataLocation_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataLocation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_GetDataLocationMinValue_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataLocationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_GetDataLocationMaxValue_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataLocationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_GetDataLocation_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataLocation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetFileName_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCGNSReader_GetFileName_19(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_CanReadFile_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCGNSReader_GetBaseSelection_111(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBaseSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCGNSReader_GetFamilySelection_112(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFamilySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCGNSReader_GetCellDataArraySelection_113(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellDataArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCGNSReader_GetFaceDataArraySelection_114(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceDataArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCGNSReader_GetPointDataArraySelection_115(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointDataArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_GetBaseArrayStatus_116(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBaseArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetBaseArrayStatus_117(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBaseArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_DisableAllBases_118(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAllBases();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_EnableAllBases_119(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAllBases();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_GetNumberOfBaseArrays_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfBaseArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCGNSReader_GetBaseArrayName_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBaseArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_GetNumberOfFamilyArrays_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFamilyArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCGNSReader_GetFamilyArrayName_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFamilyArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetFamilyArrayStatus_124(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFamilyArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_GetFamilyArrayStatus_125(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFamilyArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_EnableAllFamilies_126(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAllFamilies();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_DisableAllFamilies_127(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAllFamilies();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_GetNumberOfPointArrays_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCGNSReader_GetPointArrayName_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_GetPointArrayStatus_130(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetPointArrayStatus_131(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_DisableAllPointArrays_132(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAllPointArrays();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_EnableAllPointArrays_133(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAllPointArrays();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_GetNumberOfCellArrays_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCGNSReader_GetCellArrayName_135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_GetCellArrayStatus_136(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetCellArrayStatus_137(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_DisableAllCellArrays_138(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAllCellArrays();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_EnableAllCellArrays_139(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAllCellArrays();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_GetNumberOfFaceArrays_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaceArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCGNSReader_GetFaceArrayName_141(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_GetFaceArrayStatus_142(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetFaceArrayStatus_143(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFaceArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_DisableAllFaceArrays_144(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAllFaceArrays();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_EnableAllFaceArrays_145(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAllFaceArrays();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetDoublePrecisionMesh_146(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDoublePrecisionMesh(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_GetDoublePrecisionMesh_147(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDoublePrecisionMesh();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_DoublePrecisionMeshOn_148(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DoublePrecisionMeshOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_DoublePrecisionMeshOff_149(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DoublePrecisionMeshOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetLoadBndPatch_150(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLoadBndPatch(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCGNSReader_GetLoadBndPatch_151(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLoadBndPatch();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_LoadBndPatchOn_152(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->LoadBndPatchOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_LoadBndPatchOff_153(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->LoadBndPatchOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetLoadSurfacePatch_154(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLoadSurfacePatch(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCGNSReader_GetLoadSurfacePatch_155(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLoadSurfacePatch();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_LoadSurfacePatchOn_156(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->LoadSurfacePatchOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_LoadSurfacePatchOff_157(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->LoadSurfacePatchOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetLoadMesh_158(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLoadMesh(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCGNSReader_GetLoadMesh_159(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLoadMesh();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_LoadMeshOn_160(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->LoadMeshOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_LoadMeshOff_161(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->LoadMeshOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetUse3DVector_162(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUse3DVector(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCGNSReader_GetUse3DVector_163(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUse3DVector();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_Use3DVectorOn_164(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->Use3DVectorOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_Use3DVectorOff_165(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->Use3DVectorOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetCreateEachSolutionAsBlock_166(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCreateEachSolutionAsBlock(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_GetCreateEachSolutionAsBlock_167(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCreateEachSolutionAsBlock();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_CreateEachSolutionAsBlockOn_168(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateEachSolutionAsBlockOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_CreateEachSolutionAsBlockOff_169(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateEachSolutionAsBlockOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetIgnoreFlowSolutionPointers_170(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIgnoreFlowSolutionPointers(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCGNSReader_GetIgnoreFlowSolutionPointers_171(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIgnoreFlowSolutionPointers();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_IgnoreFlowSolutionPointersOn_172(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->IgnoreFlowSolutionPointersOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_IgnoreFlowSolutionPointersOff_173(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->IgnoreFlowSolutionPointersOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetUseUnsteadyPattern_174(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseUnsteadyPattern(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCGNSReader_GetUseUnsteadyPattern_175(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseUnsteadyPattern();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_UseUnsteadyPatternOn_176(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseUnsteadyPatternOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_UseUnsteadyPatternOff_177(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseUnsteadyPatternOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetUnsteadySolutionStartTimestep_178(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUnsteadySolutionStartTimestep(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCGNSReader_GetUnsteadySolutionStartTimestep_179(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUnsteadySolutionStartTimestep();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetDistributeBlocks_180(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDistributeBlocks(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCGNSReader_GetDistributeBlocks_181(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistributeBlocks();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_DistributeBlocksOn_182(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DistributeBlocksOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_DistributeBlocksOff_183(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DistributeBlocksOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetCacheMesh_184(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCacheMesh(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCGNSReader_GetCacheMesh_185(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCacheMesh();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_CacheMeshOn_186(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CacheMeshOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_CacheMeshOff_187(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CacheMeshOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetCacheConnectivity_188(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCacheConnectivity(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCGNSReader_GetCacheConnectivity_189(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCacheConnectivity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_CacheConnectivityOn_190(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CacheConnectivityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_CacheConnectivityOff_191(JNIEnv* env, jobject obj)
{

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CacheConnectivityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_SetController_192(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMultiProcessController * temp0;
  temp0 = static_cast<vtkMultiProcessController*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetController(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCGNSReader_GetController_193(JNIEnv* env, jobject obj)
{
  vtkMultiProcessController * temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetController();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCGNSReader_Broadcast_194(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMultiProcessController * temp0;
  temp0 = static_cast<vtkMultiProcessController*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->Broadcast(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCGNSReader_FAMILY_195(JNIEnv* env, jobject obj)
{
  vtkInformationStringKey * temp20;

  vtkCGNSReader* op = static_cast<vtkCGNSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FAMILY();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCGNSReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCGNSReader::New());
}
