// java wrapper for vtkWarpTransform object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkWarpTransform.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractTransform_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkWarpTransform_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkWarpTransform",dType)) { return me; }
  if ((res= vtkAbstractTransform_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWarpTransform_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWarpTransform* op = static_cast<vtkWarpTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWarpTransform_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWarpTransform* op = static_cast<vtkWarpTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWarpTransform_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWarpTransform* op = static_cast<vtkWarpTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWarpTransform_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWarpTransform* op = static_cast<vtkWarpTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWarpTransform_Inverse_14(JNIEnv* env, jobject obj)
{

  vtkWarpTransform* op = static_cast<vtkWarpTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Inverse();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWarpTransform_GetInverseFlag_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWarpTransform* op = static_cast<vtkWarpTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInverseFlag();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWarpTransform_SetInverseTolerance_16(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkWarpTransform* op = static_cast<vtkWarpTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInverseTolerance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkWarpTransform_GetInverseTolerance_17(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkWarpTransform* op = static_cast<vtkWarpTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInverseTolerance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWarpTransform_SetInverseIterations_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkWarpTransform* op = static_cast<vtkWarpTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInverseIterations(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWarpTransform_GetInverseIterations_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWarpTransform* op = static_cast<vtkWarpTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInverseIterations();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWarpTransform_InternalTransformPoint_110(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkWarpTransform* op = static_cast<vtkWarpTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->InternalTransformPoint(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWarpTransform_InternalTransformPoint_111(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkWarpTransform* op = static_cast<vtkWarpTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->InternalTransformPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWarpTransform_TemplateTransformPoint_112(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkWarpTransform* op = static_cast<vtkWarpTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TemplateTransformPoint(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWarpTransform_TemplateTransformPoint_113(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkWarpTransform* op = static_cast<vtkWarpTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TemplateTransformPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWarpTransform_TemplateTransformInverse_114(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkWarpTransform* op = static_cast<vtkWarpTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TemplateTransformInverse(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWarpTransform_TemplateTransformInverse_115(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkWarpTransform* op = static_cast<vtkWarpTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TemplateTransformInverse(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}
