// java wrapper for vtkInvoker object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkInvoker.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkInvoker_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkInvoker",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInvoker_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkInvoker* op = static_cast<vtkInvoker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInvoker_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkInvoker* op = static_cast<vtkInvoker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInvoker_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkInvoker* op = static_cast<vtkInvoker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInvoker_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkInvoker* op = static_cast<vtkInvoker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInvoker_SetContext_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMarshalContext * temp0;
  temp0 = static_cast<vtkMarshalContext*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInvoker* op = static_cast<vtkInvoker*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetContext(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInvoker_GetContext_15(JNIEnv* env, jobject obj)
{
  vtkMarshalContext * temp20;

  vtkInvoker* op = static_cast<vtkInvoker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContext();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInvoker_SetInvokerLogVerbosity_16(JNIEnv* env, jobject obj,jint id0)
{
  vtkLogger::Verbosity   temp0;
  temp0 = static_cast<vtkLogger::Verbosity>(id0);

  vtkInvoker* op = static_cast<vtkInvoker*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInvokerLogVerbosity(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInvoker_GetInvokerLogVerbosity_17(JNIEnv* env, jobject obj)
{
  vtkLogger::Verbosity   temp20;

  vtkInvoker* op = static_cast<vtkInvoker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInvokerLogVerbosity();
  return static_cast<jint>(temp20);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkInvoker_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkInvoker::New());
}
