// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkStickMapperGS.h"

const char *vtkStickMapperGS =
"//VTK::System::Dec\n"
"\n"
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"// Template for the polydata mappers geometry shader\n"
"\n"
"// primitiveID\n"
"//VTK::PrimID::Dec\n"
"\n"
"// optional color passed in from the vertex shader, vertexColor\n"
"//VTK::Color::Dec\n"
"\n"
"layout(points) in;\n"
"layout(triangle_strip, max_vertices = 6) out;\n"
"\n"
"uniform int cameraParallel;\n"
"\n"
"uniform mat4 VCDCMatrix;\n"
"\n"
"in float radiusVCVSOutput[];\n"
"out float radiusVCGSOutput;\n"
"\n"
"out vec4 vertexVCGSOutput;\n"
"\n"
"in float lengthVCVSOutput[];\n"
"out float lengthVCGSOutput;\n"
"\n"
"out vec3 centerVCGSOutput;\n"
"\n"
"in vec3 orientVCVSOutput[];\n"
"out vec3 orientVCGSOutput;\n"
"\n"
"// clipping plane vars\n"
"//VTK::Clip::Dec\n"
"\n"
"//VTK::Picking::Dec\n"
"\n"
"void main()\n"
"{\n"
"  centerVCGSOutput = gl_in[0].gl_Position.xyz/gl_in[0].gl_Position.w;\n"
"  radiusVCGSOutput = radiusVCVSOutput[0];\n"
"  lengthVCGSOutput = lengthVCVSOutput[0];\n"
"  orientVCGSOutput = orientVCVSOutput[0];\n"
"\n"
"  int i = 0;\n"
"\n"
"  //VTK::PrimID::Impl\n"
"\n"
"  //VTK::Clip::Impl\n"
"\n"
"  //VTK::Color::Impl\n"
"\n"
"  //VTK::Picking::Impl\n"
"\n"
"  // make the basis\n"
"  vec3 xbase;\n"
"  vec3 ybase;\n"
"\n"
"  // dir is the direction to the camera\n"
"  vec3 dir = vec3(0.0,0.0,1.0);\n"
"  if (cameraParallel == 0)\n"
"  {\n"
"    dir = normalize(-centerVCGSOutput);\n"
"  }\n"
"\n"
"  // if dir is aligned with the cylinder orientation\n"
"  if (abs(dot(dir,orientVCGSOutput)) == 1.0)\n"
"  {\n"
"    xbase = normalize(cross(vec3(0.0,1.0,0.0),orientVCGSOutput));\n"
"    ybase = cross(xbase,orientVCGSOutput);\n"
"  }\n"
"  else\n"
"  {\n"
"    xbase = normalize(cross(orientVCGSOutput,dir));\n"
"    ybase = cross(orientVCGSOutput,xbase);\n"
"  }\n"
"  xbase = xbase * radiusVCGSOutput;\n"
"  ybase = ybase * radiusVCGSOutput;\n"
"  vec3 zbase = 0.5*lengthVCGSOutput*orientVCGSOutput;\n"
"\n"
"  vertexVCGSOutput = vec4(0.0, 0.0, 0.0, 1.0);\n"
"  vertexVCGSOutput.xyz = centerVCGSOutput\n"
"    - xbase - ybase - zbase;\n"
"  gl_Position = VCDCMatrix * vertexVCGSOutput;\n"
"  EmitVertex();\n"
"\n"
"  vertexVCGSOutput.xyz = centerVCGSOutput\n"
"    + xbase - ybase - zbase;\n"
"  gl_Position = VCDCMatrix * vertexVCGSOutput;\n"
"  EmitVertex();\n"
"\n"
"  vertexVCGSOutput.xyz = centerVCGSOutput\n"
"    - xbase - ybase + zbase;\n"
"  gl_Position = VCDCMatrix * vertexVCGSOutput;\n"
"  EmitVertex();\n"
"\n"
"  vertexVCGSOutput.xyz = centerVCGSOutput\n"
"    + xbase - ybase + zbase;\n"
"  gl_Position = VCDCMatrix * vertexVCGSOutput;\n"
"  EmitVertex();\n"
"\n"
"  vertexVCGSOutput.xyz = centerVCGSOutput\n"
"    - xbase + ybase + zbase;\n"
"  gl_Position = VCDCMatrix * vertexVCGSOutput;\n"
"  EmitVertex();\n"
"\n"
"  vertexVCGSOutput.xyz = centerVCGSOutput\n"
"    + xbase + ybase + zbase;\n"
"  gl_Position = VCDCMatrix * vertexVCGSOutput;\n"
"  EmitVertex();\n"
"\n"
"  EndPrimitive();\n"
"}\n"
"";
