// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkFluidMapperVS.h"

const char *vtkFluidMapperVS =
"//VTK::System::Dec\n"
"\n"
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"// this shader implements fluid imposters in OpenGL as Spheres\n"
"\n"
"in vec4 vertexMC;\n"
"in vec3 vertexColor;\n"
"\n"
"uniform int   hasVertexColor   = 0;\n"
"\n"
"// optional normal declaration\n"
"//VTK::Normal::Dec\n"
"\n"
"// Texture coordinates\n"
"//VTK::TCoord::Dec\n"
"\n"
"// material property values\n"
"//VTK::Color::Dec\n"
"\n"
"// clipping plane vars\n"
"//VTK::Clip::Dec\n"
"\n"
"// camera and actor matrix values\n"
"uniform mat4 MCVCMatrix;\n"
"\n"
"// picking support\n"
"//VTK::Picking::Dec\n"
"\n"
"// Pass vertex color to fragment shader\n"
"out vec3 colorVSOut;\n"
"\n"
"void main() {\n"
"    //VTK::Color::Impl\n"
"\n"
"    //VTK::Normal::Impl\n"
"\n"
"    //VTK::TCoord::Impl\n"
"\n"
"    //VTK::Clip::Impl\n"
"\n"
"    gl_Position = MCVCMatrix * vertexMC;\n"
"\n"
"    if(hasVertexColor == 1) {\n"
"        colorVSOut = vertexColor;\n"
"    }\n"
"\n"
"    //VTK::Picking::Impl\n"
"}\n"
"";
