// python wrapper for vtkExternalOpenGLRenderWindow
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkExternalOpenGLRenderWindow.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkExternalOpenGLRenderWindow(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkExternalOpenGLRenderWindow_ClassNew(); }


static PyObject *
PyvtkExternalOpenGLRenderWindow_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkExternalOpenGLRenderWindow::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderWindow_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderWindow *op = static_cast<vtkExternalOpenGLRenderWindow *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkExternalOpenGLRenderWindow::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderWindow_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkExternalOpenGLRenderWindow *tempr = vtkExternalOpenGLRenderWindow::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderWindow_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderWindow *op = static_cast<vtkExternalOpenGLRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkExternalOpenGLRenderWindow *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkExternalOpenGLRenderWindow::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderWindow_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkExternalOpenGLRenderWindow::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderWindow_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderWindow *op = static_cast<vtkExternalOpenGLRenderWindow *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkExternalOpenGLRenderWindow::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderWindow_Start(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Start");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderWindow *op = static_cast<vtkExternalOpenGLRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Start();
    }
    else
    {
      op->vtkExternalOpenGLRenderWindow::Start();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderWindow_IsCurrent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsCurrent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderWindow *op = static_cast<vtkExternalOpenGLRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsCurrent() :
      op->vtkExternalOpenGLRenderWindow::IsCurrent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderWindow_GetAutomaticWindowPositionAndResize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAutomaticWindowPositionAndResize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderWindow *op = static_cast<vtkExternalOpenGLRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAutomaticWindowPositionAndResize() :
      op->vtkExternalOpenGLRenderWindow::GetAutomaticWindowPositionAndResize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderWindow_SetAutomaticWindowPositionAndResize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAutomaticWindowPositionAndResize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderWindow *op = static_cast<vtkExternalOpenGLRenderWindow *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAutomaticWindowPositionAndResize(temp0);
    }
    else
    {
      op->vtkExternalOpenGLRenderWindow::SetAutomaticWindowPositionAndResize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderWindow_AutomaticWindowPositionAndResizeOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AutomaticWindowPositionAndResizeOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderWindow *op = static_cast<vtkExternalOpenGLRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AutomaticWindowPositionAndResizeOn();
    }
    else
    {
      op->vtkExternalOpenGLRenderWindow::AutomaticWindowPositionAndResizeOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderWindow_AutomaticWindowPositionAndResizeOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AutomaticWindowPositionAndResizeOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderWindow *op = static_cast<vtkExternalOpenGLRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AutomaticWindowPositionAndResizeOff();
    }
    else
    {
      op->vtkExternalOpenGLRenderWindow::AutomaticWindowPositionAndResizeOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderWindow_GetUseExternalContent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseExternalContent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderWindow *op = static_cast<vtkExternalOpenGLRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseExternalContent() :
      op->vtkExternalOpenGLRenderWindow::GetUseExternalContent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderWindow_SetUseExternalContent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseExternalContent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderWindow *op = static_cast<vtkExternalOpenGLRenderWindow *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseExternalContent(temp0);
    }
    else
    {
      op->vtkExternalOpenGLRenderWindow::SetUseExternalContent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderWindow_UseExternalContentOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseExternalContentOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderWindow *op = static_cast<vtkExternalOpenGLRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseExternalContentOn();
    }
    else
    {
      op->vtkExternalOpenGLRenderWindow::UseExternalContentOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderWindow_UseExternalContentOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseExternalContentOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderWindow *op = static_cast<vtkExternalOpenGLRenderWindow *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseExternalContentOff();
    }
    else
    {
      op->vtkExternalOpenGLRenderWindow::UseExternalContentOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkExternalOpenGLRenderWindow_Methods[] = {
  {"IsTypeOf", PyvtkExternalOpenGLRenderWindow_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkExternalOpenGLRenderWindow_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkExternalOpenGLRenderWindow_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkExternalOpenGLRenderWindow\nC++: static vtkExternalOpenGLRenderWindow *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkExternalOpenGLRenderWindow_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkExternalOpenGLRenderWindow\nC++: vtkExternalOpenGLRenderWindow *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkExternalOpenGLRenderWindow_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkExternalOpenGLRenderWindow_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Start", PyvtkExternalOpenGLRenderWindow_Start, METH_VARARGS,
   "Start(self) -> None\nC++: void Start() override;\n\nBegin the rendering process using the existing context.\n"},
  {"IsCurrent", PyvtkExternalOpenGLRenderWindow_IsCurrent, METH_VARARGS,
   "IsCurrent(self) -> bool\nC++: bool IsCurrent() override;\n\nTells if this window is the current graphics context for the\ncalling thread.\n"},
  {"GetAutomaticWindowPositionAndResize", PyvtkExternalOpenGLRenderWindow_GetAutomaticWindowPositionAndResize, METH_VARARGS,
   "GetAutomaticWindowPositionAndResize(self) -> int\nC++: virtual int GetAutomaticWindowPositionAndResize()\n\nTurn on/off a flag which enables/disables automatic positioning\nand resizing of the render window. By default,\nvtkExternalOpenGLRenderWindow queries the viewport position and\nsize (glViewport) from the OpenGL state and uses it to resize\nitself. However, in special circumstances this feature is\nundesirable. One such circumstance may be to avoid performance\npenalty of querying OpenGL state variables. So the following\nboolean is provided to disable automatic window resize. (Turn\nAutomaticWindowPositionAndResize off if you do not want the\nviewport to be queried from the OpenGL state.)\n"},
  {"SetAutomaticWindowPositionAndResize", PyvtkExternalOpenGLRenderWindow_SetAutomaticWindowPositionAndResize, METH_VARARGS,
   "SetAutomaticWindowPositionAndResize(self, _arg:int) -> None\nC++: virtual void SetAutomaticWindowPositionAndResize(int _arg)\n\n"},
  {"AutomaticWindowPositionAndResizeOn", PyvtkExternalOpenGLRenderWindow_AutomaticWindowPositionAndResizeOn, METH_VARARGS,
   "AutomaticWindowPositionAndResizeOn(self) -> None\nC++: virtual void AutomaticWindowPositionAndResizeOn()\n\n"},
  {"AutomaticWindowPositionAndResizeOff", PyvtkExternalOpenGLRenderWindow_AutomaticWindowPositionAndResizeOff, METH_VARARGS,
   "AutomaticWindowPositionAndResizeOff(self) -> None\nC++: virtual void AutomaticWindowPositionAndResizeOff()\n\n"},
  {"GetUseExternalContent", PyvtkExternalOpenGLRenderWindow_GetUseExternalContent, METH_VARARGS,
   "GetUseExternalContent(self) -> bool\nC++: virtual bool GetUseExternalContent()\n\nTurn on/off a flag which enables/disables using the content from\nan outside application.  When on the active read buffer is first\nblitted into VTK and becomes the starting point for VTK's\nrendering.\n"},
  {"SetUseExternalContent", PyvtkExternalOpenGLRenderWindow_SetUseExternalContent, METH_VARARGS,
   "SetUseExternalContent(self, _arg:bool) -> None\nC++: virtual void SetUseExternalContent(bool _arg)\n\n"},
  {"UseExternalContentOn", PyvtkExternalOpenGLRenderWindow_UseExternalContentOn, METH_VARARGS,
   "UseExternalContentOn(self) -> None\nC++: virtual void UseExternalContentOn()\n\n"},
  {"UseExternalContentOff", PyvtkExternalOpenGLRenderWindow_UseExternalContentOff, METH_VARARGS,
   "UseExternalContentOff(self) -> None\nC++: virtual void UseExternalContentOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkExternalOpenGLRenderWindow_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("automatic_window_position_and_resize"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExternalOpenGLRenderWindow_GetAutomaticWindowPositionAndResize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExternalOpenGLRenderWindow_SetAutomaticWindowPositionAndResize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExternalOpenGLRenderWindow_SetAutomaticWindowPositionAndResize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAutomaticWindowPositionAndResize/SetAutomaticWindowPositionAndResize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_external_content"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExternalOpenGLRenderWindow_GetUseExternalContent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExternalOpenGLRenderWindow_SetUseExternalContent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExternalOpenGLRenderWindow_SetUseExternalContent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseExternalContent/SetUseExternalContent\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkExternalOpenGLRenderWindow_Doc =
  "vtkExternalOpenGLRenderWindow - OpenGL render window that allows\nusing an external window to render vtk objects\n\n"
  "Superclass: vtkGenericOpenGLRenderWindow\n\n"
  "vtkExternalOpenGLRenderWindow is a concrete implementation of the\n"
  "abstract class vtkRenderWindow. vtkExternalOpenGLRenderer interfaces\n"
  "to the OpenGL graphics library.\n\n"
  "This class extends vtkGenericOpenGLRenderWindow to allow sharing the\n"
  "same OpenGL context by various visualization applications. Basically,\n"
  "this class prevents VTK from creating a new OpenGL context. Thus, it\n"
  "requires that an OpenGL context be initialized before Render is\n"
  "called.\n"
  "\\sa Render()\n\n"
  "It is a generic implementation; this window is platform agnostic.\n"
  "However, the application user must explicitly make sure the window\n"
  "size is synchronized when the external application window/viewport\n"
  "resizes.\n"
  "\\sa SetSize()\n\n"
  "It has the same requirements as the vtkGenericOpenGLRenderWindow,\n"
  "whereby, one must register an observer for WindowMakeCurrentEvent,\n"
  "WindowIsCurrentEvent and WindowFrameEvent.\n"
  "\\sa vtkGenericOpenGLRenderWindow\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkExternalOpenGLRenderWindow_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingExternal.vtkExternalOpenGLRenderWindow", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkExternalOpenGLRenderWindow_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkExternalOpenGLRenderWindow_StaticNew()
{
  return vtkExternalOpenGLRenderWindow::New();
}

PyObject *PyvtkExternalOpenGLRenderWindow_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkExternalOpenGLRenderWindow_Type, PyvtkExternalOpenGLRenderWindow_Methods,
    "vtkExternalOpenGLRenderWindow",
 &PyvtkExternalOpenGLRenderWindow_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkGenericOpenGLRenderWindow");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkExternalOpenGLRenderWindow_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkExternalOpenGLRenderWindow(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkExternalOpenGLRenderWindow_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkExternalOpenGLRenderWindow", o) != 0)
  {
    Py_DECREF(o);
  }

}

