//
// Copyright 2025 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/usdImaging/usdSkelImaging/bindingSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(UsdSkelImagingBindingSchemaTokens,
    USD_SKEL_IMAGING_BINDING_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdPathDataSourceHandle
UsdSkelImagingBindingSchema::GetAnimationSource() const
{
    return _GetTypedDataSource<HdPathDataSource>(
        UsdSkelImagingBindingSchemaTokens->animationSource);
}

HdPathDataSourceHandle
UsdSkelImagingBindingSchema::GetSkeleton() const
{
    return _GetTypedDataSource<HdPathDataSource>(
        UsdSkelImagingBindingSchemaTokens->skeleton);
}

HdTokenArrayDataSourceHandle
UsdSkelImagingBindingSchema::GetJoints() const
{
    return _GetTypedDataSource<HdTokenArrayDataSource>(
        UsdSkelImagingBindingSchemaTokens->joints);
}

HdTokenArrayDataSourceHandle
UsdSkelImagingBindingSchema::GetBlendShapes() const
{
    return _GetTypedDataSource<HdTokenArrayDataSource>(
        UsdSkelImagingBindingSchemaTokens->blendShapes);
}

HdPathArrayDataSourceHandle
UsdSkelImagingBindingSchema::GetBlendShapeTargets() const
{
    return _GetTypedDataSource<HdPathArrayDataSource>(
        UsdSkelImagingBindingSchemaTokens->blendShapeTargets);
}

HdBoolDataSourceHandle
UsdSkelImagingBindingSchema::GetHasSkelRoot() const
{
    return _GetTypedDataSource<HdBoolDataSource>(
        UsdSkelImagingBindingSchemaTokens->hasSkelRoot);
}

/*static*/
HdContainerDataSourceHandle
UsdSkelImagingBindingSchema::BuildRetained(
        const HdPathDataSourceHandle &animationSource,
        const HdPathDataSourceHandle &skeleton,
        const HdTokenArrayDataSourceHandle &joints,
        const HdTokenArrayDataSourceHandle &blendShapes,
        const HdPathArrayDataSourceHandle &blendShapeTargets,
        const HdBoolDataSourceHandle &hasSkelRoot
)
{
    TfToken _names[6];
    HdDataSourceBaseHandle _values[6];

    size_t _count = 0;

    if (animationSource) {
        _names[_count] = UsdSkelImagingBindingSchemaTokens->animationSource;
        _values[_count++] = animationSource;
    }

    if (skeleton) {
        _names[_count] = UsdSkelImagingBindingSchemaTokens->skeleton;
        _values[_count++] = skeleton;
    }

    if (joints) {
        _names[_count] = UsdSkelImagingBindingSchemaTokens->joints;
        _values[_count++] = joints;
    }

    if (blendShapes) {
        _names[_count] = UsdSkelImagingBindingSchemaTokens->blendShapes;
        _values[_count++] = blendShapes;
    }

    if (blendShapeTargets) {
        _names[_count] = UsdSkelImagingBindingSchemaTokens->blendShapeTargets;
        _values[_count++] = blendShapeTargets;
    }

    if (hasSkelRoot) {
        _names[_count] = UsdSkelImagingBindingSchemaTokens->hasSkelRoot;
        _values[_count++] = hasSkelRoot;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

UsdSkelImagingBindingSchema::Builder &
UsdSkelImagingBindingSchema::Builder::SetAnimationSource(
    const HdPathDataSourceHandle &animationSource)
{
    _animationSource = animationSource;
    return *this;
}

UsdSkelImagingBindingSchema::Builder &
UsdSkelImagingBindingSchema::Builder::SetSkeleton(
    const HdPathDataSourceHandle &skeleton)
{
    _skeleton = skeleton;
    return *this;
}

UsdSkelImagingBindingSchema::Builder &
UsdSkelImagingBindingSchema::Builder::SetJoints(
    const HdTokenArrayDataSourceHandle &joints)
{
    _joints = joints;
    return *this;
}

UsdSkelImagingBindingSchema::Builder &
UsdSkelImagingBindingSchema::Builder::SetBlendShapes(
    const HdTokenArrayDataSourceHandle &blendShapes)
{
    _blendShapes = blendShapes;
    return *this;
}

UsdSkelImagingBindingSchema::Builder &
UsdSkelImagingBindingSchema::Builder::SetBlendShapeTargets(
    const HdPathArrayDataSourceHandle &blendShapeTargets)
{
    _blendShapeTargets = blendShapeTargets;
    return *this;
}

UsdSkelImagingBindingSchema::Builder &
UsdSkelImagingBindingSchema::Builder::SetHasSkelRoot(
    const HdBoolDataSourceHandle &hasSkelRoot)
{
    _hasSkelRoot = hasSkelRoot;
    return *this;
}

HdContainerDataSourceHandle
UsdSkelImagingBindingSchema::Builder::Build()
{
    return UsdSkelImagingBindingSchema::BuildRetained(
        _animationSource,
        _skeleton,
        _joints,
        _blendShapes,
        _blendShapeTargets,
        _hasSkelRoot
    );
}

/*static*/
UsdSkelImagingBindingSchema
UsdSkelImagingBindingSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return UsdSkelImagingBindingSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                UsdSkelImagingBindingSchemaTokens->skelBinding))
        : nullptr);
}

/*static*/
const TfToken &
UsdSkelImagingBindingSchema::GetSchemaToken()
{
    return UsdSkelImagingBindingSchemaTokens->skelBinding;
}

/*static*/
const HdDataSourceLocator &
UsdSkelImagingBindingSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingBindingSchema::GetAnimationSourceLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingBindingSchemaTokens->animationSource);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingBindingSchema::GetSkeletonLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingBindingSchemaTokens->skeleton);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingBindingSchema::GetJointsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingBindingSchemaTokens->joints);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingBindingSchema::GetBlendShapesLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingBindingSchemaTokens->blendShapes);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingBindingSchema::GetBlendShapeTargetsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingBindingSchemaTokens->blendShapeTargets);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingBindingSchema::GetHasSkelRootLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingBindingSchemaTokens->hasSkelRoot);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE