//
// Copyright 2016 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
#include "pxr/usd/usdVol/tokens.h"

PXR_NAMESPACE_OPEN_SCOPE

UsdVolTokensType::UsdVolTokensType() :
    bool_("bool", TfToken::Immortal),
    Color("Color", TfToken::Immortal),
    double2("double2", TfToken::Immortal),
    double3("double3", TfToken::Immortal),
    double_("double", TfToken::Immortal),
    field("field", TfToken::Immortal),
    fieldClass("fieldClass", TfToken::Immortal),
    fieldDataType("fieldDataType", TfToken::Immortal),
    fieldIndex("fieldIndex", TfToken::Immortal),
    fieldName("fieldName", TfToken::Immortal),
    fieldPurpose("fieldPurpose", TfToken::Immortal),
    filePath("filePath", TfToken::Immortal),
    float2("float2", TfToken::Immortal),
    float3("float3", TfToken::Immortal),
    float_("float", TfToken::Immortal),
    fogVolume("fogVolume", TfToken::Immortal),
    half("half", TfToken::Immortal),
    half2("half2", TfToken::Immortal),
    half3("half3", TfToken::Immortal),
    int2("int2", TfToken::Immortal),
    int3("int3", TfToken::Immortal),
    int64("int64", TfToken::Immortal),
    int_("int", TfToken::Immortal),
    levelSet("levelSet", TfToken::Immortal),
    mask("mask", TfToken::Immortal),
    matrix3d("matrix3d", TfToken::Immortal),
    matrix4d("matrix4d", TfToken::Immortal),
    None_("None", TfToken::Immortal),
    Normal("Normal", TfToken::Immortal),
    Point("Point", TfToken::Immortal),
    quatd("quatd", TfToken::Immortal),
    staggered("staggered", TfToken::Immortal),
    string("string", TfToken::Immortal),
    uint("uint", TfToken::Immortal),
    unknown("unknown", TfToken::Immortal),
    Vector("Vector", TfToken::Immortal),
    vectorDataRoleHint("vectorDataRoleHint", TfToken::Immortal),
    Field3DAsset("Field3DAsset", TfToken::Immortal),
    FieldAsset("FieldAsset", TfToken::Immortal),
    FieldBase("FieldBase", TfToken::Immortal),
    OpenVDBAsset("OpenVDBAsset", TfToken::Immortal),
    Volume("Volume", TfToken::Immortal),
    allTokens({
        bool_,
        Color,
        double2,
        double3,
        double_,
        field,
        fieldClass,
        fieldDataType,
        fieldIndex,
        fieldName,
        fieldPurpose,
        filePath,
        float2,
        float3,
        float_,
        fogVolume,
        half,
        half2,
        half3,
        int2,
        int3,
        int64,
        int_,
        levelSet,
        mask,
        matrix3d,
        matrix4d,
        None_,
        Normal,
        Point,
        quatd,
        staggered,
        string,
        uint,
        unknown,
        Vector,
        vectorDataRoleHint,
        Field3DAsset,
        FieldAsset,
        FieldBase,
        OpenVDBAsset,
        Volume
    })
{
}

TfStaticData<UsdVolTokensType> UsdVolTokens;

PXR_NAMESPACE_CLOSE_SCOPE
