//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/renderCapabilitiesSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdRenderCapabilitiesSchemaTokens,
    HD_RENDER_CAPABILITIES_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdBoolDataSourceHandle
HdRenderCapabilitiesSchema::GetMotionBlur() const
{
    return _GetTypedDataSource<HdBoolDataSource>(
        HdRenderCapabilitiesSchemaTokens->motionBlur);
}

/*static*/
HdContainerDataSourceHandle
HdRenderCapabilitiesSchema::BuildRetained(
        const HdBoolDataSourceHandle &motionBlur
)
{
    TfToken _names[1];
    HdDataSourceBaseHandle _values[1];

    size_t _count = 0;

    if (motionBlur) {
        _names[_count] = HdRenderCapabilitiesSchemaTokens->motionBlur;
        _values[_count++] = motionBlur;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdRenderCapabilitiesSchema::Builder &
HdRenderCapabilitiesSchema::Builder::SetMotionBlur(
    const HdBoolDataSourceHandle &motionBlur)
{
    _motionBlur = motionBlur;
    return *this;
}

HdContainerDataSourceHandle
HdRenderCapabilitiesSchema::Builder::Build()
{
    return HdRenderCapabilitiesSchema::BuildRetained(
        _motionBlur
    );
} 

PXR_NAMESPACE_CLOSE_SCOPE