// Code generated by sdkgen-v2. DO NOT EDIT.
package iamsdk

import (
	"context"

	iam "github.com/yandex-cloud/go-genproto/yandex/cloud/iam/v1"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	sdkop "github.com/yandex-cloud/go-sdk/v2/pkg/operation"
	"github.com/yandex-cloud/go-sdk/v2/pkg/transport"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/reflect/protoreflect"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// OAuthClientSecretClient provides methods for managing OAuthClientSecret resources of Yandex.Cloud IAM.
type OAuthClientSecretClient interface {
	Get(context.Context, *iam.GetOAuthClientSecretRequest, ...grpc.CallOption) (*iam.OAuthClientSecret, error)
	List(context.Context, *iam.ListOAuthClientSecretsRequest, ...grpc.CallOption) (*iam.ListOAuthClientSecretsResponse, error)
	Create(context.Context, *iam.CreateOAuthClientSecretRequest, ...grpc.CallOption) (*OAuthClientSecretCreateOperation, error)
	Delete(context.Context, *iam.DeleteOAuthClientSecretRequest, ...grpc.CallOption) (*OAuthClientSecretDeleteOperation, error)
}

var _ OAuthClientSecretClient = oAuthClientSecretClient{}

type oAuthClientSecretClient struct {
	connector transport.Connector
}

// NewOAuthClientSecretClient returns OAuthClientSecretClient implementation.
func NewOAuthClientSecretClient(connector transport.Connector) OAuthClientSecretClient {
	return oAuthClientSecretClient{connector}
}

// Get is an operation of Yandex.Cloud IAM OAuthClientSecret service.
func (c oAuthClientSecretClient) Get(ctx context.Context, in *iam.GetOAuthClientSecretRequest, opts ...grpc.CallOption) (*iam.OAuthClientSecret, error) {
	connection, err := c.connector.GetConnection(ctx, OAuthClientSecretGet, opts...)
	if err != nil {
		return nil, err
	}
	return iam.NewOAuthClientSecretServiceClient(connection).Get(ctx, in, opts...)
}

// List is an operation of Yandex.Cloud IAM OAuthClientSecret service.
func (c oAuthClientSecretClient) List(ctx context.Context, in *iam.ListOAuthClientSecretsRequest, opts ...grpc.CallOption) (*iam.ListOAuthClientSecretsResponse, error) {
	connection, err := c.connector.GetConnection(ctx, OAuthClientSecretList, opts...)
	if err != nil {
		return nil, err
	}
	return iam.NewOAuthClientSecretServiceClient(connection).List(ctx, in, opts...)
}

// OAuthClientSecretCreateOperation is used to monitor the state of Create operations.
type OAuthClientSecretCreateOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *OAuthClientSecretCreateOperation) Metadata() *iam.CreateOAuthClientSecretMetadata {
	return o.Operation.Metadata().(*iam.CreateOAuthClientSecretMetadata)
}

// Response retrieves the operation response.
func (o *OAuthClientSecretCreateOperation) Response() *iam.CreateOAuthClientSecretResponse {
	return o.Operation.Response().(*iam.CreateOAuthClientSecretResponse)
}

// Wait polls the operation until it's done.
func (o *OAuthClientSecretCreateOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*iam.CreateOAuthClientSecretResponse, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*iam.CreateOAuthClientSecretResponse)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *OAuthClientSecretCreateOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*iam.CreateOAuthClientSecretResponse, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*iam.CreateOAuthClientSecretResponse)
	return response, err
}

// Create is an operation of Yandex.Cloud IAM OAuthClientSecret service.
// It returns an object which should be used to monitor the operation state.
func (c oAuthClientSecretClient) Create(ctx context.Context, in *iam.CreateOAuthClientSecretRequest, opts ...grpc.CallOption) (*OAuthClientSecretCreateOperation, error) {
	connection, err := c.connector.GetConnection(ctx, OAuthClientSecretCreate, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := iam.NewOAuthClientSecretServiceClient(connection).Create(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll:         c.pollOperation,
		MetadataType: (*iam.CreateOAuthClientSecretMetadata)(nil),
		ResponseType: (*iam.CreateOAuthClientSecretResponse)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &OAuthClientSecretCreateOperation{*op}, nil
}

// OAuthClientSecretDeleteOperation is used to monitor the state of Delete operations.
type OAuthClientSecretDeleteOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *OAuthClientSecretDeleteOperation) Metadata() *iam.DeleteOAuthClientSecretMetadata {
	return o.Operation.Metadata().(*iam.DeleteOAuthClientSecretMetadata)
}

// Response retrieves the operation response.
func (o *OAuthClientSecretDeleteOperation) Response() *emptypb.Empty {
	return o.Operation.Response().(*emptypb.Empty)
}

// Wait polls the operation until it's done.
func (o *OAuthClientSecretDeleteOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*emptypb.Empty)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *OAuthClientSecretDeleteOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*emptypb.Empty)
	return response, err
}

// Delete is an operation of Yandex.Cloud IAM OAuthClientSecret service.
// It returns an object which should be used to monitor the operation state.
func (c oAuthClientSecretClient) Delete(ctx context.Context, in *iam.DeleteOAuthClientSecretRequest, opts ...grpc.CallOption) (*OAuthClientSecretDeleteOperation, error) {
	connection, err := c.connector.GetConnection(ctx, OAuthClientSecretDelete, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := iam.NewOAuthClientSecretServiceClient(connection).Delete(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll:         c.pollOperation,
		MetadataType: (*iam.DeleteOAuthClientSecretMetadata)(nil),
		ResponseType: (*emptypb.Empty)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &OAuthClientSecretDeleteOperation{*op}, nil
}

// pollOperation returns the current state of the polled operation.
func (c oAuthClientSecretClient) pollOperation(ctx context.Context, operationId string, opts ...grpc.CallOption) (sdkop.YCOperation, error) {
	connection, err := c.connector.GetConnection(ctx, OAuthClientSecretOperationPoller, opts...)
	if err != nil {
		return nil, err
	}
	return operation.NewOperationServiceClient(connection).Get(ctx, &operation.GetOperationRequest{OperationId: operationId}, opts...)
}

var (
	OAuthClientSecretGet             = protoreflect.FullName("yandex.cloud.iam.v1.OAuthClientSecretService.Get")
	OAuthClientSecretList            = protoreflect.FullName("yandex.cloud.iam.v1.OAuthClientSecretService.List")
	OAuthClientSecretCreate          = protoreflect.FullName("yandex.cloud.iam.v1.OAuthClientSecretService.Create")
	OAuthClientSecretDelete          = protoreflect.FullName("yandex.cloud.iam.v1.OAuthClientSecretService.Delete")
	OAuthClientSecretOperationPoller = protoreflect.FullName("yandex.cloud.operation.OperationService.Get")
)
