#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void ttkCinemaDarkroomCamera_Init(vtkClientServerInterpreter*); }
extern "C" { void ttkCinemaDarkroomShader_Init(vtkClientServerInterpreter*); }
extern "C" { void ttkCinemaDarkroomIBS_Init(vtkClientServerInterpreter*); }
extern "C" { void ttkCinemaDarkroomFXAA_Init(vtkClientServerInterpreter*); }
extern "C" { void ttkCinemaDarkroomSSAO_Init(vtkClientServerInterpreter*); }
extern "C" { void ttkCinemaDarkroomSSSAO_Init(vtkClientServerInterpreter*); }
extern "C" { void ttkCinemaDarkroomSSDoF_Init(vtkClientServerInterpreter*); }
extern "C" { void ttkCinemaDarkroomCompositing_Init(vtkClientServerInterpreter*); }
extern "C" { void ttkCinemaDarkroomColorMapping_Init(vtkClientServerInterpreter*); }
extern "C" { void ttkCinemaDarkroomNoise_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void ttkCinemaDarkroomCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  ttkCinemaDarkroomCamera_Init(csi);
  ttkCinemaDarkroomShader_Init(csi);
  ttkCinemaDarkroomIBS_Init(csi);
  ttkCinemaDarkroomFXAA_Init(csi);
  ttkCinemaDarkroomSSAO_Init(csi);
  ttkCinemaDarkroomSSSAO_Init(csi);
  ttkCinemaDarkroomSSDoF_Init(csi);
  ttkCinemaDarkroomCompositing_Init(csi);
  ttkCinemaDarkroomColorMapping_Init(csi);
  ttkCinemaDarkroomNoise_Init(csi);
}
