/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the RISCV target                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 92;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(RISCVInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(RISCVInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static RISCVInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static RISCVInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(1),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_p0s32,
  GILLT_p0s64,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_nxv1s1,
  GILLT_nxv1s8,
  GILLT_nxv1s16,
  GILLT_nxv1s32,
  GILLT_nxv1s64,
  GILLT_nxv2s1,
  GILLT_nxv2s8,
  GILLT_nxv2s16,
  GILLT_nxv2s32,
  GILLT_nxv2s64,
  GILLT_nxv4s1,
  GILLT_nxv4s8,
  GILLT_nxv4s16,
  GILLT_nxv4s32,
  GILLT_nxv4s64,
  GILLT_nxv8s1,
  GILLT_nxv8s8,
  GILLT_nxv8s16,
  GILLT_nxv8s32,
  GILLT_nxv8s64,
  GILLT_nxv16s1,
  GILLT_nxv16s8,
  GILLT_nxv16s16,
  GILLT_nxv16s32,
  GILLT_nxv32s1,
  GILLT_nxv32s8,
  GILLT_nxv32s16,
  GILLT_nxv64s1,
  GILLT_nxv64s8,
};
const static size_t NumTypeObjects = 34;
const static LLT TypeObjects[] = {
  LLT::pointer(0, 32),
  LLT::pointer(0, 64),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getScalable(1), 1),
  LLT::vector(ElementCount::getScalable(1), 8),
  LLT::vector(ElementCount::getScalable(1), 16),
  LLT::vector(ElementCount::getScalable(1), 32),
  LLT::vector(ElementCount::getScalable(1), 64),
  LLT::vector(ElementCount::getScalable(2), 1),
  LLT::vector(ElementCount::getScalable(2), 8),
  LLT::vector(ElementCount::getScalable(2), 16),
  LLT::vector(ElementCount::getScalable(2), 32),
  LLT::vector(ElementCount::getScalable(2), 64),
  LLT::vector(ElementCount::getScalable(4), 1),
  LLT::vector(ElementCount::getScalable(4), 8),
  LLT::vector(ElementCount::getScalable(4), 16),
  LLT::vector(ElementCount::getScalable(4), 32),
  LLT::vector(ElementCount::getScalable(4), 64),
  LLT::vector(ElementCount::getScalable(8), 1),
  LLT::vector(ElementCount::getScalable(8), 8),
  LLT::vector(ElementCount::getScalable(8), 16),
  LLT::vector(ElementCount::getScalable(8), 32),
  LLT::vector(ElementCount::getScalable(8), 64),
  LLT::vector(ElementCount::getScalable(16), 1),
  LLT::vector(ElementCount::getScalable(16), 8),
  LLT::vector(ElementCount::getScalable(16), 16),
  LLT::vector(ElementCount::getScalable(16), 32),
  LLT::vector(ElementCount::getScalable(32), 1),
  LLT::vector(ElementCount::getScalable(32), 8),
  LLT::vector(ElementCount::getScalable(32), 16),
  LLT::vector(ElementCount::getScalable(64), 1),
  LLT::vector(ElementCount::getScalable(64), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasStdExtZicbopBit = 68,
  Feature_HasStdExtZicondBit = 69,
  Feature_HasStdExtZimopBit = 67,
  Feature_HasStdExtZicfilpBit = 2,
  Feature_NoStdExtZicfilpBit = 1,
  Feature_HasStdExtZmmulBit = 20,
  Feature_HasStdExtMBit = 21,
  Feature_HasStdExtABit = 23,
  Feature_HasStdExtZtsoBit = 25,
  Feature_NotHasStdExtZtsoBit = 24,
  Feature_HasStdExtZabhaBit = 28,
  Feature_HasStdExtZacasBit = 27,
  Feature_NoStdExtZacasBit = 26,
  Feature_HasStdExtFBit = 5,
  Feature_HasStdExtDBit = 7,
  Feature_HasStdExtZfhminBit = 29,
  Feature_HasStdExtZfhBit = 9,
  Feature_NoStdExtZfhBit = 31,
  Feature_HasStdExtZfbfminBit = 33,
  Feature_HasStdExtZfaBit = 34,
  Feature_HasStdExtZfinxBit = 6,
  Feature_HasStdExtZdinxBit = 8,
  Feature_HasStdExtZhinxminBit = 30,
  Feature_HasStdExtZhinxBit = 10,
  Feature_NoStdExtZhinxBit = 32,
  Feature_HasStdExtCBit = 16,
  Feature_HasStdExtCOrZcaBit = 18,
  Feature_HasStdExtZbaBit = 40,
  Feature_NotHasStdExtZbaBit = 19,
  Feature_HasStdExtZbbBit = 37,
  Feature_NoStdExtZbbBit = 39,
  Feature_HasStdExtZbcBit = 42,
  Feature_HasStdExtZbsBit = 36,
  Feature_HasStdExtZbkbBit = 38,
  Feature_HasStdExtZbkxBit = 43,
  Feature_HasStdExtZbbOrZbkbBit = 35,
  Feature_HasStdExtZbcOrZbkcBit = 41,
  Feature_HasStdExtZkndBit = 44,
  Feature_HasStdExtZkneBit = 46,
  Feature_HasStdExtZkndOrZkneBit = 45,
  Feature_HasStdExtZknhBit = 47,
  Feature_HasStdExtZksedBit = 48,
  Feature_HasStdExtZkshBit = 49,
  Feature_HasStdExtZvfbfwmaBit = 56,
  Feature_HasStdExtZvkbBit = 59,
  Feature_HasStdExtZvbbBit = 58,
  Feature_HasStdExtZvbcBit = 63,
  Feature_HasStdExtZvkgBit = 60,
  Feature_HasStdExtZvknedBit = 61,
  Feature_HasStdExtZvknhaBit = 64,
  Feature_HasStdExtZvknhbBit = 65,
  Feature_HasStdExtZvksedBit = 66,
  Feature_HasStdExtZvkshBit = 62,
  Feature_HasVInstructionsBit = 11,
  Feature_HasVInstructionsI64Bit = 52,
  Feature_HasVInstructionsAnyFBit = 51,
  Feature_HasVInstructionsF16MinimalBit = 57,
  Feature_HasVInstructionsBF16Bit = 55,
  Feature_HasVInstructionsF16Bit = 50,
  Feature_HasVInstructionsF64Bit = 54,
  Feature_HasVInstructionsFullMultiplyBit = 53,
  Feature_HasVendorXVentanaCondOpsBit = 70,
  Feature_HasVendorXTHeadBaBit = 71,
  Feature_HasVendorXTHeadBbBit = 72,
  Feature_HasVendorXTHeadBsBit = 73,
  Feature_HasVendorXTHeadCondMovBit = 74,
  Feature_HasVendorXTHeadFMemIdxBit = 79,
  Feature_HasVendorXTHeadMacBit = 75,
  Feature_HasVendorXTHeadMemIdxBit = 78,
  Feature_HasVendorXTHeadMemPairBit = 77,
  Feature_HasVendorXTHeadVdotBit = 76,
  Feature_HasVendorXSfvcpBit = 80,
  Feature_HasVendorXSfvqmaccdodBit = 81,
  Feature_HasVendorXSfvqmaccqoqBit = 82,
  Feature_HasVendorXSfvfwmaccqqqBit = 83,
  Feature_HasVendorXSfvfnrclipxfqfBit = 84,
  Feature_HasVendorXCVbitmanipBit = 86,
  Feature_HasVendorXCVmacBit = 89,
  Feature_HasVendorXCVmemBit = 85,
  Feature_HasVendorXCValuBit = 87,
  Feature_HasVendorXCVbiBit = 88,
  Feature_HasVendorESP32P4Bit = 15,
  Feature_IsRV64Bit = 4,
  Feature_IsRV32Bit = 3,
  Feature_HasShortForwardBranchOptBit = 12,
  Feature_NoShortForwardBranchOptBit = 14,
  Feature_HasConditionalMoveFusionBit = 13,
  Feature_NoConditionalMoveFusionBit = 0,
  Feature_HasAtomicLdStBit = 22,
  Feature_OptForMinSizeBit = 17,
  Feature_HwMode1Bit = 91,
  Feature_HwMode0Bit = 90,
};

PredicateBitset RISCVInstructionSelector::
computeAvailableModuleFeatures(const RISCVSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (Subtarget->hasStdExtZicbop())
    Features.set(Feature_HasStdExtZicbopBit);
  if (Subtarget->hasStdExtZicond())
    Features.set(Feature_HasStdExtZicondBit);
  if (Subtarget->hasStdExtZimop())
    Features.set(Feature_HasStdExtZimopBit);
  if (Subtarget->hasStdExtZicfilp())
    Features.set(Feature_HasStdExtZicfilpBit);
  if (!Subtarget->hasStdExtZicfilp())
    Features.set(Feature_NoStdExtZicfilpBit);
  if (Subtarget->hasStdExtZmmul())
    Features.set(Feature_HasStdExtZmmulBit);
  if (Subtarget->hasStdExtM())
    Features.set(Feature_HasStdExtMBit);
  if (Subtarget->hasStdExtA())
    Features.set(Feature_HasStdExtABit);
  if (Subtarget->hasStdExtZtso())
    Features.set(Feature_HasStdExtZtsoBit);
  if (!Subtarget->hasStdExtZtso())
    Features.set(Feature_NotHasStdExtZtsoBit);
  if (Subtarget->hasStdExtZabha())
    Features.set(Feature_HasStdExtZabhaBit);
  if (Subtarget->hasStdExtZacas())
    Features.set(Feature_HasStdExtZacasBit);
  if (!Subtarget->hasStdExtZacas())
    Features.set(Feature_NoStdExtZacasBit);
  if (Subtarget->hasStdExtF())
    Features.set(Feature_HasStdExtFBit);
  if (Subtarget->hasStdExtD())
    Features.set(Feature_HasStdExtDBit);
  if (Subtarget->hasStdExtZfhmin())
    Features.set(Feature_HasStdExtZfhminBit);
  if (Subtarget->hasStdExtZfh())
    Features.set(Feature_HasStdExtZfhBit);
  if (!Subtarget->hasStdExtZfh())
    Features.set(Feature_NoStdExtZfhBit);
  if (Subtarget->hasStdExtZfbfmin())
    Features.set(Feature_HasStdExtZfbfminBit);
  if (Subtarget->hasStdExtZfa())
    Features.set(Feature_HasStdExtZfaBit);
  if (Subtarget->hasStdExtZfinx())
    Features.set(Feature_HasStdExtZfinxBit);
  if (Subtarget->hasStdExtZdinx())
    Features.set(Feature_HasStdExtZdinxBit);
  if (Subtarget->hasStdExtZhinxmin())
    Features.set(Feature_HasStdExtZhinxminBit);
  if (Subtarget->hasStdExtZhinx())
    Features.set(Feature_HasStdExtZhinxBit);
  if (!Subtarget->hasStdExtZhinx())
    Features.set(Feature_NoStdExtZhinxBit);
  if (Subtarget->hasStdExtC())
    Features.set(Feature_HasStdExtCBit);
  if (Subtarget->hasStdExtCOrZca())
    Features.set(Feature_HasStdExtCOrZcaBit);
  if (Subtarget->hasStdExtZba())
    Features.set(Feature_HasStdExtZbaBit);
  if (!Subtarget->hasStdExtZba())
    Features.set(Feature_NotHasStdExtZbaBit);
  if (Subtarget->hasStdExtZbb())
    Features.set(Feature_HasStdExtZbbBit);
  if (!Subtarget->hasStdExtZbb())
    Features.set(Feature_NoStdExtZbbBit);
  if (Subtarget->hasStdExtZbc())
    Features.set(Feature_HasStdExtZbcBit);
  if (Subtarget->hasStdExtZbs())
    Features.set(Feature_HasStdExtZbsBit);
  if (Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbkbBit);
  if (Subtarget->hasStdExtZbkx())
    Features.set(Feature_HasStdExtZbkxBit);
  if (Subtarget->hasStdExtZbb() || Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbbOrZbkbBit);
  if (Subtarget->hasStdExtZbc() || Subtarget->hasStdExtZbkc())
    Features.set(Feature_HasStdExtZbcOrZbkcBit);
  if (Subtarget->hasStdExtZknd())
    Features.set(Feature_HasStdExtZkndBit);
  if (Subtarget->hasStdExtZkne())
    Features.set(Feature_HasStdExtZkneBit);
  if (Subtarget->hasStdExtZknd() || Subtarget->hasStdExtZkne())
    Features.set(Feature_HasStdExtZkndOrZkneBit);
  if (Subtarget->hasStdExtZknh())
    Features.set(Feature_HasStdExtZknhBit);
  if (Subtarget->hasStdExtZksed())
    Features.set(Feature_HasStdExtZksedBit);
  if (Subtarget->hasStdExtZksh())
    Features.set(Feature_HasStdExtZkshBit);
  if (Subtarget->hasStdExtZvfbfwma())
    Features.set(Feature_HasStdExtZvfbfwmaBit);
  if (Subtarget->hasStdExtZvkb())
    Features.set(Feature_HasStdExtZvkbBit);
  if (Subtarget->hasStdExtZvbb())
    Features.set(Feature_HasStdExtZvbbBit);
  if (Subtarget->hasStdExtZvbc())
    Features.set(Feature_HasStdExtZvbcBit);
  if (Subtarget->hasStdExtZvkg())
    Features.set(Feature_HasStdExtZvkgBit);
  if (Subtarget->hasStdExtZvkned())
    Features.set(Feature_HasStdExtZvknedBit);
  if (Subtarget->hasStdExtZvknha())
    Features.set(Feature_HasStdExtZvknhaBit);
  if (Subtarget->hasStdExtZvknhb())
    Features.set(Feature_HasStdExtZvknhbBit);
  if (Subtarget->hasStdExtZvksed())
    Features.set(Feature_HasStdExtZvksedBit);
  if (Subtarget->hasStdExtZvksh())
    Features.set(Feature_HasStdExtZvkshBit);
  if (Subtarget->hasVInstructions())
    Features.set(Feature_HasVInstructionsBit);
  if (Subtarget->hasVInstructionsI64())
    Features.set(Feature_HasVInstructionsI64Bit);
  if (Subtarget->hasVInstructionsAnyF())
    Features.set(Feature_HasVInstructionsAnyFBit);
  if (Subtarget->hasVInstructionsF16Minimal())
    Features.set(Feature_HasVInstructionsF16MinimalBit);
  if (Subtarget->hasVInstructionsBF16())
    Features.set(Feature_HasVInstructionsBF16Bit);
  if (Subtarget->hasVInstructionsF16())
    Features.set(Feature_HasVInstructionsF16Bit);
  if (Subtarget->hasVInstructionsF64())
    Features.set(Feature_HasVInstructionsF64Bit);
  if (Subtarget->hasVInstructionsFullMultiply())
    Features.set(Feature_HasVInstructionsFullMultiplyBit);
  if (Subtarget->hasVendorXVentanaCondOps())
    Features.set(Feature_HasVendorXVentanaCondOpsBit);
  if (Subtarget->hasVendorXTHeadBa())
    Features.set(Feature_HasVendorXTHeadBaBit);
  if (Subtarget->hasVendorXTHeadBb())
    Features.set(Feature_HasVendorXTHeadBbBit);
  if (Subtarget->hasVendorXTHeadBs())
    Features.set(Feature_HasVendorXTHeadBsBit);
  if (Subtarget->hasVendorXTHeadCondMov())
    Features.set(Feature_HasVendorXTHeadCondMovBit);
  if (Subtarget->hasVendorXTHeadFMemIdx())
    Features.set(Feature_HasVendorXTHeadFMemIdxBit);
  if (Subtarget->hasVendorXTHeadMac())
    Features.set(Feature_HasVendorXTHeadMacBit);
  if (Subtarget->hasVendorXTHeadMemIdx())
    Features.set(Feature_HasVendorXTHeadMemIdxBit);
  if (Subtarget->hasVendorXTHeadMemPair())
    Features.set(Feature_HasVendorXTHeadMemPairBit);
  if (Subtarget->hasVendorXTHeadVdot())
    Features.set(Feature_HasVendorXTHeadVdotBit);
  if (Subtarget->hasVendorXSfvcp())
    Features.set(Feature_HasVendorXSfvcpBit);
  if (Subtarget->hasVendorXSfvqmaccdod())
    Features.set(Feature_HasVendorXSfvqmaccdodBit);
  if (Subtarget->hasVendorXSfvqmaccqoq())
    Features.set(Feature_HasVendorXSfvqmaccqoqBit);
  if (Subtarget->hasVendorXSfvfwmaccqqq())
    Features.set(Feature_HasVendorXSfvfwmaccqqqBit);
  if (Subtarget->hasVendorXSfvfnrclipxfqf())
    Features.set(Feature_HasVendorXSfvfnrclipxfqfBit);
  if (Subtarget->hasVendorXCVbitmanip())
    Features.set(Feature_HasVendorXCVbitmanipBit);
  if (Subtarget->hasVendorXCVmac())
    Features.set(Feature_HasVendorXCVmacBit);
  if (Subtarget->hasVendorXCVmem())
    Features.set(Feature_HasVendorXCVmemBit);
  if (Subtarget->hasVendorXCValu())
    Features.set(Feature_HasVendorXCValuBit);
  if (Subtarget->hasVendorXCVbi())
    Features.set(Feature_HasVendorXCVbiBit);
  if (Subtarget->hasVendorESP32P4())
    Features.set(Feature_HasVendorESP32P4Bit);
  if (Subtarget->is64Bit())
    Features.set(Feature_IsRV64Bit);
  if (!Subtarget->is64Bit())
    Features.set(Feature_IsRV32Bit);
  if (Subtarget->hasShortForwardBranchOpt())
    Features.set(Feature_HasShortForwardBranchOptBit);
  if (!Subtarget->hasShortForwardBranchOpt())
    Features.set(Feature_NoShortForwardBranchOptBit);
  if (Subtarget->hasConditionalMoveFusion())
    Features.set(Feature_HasConditionalMoveFusionBit);
  if (!Subtarget->hasConditionalMoveFusion())
    Features.set(Feature_NoConditionalMoveFusionBit);
  if (Subtarget->hasStdExtA() || Subtarget->hasForcedAtomics())
    Features.set(Feature_HasAtomicLdStBit);
  if (MF ? MF->getFunction().hasMinSize() : false)
    Features.set(Feature_OptForMinSizeBit);
  if (!((Subtarget->is64Bit())))
    Features.set(Feature_HwMode1Bit);
  if ((Subtarget->is64Bit()))
    Features.set(Feature_HwMode0Bit);
  return Features;
}

void RISCVInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const RISCVSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset RISCVInstructionSelector::
computeAvailableFunctionFeatures(const RISCVSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HwMode0,
  GIFBS_HwMode1,
  GIFBS_HasAtomicLdSt_HwMode0,
  GIFBS_HasAtomicLdSt_HwMode1,
  GIFBS_HasShortForwardBranchOpt_HwMode0,
  GIFBS_HasShortForwardBranchOpt_HwMode1,
  GIFBS_HasStdExtA_HwMode1,
  GIFBS_HasStdExtD,
  GIFBS_HasStdExtD_HwMode0,
  GIFBS_HasStdExtD_HwMode1,
  GIFBS_HasStdExtF,
  GIFBS_HasStdExtF_HwMode0,
  GIFBS_HasStdExtF_HwMode1,
  GIFBS_HasStdExtM_HwMode0,
  GIFBS_HasStdExtM_HwMode1,
  GIFBS_HasStdExtZba_HwMode0,
  GIFBS_HasStdExtZba_HwMode1,
  GIFBS_HasStdExtZbb_HwMode0,
  GIFBS_HasStdExtZbb_HwMode1,
  GIFBS_HasStdExtZbbOrZbkb_HwMode0,
  GIFBS_HasStdExtZbbOrZbkb_HwMode1,
  GIFBS_HasStdExtZbkx_HwMode0,
  GIFBS_HasStdExtZbkx_HwMode1,
  GIFBS_HasStdExtZbs_HwMode0,
  GIFBS_HasStdExtZbs_HwMode1,
  GIFBS_HasStdExtZfa,
  GIFBS_HasStdExtZfa_HwMode0,
  GIFBS_HasStdExtZfa_HwMode1,
  GIFBS_HasStdExtZfbfmin_HwMode0,
  GIFBS_HasStdExtZfbfmin_HwMode1,
  GIFBS_HasStdExtZfh,
  GIFBS_HasStdExtZfh_HwMode0,
  GIFBS_HasStdExtZfh_HwMode1,
  GIFBS_HasStdExtZfhmin_HwMode0,
  GIFBS_HasStdExtZfhmin_HwMode1,
  GIFBS_HasStdExtZfinx,
  GIFBS_HasStdExtZfinx_HwMode0,
  GIFBS_HasStdExtZfinx_HwMode1,
  GIFBS_HasStdExtZhinx,
  GIFBS_HasStdExtZhinx_HwMode0,
  GIFBS_HasStdExtZhinx_HwMode1,
  GIFBS_HasStdExtZhinxmin_HwMode0,
  GIFBS_HasStdExtZhinxmin_HwMode1,
  GIFBS_HasStdExtZmmul_HwMode0,
  GIFBS_HasStdExtZmmul_HwMode1,
  GIFBS_HasVInstructions_HwMode0,
  GIFBS_HasVInstructions_HwMode1,
  GIFBS_HasVInstructionsAnyF_HwMode0,
  GIFBS_HasVInstructionsAnyF_HwMode1,
  GIFBS_HasVInstructionsBF16_HwMode0,
  GIFBS_HasVInstructionsBF16_HwMode1,
  GIFBS_HasVInstructionsF16_HwMode0,
  GIFBS_HasVInstructionsF16_HwMode1,
  GIFBS_HasVInstructionsF16Minimal_HwMode0,
  GIFBS_HasVInstructionsF16Minimal_HwMode1,
  GIFBS_HasVInstructionsF64_HwMode0,
  GIFBS_HasVInstructionsF64_HwMode1,
  GIFBS_HasVInstructionsFullMultiply_HwMode0,
  GIFBS_HasVInstructionsFullMultiply_HwMode1,
  GIFBS_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructionsI64_HwMode1,
  GIFBS_HasVendorESP32P4,
  GIFBS_HasVendorESP32P4_HwMode0,
  GIFBS_HasVendorESP32P4_HwMode1,
  GIFBS_HasVendorXCVmac_HwMode0,
  GIFBS_HasVendorXCVmac_HwMode1,
  GIFBS_HasVendorXTHeadBa_HwMode0,
  GIFBS_HasVendorXTHeadBa_HwMode1,
  GIFBS_HasVendorXTHeadBb_HwMode0,
  GIFBS_HasVendorXTHeadBb_HwMode1,
  GIFBS_HasVendorXTHeadBs_HwMode0,
  GIFBS_HasVendorXTHeadBs_HwMode1,
  GIFBS_HasVendorXTHeadCondMov_HwMode0,
  GIFBS_HasVendorXTHeadCondMov_HwMode1,
  GIFBS_HasVendorXTHeadMac_HwMode0,
  GIFBS_HasVendorXTHeadMac_HwMode1,
  GIFBS_IsRV32_HwMode0,
  GIFBS_IsRV32_HwMode1,
  GIFBS_IsRV64_HwMode0,
  GIFBS_IsRV64_HwMode1,
  GIFBS_HasAtomicLdSt_IsRV64_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZtso_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZtso_HwMode1,
  GIFBS_HasStdExtA_IsRV64_HwMode1,
  GIFBS_HasStdExtA_NoStdExtZacas_HwMode1,
  GIFBS_HasStdExtA_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtA_NotHasStdExtZtso_HwMode1,
  GIFBS_HasStdExtD_HasStdExtZfa,
  GIFBS_HasStdExtD_HasStdExtZfa_HwMode0,
  GIFBS_HasStdExtD_HasStdExtZfa_HwMode1,
  GIFBS_HasStdExtD_HasStdExtZfhmin_HwMode0,
  GIFBS_HasStdExtD_HasStdExtZfhmin_HwMode1,
  GIFBS_HasStdExtD_IsRV64_HwMode0,
  GIFBS_HasStdExtF_IsRV64_HwMode0,
  GIFBS_HasStdExtM_IsRV64_HwMode0,
  GIFBS_HasStdExtM_IsRV64_HwMode1,
  GIFBS_HasStdExtZacas_HasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZacas_HasStdExtZtso_HwMode1,
  GIFBS_HasStdExtZacas_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZacas_NotHasStdExtZtso_HwMode1,
  GIFBS_HasStdExtZba_IsRV64_HwMode0,
  GIFBS_HasStdExtZba_IsRV64_HwMode1,
  GIFBS_HasStdExtZbb_IsRV32_HwMode0,
  GIFBS_HasStdExtZbb_IsRV32_HwMode1,
  GIFBS_HasStdExtZbb_IsRV64_HwMode0,
  GIFBS_HasStdExtZbb_IsRV64_HwMode1,
  GIFBS_HasStdExtZbbOrZbkb_IsRV32_HwMode0,
  GIFBS_HasStdExtZbbOrZbkb_IsRV32_HwMode1,
  GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode0,
  GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode1,
  GIFBS_HasStdExtZbs_IsRV64_HwMode0,
  GIFBS_HasStdExtZbs_IsRV64_HwMode1,
  GIFBS_HasStdExtZdinx_IsRV32,
  GIFBS_HasStdExtZdinx_IsRV32_HwMode0,
  GIFBS_HasStdExtZdinx_IsRV32_HwMode1,
  GIFBS_HasStdExtZdinx_IsRV64_HwMode0,
  GIFBS_HasStdExtZfa_HasStdExtZfh,
  GIFBS_HasStdExtZfa_HasStdExtZfh_HwMode0,
  GIFBS_HasStdExtZfa_HasStdExtZfh_HwMode1,
  GIFBS_HasStdExtZfbfmin_IsRV64_HwMode0,
  GIFBS_HasStdExtZfh_IsRV64_HwMode0,
  GIFBS_HasStdExtZfhmin_NoStdExtZfh_HwMode0,
  GIFBS_HasStdExtZfhmin_NoStdExtZfh_HwMode1,
  GIFBS_HasStdExtZfinx_IsRV64_HwMode0,
  GIFBS_HasStdExtZhinx_IsRV64_HwMode0,
  GIFBS_HasStdExtZhinxmin_NoStdExtZhinx_HwMode0,
  GIFBS_HasStdExtZhinxmin_NoStdExtZhinx_HwMode1,
  GIFBS_HasStdExtZknd_IsRV32_HwMode1,
  GIFBS_HasStdExtZknd_IsRV64_HwMode0,
  GIFBS_HasStdExtZkndOrZkne_IsRV64_HwMode0,
  GIFBS_HasStdExtZkne_IsRV32_HwMode1,
  GIFBS_HasStdExtZkne_IsRV64_HwMode0,
  GIFBS_HasStdExtZknh_IsRV32_HwMode1,
  GIFBS_HasStdExtZknh_IsRV64_HwMode0,
  GIFBS_HasStdExtZmmul_IsRV64_HwMode0,
  GIFBS_HasStdExtZmmul_IsRV64_HwMode1,
  GIFBS_HasStdExtZvbb_HasVInstructions_HwMode0,
  GIFBS_HasStdExtZvbb_HasVInstructions_HwMode1,
  GIFBS_HasStdExtZvbb_HasVInstructionsI64_HwMode0,
  GIFBS_HasStdExtZvbb_HasVInstructionsI64_HwMode1,
  GIFBS_HasStdExtZvkb_HasVInstructions_HwMode0,
  GIFBS_HasStdExtZvkb_HasVInstructions_HwMode1,
  GIFBS_HasStdExtZvkb_HasVInstructionsI64_HwMode0,
  GIFBS_HasStdExtZvkb_HasVInstructionsI64_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsAnyF_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsAnyF_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsF16_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsF16_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsF64_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsF64_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsF64_HwMode0,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsF64_HwMode1,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsI64_HwMode1,
  GIFBS_HasVInstructionsF64_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructionsF64_HasVInstructionsI64_HwMode1,
  GIFBS_HasVendorXCValu_IsRV32_HwMode0,
  GIFBS_HasVendorXCValu_IsRV32_HwMode1,
  GIFBS_HasVendorXCVbitmanip_IsRV32_HwMode0,
  GIFBS_HasVendorXCVbitmanip_IsRV32_HwMode1,
  GIFBS_HasVendorXTHeadBb_IsRV64_HwMode0,
  GIFBS_HasVendorXTHeadCondMov_IsRV64_HwMode0,
  GIFBS_HasVendorXTHeadCondMov_IsRV64_HwMode1,
  GIFBS_HasVendorXTHeadMac_IsRV64_HwMode0,
  GIFBS_HasVendorXTHeadMac_IsRV64_HwMode1,
  GIFBS_IsRV64_NotHasStdExtZba_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZabha_HasStdExtZtso_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZabha_HasStdExtZtso_HwMode1,
  GIFBS_HasStdExtA_HasStdExtZabha_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZabha_NotHasStdExtZtso_HwMode1,
  GIFBS_HasStdExtA_HasStdExtZtso_IsRV64_HwMode0,
  GIFBS_HasStdExtA_IsRV64_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZabha_HasStdExtZacas_HasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZabha_HasStdExtZacas_HasStdExtZtso_HwMode1,
  GIFBS_HasStdExtZabha_HasStdExtZacas_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZabha_HasStdExtZacas_NotHasStdExtZtso_HwMode1,
  GIFBS_HasStdExtZacas_HasStdExtZtso_IsRV64_HwMode0,
  GIFBS_HasStdExtZacas_IsRV64_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZbkb_IsRV32_NoStdExtZbb_HwMode0,
  GIFBS_HasStdExtZbkb_IsRV32_NoStdExtZbb_HwMode1,
  GIFBS_HasStdExtZbkb_IsRV64_NoStdExtZbb_HwMode0,
  GIFBS_HasStdExtZbkb_IsRV64_NoStdExtZbb_HwMode1,
  GIFBS_HasStdExtZdinx_HasStdExtZhinxmin_IsRV32_HwMode0,
  GIFBS_HasStdExtZdinx_HasStdExtZhinxmin_IsRV32_HwMode1,
  GIFBS_HasStdExtZdinx_HasStdExtZhinxmin_IsRV64_HwMode0,
  GIFBS_HasStdExtZfhmin_IsRV64_NoStdExtZfh_HwMode0,
  GIFBS_HasStdExtZhinxmin_IsRV64_NoStdExtZhinx_HwMode0,
  GIFBS_HasStdExtZmmul_IsRV64_NotHasStdExtZba_HwMode0,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HwMode0Bit, },
  {Feature_HwMode1Bit, },
  {Feature_HasAtomicLdStBit, Feature_HwMode0Bit, },
  {Feature_HasAtomicLdStBit, Feature_HwMode1Bit, },
  {Feature_HasShortForwardBranchOptBit, Feature_HwMode0Bit, },
  {Feature_HasShortForwardBranchOptBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, },
  {Feature_HasStdExtDBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtFBit, },
  {Feature_HasStdExtFBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtFBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtMBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtMBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbkxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkxBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbsBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbsBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfaBit, },
  {Feature_HasStdExtZfaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfbfminBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfbfminBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfhBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfhminBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhminBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfinxBit, },
  {Feature_HasStdExtZfinxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfinxBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZhinxBit, },
  {Feature_HasStdExtZhinxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZmmulBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZmmulBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBF16Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBF16Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF16Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF16Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF16MinimalBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF16MinimalBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsFullMultiplyBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsFullMultiplyBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorESP32P4Bit, },
  {Feature_HasVendorESP32P4Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorESP32P4Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXCVmacBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXCVmacBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBaBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadBaBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBsBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadBsBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadCondMovBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadCondMovBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadMacBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadMacBit, Feature_HwMode1Bit, },
  {Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasAtomicLdStBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_NoStdExtZacasBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_NotHasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfhminBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfhminBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtFBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtMBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtMBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZacasBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZacasBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbaBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbaBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbsBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbsBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfbfminBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhminBit, Feature_NoStdExtZfhBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhminBit, Feature_NoStdExtZfhBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfinxBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_NoStdExtZhinxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_NoStdExtZhinxBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZkndOrZkneBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZmmulBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZmmulBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsAnyFBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsAnyFBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF16Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF16Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsF64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsF64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXCValuBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXCValuBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXCVbitmanipBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXCVbitmanipBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadCondMovBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadCondMovBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadMacBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadMacBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_IsRV64Bit, Feature_NotHasStdExtZbaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZabhaBit, Feature_HasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZabhaBit, Feature_HasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZabhaBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZabhaBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZtsoBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_IsRV64Bit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZabhaBit, Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZabhaBit, Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZabhaBit, Feature_HasStdExtZacasBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZabhaBit, Feature_HasStdExtZacasBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZacasBit, Feature_IsRV64Bit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV32Bit, Feature_NoStdExtZbbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV32Bit, Feature_NoStdExtZbbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV64Bit, Feature_NoStdExtZbbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV64Bit, Feature_NoStdExtZbbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZhinxminBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZhinxminBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZhinxminBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhminBit, Feature_IsRV64Bit, Feature_NoStdExtZfhBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_IsRV64Bit, Feature_NoStdExtZhinxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZmmulBit, Feature_IsRV64Bit, Feature_NotHasStdExtZbaBit, Feature_HwMode0Bit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_GIAddrRegImm,
  GICP_GIShiftMask32,
  GICP_GIShiftMaskXLen,
  GICP_gi_sh1add_op,
  GICP_gi_sh1add_uw_op,
  GICP_gi_sh2add_op,
  GICP_gi_sh2add_uw_op,
  GICP_gi_sh3add_op,
  GICP_gi_sh3add_uw_op,
};
// See constructor for table contents

RISCVInstructionSelector::ComplexMatcherMemFn
RISCVInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &RISCVInstructionSelector::selectAddrRegImm, // GIAddrRegImm
  &RISCVInstructionSelector::selectShiftMask, // GIShiftMask32
  &RISCVInstructionSelector::selectShiftMask, // GIShiftMaskXLen
  &RISCVInstructionSelector::selectSHXADDOp<1>, // gi_sh1add_op
  &RISCVInstructionSelector::selectSHXADD_UWOp<1>, // gi_sh1add_uw_op
  &RISCVInstructionSelector::selectSHXADDOp<2>, // gi_sh2add_op
  &RISCVInstructionSelector::selectSHXADD_UWOp<2>, // gi_sh2add_uw_op
  &RISCVInstructionSelector::selectSHXADDOp<3>, // gi_sh3add_op
  &RISCVInstructionSelector::selectSHXADD_UWOp<3>, // gi_sh3add_uw_op
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_add_like_non_imm12 = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_add_non_imm12,
};
bool RISCVInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_add_like_non_imm12: {
    
        const MachineOperand &ImmOp = *Operands[1];
        const MachineFunction &MF = *MI.getParent()->getParent();
        const MachineRegisterInfo &MRI = MF.getRegInfo();
    
        if (ImmOp.isReg() && ImmOp.getReg())
          if (auto Val = getIConstantVRegValWithLookThrough(ImmOp.getReg(), MRI)) {
            // We do NOT want immediates that fit in 12 bits.
            return !isInt<12>(Val->Value.getSExtValue());
          }
    
        return true;
      
    llvm_unreachable("add_like_non_imm12 should have returned");
  }
  case GICXXPred_MI_Predicate_add_non_imm12: {
    
        const MachineOperand &ImmOp = *Operands[1];
        const MachineFunction &MF = *MI.getParent()->getParent();
        const MachineRegisterInfo &MRI = MF.getRegInfo();
    
        if (ImmOp.isReg() && ImmOp.getReg())
          if (auto Val = getIConstantVRegValWithLookThrough(ImmOp.getReg(), MRI)) {
            // We do NOT want immediates that fit in 12 bits.
            return !isInt<12>(Val->Value.getSExtValue());
          }
    
        return true;
      
    llvm_unreachable("add_non_imm12 should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_BCLRMask = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_BCLRMaski32,
  GICXXPred_I64_Predicate_SingleBitSetMask,
  GICXXPred_I64_Predicate_SingleBitSetMaski32,
  GICXXPred_I64_Predicate_byteselect,
  GICXXPred_I64_Predicate_c_lui_imm,
  GICXXPred_I64_Predicate_csr_sysreg,
  GICXXPred_I64_Predicate_cv_tuimm2,
  GICXXPred_I64_Predicate_cv_tuimm5,
  GICXXPred_I64_Predicate_cv_uimm10,
  GICXXPred_I64_Predicate_imm8,
  GICXXPred_I64_Predicate_immzero,
  GICXXPred_I64_Predicate_offset_16_16,
  GICXXPred_I64_Predicate_offset_256_4,
  GICXXPred_I64_Predicate_offset_256_8,
  GICXXPred_I64_Predicate_offset_256_16,
  GICXXPred_I64_Predicate_payload1,
  GICXXPred_I64_Predicate_payload2,
  GICXXPred_I64_Predicate_payload5,
  GICXXPred_I64_Predicate_powerOf2Minus1,
  GICXXPred_I64_Predicate_rnum,
  GICXXPred_I64_Predicate_select_2,
  GICXXPred_I64_Predicate_select_4,
  GICXXPred_I64_Predicate_select_8,
  GICXXPred_I64_Predicate_select_16,
  GICXXPred_I64_Predicate_shfl_uimm,
  GICXXPred_I64_Predicate_simm5,
  GICXXPred_I64_Predicate_simm5_plus1,
  GICXXPred_I64_Predicate_simm5_plus1_nonzero,
  GICXXPred_I64_Predicate_simm6,
  GICXXPred_I64_Predicate_simm6nonzero,
  GICXXPred_I64_Predicate_simm9_lsb0,
  GICXXPred_I64_Predicate_simm10_lsb0000nonzero,
  GICXXPred_I64_Predicate_simm12,
  GICXXPred_I64_Predicate_simm12Minus1Nonzero,
  GICXXPred_I64_Predicate_simm12Minus1NonzeroNonNeg1,
  GICXXPred_I64_Predicate_simm12Plus1,
  GICXXPred_I64_Predicate_simm12Plus1i32,
  GICXXPred_I64_Predicate_simm12_lsb0,
  GICXXPred_I64_Predicate_simm12_lsb00000,
  GICXXPred_I64_Predicate_simm12_no6,
  GICXXPred_I64_Predicate_simm12i32,
  GICXXPred_I64_Predicate_tsimm5,
  GICXXPred_I64_Predicate_tuimm5,
  GICXXPred_I64_Predicate_u32simm12,
  GICXXPred_I64_Predicate_uimm1,
  GICXXPred_I64_Predicate_uimm2,
  GICXXPred_I64_Predicate_uimm2_3,
  GICXXPred_I64_Predicate_uimm2_4,
  GICXXPred_I64_Predicate_uimm2_lsb0,
  GICXXPred_I64_Predicate_uimm4_with_predicate,
  GICXXPred_I64_Predicate_uimm5,
  GICXXPred_I64_Predicate_uimm5_lsb0,
  GICXXPred_I64_Predicate_uimm5_with_predicate,
  GICXXPred_I64_Predicate_uimm6,
  GICXXPred_I64_Predicate_uimm6_lsb0,
  GICXXPred_I64_Predicate_uimm6gt32,
  GICXXPred_I64_Predicate_uimm7_lsb00,
  GICXXPred_I64_Predicate_uimm8_lsb00,
  GICXXPred_I64_Predicate_uimm8_lsb000,
  GICXXPred_I64_Predicate_uimm9_lsb000,
  GICXXPred_I64_Predicate_uimm10_lsb00nonzero,
  GICXXPred_I64_Predicate_uimm12,
  GICXXPred_I64_Predicate_uimmlog2xlen,
  GICXXPred_I64_Predicate_uimmlog2xlennonzero,
};
bool RISCVInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_BCLRMask: {
    
      if (Subtarget->is64Bit())
        return !isInt<12>(Imm) && isPowerOf2_64(~Imm);
      return !isInt<12>(Imm) && isPowerOf2_32(~Imm);
    
    llvm_unreachable("BCLRMask should have returned");
  }
  case GICXXPred_I64_Predicate_BCLRMaski32: {
    
      return !isInt<12>(Imm) && isPowerOf2_32(~Imm);
    
  }
  case GICXXPred_I64_Predicate_SingleBitSetMask: {
    
      if (Subtarget->is64Bit())
        return !isInt<12>(Imm) && isPowerOf2_64(Imm);
      return !isInt<12>(Imm) && isPowerOf2_32(Imm);
    
    llvm_unreachable("SingleBitSetMask should have returned");
  }
  case GICXXPred_I64_Predicate_SingleBitSetMaski32: {
    
      return !isInt<12>(Imm) && isPowerOf2_32(Imm);
    
  }
  case GICXXPred_I64_Predicate_byteselect: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_c_lui_imm: {
    return (Imm != 0) &&
                                     (isUInt<5>(Imm) ||
                                      (Imm >= 0xfffe0 && Imm <= 0xfffff));
  }
  case GICXXPred_I64_Predicate_csr_sysreg: {
    return isUInt<12>(Imm);
  }
  case GICXXPred_I64_Predicate_cv_tuimm2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_cv_tuimm5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_cv_uimm10: {
    return isUInt<10>(Imm);
  }
  case GICXXPred_I64_Predicate_imm8: {
     return Imm >= -128 && Imm <= 127; 
  }
  case GICXXPred_I64_Predicate_immzero: {
    return (Imm == 0);
  }
  case GICXXPred_I64_Predicate_offset_16_16: {
     return (Imm >= -128 && Imm <= 112) && ((Imm & 0xf) == 0); 
  }
  case GICXXPred_I64_Predicate_offset_256_4: {
     return (Imm >= -512 && Imm <= 508) && ((Imm & 0x3) == 0); 
  }
  case GICXXPred_I64_Predicate_offset_256_8: {
     return (Imm >= -1024 && Imm <= 1016) && ((Imm & 0x7) == 0); 
  }
  case GICXXPred_I64_Predicate_offset_256_16: {
     return (Imm >= -2048 && Imm <= 2032) && ((Imm & 0xf) == 0); 
  }
  case GICXXPred_I64_Predicate_payload1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_payload2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_payload5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_powerOf2Minus1: {
     return isPowerOf2_32(Imm+1); 
  }
  case GICXXPred_I64_Predicate_rnum: {
    return (Imm >= 0 && Imm <= 10);
  }
  case GICXXPred_I64_Predicate_select_2: {
     return Imm >= 0 && Imm <= 1; 
  }
  case GICXXPred_I64_Predicate_select_4: {
     return Imm >= 0 && Imm <= 3; 
  }
  case GICXXPred_I64_Predicate_select_8: {
     return Imm >= 0 && Imm <= 7; 
  }
  case GICXXPred_I64_Predicate_select_16: {
     return Imm >= 0 && Imm <= 15; 
  }
  case GICXXPred_I64_Predicate_shfl_uimm: {
    
      if (Subtarget->is64Bit())
        return isUInt<5>(Imm);
      return isUInt<4>(Imm);
    
    llvm_unreachable("shfl_uimm should have returned");
  }
  case GICXXPred_I64_Predicate_simm5: {
    return isInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_simm5_plus1: {
    return (isInt<5>(Imm) && Imm != -16) || Imm == 16;
  }
  case GICXXPred_I64_Predicate_simm5_plus1_nonzero: {
    return Imm != 0 && ((isInt<5>(Imm) && Imm != -16) || Imm == 16);
  }
  case GICXXPred_I64_Predicate_simm6: {
    return isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_simm6nonzero: {
    return (Imm != 0) && isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_simm9_lsb0: {
    return isShiftedInt<8, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_simm10_lsb0000nonzero: {
    return (Imm != 0) && isShiftedInt<6, 4>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12: {
    return isInt<12>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12Minus1Nonzero: {
    
      return (Imm >= -2049 && Imm < 0) || (Imm > 0 && Imm <= 2046);
  }
  case GICXXPred_I64_Predicate_simm12Minus1NonzeroNonNeg1: {
    
      return (Imm >= -2049 && Imm < -1) || (Imm > 0 && Imm <= 2046);
  }
  case GICXXPred_I64_Predicate_simm12Plus1: {
    
        return (isInt<12>(Imm) && Imm != -2048) || Imm == 2048;
  }
  case GICXXPred_I64_Predicate_simm12Plus1i32: {
    
        return (isInt<12>(Imm) && Imm != -2048) || Imm == 2048;
  }
  case GICXXPred_I64_Predicate_simm12_lsb0: {
    return isShiftedInt<11, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12_lsb00000: {
    return isShiftedInt<7, 5>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12_no6: {
    
      return isInt<12>(Imm) && !isInt<6>(Imm) && isInt<12>(-Imm);
  }
  case GICXXPred_I64_Predicate_simm12i32: {
    return isInt<12>(Imm);
  }
  case GICXXPred_I64_Predicate_tsimm5: {
    return isInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_tuimm5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_u32simm12: {
    
      return isUInt<32>(Imm) && isInt<12>(SignExtend64<32>(Imm));
    
  }
  case GICXXPred_I64_Predicate_uimm1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm2_3: {
    
      return isShiftedUInt<2, 3>(Imm);
    
  }
  case GICXXPred_I64_Predicate_uimm2_4: {
    
      return isShiftedUInt<2, 4>(Imm);
    
  }
  case GICXXPred_I64_Predicate_uimm2_lsb0: {
    return isShiftedUInt<1, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm4_with_predicate: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5_lsb0: {
    return isShiftedUInt<4, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5_with_predicate: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm6: {
    return isUInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm6_lsb0: {
    return isShiftedUInt<5, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm6gt32: {
    
      return isUInt<6>(Imm) && Imm > 32;
    
  }
  case GICXXPred_I64_Predicate_uimm7_lsb00: {
    return isShiftedUInt<5, 2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm8_lsb00: {
    return isShiftedUInt<6, 2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm8_lsb000: {
    return isShiftedUInt<5, 3>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm9_lsb000: {
    return isShiftedUInt<6, 3>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm10_lsb00nonzero: {
    return isShiftedUInt<8, 2>(Imm) && (Imm != 0);
  }
  case GICXXPred_I64_Predicate_uimm12: {
    return isUInt<12>(Imm);
  }
  case GICXXPred_I64_Predicate_uimmlog2xlen: {
    
      if (Subtarget->is64Bit())
        return isUInt<6>(Imm);
      return isUInt<5>(Imm);
    
    llvm_unreachable("uimmlog2xlen should have returned");
  }
  case GICXXPred_I64_Predicate_uimmlog2xlennonzero: {
    
      if (Subtarget->is64Bit())
        return isUInt<6>(Imm) && (Imm != 0);
      return isUInt<5>(Imm) && (Imm != 0);
    
    llvm_unreachable("uimmlog2xlennonzero should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool RISCVInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_Shifted32OnesMask = GICXXPred_Invalid + 1,
};
bool RISCVInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_Shifted32OnesMask: {
    
      if (!Imm.isShiftedMask())
        return false;
    
      unsigned TrailingZeros = Imm.countr_zero();
      return TrailingZeros > 0 && TrailingZeros < 32 &&
             Imm == UINT64_C(0xFFFFFFFF) << TrailingZeros;
    
    llvm_unreachable("Shifted32OnesMask should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("RISCVInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderImm,
  GICR_renderImmPlus1,
  GICR_renderImmSubFrom32,
  GICR_renderImmSubFromXLen,
  GICR_renderNegImm,
  GICR_renderTrailingZeros,
};
RISCVInstructionSelector::CustomRendererFn
RISCVInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &RISCVInstructionSelector::renderImm,
  &RISCVInstructionSelector::renderImmPlus1,
  &RISCVInstructionSelector::renderImmSubFrom32,
  &RISCVInstructionSelector::renderImmSubFromXLen,
  &RISCVInstructionSelector::renderNegImm,
  &RISCVInstructionSelector::renderTrailingZeros,
};

bool RISCVInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool RISCVInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("RISCVInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *RISCVInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(51), GIMT_Encode2(654), /*)*//*default:*//*Label 99*/ GIMT_Encode4(347872),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(2422),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(11764),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(14868),
    /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(17773),
    /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(20543),
    /*TargetOpcode::G_SREM*//*Label 5*/ GIMT_Encode4(23313),
    /*TargetOpcode::G_UREM*//*Label 6*/ GIMT_Encode4(26083), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 7*/ GIMT_Encode4(28853),
    /*TargetOpcode::G_OR*//*Label 8*/ GIMT_Encode4(38399),
    /*TargetOpcode::G_XOR*//*Label 9*/ GIMT_Encode4(46330), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 10*/ GIMT_Encode4(61718), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 11*/ GIMT_Encode4(62031),
    /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 12*/ GIMT_Encode4(62229),
    /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 13*/ GIMT_Encode4(62427),
    /*TargetOpcode::G_INTRINSIC_LLRINT*//*Label 14*/ GIMT_Encode4(63325),
    /*TargetOpcode::G_INTRINSIC_ROUNDEVEN*//*Label 15*/ GIMT_Encode4(63627),
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 16*/ GIMT_Encode4(63767),
    /*TargetOpcode::G_READSTEADYCOUNTER*//*Label 17*/ GIMT_Encode4(63806),
    /*TargetOpcode::G_LOAD*//*Label 18*/ GIMT_Encode4(63845),
    /*TargetOpcode::G_SEXTLOAD*//*Label 19*/ GIMT_Encode4(68275),
    /*TargetOpcode::G_ZEXTLOAD*//*Label 20*/ GIMT_Encode4(68783), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STORE*//*Label 21*/ GIMT_Encode4(69291), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 22*/ GIMT_Encode4(73237),
    /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 23*/ GIMT_Encode4(77793),
    /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 24*/ GIMT_Encode4(81523), GIMT_Encode4(0),
    /*TargetOpcode::G_ATOMICRMW_AND*//*Label 25*/ GIMT_Encode4(85253),
    /*TargetOpcode::G_ATOMICRMW_NAND*//*Label 26*/ GIMT_Encode4(88983),
    /*TargetOpcode::G_ATOMICRMW_OR*//*Label 27*/ GIMT_Encode4(89268),
    /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 28*/ GIMT_Encode4(92998),
    /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 29*/ GIMT_Encode4(96728),
    /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 30*/ GIMT_Encode4(100458),
    /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 31*/ GIMT_Encode4(104188),
    /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 32*/ GIMT_Encode4(107918), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FENCE*//*Label 33*/ GIMT_Encode4(111648), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 34*/ GIMT_Encode4(111866),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 35*/ GIMT_Encode4(116046), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ANYEXT*//*Label 36*/ GIMT_Encode4(143229), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 37*/ GIMT_Encode4(146350), GIMT_Encode4(0),
    /*TargetOpcode::G_ZEXT*//*Label 38*/ GIMT_Encode4(149515),
    /*TargetOpcode::G_SHL*//*Label 39*/ GIMT_Encode4(152731),
    /*TargetOpcode::G_LSHR*//*Label 40*/ GIMT_Encode4(156176),
    /*TargetOpcode::G_ASHR*//*Label 41*/ GIMT_Encode4(159283), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ROTR*//*Label 42*/ GIMT_Encode4(162359),
    /*TargetOpcode::G_ROTL*//*Label 43*/ GIMT_Encode4(165462),
    /*TargetOpcode::G_ICMP*//*Label 44*/ GIMT_Encode4(168528),
    /*TargetOpcode::G_FCMP*//*Label 45*/ GIMT_Encode4(195191), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SELECT*//*Label 46*/ GIMT_Encode4(202653), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 47*/ GIMT_Encode4(209383),
    /*TargetOpcode::G_SMULH*//*Label 48*/ GIMT_Encode4(212117),
    /*TargetOpcode::G_UADDSAT*//*Label 49*/ GIMT_Encode4(214851),
    /*TargetOpcode::G_SADDSAT*//*Label 50*/ GIMT_Encode4(217637),
    /*TargetOpcode::G_USUBSAT*//*Label 51*/ GIMT_Encode4(220423),
    /*TargetOpcode::G_SSUBSAT*//*Label 52*/ GIMT_Encode4(223209), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 53*/ GIMT_Encode4(225995),
    /*TargetOpcode::G_FSUB*//*Label 54*/ GIMT_Encode4(228423),
    /*TargetOpcode::G_FMUL*//*Label 55*/ GIMT_Encode4(230851),
    /*TargetOpcode::G_FMA*//*Label 56*/ GIMT_Encode4(233279), GIMT_Encode4(0),
    /*TargetOpcode::G_FDIV*//*Label 57*/ GIMT_Encode4(249924), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 58*/ GIMT_Encode4(252352),
    /*TargetOpcode::G_FPEXT*//*Label 59*/ GIMT_Encode4(254323),
    /*TargetOpcode::G_FPTRUNC*//*Label 60*/ GIMT_Encode4(254776),
    /*TargetOpcode::G_FPTOSI*//*Label 61*/ GIMT_Encode4(256772),
    /*TargetOpcode::G_FPTOUI*//*Label 62*/ GIMT_Encode4(262135),
    /*TargetOpcode::G_SITOFP*//*Label 63*/ GIMT_Encode4(267498),
    /*TargetOpcode::G_UITOFP*//*Label 64*/ GIMT_Encode4(273039),
    /*TargetOpcode::G_FABS*//*Label 65*/ GIMT_Encode4(278580),
    /*TargetOpcode::G_FCOPYSIGN*//*Label 66*/ GIMT_Encode4(280551), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINNUM*//*Label 67*/ GIMT_Encode4(286200),
    /*TargetOpcode::G_FMAXNUM*//*Label 68*/ GIMT_Encode4(288285), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINIMUM*//*Label 69*/ GIMT_Encode4(290370),
    /*TargetOpcode::G_FMAXIMUM*//*Label 70*/ GIMT_Encode4(290496), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 71*/ GIMT_Encode4(290622),
    /*TargetOpcode::G_SMAX*//*Label 72*/ GIMT_Encode4(293398),
    /*TargetOpcode::G_UMIN*//*Label 73*/ GIMT_Encode4(296174),
    /*TargetOpcode::G_UMAX*//*Label 74*/ GIMT_Encode4(298950),
    /*TargetOpcode::G_ABS*//*Label 75*/ GIMT_Encode4(301726),
    /*TargetOpcode::G_LROUND*//*Label 76*/ GIMT_Encode4(301884),
    /*TargetOpcode::G_LLROUND*//*Label 77*/ GIMT_Encode4(302782),
    /*TargetOpcode::G_BR*//*Label 78*/ GIMT_Encode4(303084), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CTTZ*//*Label 79*/ GIMT_Encode4(303100), GIMT_Encode4(0),
    /*TargetOpcode::G_CTLZ*//*Label 80*/ GIMT_Encode4(305650), GIMT_Encode4(0),
    /*TargetOpcode::G_CTPOP*//*Label 81*/ GIMT_Encode4(308346),
    /*TargetOpcode::G_BSWAP*//*Label 82*/ GIMT_Encode4(310896),
    /*TargetOpcode::G_BITREVERSE*//*Label 83*/ GIMT_Encode4(313431),
    /*TargetOpcode::G_FCEIL*//*Label 84*/ GIMT_Encode4(315925), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 85*/ GIMT_Encode4(316123),
    /*TargetOpcode::G_FFLOOR*//*Label 86*/ GIMT_Encode4(318299),
    /*TargetOpcode::G_FRINT*//*Label 87*/ GIMT_Encode4(318497),
    /*TargetOpcode::G_FNEARBYINT*//*Label 88*/ GIMT_Encode4(318695), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FADD*//*Label 89*/ GIMT_Encode4(318893),
    /*TargetOpcode::G_STRICT_FSUB*//*Label 90*/ GIMT_Encode4(321321),
    /*TargetOpcode::G_STRICT_FMUL*//*Label 91*/ GIMT_Encode4(323749),
    /*TargetOpcode::G_STRICT_FDIV*//*Label 92*/ GIMT_Encode4(326177), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FMA*//*Label 93*/ GIMT_Encode4(328605),
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 94*/ GIMT_Encode4(345250), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_TRAP*//*Label 95*/ GIMT_Encode4(347426),
    /*TargetOpcode::G_DEBUGTRAP*//*Label 96*/ GIMT_Encode4(347439), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*RISCV::G_FCLASS*//*Label 97*/ GIMT_Encode4(347452),
    /*RISCV::G_READ_VLENB*//*Label 98*/ GIMT_Encode4(347812),
    // Label 0: @2422
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 124*/ GIMT_Encode4(11763),
    /*GILLT_s32*//*Label 100*/ GIMT_Encode4(2557),
    /*GILLT_s64*//*Label 101*/ GIMT_Encode4(5055), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 102*/ GIMT_Encode4(9233),
    /*GILLT_nxv1s16*//*Label 103*/ GIMT_Encode4(9348),
    /*GILLT_nxv1s32*//*Label 104*/ GIMT_Encode4(9463),
    /*GILLT_nxv1s64*//*Label 105*/ GIMT_Encode4(9578), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 106*/ GIMT_Encode4(9693),
    /*GILLT_nxv2s16*//*Label 107*/ GIMT_Encode4(9808),
    /*GILLT_nxv2s32*//*Label 108*/ GIMT_Encode4(9923),
    /*GILLT_nxv2s64*//*Label 109*/ GIMT_Encode4(10038), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 110*/ GIMT_Encode4(10153),
    /*GILLT_nxv4s16*//*Label 111*/ GIMT_Encode4(10268),
    /*GILLT_nxv4s32*//*Label 112*/ GIMT_Encode4(10383),
    /*GILLT_nxv4s64*//*Label 113*/ GIMT_Encode4(10498), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 114*/ GIMT_Encode4(10613),
    /*GILLT_nxv8s16*//*Label 115*/ GIMT_Encode4(10728),
    /*GILLT_nxv8s32*//*Label 116*/ GIMT_Encode4(10843),
    /*GILLT_nxv8s64*//*Label 117*/ GIMT_Encode4(10958), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 118*/ GIMT_Encode4(11073),
    /*GILLT_nxv16s16*//*Label 119*/ GIMT_Encode4(11188),
    /*GILLT_nxv16s32*//*Label 120*/ GIMT_Encode4(11303), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 121*/ GIMT_Encode4(11418),
    /*GILLT_nxv32s16*//*Label 122*/ GIMT_Encode4(11533), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 123*/ GIMT_Encode4(11648),
    // Label 100: @2557
    GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(5054),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(2616), // Rule ID 3309 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:2:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:2:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1:$pred:2:x, GPR:{ *:[i32] }:$rs2:$pred:2:y)<<P:2:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3309,
        GIR_EraseRootFromParent_Done,
      // Label 126: @2616
      GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(2664), // Rule ID 3319 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:4:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:4:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1:$pred:4:x, GPR:{ *:[i32] }:$rs2:$pred:4:y)<<P:4:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3319,
        GIR_EraseRootFromParent_Done,
      // Label 127: @2664
      GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(2712), // Rule ID 3329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1:$pred:6:x, GPR:{ *:[i32] }:$rs2:$pred:6:y)<<P:6:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3329,
        GIR_EraseRootFromParent_Done,
      // Label 128: @2712
      GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(2763), // Rule ID 63596 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:27:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:27:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1:$pred:27:x, GPR:{ *:[i32] }:$rs2:$pred:27:y)<<P:27:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs2, sh1add_op:{ *:[i32] }:$rs1, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63596,
        GIR_EraseRootFromParent_Done,
      // Label 129: @2763
      GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(2814), // Rule ID 63598 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:28:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:28:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1:$pred:28:x, GPR:{ *:[i32] }:$rs2:$pred:28:y)<<P:28:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs2, sh2add_op:{ *:[i32] }:$rs1, 2:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63598,
        GIR_EraseRootFromParent_Done,
      // Label 130: @2814
      GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(2865), // Rule ID 63600 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:29:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:29:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1:$pred:29:x, GPR:{ *:[i32] }:$rs2:$pred:29:y)<<P:29:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs2, sh3add_op:{ *:[i32] }:$rs1, 3:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63600,
        GIR_EraseRootFromParent_Done,
      // Label 131: @2865
      GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(2913), // Rule ID 65819 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:2:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:2:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:2:y, sh1add_op:{ *:[i32] }:$rs1:$pred:2:x)<<P:2:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65819,
        GIR_EraseRootFromParent_Done,
      // Label 132: @2913
      GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(2961), // Rule ID 65827 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:4:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:4:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:4:y, sh2add_op:{ *:[i32] }:$rs1:$pred:4:x)<<P:4:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65827,
        GIR_EraseRootFromParent_Done,
      // Label 133: @2961
      GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(3009), // Rule ID 65835 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:6:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:6:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:6:y, sh3add_op:{ *:[i32] }:$rs1:$pred:6:x)<<P:6:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65835,
        GIR_EraseRootFromParent_Done,
      // Label 134: @3009
      GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(3060), // Rule ID 74314 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:27:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:27:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:27:y, sh1add_op:{ *:[i32] }:$rs1:$pred:27:x)<<P:27:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs2, sh1add_op:{ *:[i32] }:$rs1, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 74314,
        GIR_EraseRootFromParent_Done,
      // Label 135: @3060
      GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(3111), // Rule ID 74316 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:28:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:28:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:28:y, sh2add_op:{ *:[i32] }:$rs1:$pred:28:x)<<P:28:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs2, sh2add_op:{ *:[i32] }:$rs1, 2:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 74316,
        GIR_EraseRootFromParent_Done,
      // Label 136: @3111
      GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(3162), // Rule ID 74318 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:29:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:29:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:29:y, sh3add_op:{ *:[i32] }:$rs1:$pred:29:x)<<P:29:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs2, sh3add_op:{ *:[i32] }:$rs1, 3:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 74318,
        GIR_EraseRootFromParent_Done,
      // Label 137: @3162
      GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(3230), // Rule ID 3303 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }):$pred:1:x, GPR:{ *:[i32] }:$rs2:$pred:1:y)<<P:1:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3303,
        GIR_EraseRootFromParent_Done,
      // Label 138: @3230
      GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(3298), // Rule ID 3313 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i32] }):$pred:3:x, GPR:{ *:[i32] }:$rs2:$pred:3:y)<<P:3:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3313,
        GIR_EraseRootFromParent_Done,
      // Label 139: @3298
      GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(3366), // Rule ID 3323 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i32] }):$pred:5:x, GPR:{ *:[i32] }:$rs2:$pred:5:y)<<P:5:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3323,
        GIR_EraseRootFromParent_Done,
      // Label 140: @3366
      GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(3434), // Rule ID 3425 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:24:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:24:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i64] }):$pred:24:x, GPR:{ *:[i32] }:$rs2:$pred:24:y)<<P:24:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3425,
        GIR_EraseRootFromParent_Done,
      // Label 141: @3434
      GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(3502), // Rule ID 3426 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:24:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:24:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i64] }):$pred:24:x, GPR:{ *:[i32] }:$rs2:$pred:24:y)<<P:24:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3426,
        GIR_EraseRootFromParent_Done,
      // Label 142: @3502
      GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(3570), // Rule ID 3431 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:25:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:25:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i64] }):$pred:25:x, GPR:{ *:[i32] }:$rs2:$pred:25:y)<<P:25:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3431,
        GIR_EraseRootFromParent_Done,
      // Label 143: @3570
      GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(3638), // Rule ID 3432 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:25:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:25:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i64] }):$pred:25:x, GPR:{ *:[i32] }:$rs2:$pred:25:y)<<P:25:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3432,
        GIR_EraseRootFromParent_Done,
      // Label 144: @3638
      GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(3706), // Rule ID 3437 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:26:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:26:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i64] }):$pred:26:x, GPR:{ *:[i32] }:$rs2:$pred:26:y)<<P:26:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3437,
        GIR_EraseRootFromParent_Done,
      // Label 145: @3706
      GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(3774), // Rule ID 3438 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:26:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:26:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i64] }):$pred:26:x, GPR:{ *:[i32] }:$rs2:$pred:26:y)<<P:26:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3438,
        GIR_EraseRootFromParent_Done,
      // Label 146: @3774
      GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(3842), // Rule ID 65815 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:1:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }):$pred:1:x)<<P:1:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65815,
        GIR_EraseRootFromParent_Done,
      // Label 147: @3842
      GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(3910), // Rule ID 65823 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:3:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:3:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i32] }):$pred:3:x)<<P:3:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65823,
        GIR_EraseRootFromParent_Done,
      // Label 148: @3910
      GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(3978), // Rule ID 65831 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:5:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i32] }):$pred:5:x)<<P:5:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65831,
        GIR_EraseRootFromParent_Done,
      // Label 149: @3978
      GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(4046), // Rule ID 65887 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:24:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:24:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:24:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i64] }):$pred:24:x)<<P:24:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65887,
        GIR_EraseRootFromParent_Done,
      // Label 150: @4046
      GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(4114), // Rule ID 65888 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:24:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:24:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:24:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i64] }):$pred:24:x)<<P:24:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65888,
        GIR_EraseRootFromParent_Done,
      // Label 151: @4114
      GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(4182), // Rule ID 65891 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:25:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:25:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:25:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i64] }):$pred:25:x)<<P:25:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65891,
        GIR_EraseRootFromParent_Done,
      // Label 152: @4182
      GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(4250), // Rule ID 65892 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:25:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:25:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:25:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i64] }):$pred:25:x)<<P:25:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65892,
        GIR_EraseRootFromParent_Done,
      // Label 153: @4250
      GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(4318), // Rule ID 65895 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:26:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:26:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:26:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i64] }):$pred:26:x)<<P:26:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65895,
        GIR_EraseRootFromParent_Done,
      // Label 154: @4318
      GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(4386), // Rule ID 65896 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:26:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:26:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:26:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i64] }):$pred:26:x)<<P:26:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65896,
        GIR_EraseRootFromParent_Done,
      // Label 155: @4386
      GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(4453), // Rule ID 74312 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2), GPR:{ *:[i32] }:$rs1)  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 74312,
        GIR_EraseRootFromParent_Done,
      // Label 156: @4453
      GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(4520), // Rule ID 63592 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2))  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63592,
        GIR_EraseRootFromParent_Done,
      // Label 157: @4520
      GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(4562), // Rule ID 662 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ADDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 662,
        GIR_EraseRootFromParent_Done,
      // Label 158: @4562
      GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(4606), // Rule ID 903 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12i32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12i32>>:$imm)  =>  (ADDIW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (as_i64imm:{ *:[i64] } ?:{ *:[i32] }:$imm))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDIW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderImm), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 903,
        GIR_EraseRootFromParent_Done,
      // Label 159: @4606
      GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(4667), // Rule ID 74320 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rd)  =>  (TH_MULA:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/2, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 74320,
        GIR_EraseRootFromParent_Done,
      // Label 160: @4667
      GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(4728), // Rule ID 74324 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rd)  =>  (TH_MULAW:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULAW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/2, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 74324,
        GIR_EraseRootFromParent_Done,
      // Label 161: @4728
      GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(4789), // Rule ID 74325 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rd)  =>  (TH_MULAW:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULAW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/2, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 74325,
        GIR_EraseRootFromParent_Done,
      // Label 162: @4789
      GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(4850), // Rule ID 63652 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULA:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63652,
        GIR_EraseRootFromParent_Done,
      // Label 163: @4850
      GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(4911), // Rule ID 63909 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULAW:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULAW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63909,
        GIR_EraseRootFromParent_Done,
      // Label 164: @4911
      GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(4972), // Rule ID 63910 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULAW:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULAW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63910,
        GIR_EraseRootFromParent_Done,
      // Label 165: @4972
      GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(4999), // Rule ID 660 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADD),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 660,
        GIR_Done,
      // Label 166: @4999
      GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(5026), // Rule ID 890 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (ADDW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADDW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 890,
        GIR_Done,
      // Label 167: @5026
      GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(5053), // Rule ID 891 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (ADDW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADDW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 891,
        GIR_Done,
      // Label 168: @5053
      GIM_Reject,
    // Label 125: @5054
    GIM_Reject,
    // Label 101: @5055
    GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(9232),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(5161), // Rule ID 3353 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:11:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934591),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:11:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), 8589934591:{ *:[i64] }):$pred:11:x, GPR:{ *:[i64] }:$rs2:$pred:11:y)<<P:11:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3353,
        GIR_EraseRootFromParent_Done,
      // Label 170: @5161
      GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(5256), // Rule ID 3355 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:12:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 2,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869183),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:12:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), 17179869183:{ *:[i64] }):$pred:12:x, GPR:{ *:[i64] }:$rs2:$pred:12:y)<<P:12:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3355,
        GIR_EraseRootFromParent_Done,
      // Label 171: @5256
      GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(5351), // Rule ID 3357 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:13:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 3,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738367),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:13:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), 34359738367:{ *:[i64] }):$pred:13:x, GPR:{ *:[i64] }:$rs2:$pred:13:y)<<P:13:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3357,
        GIR_EraseRootFromParent_Done,
      // Label 172: @5351
      GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(5446), // Rule ID 3344 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 1:{ *:[i64] }):$pred:8:x, GPR:{ *:[i64] }:$rs2:$pred:8:y)<<P:8:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3344,
        GIR_EraseRootFromParent_Done,
      // Label 173: @5446
      GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(5541), // Rule ID 3347 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:9:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:9:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 2:{ *:[i64] }):$pred:9:x, GPR:{ *:[i64] }:$rs2:$pred:9:y)<<P:9:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3347,
        GIR_EraseRootFromParent_Done,
      // Label 174: @5541
      GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(5636), // Rule ID 3350 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:10:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:10:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 3:{ *:[i64] }):$pred:10:x, GPR:{ *:[i64] }:$rs2:$pred:10:y)<<P:10:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3350,
        GIR_EraseRootFromParent_Done,
      // Label 175: @5636
      GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(5731), // Rule ID 65845 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:11:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:11:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934591),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:11:y, (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), 8589934591:{ *:[i64] }):$pred:11:x)<<P:11:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65845,
        GIR_EraseRootFromParent_Done,
      // Label 176: @5731
      GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(5826), // Rule ID 65847 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:12:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:12:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 2,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869183),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:12:y, (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), 17179869183:{ *:[i64] }):$pred:12:x)<<P:12:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65847,
        GIR_EraseRootFromParent_Done,
      // Label 177: @5826
      GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(5921), // Rule ID 65849 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:13:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:13:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 3,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738367),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:13:y, (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), 34359738367:{ *:[i64] }):$pred:13:x)<<P:13:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65849,
        GIR_EraseRootFromParent_Done,
      // Label 178: @5921
      GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(6016), // Rule ID 65839 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:8:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:8:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:8:y, (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 1:{ *:[i64] }):$pred:8:x)<<P:8:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65839,
        GIR_EraseRootFromParent_Done,
      // Label 179: @6016
      GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(6111), // Rule ID 65841 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:9:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:9:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:9:y, (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 2:{ *:[i64] }):$pred:9:x)<<P:9:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65841,
        GIR_EraseRootFromParent_Done,
      // Label 180: @6111
      GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(6206), // Rule ID 65843 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:10:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:10:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:10:y, (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 3:{ *:[i64] }):$pred:10:x)<<P:10:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65843,
        GIR_EraseRootFromParent_Done,
      // Label 181: @6206
      GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(6254), // Rule ID 3308 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:2:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:2:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1:$pred:2:x, GPR:{ *:[i64] }:$rs2:$pred:2:y)<<P:2:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3308,
        GIR_EraseRootFromParent_Done,
      // Label 182: @6254
      GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(6302), // Rule ID 3318 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:4:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:4:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1:$pred:4:x, GPR:{ *:[i64] }:$rs2:$pred:4:y)<<P:4:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3318,
        GIR_EraseRootFromParent_Done,
      // Label 183: @6302
      GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(6350), // Rule ID 3328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1:$pred:6:x, GPR:{ *:[i64] }:$rs2:$pred:6:y)<<P:6:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3328,
        GIR_EraseRootFromParent_Done,
      // Label 184: @6350
      GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(6398), // Rule ID 3359 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:14:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:14:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_uw_op),
        // (add:{ *:[i64] } sh1add_uw_op:{ *:[i64] }:$rs1:$pred:14:x, GPR:{ *:[i64] }:$rs2:$pred:14:y)<<P:14:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } sh1add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3359,
        GIR_EraseRootFromParent_Done,
      // Label 185: @6398
      GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(6446), // Rule ID 3361 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:15:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:15:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_uw_op),
        // (add:{ *:[i64] } sh2add_uw_op:{ *:[i64] }:$rs1:$pred:15:x, GPR:{ *:[i64] }:$rs2:$pred:15:y)<<P:15:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } sh2add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3361,
        GIR_EraseRootFromParent_Done,
      // Label 186: @6446
      GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(6494), // Rule ID 3363 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:16:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:16:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_uw_op),
        // (add:{ *:[i64] } sh3add_uw_op:{ *:[i64] }:$rs1:$pred:16:x, GPR:{ *:[i64] }:$rs2:$pred:16:y)<<P:16:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } sh3add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3363,
        GIR_EraseRootFromParent_Done,
      // Label 187: @6494
      GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(6545), // Rule ID 63595 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:27:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:27:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1:$pred:27:x, GPR:{ *:[i64] }:$rs2:$pred:27:y)<<P:27:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs2, sh1add_op:{ *:[i64] }:$rs1, 1:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63595,
        GIR_EraseRootFromParent_Done,
      // Label 188: @6545
      GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(6596), // Rule ID 63597 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:28:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:28:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1:$pred:28:x, GPR:{ *:[i64] }:$rs2:$pred:28:y)<<P:28:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs2, sh2add_op:{ *:[i64] }:$rs1, 2:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63597,
        GIR_EraseRootFromParent_Done,
      // Label 189: @6596
      GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(6647), // Rule ID 63599 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:29:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:29:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1:$pred:29:x, GPR:{ *:[i64] }:$rs2:$pred:29:y)<<P:29:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs2, sh3add_op:{ *:[i64] }:$rs1, 3:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63599,
        GIR_EraseRootFromParent_Done,
      // Label 190: @6647
      GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(6695), // Rule ID 65818 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:2:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:2:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:2:y, sh1add_op:{ *:[i64] }:$rs1:$pred:2:x)<<P:2:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65818,
        GIR_EraseRootFromParent_Done,
      // Label 191: @6695
      GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(6743), // Rule ID 65826 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:4:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:4:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:4:y, sh2add_op:{ *:[i64] }:$rs1:$pred:4:x)<<P:4:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65826,
        GIR_EraseRootFromParent_Done,
      // Label 192: @6743
      GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(6791), // Rule ID 65834 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:6:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:6:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:6:y, sh3add_op:{ *:[i64] }:$rs1:$pred:6:x)<<P:6:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65834,
        GIR_EraseRootFromParent_Done,
      // Label 193: @6791
      GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(6839), // Rule ID 65851 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:14:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:14:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_uw_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:14:y, sh1add_uw_op:{ *:[i64] }:$rs1:$pred:14:x)<<P:14:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } sh1add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65851,
        GIR_EraseRootFromParent_Done,
      // Label 194: @6839
      GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(6887), // Rule ID 65853 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:15:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:15:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_uw_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:15:y, sh2add_uw_op:{ *:[i64] }:$rs1:$pred:15:x)<<P:15:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } sh2add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65853,
        GIR_EraseRootFromParent_Done,
      // Label 195: @6887
      GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(6935), // Rule ID 65855 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:16:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:16:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_uw_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:16:y, sh3add_uw_op:{ *:[i64] }:$rs1:$pred:16:x)<<P:16:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } sh3add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65855,
        GIR_EraseRootFromParent_Done,
      // Label 196: @6935
      GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(6986), // Rule ID 74313 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:27:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:27:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:27:y, sh1add_op:{ *:[i64] }:$rs1:$pred:27:x)<<P:27:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs2, sh1add_op:{ *:[i64] }:$rs1, 1:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 74313,
        GIR_EraseRootFromParent_Done,
      // Label 197: @6986
      GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(7037), // Rule ID 74315 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:28:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:28:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:28:y, sh2add_op:{ *:[i64] }:$rs1:$pred:28:x)<<P:28:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs2, sh2add_op:{ *:[i64] }:$rs1, 2:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 74315,
        GIR_EraseRootFromParent_Done,
      // Label 198: @7037
      GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(7088), // Rule ID 74317 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:29:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:29:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:29:y, sh3add_op:{ *:[i64] }:$rs1:$pred:29:x)<<P:29:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs2, sh3add_op:{ *:[i64] }:$rs1, 3:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 74317,
        GIR_EraseRootFromParent_Done,
      // Label 199: @7088
      GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(7163), // Rule ID 3341 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:7:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:7:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }):$pred:7:x, GPR:{ *:[i64] }:$rs2:$pred:7:y)<<P:7:Predicate_add_like_non_imm12>>  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3341,
        GIR_EraseRootFromParent_Done,
      // Label 200: @7163
      GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(7258), // Rule ID 3365 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:17:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967294),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:17:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967294:{ *:[i64] }):$pred:17:x, GPR:{ *:[i64] }:$rs2:$pred:17:y)<<P:17:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3365,
        GIR_EraseRootFromParent_Done,
      // Label 201: @7258
      GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(7353), // Rule ID 3367 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:18:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967292),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:18:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967292:{ *:[i64] }):$pred:18:x, GPR:{ *:[i64] }:$rs2:$pred:18:y)<<P:18:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3367,
        GIR_EraseRootFromParent_Done,
      // Label 202: @7353
      GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(7448), // Rule ID 3369 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:19:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967288),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:19:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967288:{ *:[i64] }):$pred:19:x, GPR:{ *:[i64] }:$rs2:$pred:19:y)<<P:19:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3369,
        GIR_EraseRootFromParent_Done,
      // Label 203: @7448
      GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(7543), // Rule ID 3371 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:20:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934590),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:20:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 8589934590:{ *:[i64] }):$pred:20:x, GPR:{ *:[i64] }:$rs2:$pred:20:y)<<P:20:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3371,
        GIR_EraseRootFromParent_Done,
      // Label 204: @7543
      GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(7638), // Rule ID 3373 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:21:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869180),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:21:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 17179869180:{ *:[i64] }):$pred:21:x, GPR:{ *:[i64] }:$rs2:$pred:21:y)<<P:21:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3373,
        GIR_EraseRootFromParent_Done,
      // Label 205: @7638
      GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(7733), // Rule ID 3375 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:22:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738360),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:22:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 34359738360:{ *:[i64] }):$pred:22:x, GPR:{ *:[i64] }:$rs2:$pred:22:y)<<P:22:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3375,
        GIR_EraseRootFromParent_Done,
      // Label 206: @7733
      GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(7801), // Rule ID 3302 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }):$pred:1:x, GPR:{ *:[i64] }:$rs2:$pred:1:y)<<P:1:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3302,
        GIR_EraseRootFromParent_Done,
      // Label 207: @7801
      GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(7869), // Rule ID 3312 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }):$pred:3:x, GPR:{ *:[i64] }:$rs2:$pred:3:y)<<P:3:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3312,
        GIR_EraseRootFromParent_Done,
      // Label 208: @7869
      GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(7937), // Rule ID 3322 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }):$pred:5:x, GPR:{ *:[i64] }:$rs2:$pred:5:y)<<P:5:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3322,
        GIR_EraseRootFromParent_Done,
      // Label 209: @7937
      GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(8012), // Rule ID 65837 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:7:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:7:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:7:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }):$pred:7:x)<<P:7:Predicate_add_like_non_imm12>>  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65837,
        GIR_EraseRootFromParent_Done,
      // Label 210: @8012
      GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(8107), // Rule ID 65857 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:17:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:17:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967294),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:17:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967294:{ *:[i64] }):$pred:17:x)<<P:17:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65857,
        GIR_EraseRootFromParent_Done,
      // Label 211: @8107
      GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(8202), // Rule ID 65859 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:18:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:18:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967292),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:18:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967292:{ *:[i64] }):$pred:18:x)<<P:18:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65859,
        GIR_EraseRootFromParent_Done,
      // Label 212: @8202
      GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(8297), // Rule ID 65861 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:19:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:19:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967288),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:19:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967288:{ *:[i64] }):$pred:19:x)<<P:19:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65861,
        GIR_EraseRootFromParent_Done,
      // Label 213: @8297
      GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(8392), // Rule ID 65863 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:20:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:20:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934590),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:20:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 8589934590:{ *:[i64] }):$pred:20:x)<<P:20:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65863,
        GIR_EraseRootFromParent_Done,
      // Label 214: @8392
      GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(8487), // Rule ID 65865 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:21:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:21:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869180),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:21:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 17179869180:{ *:[i64] }):$pred:21:x)<<P:21:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65865,
        GIR_EraseRootFromParent_Done,
      // Label 215: @8487
      GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(8582), // Rule ID 65867 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:22:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:22:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738360),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:22:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 34359738360:{ *:[i64] }):$pred:22:x)<<P:22:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65867,
        GIR_EraseRootFromParent_Done,
      // Label 216: @8582
      GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(8650), // Rule ID 65814 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:1:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }):$pred:1:x)<<P:1:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65814,
        GIR_EraseRootFromParent_Done,
      // Label 217: @8650
      GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(8718), // Rule ID 65822 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:3:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:3:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }):$pred:3:x)<<P:3:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65822,
        GIR_EraseRootFromParent_Done,
      // Label 218: @8718
      GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(8786), // Rule ID 65830 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:5:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }):$pred:5:x)<<P:5:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65830,
        GIR_EraseRootFromParent_Done,
      // Label 219: @8786
      GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(8853), // Rule ID 74311 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2), GPR:{ *:[i64] }:$rs1)  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 74311,
        GIR_EraseRootFromParent_Done,
      // Label 220: @8853
      GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(8920), // Rule ID 63591 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2))  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63591,
        GIR_EraseRootFromParent_Done,
      // Label 221: @8920
      GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(8980), // Rule ID 3421 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:23:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:23:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (zext:{ *:[i64] } GPR:{ *:[i32] }:$rs1):$pred:23:x, GPR:{ *:[i64] }:$rs2:$pred:23:y)<<P:23:Predicate_add_like_non_imm12>>  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3421,
        GIR_EraseRootFromParent_Done,
      // Label 222: @8980
      GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(9040), // Rule ID 65884 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:23:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:23:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:23:y, (zext:{ *:[i64] } GPR:{ *:[i32] }:$rs1):$pred:23:x)<<P:23:Predicate_add_like_non_imm12>>  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65884,
        GIR_EraseRootFromParent_Done,
      // Label 223: @9040
      GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(9082), // Rule ID 661 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ADDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 661,
        GIR_EraseRootFromParent_Done,
      // Label 224: @9082
      GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(9143), // Rule ID 74319 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2), GPR:{ *:[i64] }:$rd)  =>  (TH_MULA:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/2, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 74319,
        GIR_EraseRootFromParent_Done,
      // Label 225: @9143
      GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(9204), // Rule ID 63651 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rd, (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2))  =>  (TH_MULA:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63651,
        GIR_EraseRootFromParent_Done,
      // Label 226: @9204
      GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(9231), // Rule ID 659 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADD),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 659,
        GIR_Done,
      // Label 227: @9231
      GIM_Reject,
    // Label 169: @9232
    GIM_Reject,
    // Label 102: @9233
    GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(9347),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(9301), // Rule ID 47171 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVADD_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47171,
        GIR_EraseRootFromParent_Done,
      // Label 229: @9301
      GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(9346), // Rule ID 47172 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVADD_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47172,
        GIR_EraseRootFromParent_Done,
      // Label 230: @9346
      GIM_Reject,
    // Label 228: @9347
    GIM_Reject,
    // Label 103: @9348
    GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(9462),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(9416), // Rule ID 47551 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47551,
        GIR_EraseRootFromParent_Done,
      // Label 232: @9416
      GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(9461), // Rule ID 47552 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47552,
        GIR_EraseRootFromParent_Done,
      // Label 233: @9461
      GIM_Reject,
    // Label 231: @9462
    GIM_Reject,
    // Label 104: @9463
    GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(9577),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(9531), // Rule ID 47559 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47559,
        GIR_EraseRootFromParent_Done,
      // Label 235: @9531
      GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(9576), // Rule ID 47560 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47560,
        GIR_EraseRootFromParent_Done,
      // Label 236: @9576
      GIM_Reject,
    // Label 234: @9577
    GIM_Reject,
    // Label 105: @9578
    GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(9692),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(9646), // Rule ID 47575 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47575,
        GIR_EraseRootFromParent_Done,
      // Label 238: @9646
      GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(9691), // Rule ID 47576 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47576,
        GIR_EraseRootFromParent_Done,
      // Label 239: @9691
      GIM_Reject,
    // Label 237: @9692
    GIM_Reject,
    // Label 106: @9693
    GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(9807),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(9761), // Rule ID 47543 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47543,
        GIR_EraseRootFromParent_Done,
      // Label 241: @9761
      GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(9806), // Rule ID 47544 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47544,
        GIR_EraseRootFromParent_Done,
      // Label 242: @9806
      GIM_Reject,
    // Label 240: @9807
    GIM_Reject,
    // Label 107: @9808
    GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(9922),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(9876), // Rule ID 47555 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47555,
        GIR_EraseRootFromParent_Done,
      // Label 244: @9876
      GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(9921), // Rule ID 47556 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47556,
        GIR_EraseRootFromParent_Done,
      // Label 245: @9921
      GIM_Reject,
    // Label 243: @9922
    GIM_Reject,
    // Label 108: @9923
    GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(10037),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(9991), // Rule ID 47571 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47571,
        GIR_EraseRootFromParent_Done,
      // Label 247: @9991
      GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(10036), // Rule ID 47572 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47572,
        GIR_EraseRootFromParent_Done,
      // Label 248: @10036
      GIM_Reject,
    // Label 246: @10037
    GIM_Reject,
    // Label 109: @10038
    GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(10152),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(10106), // Rule ID 47615 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47615,
        GIR_EraseRootFromParent_Done,
      // Label 250: @10106
      GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(10151), // Rule ID 47616 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47616,
        GIR_EraseRootFromParent_Done,
      // Label 251: @10151
      GIM_Reject,
    // Label 249: @10152
    GIM_Reject,
    // Label 110: @10153
    GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(10267),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(10221), // Rule ID 47547 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47547,
        GIR_EraseRootFromParent_Done,
      // Label 253: @10221
      GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(10266), // Rule ID 47548 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47548,
        GIR_EraseRootFromParent_Done,
      // Label 254: @10266
      GIM_Reject,
    // Label 252: @10267
    GIM_Reject,
    // Label 111: @10268
    GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(10382),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(10336), // Rule ID 47567 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47567,
        GIR_EraseRootFromParent_Done,
      // Label 256: @10336
      GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(10381), // Rule ID 47568 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47568,
        GIR_EraseRootFromParent_Done,
      // Label 257: @10381
      GIM_Reject,
    // Label 255: @10382
    GIM_Reject,
    // Label 112: @10383
    GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(10497),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(10451), // Rule ID 47603 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47603,
        GIR_EraseRootFromParent_Done,
      // Label 259: @10451
      GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(10496), // Rule ID 47604 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47604,
        GIR_EraseRootFromParent_Done,
      // Label 260: @10496
      GIM_Reject,
    // Label 258: @10497
    GIM_Reject,
    // Label 113: @10498
    GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(10612),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(10566), // Rule ID 47619 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (add:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47619,
        GIR_EraseRootFromParent_Done,
      // Label 262: @10566
      GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(10611), // Rule ID 47620 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (add:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47620,
        GIR_EraseRootFromParent_Done,
      // Label 263: @10611
      GIM_Reject,
    // Label 261: @10612
    GIM_Reject,
    // Label 114: @10613
    GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(10727),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(10681), // Rule ID 47563 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47563,
        GIR_EraseRootFromParent_Done,
      // Label 265: @10681
      GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(10726), // Rule ID 47564 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47564,
        GIR_EraseRootFromParent_Done,
      // Label 266: @10726
      GIM_Reject,
    // Label 264: @10727
    GIM_Reject,
    // Label 115: @10728
    GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(10842),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(10796), // Rule ID 47591 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47591,
        GIR_EraseRootFromParent_Done,
      // Label 268: @10796
      GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(10841), // Rule ID 47592 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47592,
        GIR_EraseRootFromParent_Done,
      // Label 269: @10841
      GIM_Reject,
    // Label 267: @10842
    GIM_Reject,
    // Label 116: @10843
    GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(10957),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(10911), // Rule ID 47607 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47607,
        GIR_EraseRootFromParent_Done,
      // Label 271: @10911
      GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(10956), // Rule ID 47608 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47608,
        GIR_EraseRootFromParent_Done,
      // Label 272: @10956
      GIM_Reject,
    // Label 270: @10957
    GIM_Reject,
    // Label 117: @10958
    GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(11072),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(11026), // Rule ID 47623 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (add:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47623,
        GIR_EraseRootFromParent_Done,
      // Label 274: @11026
      GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(11071), // Rule ID 47624 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (add:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47624,
        GIR_EraseRootFromParent_Done,
      // Label 275: @11071
      GIM_Reject,
    // Label 273: @11072
    GIM_Reject,
    // Label 118: @11073
    GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(11187),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(11141), // Rule ID 47579 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47579,
        GIR_EraseRootFromParent_Done,
      // Label 277: @11141
      GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(11186), // Rule ID 47580 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47580,
        GIR_EraseRootFromParent_Done,
      // Label 278: @11186
      GIM_Reject,
    // Label 276: @11187
    GIM_Reject,
    // Label 119: @11188
    GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(11302),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(11256), // Rule ID 47595 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47595,
        GIR_EraseRootFromParent_Done,
      // Label 280: @11256
      GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(11301), // Rule ID 47596 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47596,
        GIR_EraseRootFromParent_Done,
      // Label 281: @11301
      GIM_Reject,
    // Label 279: @11302
    GIM_Reject,
    // Label 120: @11303
    GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(11417),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(11371), // Rule ID 47611 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47611,
        GIR_EraseRootFromParent_Done,
      // Label 283: @11371
      GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(11416), // Rule ID 47612 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47612,
        GIR_EraseRootFromParent_Done,
      // Label 284: @11416
      GIM_Reject,
    // Label 282: @11417
    GIM_Reject,
    // Label 121: @11418
    GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(11532),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(11486), // Rule ID 47583 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47583,
        GIR_EraseRootFromParent_Done,
      // Label 286: @11486
      GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(11531), // Rule ID 47584 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47584,
        GIR_EraseRootFromParent_Done,
      // Label 287: @11531
      GIM_Reject,
    // Label 285: @11532
    GIM_Reject,
    // Label 122: @11533
    GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(11647),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(11601), // Rule ID 47599 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47599,
        GIR_EraseRootFromParent_Done,
      // Label 289: @11601
      GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(11646), // Rule ID 47600 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47600,
        GIR_EraseRootFromParent_Done,
      // Label 290: @11646
      GIM_Reject,
    // Label 288: @11647
    GIM_Reject,
    // Label 123: @11648
    GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(11762),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(11716), // Rule ID 47587 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47587,
        GIR_EraseRootFromParent_Done,
      // Label 292: @11716
      GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(11761), // Rule ID 47588 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47588,
        GIR_EraseRootFromParent_Done,
      // Label 293: @11761
      GIM_Reject,
    // Label 291: @11762
    GIM_Reject,
    // Label 124: @11763
    GIM_Reject,
    // Label 1: @11764
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 318*/ GIMT_Encode4(14867),
    /*GILLT_s32*//*Label 294*/ GIMT_Encode4(11899),
    /*GILLT_s64*//*Label 295*/ GIMT_Encode4(12208), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 296*/ GIMT_Encode4(12337),
    /*GILLT_nxv1s16*//*Label 297*/ GIMT_Encode4(12452),
    /*GILLT_nxv1s32*//*Label 298*/ GIMT_Encode4(12567),
    /*GILLT_nxv1s64*//*Label 299*/ GIMT_Encode4(12682), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 300*/ GIMT_Encode4(12797),
    /*GILLT_nxv2s16*//*Label 301*/ GIMT_Encode4(12912),
    /*GILLT_nxv2s32*//*Label 302*/ GIMT_Encode4(13027),
    /*GILLT_nxv2s64*//*Label 303*/ GIMT_Encode4(13142), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 304*/ GIMT_Encode4(13257),
    /*GILLT_nxv4s16*//*Label 305*/ GIMT_Encode4(13372),
    /*GILLT_nxv4s32*//*Label 306*/ GIMT_Encode4(13487),
    /*GILLT_nxv4s64*//*Label 307*/ GIMT_Encode4(13602), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 308*/ GIMT_Encode4(13717),
    /*GILLT_nxv8s16*//*Label 309*/ GIMT_Encode4(13832),
    /*GILLT_nxv8s32*//*Label 310*/ GIMT_Encode4(13947),
    /*GILLT_nxv8s64*//*Label 311*/ GIMT_Encode4(14062), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 312*/ GIMT_Encode4(14177),
    /*GILLT_nxv16s16*//*Label 313*/ GIMT_Encode4(14292),
    /*GILLT_nxv16s32*//*Label 314*/ GIMT_Encode4(14407), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 315*/ GIMT_Encode4(14522),
    /*GILLT_nxv32s16*//*Label 316*/ GIMT_Encode4(14637), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 317*/ GIMT_Encode4(14752),
    // Label 294: @11899
    GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(12207),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(11954), // Rule ID 65636 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12Plus1),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12Plus1>>:$imm)  =>  (ADDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (NegImm:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_simm12Plus1>>:$imm))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegImm), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65636,
        GIR_EraseRootFromParent_Done,
      // Label 320: @11954
      GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(11990), // Rule ID 65637 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12Plus1i32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12Plus1i32>>:$imm)  =>  (ADDIW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (NegImm:{ *:[i64] } ?:{ *:[i32] }:$imm))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDIW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegImm), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65637,
        GIR_EraseRootFromParent_Done,
      // Label 321: @11990
      GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(12043), // Rule ID 63654 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULS:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63654,
        GIR_EraseRootFromParent_Done,
      // Label 322: @12043
      GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(12096), // Rule ID 63911 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULSW:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULSW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63911,
        GIR_EraseRootFromParent_Done,
      // Label 323: @12096
      GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(12149), // Rule ID 63912 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_IsRV64_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULSW:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULSW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63912,
        GIR_EraseRootFromParent_Done,
      // Label 324: @12149
      GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(12168), // Rule ID 664 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (SUB:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SUB),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 664,
        GIR_Done,
      // Label 325: @12168
      GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(12187), // Rule ID 892 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (SUBW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SUBW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 892,
        GIR_Done,
      // Label 326: @12187
      GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(12206), // Rule ID 893 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (SUBW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SUBW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 893,
        GIR_Done,
      // Label 327: @12206
      GIM_Reject,
    // Label 319: @12207
    GIM_Reject,
    // Label 295: @12208
    GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(12336),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(12263), // Rule ID 65635 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12Plus1),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12Plus1>>:$imm)  =>  (ADDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (NegImm:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_simm12Plus1>>:$imm))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegImm), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65635,
        GIR_EraseRootFromParent_Done,
      // Label 329: @12263
      GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(12316), // Rule ID 63653 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } GPR:{ *:[i64] }:$rd, (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2))  =>  (TH_MULS:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63653,
        GIR_EraseRootFromParent_Done,
      // Label 330: @12316
      GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(12335), // Rule ID 663 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (sub:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (SUB:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SUB),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 663,
        GIR_Done,
      // Label 331: @12335
      GIM_Reject,
    // Label 328: @12336
    GIM_Reject,
    // Label 296: @12337
    GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(12451),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(12405), // Rule ID 47669 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVSUB_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47669,
        GIR_EraseRootFromParent_Done,
      // Label 333: @12405
      GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(12450), // Rule ID 47670 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVSUB_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47670,
        GIR_EraseRootFromParent_Done,
      // Label 334: @12450
      GIM_Reject,
    // Label 332: @12451
    GIM_Reject,
    // Label 297: @12452
    GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(12566),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(12520), // Rule ID 47681 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47681,
        GIR_EraseRootFromParent_Done,
      // Label 336: @12520
      GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(12565), // Rule ID 47682 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47682,
        GIR_EraseRootFromParent_Done,
      // Label 337: @12565
      GIM_Reject,
    // Label 335: @12566
    GIM_Reject,
    // Label 298: @12567
    GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(12681),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(12635), // Rule ID 47689 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47689,
        GIR_EraseRootFromParent_Done,
      // Label 339: @12635
      GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(12680), // Rule ID 47690 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47690,
        GIR_EraseRootFromParent_Done,
      // Label 340: @12680
      GIM_Reject,
    // Label 338: @12681
    GIM_Reject,
    // Label 299: @12682
    GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(12796),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(12750), // Rule ID 47705 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sub:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47705,
        GIR_EraseRootFromParent_Done,
      // Label 342: @12750
      GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(12795), // Rule ID 47706 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sub:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47706,
        GIR_EraseRootFromParent_Done,
      // Label 343: @12795
      GIM_Reject,
    // Label 341: @12796
    GIM_Reject,
    // Label 300: @12797
    GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(12911),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(12865), // Rule ID 47673 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47673,
        GIR_EraseRootFromParent_Done,
      // Label 345: @12865
      GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(12910), // Rule ID 47674 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47674,
        GIR_EraseRootFromParent_Done,
      // Label 346: @12910
      GIM_Reject,
    // Label 344: @12911
    GIM_Reject,
    // Label 301: @12912
    GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(13026),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(12980), // Rule ID 47685 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47685,
        GIR_EraseRootFromParent_Done,
      // Label 348: @12980
      GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(13025), // Rule ID 47686 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47686,
        GIR_EraseRootFromParent_Done,
      // Label 349: @13025
      GIM_Reject,
    // Label 347: @13026
    GIM_Reject,
    // Label 302: @13027
    GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(13141),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(13095), // Rule ID 47701 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47701,
        GIR_EraseRootFromParent_Done,
      // Label 351: @13095
      GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(13140), // Rule ID 47702 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47702,
        GIR_EraseRootFromParent_Done,
      // Label 352: @13140
      GIM_Reject,
    // Label 350: @13141
    GIM_Reject,
    // Label 303: @13142
    GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(13256),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(13210), // Rule ID 47745 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sub:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47745,
        GIR_EraseRootFromParent_Done,
      // Label 354: @13210
      GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(13255), // Rule ID 47746 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sub:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47746,
        GIR_EraseRootFromParent_Done,
      // Label 355: @13255
      GIM_Reject,
    // Label 353: @13256
    GIM_Reject,
    // Label 304: @13257
    GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(13371),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(13325), // Rule ID 47677 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47677,
        GIR_EraseRootFromParent_Done,
      // Label 357: @13325
      GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(13370), // Rule ID 47678 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47678,
        GIR_EraseRootFromParent_Done,
      // Label 358: @13370
      GIM_Reject,
    // Label 356: @13371
    GIM_Reject,
    // Label 305: @13372
    GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(13486),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(13440), // Rule ID 47697 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47697,
        GIR_EraseRootFromParent_Done,
      // Label 360: @13440
      GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(13485), // Rule ID 47698 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47698,
        GIR_EraseRootFromParent_Done,
      // Label 361: @13485
      GIM_Reject,
    // Label 359: @13486
    GIM_Reject,
    // Label 306: @13487
    GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(13601),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(13555), // Rule ID 47733 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47733,
        GIR_EraseRootFromParent_Done,
      // Label 363: @13555
      GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(13600), // Rule ID 47734 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47734,
        GIR_EraseRootFromParent_Done,
      // Label 364: @13600
      GIM_Reject,
    // Label 362: @13601
    GIM_Reject,
    // Label 307: @13602
    GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(13716),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(13670), // Rule ID 47749 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sub:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47749,
        GIR_EraseRootFromParent_Done,
      // Label 366: @13670
      GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(13715), // Rule ID 47750 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sub:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47750,
        GIR_EraseRootFromParent_Done,
      // Label 367: @13715
      GIM_Reject,
    // Label 365: @13716
    GIM_Reject,
    // Label 308: @13717
    GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(13831),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(13785), // Rule ID 47693 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47693,
        GIR_EraseRootFromParent_Done,
      // Label 369: @13785
      GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(13830), // Rule ID 47694 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47694,
        GIR_EraseRootFromParent_Done,
      // Label 370: @13830
      GIM_Reject,
    // Label 368: @13831
    GIM_Reject,
    // Label 309: @13832
    GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(13946),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(13900), // Rule ID 47721 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47721,
        GIR_EraseRootFromParent_Done,
      // Label 372: @13900
      GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(13945), // Rule ID 47722 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47722,
        GIR_EraseRootFromParent_Done,
      // Label 373: @13945
      GIM_Reject,
    // Label 371: @13946
    GIM_Reject,
    // Label 310: @13947
    GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(14061),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(14015), // Rule ID 47737 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47737,
        GIR_EraseRootFromParent_Done,
      // Label 375: @14015
      GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(14060), // Rule ID 47738 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47738,
        GIR_EraseRootFromParent_Done,
      // Label 376: @14060
      GIM_Reject,
    // Label 374: @14061
    GIM_Reject,
    // Label 311: @14062
    GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(14176),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(14130), // Rule ID 47753 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sub:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47753,
        GIR_EraseRootFromParent_Done,
      // Label 378: @14130
      GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(14175), // Rule ID 47754 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sub:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47754,
        GIR_EraseRootFromParent_Done,
      // Label 379: @14175
      GIM_Reject,
    // Label 377: @14176
    GIM_Reject,
    // Label 312: @14177
    GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(14291),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(14245), // Rule ID 47709 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47709,
        GIR_EraseRootFromParent_Done,
      // Label 381: @14245
      GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(14290), // Rule ID 47710 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47710,
        GIR_EraseRootFromParent_Done,
      // Label 382: @14290
      GIM_Reject,
    // Label 380: @14291
    GIM_Reject,
    // Label 313: @14292
    GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(14406),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(14360), // Rule ID 47725 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47725,
        GIR_EraseRootFromParent_Done,
      // Label 384: @14360
      GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(14405), // Rule ID 47726 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47726,
        GIR_EraseRootFromParent_Done,
      // Label 385: @14405
      GIM_Reject,
    // Label 383: @14406
    GIM_Reject,
    // Label 314: @14407
    GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(14521),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(14475), // Rule ID 47741 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47741,
        GIR_EraseRootFromParent_Done,
      // Label 387: @14475
      GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(14520), // Rule ID 47742 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47742,
        GIR_EraseRootFromParent_Done,
      // Label 388: @14520
      GIM_Reject,
    // Label 386: @14521
    GIM_Reject,
    // Label 315: @14522
    GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(14636),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(14590), // Rule ID 47713 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47713,
        GIR_EraseRootFromParent_Done,
      // Label 390: @14590
      GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(14635), // Rule ID 47714 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47714,
        GIR_EraseRootFromParent_Done,
      // Label 391: @14635
      GIM_Reject,
    // Label 389: @14636
    GIM_Reject,
    // Label 316: @14637
    GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(14751),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(14705), // Rule ID 47729 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47729,
        GIR_EraseRootFromParent_Done,
      // Label 393: @14705
      GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(14750), // Rule ID 47730 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47730,
        GIR_EraseRootFromParent_Done,
      // Label 394: @14750
      GIM_Reject,
    // Label 392: @14751
    GIM_Reject,
    // Label 317: @14752
    GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(14866),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(14820), // Rule ID 47717 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47717,
        GIR_EraseRootFromParent_Done,
      // Label 396: @14820
      GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(14865), // Rule ID 47718 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47718,
        GIR_EraseRootFromParent_Done,
      // Label 397: @14865
      GIM_Reject,
    // Label 395: @14866
    GIM_Reject,
    // Label 318: @14867
    GIM_Reject,
    // Label 2: @14868
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 422*/ GIMT_Encode4(17772),
    /*GILLT_s32*//*Label 398*/ GIMT_Encode4(15003),
    /*GILLT_s64*//*Label 399*/ GIMT_Encode4(15073), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 400*/ GIMT_Encode4(15242),
    /*GILLT_nxv1s16*//*Label 401*/ GIMT_Encode4(15357),
    /*GILLT_nxv1s32*//*Label 402*/ GIMT_Encode4(15472),
    /*GILLT_nxv1s64*//*Label 403*/ GIMT_Encode4(15587), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 404*/ GIMT_Encode4(15702),
    /*GILLT_nxv2s16*//*Label 405*/ GIMT_Encode4(15817),
    /*GILLT_nxv2s32*//*Label 406*/ GIMT_Encode4(15932),
    /*GILLT_nxv2s64*//*Label 407*/ GIMT_Encode4(16047), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 408*/ GIMT_Encode4(16162),
    /*GILLT_nxv4s16*//*Label 409*/ GIMT_Encode4(16277),
    /*GILLT_nxv4s32*//*Label 410*/ GIMT_Encode4(16392),
    /*GILLT_nxv4s64*//*Label 411*/ GIMT_Encode4(16507), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 412*/ GIMT_Encode4(16622),
    /*GILLT_nxv8s16*//*Label 413*/ GIMT_Encode4(16737),
    /*GILLT_nxv8s32*//*Label 414*/ GIMT_Encode4(16852),
    /*GILLT_nxv8s64*//*Label 415*/ GIMT_Encode4(16967), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 416*/ GIMT_Encode4(17082),
    /*GILLT_nxv16s16*//*Label 417*/ GIMT_Encode4(17197),
    /*GILLT_nxv16s32*//*Label 418*/ GIMT_Encode4(17312), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 419*/ GIMT_Encode4(17427),
    /*GILLT_nxv32s16*//*Label 420*/ GIMT_Encode4(17542), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 421*/ GIMT_Encode4(17657),
    // Label 398: @15003
    GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(15072),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(15041), // Rule ID 918 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZmmul_HwMode1),
        // (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (MUL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::MUL),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 918,
        GIR_Done,
      // Label 424: @15041
      GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(15056), // Rule ID 941 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZmmul_IsRV64_HwMode0),
        // (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (MULW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::MULW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 941,
        GIR_Done,
      // Label 425: @15056
      GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(15071), // Rule ID 942 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZmmul_IsRV64_HwMode1),
        // (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (MULW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::MULW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 942,
        GIR_Done,
      // Label 426: @15071
      GIM_Reject,
    // Label 423: @15072
    GIM_Reject,
    // Label 399: @15073
    GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(15241),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(15217), // Rule ID 940 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZmmul_IsRV64_NotHasStdExtZba_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 4294967295:{ *:[i64] }))  =>  (MULHU:{ *:[i64] } (SLLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }), (SLLI:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 32:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(RISCV::SLLI),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/2, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SLLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::MULHU),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 940,
        GIR_EraseRootFromParent_Done,
      // Label 428: @15217
      GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(15240), // Rule ID 917 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZmmul_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (MUL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::MUL),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 917,
        GIR_Done,
      // Label 429: @15240
      GIM_Reject,
    // Label 427: @15241
    GIM_Reject,
    // Label 400: @15242
    GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(15356),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(15310), // Rule ID 52073 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVMUL_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52073,
        GIR_EraseRootFromParent_Done,
      // Label 431: @15310
      GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(15355), // Rule ID 52074 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVMUL_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52074,
        GIR_EraseRootFromParent_Done,
      // Label 432: @15355
      GIM_Reject,
    // Label 430: @15356
    GIM_Reject,
    // Label 401: @15357
    GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(15471),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(15425), // Rule ID 52085 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52085,
        GIR_EraseRootFromParent_Done,
      // Label 434: @15425
      GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(15470), // Rule ID 52086 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52086,
        GIR_EraseRootFromParent_Done,
      // Label 435: @15470
      GIM_Reject,
    // Label 433: @15471
    GIM_Reject,
    // Label 402: @15472
    GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(15586),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(15540), // Rule ID 52093 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52093,
        GIR_EraseRootFromParent_Done,
      // Label 437: @15540
      GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(15585), // Rule ID 52094 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52094,
        GIR_EraseRootFromParent_Done,
      // Label 438: @15585
      GIM_Reject,
    // Label 436: @15586
    GIM_Reject,
    // Label 403: @15587
    GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(15701),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(15655), // Rule ID 52109 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52109,
        GIR_EraseRootFromParent_Done,
      // Label 440: @15655
      GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(15700), // Rule ID 52110 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52110,
        GIR_EraseRootFromParent_Done,
      // Label 441: @15700
      GIM_Reject,
    // Label 439: @15701
    GIM_Reject,
    // Label 404: @15702
    GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(15816),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(15770), // Rule ID 52077 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52077,
        GIR_EraseRootFromParent_Done,
      // Label 443: @15770
      GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(15815), // Rule ID 52078 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52078,
        GIR_EraseRootFromParent_Done,
      // Label 444: @15815
      GIM_Reject,
    // Label 442: @15816
    GIM_Reject,
    // Label 405: @15817
    GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(15931),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(15885), // Rule ID 52089 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52089,
        GIR_EraseRootFromParent_Done,
      // Label 446: @15885
      GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(15930), // Rule ID 52090 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52090,
        GIR_EraseRootFromParent_Done,
      // Label 447: @15930
      GIM_Reject,
    // Label 445: @15931
    GIM_Reject,
    // Label 406: @15932
    GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(16046),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(16000), // Rule ID 52105 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52105,
        GIR_EraseRootFromParent_Done,
      // Label 449: @16000
      GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(16045), // Rule ID 52106 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52106,
        GIR_EraseRootFromParent_Done,
      // Label 450: @16045
      GIM_Reject,
    // Label 448: @16046
    GIM_Reject,
    // Label 407: @16047
    GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(16161),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(16115), // Rule ID 52149 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52149,
        GIR_EraseRootFromParent_Done,
      // Label 452: @16115
      GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(16160), // Rule ID 52150 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52150,
        GIR_EraseRootFromParent_Done,
      // Label 453: @16160
      GIM_Reject,
    // Label 451: @16161
    GIM_Reject,
    // Label 408: @16162
    GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(16276),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(16230), // Rule ID 52081 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52081,
        GIR_EraseRootFromParent_Done,
      // Label 455: @16230
      GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(16275), // Rule ID 52082 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52082,
        GIR_EraseRootFromParent_Done,
      // Label 456: @16275
      GIM_Reject,
    // Label 454: @16276
    GIM_Reject,
    // Label 409: @16277
    GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(16391),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(16345), // Rule ID 52101 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52101,
        GIR_EraseRootFromParent_Done,
      // Label 458: @16345
      GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(16390), // Rule ID 52102 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52102,
        GIR_EraseRootFromParent_Done,
      // Label 459: @16390
      GIM_Reject,
    // Label 457: @16391
    GIM_Reject,
    // Label 410: @16392
    GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(16506),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(16460), // Rule ID 52137 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52137,
        GIR_EraseRootFromParent_Done,
      // Label 461: @16460
      GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(16505), // Rule ID 52138 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52138,
        GIR_EraseRootFromParent_Done,
      // Label 462: @16505
      GIM_Reject,
    // Label 460: @16506
    GIM_Reject,
    // Label 411: @16507
    GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(16621),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(16575), // Rule ID 52153 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (mul:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52153,
        GIR_EraseRootFromParent_Done,
      // Label 464: @16575
      GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(16620), // Rule ID 52154 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (mul:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52154,
        GIR_EraseRootFromParent_Done,
      // Label 465: @16620
      GIM_Reject,
    // Label 463: @16621
    GIM_Reject,
    // Label 412: @16622
    GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(16736),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(16690), // Rule ID 52097 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52097,
        GIR_EraseRootFromParent_Done,
      // Label 467: @16690
      GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(16735), // Rule ID 52098 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52098,
        GIR_EraseRootFromParent_Done,
      // Label 468: @16735
      GIM_Reject,
    // Label 466: @16736
    GIM_Reject,
    // Label 413: @16737
    GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(16851),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(16805), // Rule ID 52125 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52125,
        GIR_EraseRootFromParent_Done,
      // Label 470: @16805
      GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(16850), // Rule ID 52126 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52126,
        GIR_EraseRootFromParent_Done,
      // Label 471: @16850
      GIM_Reject,
    // Label 469: @16851
    GIM_Reject,
    // Label 414: @16852
    GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(16966),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(16920), // Rule ID 52141 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52141,
        GIR_EraseRootFromParent_Done,
      // Label 473: @16920
      GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(16965), // Rule ID 52142 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52142,
        GIR_EraseRootFromParent_Done,
      // Label 474: @16965
      GIM_Reject,
    // Label 472: @16966
    GIM_Reject,
    // Label 415: @16967
    GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(17081),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(17035), // Rule ID 52157 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (mul:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52157,
        GIR_EraseRootFromParent_Done,
      // Label 476: @17035
      GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(17080), // Rule ID 52158 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (mul:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52158,
        GIR_EraseRootFromParent_Done,
      // Label 477: @17080
      GIM_Reject,
    // Label 475: @17081
    GIM_Reject,
    // Label 416: @17082
    GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(17196),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(17150), // Rule ID 52113 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52113,
        GIR_EraseRootFromParent_Done,
      // Label 479: @17150
      GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(17195), // Rule ID 52114 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52114,
        GIR_EraseRootFromParent_Done,
      // Label 480: @17195
      GIM_Reject,
    // Label 478: @17196
    GIM_Reject,
    // Label 417: @17197
    GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(17311),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(17265), // Rule ID 52129 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52129,
        GIR_EraseRootFromParent_Done,
      // Label 482: @17265
      GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(17310), // Rule ID 52130 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52130,
        GIR_EraseRootFromParent_Done,
      // Label 483: @17310
      GIM_Reject,
    // Label 481: @17311
    GIM_Reject,
    // Label 418: @17312
    GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(17426),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(17380), // Rule ID 52145 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52145,
        GIR_EraseRootFromParent_Done,
      // Label 485: @17380
      GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(17425), // Rule ID 52146 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52146,
        GIR_EraseRootFromParent_Done,
      // Label 486: @17425
      GIM_Reject,
    // Label 484: @17426
    GIM_Reject,
    // Label 419: @17427
    GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(17541),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(17495), // Rule ID 52117 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52117,
        GIR_EraseRootFromParent_Done,
      // Label 488: @17495
      GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(17540), // Rule ID 52118 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52118,
        GIR_EraseRootFromParent_Done,
      // Label 489: @17540
      GIM_Reject,
    // Label 487: @17541
    GIM_Reject,
    // Label 420: @17542
    GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(17656),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(17610), // Rule ID 52133 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52133,
        GIR_EraseRootFromParent_Done,
      // Label 491: @17610
      GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(17655), // Rule ID 52134 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52134,
        GIR_EraseRootFromParent_Done,
      // Label 492: @17655
      GIM_Reject,
    // Label 490: @17656
    GIM_Reject,
    // Label 421: @17657
    GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(17771),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(17725), // Rule ID 52121 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52121,
        GIR_EraseRootFromParent_Done,
      // Label 494: @17725
      GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(17770), // Rule ID 52122 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52122,
        GIR_EraseRootFromParent_Done,
      // Label 495: @17770
      GIM_Reject,
    // Label 493: @17771
    GIM_Reject,
    // Label 422: @17772
    GIM_Reject,
    // Label 3: @17773
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 520*/ GIMT_Encode4(20542),
    /*GILLT_s32*//*Label 496*/ GIMT_Encode4(17908),
    /*GILLT_s64*//*Label 497*/ GIMT_Encode4(17978), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 498*/ GIMT_Encode4(18012),
    /*GILLT_nxv1s16*//*Label 499*/ GIMT_Encode4(18127),
    /*GILLT_nxv1s32*//*Label 500*/ GIMT_Encode4(18242),
    /*GILLT_nxv1s64*//*Label 501*/ GIMT_Encode4(18357), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 502*/ GIMT_Encode4(18472),
    /*GILLT_nxv2s16*//*Label 503*/ GIMT_Encode4(18587),
    /*GILLT_nxv2s32*//*Label 504*/ GIMT_Encode4(18702),
    /*GILLT_nxv2s64*//*Label 505*/ GIMT_Encode4(18817), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 506*/ GIMT_Encode4(18932),
    /*GILLT_nxv4s16*//*Label 507*/ GIMT_Encode4(19047),
    /*GILLT_nxv4s32*//*Label 508*/ GIMT_Encode4(19162),
    /*GILLT_nxv4s64*//*Label 509*/ GIMT_Encode4(19277), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 510*/ GIMT_Encode4(19392),
    /*GILLT_nxv8s16*//*Label 511*/ GIMT_Encode4(19507),
    /*GILLT_nxv8s32*//*Label 512*/ GIMT_Encode4(19622),
    /*GILLT_nxv8s64*//*Label 513*/ GIMT_Encode4(19737), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 514*/ GIMT_Encode4(19852),
    /*GILLT_nxv16s16*//*Label 515*/ GIMT_Encode4(19967),
    /*GILLT_nxv16s32*//*Label 516*/ GIMT_Encode4(20082), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 517*/ GIMT_Encode4(20197),
    /*GILLT_nxv32s16*//*Label 518*/ GIMT_Encode4(20312), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 519*/ GIMT_Encode4(20427),
    // Label 496: @17908
    GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(17977),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(17946), // Rule ID 926 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode1),
        // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIV:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIV),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 926,
        GIR_Done,
      // Label 522: @17946
      GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(17961), // Rule ID 943 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode0),
        // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 943,
        GIR_Done,
      // Label 523: @17961
      GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(17976), // Rule ID 944 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode1),
        // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 944,
        GIR_Done,
      // Label 524: @17976
      GIM_Reject,
    // Label 521: @17977
    GIM_Reject,
    // Label 497: @17978
    GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(18011), // Rule ID 925 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (sdiv:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (DIV:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIV),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 925,
      GIR_Done,
    // Label 525: @18011
    GIM_Reject,
    // Label 498: @18012
    GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(18126),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(18080), // Rule ID 52425 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIV_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52425,
        GIR_EraseRootFromParent_Done,
      // Label 527: @18080
      GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(18125), // Rule ID 52426 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIV_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52426,
        GIR_EraseRootFromParent_Done,
      // Label 528: @18125
      GIM_Reject,
    // Label 526: @18126
    GIM_Reject,
    // Label 499: @18127
    GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(18241),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(18195), // Rule ID 52437 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52437,
        GIR_EraseRootFromParent_Done,
      // Label 530: @18195
      GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(18240), // Rule ID 52438 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52438,
        GIR_EraseRootFromParent_Done,
      // Label 531: @18240
      GIM_Reject,
    // Label 529: @18241
    GIM_Reject,
    // Label 500: @18242
    GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(18356),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(18310), // Rule ID 52445 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52445,
        GIR_EraseRootFromParent_Done,
      // Label 533: @18310
      GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(18355), // Rule ID 52446 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52446,
        GIR_EraseRootFromParent_Done,
      // Label 534: @18355
      GIM_Reject,
    // Label 532: @18356
    GIM_Reject,
    // Label 501: @18357
    GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(18471),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(18425), // Rule ID 52461 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sdiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIV_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52461,
        GIR_EraseRootFromParent_Done,
      // Label 536: @18425
      GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(18470), // Rule ID 52462 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sdiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIV_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52462,
        GIR_EraseRootFromParent_Done,
      // Label 537: @18470
      GIM_Reject,
    // Label 535: @18471
    GIM_Reject,
    // Label 502: @18472
    GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(18586),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(18540), // Rule ID 52429 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52429,
        GIR_EraseRootFromParent_Done,
      // Label 539: @18540
      GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(18585), // Rule ID 52430 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52430,
        GIR_EraseRootFromParent_Done,
      // Label 540: @18585
      GIM_Reject,
    // Label 538: @18586
    GIM_Reject,
    // Label 503: @18587
    GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(18701),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(18655), // Rule ID 52441 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52441,
        GIR_EraseRootFromParent_Done,
      // Label 542: @18655
      GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(18700), // Rule ID 52442 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52442,
        GIR_EraseRootFromParent_Done,
      // Label 543: @18700
      GIM_Reject,
    // Label 541: @18701
    GIM_Reject,
    // Label 504: @18702
    GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(18816),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(18770), // Rule ID 52457 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIV_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52457,
        GIR_EraseRootFromParent_Done,
      // Label 545: @18770
      GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(18815), // Rule ID 52458 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIV_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52458,
        GIR_EraseRootFromParent_Done,
      // Label 546: @18815
      GIM_Reject,
    // Label 544: @18816
    GIM_Reject,
    // Label 505: @18817
    GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(18931),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(18885), // Rule ID 52501 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sdiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIV_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52501,
        GIR_EraseRootFromParent_Done,
      // Label 548: @18885
      GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(18930), // Rule ID 52502 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sdiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIV_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52502,
        GIR_EraseRootFromParent_Done,
      // Label 549: @18930
      GIM_Reject,
    // Label 547: @18931
    GIM_Reject,
    // Label 506: @18932
    GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(19046),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(19000), // Rule ID 52433 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52433,
        GIR_EraseRootFromParent_Done,
      // Label 551: @19000
      GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(19045), // Rule ID 52434 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52434,
        GIR_EraseRootFromParent_Done,
      // Label 552: @19045
      GIM_Reject,
    // Label 550: @19046
    GIM_Reject,
    // Label 507: @19047
    GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(19161),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(19115), // Rule ID 52453 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIV_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52453,
        GIR_EraseRootFromParent_Done,
      // Label 554: @19115
      GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(19160), // Rule ID 52454 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIV_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52454,
        GIR_EraseRootFromParent_Done,
      // Label 555: @19160
      GIM_Reject,
    // Label 553: @19161
    GIM_Reject,
    // Label 508: @19162
    GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(19276),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(19230), // Rule ID 52489 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIV_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52489,
        GIR_EraseRootFromParent_Done,
      // Label 557: @19230
      GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(19275), // Rule ID 52490 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIV_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52490,
        GIR_EraseRootFromParent_Done,
      // Label 558: @19275
      GIM_Reject,
    // Label 556: @19276
    GIM_Reject,
    // Label 509: @19277
    GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(19391),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(19345), // Rule ID 52505 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sdiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIV_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52505,
        GIR_EraseRootFromParent_Done,
      // Label 560: @19345
      GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(19390), // Rule ID 52506 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sdiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIV_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52506,
        GIR_EraseRootFromParent_Done,
      // Label 561: @19390
      GIM_Reject,
    // Label 559: @19391
    GIM_Reject,
    // Label 510: @19392
    GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(19506),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(19460), // Rule ID 52449 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIV_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52449,
        GIR_EraseRootFromParent_Done,
      // Label 563: @19460
      GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(19505), // Rule ID 52450 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIV_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52450,
        GIR_EraseRootFromParent_Done,
      // Label 564: @19505
      GIM_Reject,
    // Label 562: @19506
    GIM_Reject,
    // Label 511: @19507
    GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(19621),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(19575), // Rule ID 52477 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIV_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52477,
        GIR_EraseRootFromParent_Done,
      // Label 566: @19575
      GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(19620), // Rule ID 52478 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIV_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52478,
        GIR_EraseRootFromParent_Done,
      // Label 567: @19620
      GIM_Reject,
    // Label 565: @19621
    GIM_Reject,
    // Label 512: @19622
    GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(19736),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(19690), // Rule ID 52493 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIV_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52493,
        GIR_EraseRootFromParent_Done,
      // Label 569: @19690
      GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(19735), // Rule ID 52494 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIV_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52494,
        GIR_EraseRootFromParent_Done,
      // Label 570: @19735
      GIM_Reject,
    // Label 568: @19736
    GIM_Reject,
    // Label 513: @19737
    GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(19851),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(19805), // Rule ID 52509 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sdiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIV_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52509,
        GIR_EraseRootFromParent_Done,
      // Label 572: @19805
      GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(19850), // Rule ID 52510 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sdiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIV_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52510,
        GIR_EraseRootFromParent_Done,
      // Label 573: @19850
      GIM_Reject,
    // Label 571: @19851
    GIM_Reject,
    // Label 514: @19852
    GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(19966),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(19920), // Rule ID 52465 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIV_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52465,
        GIR_EraseRootFromParent_Done,
      // Label 575: @19920
      GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(19965), // Rule ID 52466 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIV_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52466,
        GIR_EraseRootFromParent_Done,
      // Label 576: @19965
      GIM_Reject,
    // Label 574: @19966
    GIM_Reject,
    // Label 515: @19967
    GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(20081),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(20035), // Rule ID 52481 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIV_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52481,
        GIR_EraseRootFromParent_Done,
      // Label 578: @20035
      GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(20080), // Rule ID 52482 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIV_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52482,
        GIR_EraseRootFromParent_Done,
      // Label 579: @20080
      GIM_Reject,
    // Label 577: @20081
    GIM_Reject,
    // Label 516: @20082
    GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(20196),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(20150), // Rule ID 52497 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIV_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52497,
        GIR_EraseRootFromParent_Done,
      // Label 581: @20150
      GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(20195), // Rule ID 52498 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIV_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52498,
        GIR_EraseRootFromParent_Done,
      // Label 582: @20195
      GIM_Reject,
    // Label 580: @20196
    GIM_Reject,
    // Label 517: @20197
    GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(20311),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(20265), // Rule ID 52469 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIV_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52469,
        GIR_EraseRootFromParent_Done,
      // Label 584: @20265
      GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(20310), // Rule ID 52470 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIV_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52470,
        GIR_EraseRootFromParent_Done,
      // Label 585: @20310
      GIM_Reject,
    // Label 583: @20311
    GIM_Reject,
    // Label 518: @20312
    GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(20426),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(20380), // Rule ID 52485 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIV_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52485,
        GIR_EraseRootFromParent_Done,
      // Label 587: @20380
      GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(20425), // Rule ID 52486 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIV_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52486,
        GIR_EraseRootFromParent_Done,
      // Label 588: @20425
      GIM_Reject,
    // Label 586: @20426
    GIM_Reject,
    // Label 519: @20427
    GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(20541),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(20495), // Rule ID 52473 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIV_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52473,
        GIR_EraseRootFromParent_Done,
      // Label 590: @20495
      GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(20540), // Rule ID 52474 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIV_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52474,
        GIR_EraseRootFromParent_Done,
      // Label 591: @20540
      GIM_Reject,
    // Label 589: @20541
    GIM_Reject,
    // Label 520: @20542
    GIM_Reject,
    // Label 4: @20543
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 616*/ GIMT_Encode4(23312),
    /*GILLT_s32*//*Label 592*/ GIMT_Encode4(20678),
    /*GILLT_s64*//*Label 593*/ GIMT_Encode4(20748), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 594*/ GIMT_Encode4(20782),
    /*GILLT_nxv1s16*//*Label 595*/ GIMT_Encode4(20897),
    /*GILLT_nxv1s32*//*Label 596*/ GIMT_Encode4(21012),
    /*GILLT_nxv1s64*//*Label 597*/ GIMT_Encode4(21127), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 598*/ GIMT_Encode4(21242),
    /*GILLT_nxv2s16*//*Label 599*/ GIMT_Encode4(21357),
    /*GILLT_nxv2s32*//*Label 600*/ GIMT_Encode4(21472),
    /*GILLT_nxv2s64*//*Label 601*/ GIMT_Encode4(21587), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 602*/ GIMT_Encode4(21702),
    /*GILLT_nxv4s16*//*Label 603*/ GIMT_Encode4(21817),
    /*GILLT_nxv4s32*//*Label 604*/ GIMT_Encode4(21932),
    /*GILLT_nxv4s64*//*Label 605*/ GIMT_Encode4(22047), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 606*/ GIMT_Encode4(22162),
    /*GILLT_nxv8s16*//*Label 607*/ GIMT_Encode4(22277),
    /*GILLT_nxv8s32*//*Label 608*/ GIMT_Encode4(22392),
    /*GILLT_nxv8s64*//*Label 609*/ GIMT_Encode4(22507), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 610*/ GIMT_Encode4(22622),
    /*GILLT_nxv16s16*//*Label 611*/ GIMT_Encode4(22737),
    /*GILLT_nxv16s32*//*Label 612*/ GIMT_Encode4(22852), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 613*/ GIMT_Encode4(22967),
    /*GILLT_nxv32s16*//*Label 614*/ GIMT_Encode4(23082), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 615*/ GIMT_Encode4(23197),
    // Label 592: @20678
    GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(20747),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(20716), // Rule ID 928 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode1),
        // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVU),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 928,
        GIR_Done,
      // Label 618: @20716
      GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(20731), // Rule ID 945 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode0),
        // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVUW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVUW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 945,
        GIR_Done,
      // Label 619: @20731
      GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(20746), // Rule ID 946 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode1),
        // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVUW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVUW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 946,
        GIR_Done,
      // Label 620: @20746
      GIM_Reject,
    // Label 617: @20747
    GIM_Reject,
    // Label 593: @20748
    GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(20781), // Rule ID 927 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (udiv:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (DIVU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVU),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 927,
      GIR_Done,
    // Label 621: @20781
    GIM_Reject,
    // Label 594: @20782
    GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(20896),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(20850), // Rule ID 52337 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52337,
        GIR_EraseRootFromParent_Done,
      // Label 623: @20850
      GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(20895), // Rule ID 52338 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52338,
        GIR_EraseRootFromParent_Done,
      // Label 624: @20895
      GIM_Reject,
    // Label 622: @20896
    GIM_Reject,
    // Label 595: @20897
    GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(21011),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(20965), // Rule ID 52349 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52349,
        GIR_EraseRootFromParent_Done,
      // Label 626: @20965
      GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(21010), // Rule ID 52350 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52350,
        GIR_EraseRootFromParent_Done,
      // Label 627: @21010
      GIM_Reject,
    // Label 625: @21011
    GIM_Reject,
    // Label 596: @21012
    GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(21126),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(21080), // Rule ID 52357 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52357,
        GIR_EraseRootFromParent_Done,
      // Label 629: @21080
      GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(21125), // Rule ID 52358 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52358,
        GIR_EraseRootFromParent_Done,
      // Label 630: @21125
      GIM_Reject,
    // Label 628: @21126
    GIM_Reject,
    // Label 597: @21127
    GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(21241),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(21195), // Rule ID 52373 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (udiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52373,
        GIR_EraseRootFromParent_Done,
      // Label 632: @21195
      GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(21240), // Rule ID 52374 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (udiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52374,
        GIR_EraseRootFromParent_Done,
      // Label 633: @21240
      GIM_Reject,
    // Label 631: @21241
    GIM_Reject,
    // Label 598: @21242
    GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(21356),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(21310), // Rule ID 52341 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52341,
        GIR_EraseRootFromParent_Done,
      // Label 635: @21310
      GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(21355), // Rule ID 52342 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52342,
        GIR_EraseRootFromParent_Done,
      // Label 636: @21355
      GIM_Reject,
    // Label 634: @21356
    GIM_Reject,
    // Label 599: @21357
    GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(21471),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(21425), // Rule ID 52353 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52353,
        GIR_EraseRootFromParent_Done,
      // Label 638: @21425
      GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(21470), // Rule ID 52354 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52354,
        GIR_EraseRootFromParent_Done,
      // Label 639: @21470
      GIM_Reject,
    // Label 637: @21471
    GIM_Reject,
    // Label 600: @21472
    GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(21586),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(21540), // Rule ID 52369 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52369,
        GIR_EraseRootFromParent_Done,
      // Label 641: @21540
      GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(21585), // Rule ID 52370 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52370,
        GIR_EraseRootFromParent_Done,
      // Label 642: @21585
      GIM_Reject,
    // Label 640: @21586
    GIM_Reject,
    // Label 601: @21587
    GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(21701),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(21655), // Rule ID 52413 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (udiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52413,
        GIR_EraseRootFromParent_Done,
      // Label 644: @21655
      GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(21700), // Rule ID 52414 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (udiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52414,
        GIR_EraseRootFromParent_Done,
      // Label 645: @21700
      GIM_Reject,
    // Label 643: @21701
    GIM_Reject,
    // Label 602: @21702
    GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(21816),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(21770), // Rule ID 52345 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52345,
        GIR_EraseRootFromParent_Done,
      // Label 647: @21770
      GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(21815), // Rule ID 52346 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52346,
        GIR_EraseRootFromParent_Done,
      // Label 648: @21815
      GIM_Reject,
    // Label 646: @21816
    GIM_Reject,
    // Label 603: @21817
    GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(21931),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(21885), // Rule ID 52365 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52365,
        GIR_EraseRootFromParent_Done,
      // Label 650: @21885
      GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(21930), // Rule ID 52366 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52366,
        GIR_EraseRootFromParent_Done,
      // Label 651: @21930
      GIM_Reject,
    // Label 649: @21931
    GIM_Reject,
    // Label 604: @21932
    GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(22046),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(22000), // Rule ID 52401 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52401,
        GIR_EraseRootFromParent_Done,
      // Label 653: @22000
      GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(22045), // Rule ID 52402 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52402,
        GIR_EraseRootFromParent_Done,
      // Label 654: @22045
      GIM_Reject,
    // Label 652: @22046
    GIM_Reject,
    // Label 605: @22047
    GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(22161),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(22115), // Rule ID 52417 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (udiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52417,
        GIR_EraseRootFromParent_Done,
      // Label 656: @22115
      GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(22160), // Rule ID 52418 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (udiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52418,
        GIR_EraseRootFromParent_Done,
      // Label 657: @22160
      GIM_Reject,
    // Label 655: @22161
    GIM_Reject,
    // Label 606: @22162
    GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(22276),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(22230), // Rule ID 52361 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52361,
        GIR_EraseRootFromParent_Done,
      // Label 659: @22230
      GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(22275), // Rule ID 52362 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52362,
        GIR_EraseRootFromParent_Done,
      // Label 660: @22275
      GIM_Reject,
    // Label 658: @22276
    GIM_Reject,
    // Label 607: @22277
    GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(22391),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(22345), // Rule ID 52389 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52389,
        GIR_EraseRootFromParent_Done,
      // Label 662: @22345
      GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(22390), // Rule ID 52390 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52390,
        GIR_EraseRootFromParent_Done,
      // Label 663: @22390
      GIM_Reject,
    // Label 661: @22391
    GIM_Reject,
    // Label 608: @22392
    GIM_Try, /*On fail goto*//*Label 664*/ GIMT_Encode4(22506),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 665*/ GIMT_Encode4(22460), // Rule ID 52405 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52405,
        GIR_EraseRootFromParent_Done,
      // Label 665: @22460
      GIM_Try, /*On fail goto*//*Label 666*/ GIMT_Encode4(22505), // Rule ID 52406 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52406,
        GIR_EraseRootFromParent_Done,
      // Label 666: @22505
      GIM_Reject,
    // Label 664: @22506
    GIM_Reject,
    // Label 609: @22507
    GIM_Try, /*On fail goto*//*Label 667*/ GIMT_Encode4(22621),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 668*/ GIMT_Encode4(22575), // Rule ID 52421 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (udiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52421,
        GIR_EraseRootFromParent_Done,
      // Label 668: @22575
      GIM_Try, /*On fail goto*//*Label 669*/ GIMT_Encode4(22620), // Rule ID 52422 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (udiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52422,
        GIR_EraseRootFromParent_Done,
      // Label 669: @22620
      GIM_Reject,
    // Label 667: @22621
    GIM_Reject,
    // Label 610: @22622
    GIM_Try, /*On fail goto*//*Label 670*/ GIMT_Encode4(22736),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 671*/ GIMT_Encode4(22690), // Rule ID 52377 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52377,
        GIR_EraseRootFromParent_Done,
      // Label 671: @22690
      GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(22735), // Rule ID 52378 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52378,
        GIR_EraseRootFromParent_Done,
      // Label 672: @22735
      GIM_Reject,
    // Label 670: @22736
    GIM_Reject,
    // Label 611: @22737
    GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(22851),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(22805), // Rule ID 52393 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52393,
        GIR_EraseRootFromParent_Done,
      // Label 674: @22805
      GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(22850), // Rule ID 52394 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52394,
        GIR_EraseRootFromParent_Done,
      // Label 675: @22850
      GIM_Reject,
    // Label 673: @22851
    GIM_Reject,
    // Label 612: @22852
    GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(22966),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 677*/ GIMT_Encode4(22920), // Rule ID 52409 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52409,
        GIR_EraseRootFromParent_Done,
      // Label 677: @22920
      GIM_Try, /*On fail goto*//*Label 678*/ GIMT_Encode4(22965), // Rule ID 52410 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52410,
        GIR_EraseRootFromParent_Done,
      // Label 678: @22965
      GIM_Reject,
    // Label 676: @22966
    GIM_Reject,
    // Label 613: @22967
    GIM_Try, /*On fail goto*//*Label 679*/ GIMT_Encode4(23081),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 680*/ GIMT_Encode4(23035), // Rule ID 52381 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52381,
        GIR_EraseRootFromParent_Done,
      // Label 680: @23035
      GIM_Try, /*On fail goto*//*Label 681*/ GIMT_Encode4(23080), // Rule ID 52382 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52382,
        GIR_EraseRootFromParent_Done,
      // Label 681: @23080
      GIM_Reject,
    // Label 679: @23081
    GIM_Reject,
    // Label 614: @23082
    GIM_Try, /*On fail goto*//*Label 682*/ GIMT_Encode4(23196),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 683*/ GIMT_Encode4(23150), // Rule ID 52397 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52397,
        GIR_EraseRootFromParent_Done,
      // Label 683: @23150
      GIM_Try, /*On fail goto*//*Label 684*/ GIMT_Encode4(23195), // Rule ID 52398 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52398,
        GIR_EraseRootFromParent_Done,
      // Label 684: @23195
      GIM_Reject,
    // Label 682: @23196
    GIM_Reject,
    // Label 615: @23197
    GIM_Try, /*On fail goto*//*Label 685*/ GIMT_Encode4(23311),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 686*/ GIMT_Encode4(23265), // Rule ID 52385 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52385,
        GIR_EraseRootFromParent_Done,
      // Label 686: @23265
      GIM_Try, /*On fail goto*//*Label 687*/ GIMT_Encode4(23310), // Rule ID 52386 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52386,
        GIR_EraseRootFromParent_Done,
      // Label 687: @23310
      GIM_Reject,
    // Label 685: @23311
    GIM_Reject,
    // Label 616: @23312
    GIM_Reject,
    // Label 5: @23313
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 712*/ GIMT_Encode4(26082),
    /*GILLT_s32*//*Label 688*/ GIMT_Encode4(23448),
    /*GILLT_s64*//*Label 689*/ GIMT_Encode4(23518), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 690*/ GIMT_Encode4(23552),
    /*GILLT_nxv1s16*//*Label 691*/ GIMT_Encode4(23667),
    /*GILLT_nxv1s32*//*Label 692*/ GIMT_Encode4(23782),
    /*GILLT_nxv1s64*//*Label 693*/ GIMT_Encode4(23897), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 694*/ GIMT_Encode4(24012),
    /*GILLT_nxv2s16*//*Label 695*/ GIMT_Encode4(24127),
    /*GILLT_nxv2s32*//*Label 696*/ GIMT_Encode4(24242),
    /*GILLT_nxv2s64*//*Label 697*/ GIMT_Encode4(24357), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 698*/ GIMT_Encode4(24472),
    /*GILLT_nxv4s16*//*Label 699*/ GIMT_Encode4(24587),
    /*GILLT_nxv4s32*//*Label 700*/ GIMT_Encode4(24702),
    /*GILLT_nxv4s64*//*Label 701*/ GIMT_Encode4(24817), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 702*/ GIMT_Encode4(24932),
    /*GILLT_nxv8s16*//*Label 703*/ GIMT_Encode4(25047),
    /*GILLT_nxv8s32*//*Label 704*/ GIMT_Encode4(25162),
    /*GILLT_nxv8s64*//*Label 705*/ GIMT_Encode4(25277), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 706*/ GIMT_Encode4(25392),
    /*GILLT_nxv16s16*//*Label 707*/ GIMT_Encode4(25507),
    /*GILLT_nxv16s32*//*Label 708*/ GIMT_Encode4(25622), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 709*/ GIMT_Encode4(25737),
    /*GILLT_nxv32s16*//*Label 710*/ GIMT_Encode4(25852), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 711*/ GIMT_Encode4(25967),
    // Label 688: @23448
    GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(23517),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(23486), // Rule ID 930 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode1),
        // (srem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REM:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 930,
        GIR_Done,
      // Label 714: @23486
      GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(23501), // Rule ID 947 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode0),
        // (srem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 947,
        GIR_Done,
      // Label 715: @23501
      GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(23516), // Rule ID 948 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode1),
        // (srem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 948,
        GIR_Done,
      // Label 716: @23516
      GIM_Reject,
    // Label 713: @23517
    GIM_Reject,
    // Label 689: @23518
    GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(23551), // Rule ID 929 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (srem:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (REM:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 929,
      GIR_Done,
    // Label 717: @23551
    GIM_Reject,
    // Label 690: @23552
    GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(23666),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(23620), // Rule ID 52601 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREM_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52601,
        GIR_EraseRootFromParent_Done,
      // Label 719: @23620
      GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(23665), // Rule ID 52602 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREM_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52602,
        GIR_EraseRootFromParent_Done,
      // Label 720: @23665
      GIM_Reject,
    // Label 718: @23666
    GIM_Reject,
    // Label 691: @23667
    GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(23781),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(23735), // Rule ID 52613 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREM_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52613,
        GIR_EraseRootFromParent_Done,
      // Label 722: @23735
      GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(23780), // Rule ID 52614 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREM_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52614,
        GIR_EraseRootFromParent_Done,
      // Label 723: @23780
      GIM_Reject,
    // Label 721: @23781
    GIM_Reject,
    // Label 692: @23782
    GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(23896),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(23850), // Rule ID 52621 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREM_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52621,
        GIR_EraseRootFromParent_Done,
      // Label 725: @23850
      GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(23895), // Rule ID 52622 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREM_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52622,
        GIR_EraseRootFromParent_Done,
      // Label 726: @23895
      GIM_Reject,
    // Label 724: @23896
    GIM_Reject,
    // Label 693: @23897
    GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(24011),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(23965), // Rule ID 52637 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (srem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREM_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52637,
        GIR_EraseRootFromParent_Done,
      // Label 728: @23965
      GIM_Try, /*On fail goto*//*Label 729*/ GIMT_Encode4(24010), // Rule ID 52638 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (srem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREM_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52638,
        GIR_EraseRootFromParent_Done,
      // Label 729: @24010
      GIM_Reject,
    // Label 727: @24011
    GIM_Reject,
    // Label 694: @24012
    GIM_Try, /*On fail goto*//*Label 730*/ GIMT_Encode4(24126),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 731*/ GIMT_Encode4(24080), // Rule ID 52605 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREM_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52605,
        GIR_EraseRootFromParent_Done,
      // Label 731: @24080
      GIM_Try, /*On fail goto*//*Label 732*/ GIMT_Encode4(24125), // Rule ID 52606 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREM_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52606,
        GIR_EraseRootFromParent_Done,
      // Label 732: @24125
      GIM_Reject,
    // Label 730: @24126
    GIM_Reject,
    // Label 695: @24127
    GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(24241),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(24195), // Rule ID 52617 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREM_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52617,
        GIR_EraseRootFromParent_Done,
      // Label 734: @24195
      GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(24240), // Rule ID 52618 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREM_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52618,
        GIR_EraseRootFromParent_Done,
      // Label 735: @24240
      GIM_Reject,
    // Label 733: @24241
    GIM_Reject,
    // Label 696: @24242
    GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(24356),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(24310), // Rule ID 52633 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREM_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52633,
        GIR_EraseRootFromParent_Done,
      // Label 737: @24310
      GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(24355), // Rule ID 52634 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREM_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52634,
        GIR_EraseRootFromParent_Done,
      // Label 738: @24355
      GIM_Reject,
    // Label 736: @24356
    GIM_Reject,
    // Label 697: @24357
    GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(24471),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(24425), // Rule ID 52677 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (srem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREM_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52677,
        GIR_EraseRootFromParent_Done,
      // Label 740: @24425
      GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(24470), // Rule ID 52678 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (srem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREM_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52678,
        GIR_EraseRootFromParent_Done,
      // Label 741: @24470
      GIM_Reject,
    // Label 739: @24471
    GIM_Reject,
    // Label 698: @24472
    GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(24586),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(24540), // Rule ID 52609 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREM_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52609,
        GIR_EraseRootFromParent_Done,
      // Label 743: @24540
      GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(24585), // Rule ID 52610 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREM_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52610,
        GIR_EraseRootFromParent_Done,
      // Label 744: @24585
      GIM_Reject,
    // Label 742: @24586
    GIM_Reject,
    // Label 699: @24587
    GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(24701),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(24655), // Rule ID 52629 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREM_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52629,
        GIR_EraseRootFromParent_Done,
      // Label 746: @24655
      GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(24700), // Rule ID 52630 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREM_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52630,
        GIR_EraseRootFromParent_Done,
      // Label 747: @24700
      GIM_Reject,
    // Label 745: @24701
    GIM_Reject,
    // Label 700: @24702
    GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(24816),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(24770), // Rule ID 52665 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREM_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52665,
        GIR_EraseRootFromParent_Done,
      // Label 749: @24770
      GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(24815), // Rule ID 52666 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREM_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52666,
        GIR_EraseRootFromParent_Done,
      // Label 750: @24815
      GIM_Reject,
    // Label 748: @24816
    GIM_Reject,
    // Label 701: @24817
    GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(24931),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(24885), // Rule ID 52681 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (srem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREM_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52681,
        GIR_EraseRootFromParent_Done,
      // Label 752: @24885
      GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(24930), // Rule ID 52682 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (srem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREM_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52682,
        GIR_EraseRootFromParent_Done,
      // Label 753: @24930
      GIM_Reject,
    // Label 751: @24931
    GIM_Reject,
    // Label 702: @24932
    GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(25046),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(25000), // Rule ID 52625 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREM_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52625,
        GIR_EraseRootFromParent_Done,
      // Label 755: @25000
      GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(25045), // Rule ID 52626 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREM_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52626,
        GIR_EraseRootFromParent_Done,
      // Label 756: @25045
      GIM_Reject,
    // Label 754: @25046
    GIM_Reject,
    // Label 703: @25047
    GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(25161),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(25115), // Rule ID 52653 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREM_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52653,
        GIR_EraseRootFromParent_Done,
      // Label 758: @25115
      GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(25160), // Rule ID 52654 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREM_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52654,
        GIR_EraseRootFromParent_Done,
      // Label 759: @25160
      GIM_Reject,
    // Label 757: @25161
    GIM_Reject,
    // Label 704: @25162
    GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(25276),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(25230), // Rule ID 52669 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREM_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52669,
        GIR_EraseRootFromParent_Done,
      // Label 761: @25230
      GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(25275), // Rule ID 52670 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREM_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52670,
        GIR_EraseRootFromParent_Done,
      // Label 762: @25275
      GIM_Reject,
    // Label 760: @25276
    GIM_Reject,
    // Label 705: @25277
    GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(25391),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(25345), // Rule ID 52685 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (srem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREM_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52685,
        GIR_EraseRootFromParent_Done,
      // Label 764: @25345
      GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(25390), // Rule ID 52686 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (srem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREM_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52686,
        GIR_EraseRootFromParent_Done,
      // Label 765: @25390
      GIM_Reject,
    // Label 763: @25391
    GIM_Reject,
    // Label 706: @25392
    GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(25506),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 767*/ GIMT_Encode4(25460), // Rule ID 52641 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREM_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52641,
        GIR_EraseRootFromParent_Done,
      // Label 767: @25460
      GIM_Try, /*On fail goto*//*Label 768*/ GIMT_Encode4(25505), // Rule ID 52642 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREM_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52642,
        GIR_EraseRootFromParent_Done,
      // Label 768: @25505
      GIM_Reject,
    // Label 766: @25506
    GIM_Reject,
    // Label 707: @25507
    GIM_Try, /*On fail goto*//*Label 769*/ GIMT_Encode4(25621),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 770*/ GIMT_Encode4(25575), // Rule ID 52657 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREM_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52657,
        GIR_EraseRootFromParent_Done,
      // Label 770: @25575
      GIM_Try, /*On fail goto*//*Label 771*/ GIMT_Encode4(25620), // Rule ID 52658 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREM_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52658,
        GIR_EraseRootFromParent_Done,
      // Label 771: @25620
      GIM_Reject,
    // Label 769: @25621
    GIM_Reject,
    // Label 708: @25622
    GIM_Try, /*On fail goto*//*Label 772*/ GIMT_Encode4(25736),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 773*/ GIMT_Encode4(25690), // Rule ID 52673 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREM_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52673,
        GIR_EraseRootFromParent_Done,
      // Label 773: @25690
      GIM_Try, /*On fail goto*//*Label 774*/ GIMT_Encode4(25735), // Rule ID 52674 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREM_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52674,
        GIR_EraseRootFromParent_Done,
      // Label 774: @25735
      GIM_Reject,
    // Label 772: @25736
    GIM_Reject,
    // Label 709: @25737
    GIM_Try, /*On fail goto*//*Label 775*/ GIMT_Encode4(25851),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 776*/ GIMT_Encode4(25805), // Rule ID 52645 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREM_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52645,
        GIR_EraseRootFromParent_Done,
      // Label 776: @25805
      GIM_Try, /*On fail goto*//*Label 777*/ GIMT_Encode4(25850), // Rule ID 52646 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREM_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52646,
        GIR_EraseRootFromParent_Done,
      // Label 777: @25850
      GIM_Reject,
    // Label 775: @25851
    GIM_Reject,
    // Label 710: @25852
    GIM_Try, /*On fail goto*//*Label 778*/ GIMT_Encode4(25966),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 779*/ GIMT_Encode4(25920), // Rule ID 52661 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREM_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52661,
        GIR_EraseRootFromParent_Done,
      // Label 779: @25920
      GIM_Try, /*On fail goto*//*Label 780*/ GIMT_Encode4(25965), // Rule ID 52662 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREM_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52662,
        GIR_EraseRootFromParent_Done,
      // Label 780: @25965
      GIM_Reject,
    // Label 778: @25966
    GIM_Reject,
    // Label 711: @25967
    GIM_Try, /*On fail goto*//*Label 781*/ GIMT_Encode4(26081),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 782*/ GIMT_Encode4(26035), // Rule ID 52649 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREM_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52649,
        GIR_EraseRootFromParent_Done,
      // Label 782: @26035
      GIM_Try, /*On fail goto*//*Label 783*/ GIMT_Encode4(26080), // Rule ID 52650 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREM_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52650,
        GIR_EraseRootFromParent_Done,
      // Label 783: @26080
      GIM_Reject,
    // Label 781: @26081
    GIM_Reject,
    // Label 712: @26082
    GIM_Reject,
    // Label 6: @26083
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 808*/ GIMT_Encode4(28852),
    /*GILLT_s32*//*Label 784*/ GIMT_Encode4(26218),
    /*GILLT_s64*//*Label 785*/ GIMT_Encode4(26288), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 786*/ GIMT_Encode4(26322),
    /*GILLT_nxv1s16*//*Label 787*/ GIMT_Encode4(26437),
    /*GILLT_nxv1s32*//*Label 788*/ GIMT_Encode4(26552),
    /*GILLT_nxv1s64*//*Label 789*/ GIMT_Encode4(26667), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 790*/ GIMT_Encode4(26782),
    /*GILLT_nxv2s16*//*Label 791*/ GIMT_Encode4(26897),
    /*GILLT_nxv2s32*//*Label 792*/ GIMT_Encode4(27012),
    /*GILLT_nxv2s64*//*Label 793*/ GIMT_Encode4(27127), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 794*/ GIMT_Encode4(27242),
    /*GILLT_nxv4s16*//*Label 795*/ GIMT_Encode4(27357),
    /*GILLT_nxv4s32*//*Label 796*/ GIMT_Encode4(27472),
    /*GILLT_nxv4s64*//*Label 797*/ GIMT_Encode4(27587), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 798*/ GIMT_Encode4(27702),
    /*GILLT_nxv8s16*//*Label 799*/ GIMT_Encode4(27817),
    /*GILLT_nxv8s32*//*Label 800*/ GIMT_Encode4(27932),
    /*GILLT_nxv8s64*//*Label 801*/ GIMT_Encode4(28047), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 802*/ GIMT_Encode4(28162),
    /*GILLT_nxv16s16*//*Label 803*/ GIMT_Encode4(28277),
    /*GILLT_nxv16s32*//*Label 804*/ GIMT_Encode4(28392), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 805*/ GIMT_Encode4(28507),
    /*GILLT_nxv32s16*//*Label 806*/ GIMT_Encode4(28622), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 807*/ GIMT_Encode4(28737),
    // Label 784: @26218
    GIM_Try, /*On fail goto*//*Label 809*/ GIMT_Encode4(26287),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 810*/ GIMT_Encode4(26256), // Rule ID 932 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode1),
        // (urem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMU),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 932,
        GIR_Done,
      // Label 810: @26256
      GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(26271), // Rule ID 949 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode0),
        // (urem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMUW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMUW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 949,
        GIR_Done,
      // Label 811: @26271
      GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(26286), // Rule ID 950 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode1),
        // (urem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMUW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMUW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 950,
        GIR_Done,
      // Label 812: @26286
      GIM_Reject,
    // Label 809: @26287
    GIM_Reject,
    // Label 785: @26288
    GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(26321), // Rule ID 931 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (urem:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (REMU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMU),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 931,
      GIR_Done,
    // Label 813: @26321
    GIM_Reject,
    // Label 786: @26322
    GIM_Try, /*On fail goto*//*Label 814*/ GIMT_Encode4(26436),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 815*/ GIMT_Encode4(26390), // Rule ID 52513 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREMU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52513,
        GIR_EraseRootFromParent_Done,
      // Label 815: @26390
      GIM_Try, /*On fail goto*//*Label 816*/ GIMT_Encode4(26435), // Rule ID 52514 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREMU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52514,
        GIR_EraseRootFromParent_Done,
      // Label 816: @26435
      GIM_Reject,
    // Label 814: @26436
    GIM_Reject,
    // Label 787: @26437
    GIM_Try, /*On fail goto*//*Label 817*/ GIMT_Encode4(26551),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 818*/ GIMT_Encode4(26505), // Rule ID 52525 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52525,
        GIR_EraseRootFromParent_Done,
      // Label 818: @26505
      GIM_Try, /*On fail goto*//*Label 819*/ GIMT_Encode4(26550), // Rule ID 52526 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52526,
        GIR_EraseRootFromParent_Done,
      // Label 819: @26550
      GIM_Reject,
    // Label 817: @26551
    GIM_Reject,
    // Label 788: @26552
    GIM_Try, /*On fail goto*//*Label 820*/ GIMT_Encode4(26666),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 821*/ GIMT_Encode4(26620), // Rule ID 52533 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52533,
        GIR_EraseRootFromParent_Done,
      // Label 821: @26620
      GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(26665), // Rule ID 52534 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52534,
        GIR_EraseRootFromParent_Done,
      // Label 822: @26665
      GIM_Reject,
    // Label 820: @26666
    GIM_Reject,
    // Label 789: @26667
    GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(26781),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(26735), // Rule ID 52549 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (urem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREMU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52549,
        GIR_EraseRootFromParent_Done,
      // Label 824: @26735
      GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(26780), // Rule ID 52550 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (urem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREMU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52550,
        GIR_EraseRootFromParent_Done,
      // Label 825: @26780
      GIM_Reject,
    // Label 823: @26781
    GIM_Reject,
    // Label 790: @26782
    GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(26896),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(26850), // Rule ID 52517 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52517,
        GIR_EraseRootFromParent_Done,
      // Label 827: @26850
      GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(26895), // Rule ID 52518 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52518,
        GIR_EraseRootFromParent_Done,
      // Label 828: @26895
      GIM_Reject,
    // Label 826: @26896
    GIM_Reject,
    // Label 791: @26897
    GIM_Try, /*On fail goto*//*Label 829*/ GIMT_Encode4(27011),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 830*/ GIMT_Encode4(26965), // Rule ID 52529 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52529,
        GIR_EraseRootFromParent_Done,
      // Label 830: @26965
      GIM_Try, /*On fail goto*//*Label 831*/ GIMT_Encode4(27010), // Rule ID 52530 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52530,
        GIR_EraseRootFromParent_Done,
      // Label 831: @27010
      GIM_Reject,
    // Label 829: @27011
    GIM_Reject,
    // Label 792: @27012
    GIM_Try, /*On fail goto*//*Label 832*/ GIMT_Encode4(27126),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 833*/ GIMT_Encode4(27080), // Rule ID 52545 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREMU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52545,
        GIR_EraseRootFromParent_Done,
      // Label 833: @27080
      GIM_Try, /*On fail goto*//*Label 834*/ GIMT_Encode4(27125), // Rule ID 52546 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREMU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52546,
        GIR_EraseRootFromParent_Done,
      // Label 834: @27125
      GIM_Reject,
    // Label 832: @27126
    GIM_Reject,
    // Label 793: @27127
    GIM_Try, /*On fail goto*//*Label 835*/ GIMT_Encode4(27241),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 836*/ GIMT_Encode4(27195), // Rule ID 52589 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (urem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREMU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52589,
        GIR_EraseRootFromParent_Done,
      // Label 836: @27195
      GIM_Try, /*On fail goto*//*Label 837*/ GIMT_Encode4(27240), // Rule ID 52590 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (urem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREMU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52590,
        GIR_EraseRootFromParent_Done,
      // Label 837: @27240
      GIM_Reject,
    // Label 835: @27241
    GIM_Reject,
    // Label 794: @27242
    GIM_Try, /*On fail goto*//*Label 838*/ GIMT_Encode4(27356),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 839*/ GIMT_Encode4(27310), // Rule ID 52521 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52521,
        GIR_EraseRootFromParent_Done,
      // Label 839: @27310
      GIM_Try, /*On fail goto*//*Label 840*/ GIMT_Encode4(27355), // Rule ID 52522 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52522,
        GIR_EraseRootFromParent_Done,
      // Label 840: @27355
      GIM_Reject,
    // Label 838: @27356
    GIM_Reject,
    // Label 795: @27357
    GIM_Try, /*On fail goto*//*Label 841*/ GIMT_Encode4(27471),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 842*/ GIMT_Encode4(27425), // Rule ID 52541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREMU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52541,
        GIR_EraseRootFromParent_Done,
      // Label 842: @27425
      GIM_Try, /*On fail goto*//*Label 843*/ GIMT_Encode4(27470), // Rule ID 52542 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREMU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52542,
        GIR_EraseRootFromParent_Done,
      // Label 843: @27470
      GIM_Reject,
    // Label 841: @27471
    GIM_Reject,
    // Label 796: @27472
    GIM_Try, /*On fail goto*//*Label 844*/ GIMT_Encode4(27586),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 845*/ GIMT_Encode4(27540), // Rule ID 52577 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREMU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52577,
        GIR_EraseRootFromParent_Done,
      // Label 845: @27540
      GIM_Try, /*On fail goto*//*Label 846*/ GIMT_Encode4(27585), // Rule ID 52578 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREMU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52578,
        GIR_EraseRootFromParent_Done,
      // Label 846: @27585
      GIM_Reject,
    // Label 844: @27586
    GIM_Reject,
    // Label 797: @27587
    GIM_Try, /*On fail goto*//*Label 847*/ GIMT_Encode4(27701),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 848*/ GIMT_Encode4(27655), // Rule ID 52593 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (urem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREMU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52593,
        GIR_EraseRootFromParent_Done,
      // Label 848: @27655
      GIM_Try, /*On fail goto*//*Label 849*/ GIMT_Encode4(27700), // Rule ID 52594 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (urem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREMU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52594,
        GIR_EraseRootFromParent_Done,
      // Label 849: @27700
      GIM_Reject,
    // Label 847: @27701
    GIM_Reject,
    // Label 798: @27702
    GIM_Try, /*On fail goto*//*Label 850*/ GIMT_Encode4(27816),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 851*/ GIMT_Encode4(27770), // Rule ID 52537 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREMU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52537,
        GIR_EraseRootFromParent_Done,
      // Label 851: @27770
      GIM_Try, /*On fail goto*//*Label 852*/ GIMT_Encode4(27815), // Rule ID 52538 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREMU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52538,
        GIR_EraseRootFromParent_Done,
      // Label 852: @27815
      GIM_Reject,
    // Label 850: @27816
    GIM_Reject,
    // Label 799: @27817
    GIM_Try, /*On fail goto*//*Label 853*/ GIMT_Encode4(27931),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 854*/ GIMT_Encode4(27885), // Rule ID 52565 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREMU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52565,
        GIR_EraseRootFromParent_Done,
      // Label 854: @27885
      GIM_Try, /*On fail goto*//*Label 855*/ GIMT_Encode4(27930), // Rule ID 52566 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREMU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52566,
        GIR_EraseRootFromParent_Done,
      // Label 855: @27930
      GIM_Reject,
    // Label 853: @27931
    GIM_Reject,
    // Label 800: @27932
    GIM_Try, /*On fail goto*//*Label 856*/ GIMT_Encode4(28046),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 857*/ GIMT_Encode4(28000), // Rule ID 52581 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREMU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52581,
        GIR_EraseRootFromParent_Done,
      // Label 857: @28000
      GIM_Try, /*On fail goto*//*Label 858*/ GIMT_Encode4(28045), // Rule ID 52582 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREMU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52582,
        GIR_EraseRootFromParent_Done,
      // Label 858: @28045
      GIM_Reject,
    // Label 856: @28046
    GIM_Reject,
    // Label 801: @28047
    GIM_Try, /*On fail goto*//*Label 859*/ GIMT_Encode4(28161),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 860*/ GIMT_Encode4(28115), // Rule ID 52597 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (urem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREMU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52597,
        GIR_EraseRootFromParent_Done,
      // Label 860: @28115
      GIM_Try, /*On fail goto*//*Label 861*/ GIMT_Encode4(28160), // Rule ID 52598 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (urem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREMU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52598,
        GIR_EraseRootFromParent_Done,
      // Label 861: @28160
      GIM_Reject,
    // Label 859: @28161
    GIM_Reject,
    // Label 802: @28162
    GIM_Try, /*On fail goto*//*Label 862*/ GIMT_Encode4(28276),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 863*/ GIMT_Encode4(28230), // Rule ID 52553 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREMU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52553,
        GIR_EraseRootFromParent_Done,
      // Label 863: @28230
      GIM_Try, /*On fail goto*//*Label 864*/ GIMT_Encode4(28275), // Rule ID 52554 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREMU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52554,
        GIR_EraseRootFromParent_Done,
      // Label 864: @28275
      GIM_Reject,
    // Label 862: @28276
    GIM_Reject,
    // Label 803: @28277
    GIM_Try, /*On fail goto*//*Label 865*/ GIMT_Encode4(28391),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 866*/ GIMT_Encode4(28345), // Rule ID 52569 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREMU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52569,
        GIR_EraseRootFromParent_Done,
      // Label 866: @28345
      GIM_Try, /*On fail goto*//*Label 867*/ GIMT_Encode4(28390), // Rule ID 52570 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREMU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52570,
        GIR_EraseRootFromParent_Done,
      // Label 867: @28390
      GIM_Reject,
    // Label 865: @28391
    GIM_Reject,
    // Label 804: @28392
    GIM_Try, /*On fail goto*//*Label 868*/ GIMT_Encode4(28506),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 869*/ GIMT_Encode4(28460), // Rule ID 52585 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREMU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52585,
        GIR_EraseRootFromParent_Done,
      // Label 869: @28460
      GIM_Try, /*On fail goto*//*Label 870*/ GIMT_Encode4(28505), // Rule ID 52586 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREMU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52586,
        GIR_EraseRootFromParent_Done,
      // Label 870: @28505
      GIM_Reject,
    // Label 868: @28506
    GIM_Reject,
    // Label 805: @28507
    GIM_Try, /*On fail goto*//*Label 871*/ GIMT_Encode4(28621),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 872*/ GIMT_Encode4(28575), // Rule ID 52557 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREMU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52557,
        GIR_EraseRootFromParent_Done,
      // Label 872: @28575
      GIM_Try, /*On fail goto*//*Label 873*/ GIMT_Encode4(28620), // Rule ID 52558 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREMU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52558,
        GIR_EraseRootFromParent_Done,
      // Label 873: @28620
      GIM_Reject,
    // Label 871: @28621
    GIM_Reject,
    // Label 806: @28622
    GIM_Try, /*On fail goto*//*Label 874*/ GIMT_Encode4(28736),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 875*/ GIMT_Encode4(28690), // Rule ID 52573 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREMU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52573,
        GIR_EraseRootFromParent_Done,
      // Label 875: @28690
      GIM_Try, /*On fail goto*//*Label 876*/ GIMT_Encode4(28735), // Rule ID 52574 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREMU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52574,
        GIR_EraseRootFromParent_Done,
      // Label 876: @28735
      GIM_Reject,
    // Label 874: @28736
    GIM_Reject,
    // Label 807: @28737
    GIM_Try, /*On fail goto*//*Label 877*/ GIMT_Encode4(28851),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 878*/ GIMT_Encode4(28805), // Rule ID 52561 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREMU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52561,
        GIR_EraseRootFromParent_Done,
      // Label 878: @28805
      GIM_Try, /*On fail goto*//*Label 879*/ GIMT_Encode4(28850), // Rule ID 52562 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREMU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52562,
        GIR_EraseRootFromParent_Done,
      // Label 879: @28850
      GIM_Reject,
    // Label 877: @28851
    GIM_Reject,
    // Label 808: @28852
    GIM_Reject,
    // Label 7: @28853
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 911*/ GIMT_Encode4(38398),
    /*GILLT_s32*//*Label 880*/ GIMT_Encode4(28988),
    /*GILLT_s64*//*Label 881*/ GIMT_Encode4(30644),
    /*GILLT_nxv1s1*//*Label 882*/ GIMT_Encode4(31591),
    /*GILLT_nxv1s8*//*Label 883*/ GIMT_Encode4(32202),
    /*GILLT_nxv1s16*//*Label 884*/ GIMT_Encode4(32317),
    /*GILLT_nxv1s32*//*Label 885*/ GIMT_Encode4(32432),
    /*GILLT_nxv1s64*//*Label 886*/ GIMT_Encode4(32547),
    /*GILLT_nxv2s1*//*Label 887*/ GIMT_Encode4(32662),
    /*GILLT_nxv2s8*//*Label 888*/ GIMT_Encode4(33273),
    /*GILLT_nxv2s16*//*Label 889*/ GIMT_Encode4(33388),
    /*GILLT_nxv2s32*//*Label 890*/ GIMT_Encode4(33503),
    /*GILLT_nxv2s64*//*Label 891*/ GIMT_Encode4(33618),
    /*GILLT_nxv4s1*//*Label 892*/ GIMT_Encode4(33733),
    /*GILLT_nxv4s8*//*Label 893*/ GIMT_Encode4(34344),
    /*GILLT_nxv4s16*//*Label 894*/ GIMT_Encode4(34459),
    /*GILLT_nxv4s32*//*Label 895*/ GIMT_Encode4(34574),
    /*GILLT_nxv4s64*//*Label 896*/ GIMT_Encode4(34689),
    /*GILLT_nxv8s1*//*Label 897*/ GIMT_Encode4(34804),
    /*GILLT_nxv8s8*//*Label 898*/ GIMT_Encode4(35415),
    /*GILLT_nxv8s16*//*Label 899*/ GIMT_Encode4(35530),
    /*GILLT_nxv8s32*//*Label 900*/ GIMT_Encode4(35645),
    /*GILLT_nxv8s64*//*Label 901*/ GIMT_Encode4(35760),
    /*GILLT_nxv16s1*//*Label 902*/ GIMT_Encode4(35875),
    /*GILLT_nxv16s8*//*Label 903*/ GIMT_Encode4(36486),
    /*GILLT_nxv16s16*//*Label 904*/ GIMT_Encode4(36601),
    /*GILLT_nxv16s32*//*Label 905*/ GIMT_Encode4(36716),
    /*GILLT_nxv32s1*//*Label 906*/ GIMT_Encode4(36831),
    /*GILLT_nxv32s8*//*Label 907*/ GIMT_Encode4(37442),
    /*GILLT_nxv32s16*//*Label 908*/ GIMT_Encode4(37557),
    /*GILLT_nxv64s1*//*Label 909*/ GIMT_Encode4(37672),
    /*GILLT_nxv64s8*//*Label 910*/ GIMT_Encode4(38283),
    // Label 880: @28988
    GIM_Try, /*On fail goto*//*Label 912*/ GIMT_Encode4(30643),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 913*/ GIMT_Encode4(29078), // Rule ID 3214 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3214,
        GIR_EraseRootFromParent_Done,
      // Label 913: @29078
      GIM_Try, /*On fail goto*//*Label 914*/ GIMT_Encode4(29153), // Rule ID 3441 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3441,
        GIR_EraseRootFromParent_Done,
      // Label 914: @29153
      GIM_Try, /*On fail goto*//*Label 915*/ GIMT_Encode4(29228), // Rule ID 65793 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), -1:{ *:[i32] }))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65793,
        GIR_EraseRootFromParent_Done,
      // Label 915: @29228
      GIM_Try, /*On fail goto*//*Label 916*/ GIMT_Encode4(29303), // Rule ID 65897 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), -1:{ *:[i32] }))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65897,
        GIR_EraseRootFromParent_Done,
      // Label 916: @29303
      GIM_Try, /*On fail goto*//*Label 917*/ GIMT_Encode4(29364), // Rule ID 3234 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimmlog2xlen),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i32] })  =>  (BEXTI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXTI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3234,
        GIR_EraseRootFromParent_Done,
      // Label 917: @29364
      GIM_Try, /*On fail goto*//*Label 918*/ GIMT_Encode4(29425), // Rule ID 3449 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm5),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimm5>>:$shamt), 1:{ *:[i32] })  =>  (BEXTI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimm5>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXTI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3449,
        GIR_EraseRootFromParent_Done,
      // Label 918: @29425
      GIM_Try, /*On fail goto*//*Label 919*/ GIMT_Encode4(29486), // Rule ID 3450 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm5),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimm5>>:$shamt), 1:{ *:[i32] })  =>  (BEXTI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimm5>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXTI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3450,
        GIR_EraseRootFromParent_Done,
      // Label 919: @29486
      GIM_Try, /*On fail goto*//*Label 920*/ GIMT_Encode4(29547), // Rule ID 63630 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimmlog2xlen),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i32] })  =>  (TH_TST:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_TST),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63630,
        GIR_EraseRootFromParent_Done,
      // Label 920: @29547
      GIM_Try, /*On fail goto*//*Label 921*/ GIMT_Encode4(29605), // Rule ID 3222 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), 1:{ *:[i32] })  =>  (BEXT:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3222,
        GIR_EraseRootFromParent_Done,
      // Label 921: @29605
      GIM_Try, /*On fail goto*//*Label 922*/ GIMT_Encode4(29663), // Rule ID 3445 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), 1:{ *:[i32] })  =>  (BEXT:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3445,
        GIR_EraseRootFromParent_Done,
      // Label 922: @29663
      GIM_Try, /*On fail goto*//*Label 923*/ GIMT_Encode4(29715), // Rule ID 3216 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3216,
        GIR_EraseRootFromParent_Done,
      // Label 923: @29715
      GIM_Try, /*On fail goto*//*Label 924*/ GIMT_Encode4(29767), // Rule ID 3442 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i64] }:$rs2), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3442,
        GIR_EraseRootFromParent_Done,
      // Label 924: @29767
      GIM_Try, /*On fail goto*//*Label 925*/ GIMT_Encode4(29819), // Rule ID 65785 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65785,
        GIR_EraseRootFromParent_Done,
      // Label 925: @29819
      GIM_Try, /*On fail goto*//*Label 926*/ GIMT_Encode4(29871), // Rule ID 65868 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65868,
        GIR_EraseRootFromParent_Done,
      // Label 926: @29871
      GIM_Try, /*On fail goto*//*Label 927*/ GIMT_Encode4(29923), // Rule ID 65869 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65869,
        GIR_EraseRootFromParent_Done,
      // Label 927: @29923
      GIM_Try, /*On fail goto*//*Label 928*/ GIMT_Encode4(29975), // Rule ID 65795 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i32] }:$rs2))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65795,
        GIR_EraseRootFromParent_Done,
      // Label 928: @29975
      GIM_Try, /*On fail goto*//*Label 929*/ GIMT_Encode4(30027), // Rule ID 65898 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i64] }:$rs2))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65898,
        GIR_EraseRootFromParent_Done,
      // Label 929: @30027
      GIM_Try, /*On fail goto*//*Label 930*/ GIMT_Encode4(30079), // Rule ID 3196 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3196,
        GIR_EraseRootFromParent_Done,
      // Label 930: @30079
      GIM_Try, /*On fail goto*//*Label 931*/ GIMT_Encode4(30131), // Rule ID 3400 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3400,
        GIR_EraseRootFromParent_Done,
      // Label 931: @30131
      GIM_Try, /*On fail goto*//*Label 932*/ GIMT_Encode4(30183), // Rule ID 3401 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3401,
        GIR_EraseRootFromParent_Done,
      // Label 932: @30183
      GIM_Try, /*On fail goto*//*Label 933*/ GIMT_Encode4(30215), // Rule ID 65585 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXCValu_IsRV32_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 65535:{ *:[i32] })  =>  (CV_EXTHZ:{ *:[i32] } GPR:{ *:[i32] }:$rs1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::CV_EXTHZ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65585,
        GIR_EraseRootFromParent_Done,
      // Label 933: @30215
      GIM_Try, /*On fail goto*//*Label 934*/ GIMT_Encode4(30247), // Rule ID 3294 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbb_IsRV32_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (ZEXT_H_RV32:{ *:[i32] } GPR:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ZEXT_H_RV32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3294,
        GIR_EraseRootFromParent_Done,
      // Label 934: @30247
      GIM_Try, /*On fail goto*//*Label 935*/ GIMT_Encode4(30279), // Rule ID 3295 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbb_IsRV32_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (ZEXT_H_RV32:{ *:[i32] } GPR:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ZEXT_H_RV32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3295,
        GIR_EraseRootFromParent_Done,
      // Label 935: @30279
      GIM_Try, /*On fail goto*//*Label 936*/ GIMT_Encode4(30317), // Rule ID 3297 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV32_NoStdExtZbb_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (PACK:{ *:[i32] } GPR:{ *:[i32] }:$rs, X0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACK),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(RISCV::X0), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3297,
        GIR_EraseRootFromParent_Done,
      // Label 936: @30317
      GIM_Try, /*On fail goto*//*Label 937*/ GIMT_Encode4(30355), // Rule ID 3298 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV32_NoStdExtZbb_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (PACK:{ *:[i32] } GPR:{ *:[i32] }:$rs, X0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACK),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(RISCV::X0), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3298,
        GIR_EraseRootFromParent_Done,
      // Label 937: @30355
      GIM_Try, /*On fail goto*//*Label 938*/ GIMT_Encode4(30387), // Rule ID 3396 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbb_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (ZEXT_H_RV64:{ *:[i32] } GPR:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ZEXT_H_RV64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3396,
        GIR_EraseRootFromParent_Done,
      // Label 938: @30387
      GIM_Try, /*On fail goto*//*Label 939*/ GIMT_Encode4(30419), // Rule ID 3397 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbb_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (ZEXT_H_RV64:{ *:[i32] } GPR:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ZEXT_H_RV64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3397,
        GIR_EraseRootFromParent_Done,
      // Label 939: @30419
      GIM_Try, /*On fail goto*//*Label 940*/ GIMT_Encode4(30457), // Rule ID 3398 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV64_NoStdExtZbb_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (PACKW:{ *:[i32] } GPR:{ *:[i32] }:$rs, X0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACKW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(RISCV::X0), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3398,
        GIR_EraseRootFromParent_Done,
      // Label 940: @30457
      GIM_Try, /*On fail goto*//*Label 941*/ GIMT_Encode4(30495), // Rule ID 3399 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV64_NoStdExtZbb_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (PACKW:{ *:[i32] } GPR:{ *:[i32] }:$rs, X0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACKW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(RISCV::X0), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3399,
        GIR_EraseRootFromParent_Done,
      // Label 941: @30495
      GIM_Try, /*On fail goto*//*Label 942*/ GIMT_Encode4(30533), // Rule ID 672 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ANDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 672,
        GIR_EraseRootFromParent_Done,
      // Label 942: @30533
      GIM_Try, /*On fail goto*//*Label 943*/ GIMT_Encode4(30573), // Rule ID 904 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12i32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12i32>>:$imm)  =>  (ANDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (as_i64imm:{ *:[i64] } ?:{ *:[i32] }:$imm))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderImm), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 904,
        GIR_EraseRootFromParent_Done,
      // Label 943: @30573
      GIM_Try, /*On fail goto*//*Label 944*/ GIMT_Encode4(30596), // Rule ID 670 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (AND:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::AND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 670,
        GIR_Done,
      // Label 944: @30596
      GIM_Try, /*On fail goto*//*Label 945*/ GIMT_Encode4(30619), // Rule ID 894 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (AND:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::AND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 894,
        GIR_Done,
      // Label 945: @30619
      GIM_Try, /*On fail goto*//*Label 946*/ GIMT_Encode4(30642), // Rule ID 895 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (AND:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::AND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 895,
        GIR_Done,
      // Label 946: @30642
      GIM_Reject,
    // Label 912: @30643
    GIM_Reject,
    // Label 881: @30644
    GIM_Try, /*On fail goto*//*Label 947*/ GIMT_Encode4(31590),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 948*/ GIMT_Encode4(30734), // Rule ID 3213 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i64] } (xor:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs1)  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3213,
        GIR_EraseRootFromParent_Done,
      // Label 948: @30734
      GIM_Try, /*On fail goto*//*Label 949*/ GIMT_Encode4(30809), // Rule ID 65792 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), -1:{ *:[i64] }))  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65792,
        GIR_EraseRootFromParent_Done,
      // Label 949: @30809
      GIM_Try, /*On fail goto*//*Label 950*/ GIMT_Encode4(30879), // Rule ID 3446 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i64] } (anyext:{ *:[i64] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2))), 1:{ *:[i64] })  =>  (BEXT:{ *:[i64] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3446,
        GIR_EraseRootFromParent_Done,
      // Label 950: @30879
      GIM_Try, /*On fail goto*//*Label 951*/ GIMT_Encode4(30940), // Rule ID 3233 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimmlog2xlen),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i64] })  =>  (BEXTI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXTI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3233,
        GIR_EraseRootFromParent_Done,
      // Label 951: @30940
      GIM_Try, /*On fail goto*//*Label 952*/ GIMT_Encode4(31001), // Rule ID 63629 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimmlog2xlen),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i64] })  =>  (TH_TST:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_TST),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63629,
        GIR_EraseRootFromParent_Done,
      // Label 952: @31001
      GIM_Try, /*On fail goto*//*Label 953*/ GIMT_Encode4(31059), // Rule ID 3221 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), 1:{ *:[i64] })  =>  (BEXT:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3221,
        GIR_EraseRootFromParent_Done,
      // Label 953: @31059
      GIM_Try, /*On fail goto*//*Label 954*/ GIMT_Encode4(31111), // Rule ID 3215 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (rotl:{ *:[i64] } -2:{ *:[i64] }, GPR:{ *:[i64] }:$rs2), GPR:{ *:[i64] }:$rs1)  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3215,
        GIR_EraseRootFromParent_Done,
      // Label 954: @31111
      GIM_Try, /*On fail goto*//*Label 955*/ GIMT_Encode4(31163), // Rule ID 65784 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs1)  =>  (ANDN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65784,
        GIR_EraseRootFromParent_Done,
      // Label 955: @31163
      GIM_Try, /*On fail goto*//*Label 956*/ GIMT_Encode4(31215), // Rule ID 65794 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (rotl:{ *:[i64] } -2:{ *:[i64] }, GPR:{ *:[i64] }:$rs2))  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65794,
        GIR_EraseRootFromParent_Done,
      // Label 956: @31215
      GIM_Try, /*On fail goto*//*Label 957*/ GIMT_Encode4(31267), // Rule ID 3195 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }))  =>  (ANDN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3195,
        GIR_EraseRootFromParent_Done,
      // Label 957: @31267
      GIM_Try, /*On fail goto*//*Label 958*/ GIMT_Encode4(31299), // Rule ID 65584 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXCValu_IsRV32_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 65535:{ *:[i64] })  =>  (CV_EXTHZ:{ *:[i64] } GPR:{ *:[i64] }:$rs1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::CV_EXTHZ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65584,
        GIR_EraseRootFromParent_Done,
      // Label 958: @31299
      GIM_Try, /*On fail goto*//*Label 959*/ GIMT_Encode4(31356), // Rule ID 836 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_NotHasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294967295),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] })  =>  (SRLI:{ *:[i64] } (SLLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }), 32:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SLLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/32,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 836,
        GIR_EraseRootFromParent_Done,
      // Label 959: @31356
      GIM_Try, /*On fail goto*//*Label 960*/ GIMT_Encode4(31388), // Rule ID 3296 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbb_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 65535:{ *:[i64] })  =>  (ZEXT_H_RV64:{ *:[i64] } GPR:{ *:[i64] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ZEXT_H_RV64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3296,
        GIR_EraseRootFromParent_Done,
      // Label 960: @31388
      GIM_Try, /*On fail goto*//*Label 961*/ GIMT_Encode4(31426), // Rule ID 3299 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV64_NoStdExtZbb_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 65535:{ *:[i64] })  =>  (PACKW:{ *:[i64] } GPR:{ *:[i64] }:$rs, X0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACKW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(RISCV::X0), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3299,
        GIR_EraseRootFromParent_Done,
      // Label 961: @31426
      GIM_Try, /*On fail goto*//*Label 962*/ GIMT_Encode4(31464), // Rule ID 3342 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294967295),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 4294967295:{ *:[i64] })  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs, X0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(RISCV::X0), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3342,
        GIR_EraseRootFromParent_Done,
      // Label 962: @31464
      GIM_Try, /*On fail goto*//*Label 963*/ GIMT_Encode4(31502), // Rule ID 671 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ANDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 671,
        GIR_EraseRootFromParent_Done,
      // Label 963: @31502
      GIM_Try, /*On fail goto*//*Label 964*/ GIMT_Encode4(31566), // Rule ID 3339 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_Shifted32OnesMask),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_Shifted32OnesMask>><<X:TrailingZeros>>:$mask)  =>  (SLLI_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (TrailingZeros:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_Shifted32OnesMask>>:$mask)), (TrailingZeros:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_Shifted32OnesMask>>:$mask))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderTrailingZeros), // mask
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SLLI_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderTrailingZeros), // mask
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3339,
        GIR_EraseRootFromParent_Done,
      // Label 964: @31566
      GIM_Try, /*On fail goto*//*Label 965*/ GIMT_Encode4(31589), // Rule ID 669 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (AND:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::AND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 669,
        GIR_Done,
      // Label 965: @31589
      GIM_Reject,
    // Label 947: @31590
    GIM_Reject,
    // Label 882: @31591
    GIM_Try, /*On fail goto*//*Label 966*/ GIMT_Encode4(32201),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 967*/ GIMT_Encode4(31672), // Rule ID 71861 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } (xor:{ *:[nxv1i1] } (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv1i1] }:$rs2), VR:{ *:[nxv1i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71861,
        GIR_EraseRootFromParent_Done,
      // Label 967: @31672
      GIM_Try, /*On fail goto*//*Label 968*/ GIMT_Encode4(31738), // Rule ID 71862 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } (xor:{ *:[nxv1i1] } (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv1i1] }:$rs2), VR:{ *:[nxv1i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71862,
        GIR_EraseRootFromParent_Done,
      // Label 968: @31738
      GIM_Try, /*On fail goto*//*Label 969*/ GIMT_Encode4(31804), // Rule ID 71859 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv1i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71859,
        GIR_EraseRootFromParent_Done,
      // Label 969: @31804
      GIM_Try, /*On fail goto*//*Label 970*/ GIMT_Encode4(31870), // Rule ID 71860 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv1i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71860,
        GIR_EraseRootFromParent_Done,
      // Label 970: @31870
      GIM_Try, /*On fail goto*//*Label 971*/ GIMT_Encode4(31936), // Rule ID 71857 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, (xor:{ *:[nxv1i1] } (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv1i1] }:$rs2))  =>  (PseudoVMANDN_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71857,
        GIR_EraseRootFromParent_Done,
      // Label 971: @31936
      GIM_Try, /*On fail goto*//*Label 972*/ GIMT_Encode4(32002), // Rule ID 71858 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, (xor:{ *:[nxv1i1] } (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv1i1] }:$rs2))  =>  (PseudoVMANDN_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71858,
        GIR_EraseRootFromParent_Done,
      // Label 972: @32002
      GIM_Try, /*On fail goto*//*Label 973*/ GIMT_Encode4(32068), // Rule ID 54389 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54389,
        GIR_EraseRootFromParent_Done,
      // Label 973: @32068
      GIM_Try, /*On fail goto*//*Label 974*/ GIMT_Encode4(32134), // Rule ID 54390 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54390,
        GIR_EraseRootFromParent_Done,
      // Label 974: @32134
      GIM_Try, /*On fail goto*//*Label 975*/ GIMT_Encode4(32167), // Rule ID 54377 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMAND_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54377,
        GIR_EraseRootFromParent_Done,
      // Label 975: @32167
      GIM_Try, /*On fail goto*//*Label 976*/ GIMT_Encode4(32200), // Rule ID 54378 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMAND_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54378,
        GIR_EraseRootFromParent_Done,
      // Label 976: @32200
      GIM_Reject,
    // Label 966: @32201
    GIM_Reject,
    // Label 883: @32202
    GIM_Try, /*On fail goto*//*Label 977*/ GIMT_Encode4(32316),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 978*/ GIMT_Encode4(32270), // Rule ID 48873 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVAND_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48873,
        GIR_EraseRootFromParent_Done,
      // Label 978: @32270
      GIM_Try, /*On fail goto*//*Label 979*/ GIMT_Encode4(32315), // Rule ID 48874 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVAND_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48874,
        GIR_EraseRootFromParent_Done,
      // Label 979: @32315
      GIM_Reject,
    // Label 977: @32316
    GIM_Reject,
    // Label 884: @32317
    GIM_Try, /*On fail goto*//*Label 980*/ GIMT_Encode4(32431),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 981*/ GIMT_Encode4(32385), // Rule ID 48885 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48885,
        GIR_EraseRootFromParent_Done,
      // Label 981: @32385
      GIM_Try, /*On fail goto*//*Label 982*/ GIMT_Encode4(32430), // Rule ID 48886 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48886,
        GIR_EraseRootFromParent_Done,
      // Label 982: @32430
      GIM_Reject,
    // Label 980: @32431
    GIM_Reject,
    // Label 885: @32432
    GIM_Try, /*On fail goto*//*Label 983*/ GIMT_Encode4(32546),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 984*/ GIMT_Encode4(32500), // Rule ID 48893 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48893,
        GIR_EraseRootFromParent_Done,
      // Label 984: @32500
      GIM_Try, /*On fail goto*//*Label 985*/ GIMT_Encode4(32545), // Rule ID 48894 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48894,
        GIR_EraseRootFromParent_Done,
      // Label 985: @32545
      GIM_Reject,
    // Label 983: @32546
    GIM_Reject,
    // Label 886: @32547
    GIM_Try, /*On fail goto*//*Label 986*/ GIMT_Encode4(32661),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 987*/ GIMT_Encode4(32615), // Rule ID 48909 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (and:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48909,
        GIR_EraseRootFromParent_Done,
      // Label 987: @32615
      GIM_Try, /*On fail goto*//*Label 988*/ GIMT_Encode4(32660), // Rule ID 48910 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (and:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48910,
        GIR_EraseRootFromParent_Done,
      // Label 988: @32660
      GIM_Reject,
    // Label 986: @32661
    GIM_Reject,
    // Label 887: @32662
    GIM_Try, /*On fail goto*//*Label 989*/ GIMT_Encode4(33272),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 990*/ GIMT_Encode4(32743), // Rule ID 71889 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } (xor:{ *:[nxv2i1] } (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv2i1] }:$rs2), VR:{ *:[nxv2i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71889,
        GIR_EraseRootFromParent_Done,
      // Label 990: @32743
      GIM_Try, /*On fail goto*//*Label 991*/ GIMT_Encode4(32809), // Rule ID 71890 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } (xor:{ *:[nxv2i1] } (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv2i1] }:$rs2), VR:{ *:[nxv2i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71890,
        GIR_EraseRootFromParent_Done,
      // Label 991: @32809
      GIM_Try, /*On fail goto*//*Label 992*/ GIMT_Encode4(32875), // Rule ID 71887 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv2i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71887,
        GIR_EraseRootFromParent_Done,
      // Label 992: @32875
      GIM_Try, /*On fail goto*//*Label 993*/ GIMT_Encode4(32941), // Rule ID 71888 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv2i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71888,
        GIR_EraseRootFromParent_Done,
      // Label 993: @32941
      GIM_Try, /*On fail goto*//*Label 994*/ GIMT_Encode4(33007), // Rule ID 71885 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, (xor:{ *:[nxv2i1] } (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv2i1] }:$rs2))  =>  (PseudoVMANDN_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71885,
        GIR_EraseRootFromParent_Done,
      // Label 994: @33007
      GIM_Try, /*On fail goto*//*Label 995*/ GIMT_Encode4(33073), // Rule ID 71886 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, (xor:{ *:[nxv2i1] } (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv2i1] }:$rs2))  =>  (PseudoVMANDN_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71886,
        GIR_EraseRootFromParent_Done,
      // Label 995: @33073
      GIM_Try, /*On fail goto*//*Label 996*/ GIMT_Encode4(33139), // Rule ID 54407 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54407,
        GIR_EraseRootFromParent_Done,
      // Label 996: @33139
      GIM_Try, /*On fail goto*//*Label 997*/ GIMT_Encode4(33205), // Rule ID 54408 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54408,
        GIR_EraseRootFromParent_Done,
      // Label 997: @33205
      GIM_Try, /*On fail goto*//*Label 998*/ GIMT_Encode4(33238), // Rule ID 54395 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMAND_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54395,
        GIR_EraseRootFromParent_Done,
      // Label 998: @33238
      GIM_Try, /*On fail goto*//*Label 999*/ GIMT_Encode4(33271), // Rule ID 54396 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMAND_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54396,
        GIR_EraseRootFromParent_Done,
      // Label 999: @33271
      GIM_Reject,
    // Label 989: @33272
    GIM_Reject,
    // Label 888: @33273
    GIM_Try, /*On fail goto*//*Label 1000*/ GIMT_Encode4(33387),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1001*/ GIMT_Encode4(33341), // Rule ID 48877 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48877,
        GIR_EraseRootFromParent_Done,
      // Label 1001: @33341
      GIM_Try, /*On fail goto*//*Label 1002*/ GIMT_Encode4(33386), // Rule ID 48878 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48878,
        GIR_EraseRootFromParent_Done,
      // Label 1002: @33386
      GIM_Reject,
    // Label 1000: @33387
    GIM_Reject,
    // Label 889: @33388
    GIM_Try, /*On fail goto*//*Label 1003*/ GIMT_Encode4(33502),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1004*/ GIMT_Encode4(33456), // Rule ID 48889 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48889,
        GIR_EraseRootFromParent_Done,
      // Label 1004: @33456
      GIM_Try, /*On fail goto*//*Label 1005*/ GIMT_Encode4(33501), // Rule ID 48890 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48890,
        GIR_EraseRootFromParent_Done,
      // Label 1005: @33501
      GIM_Reject,
    // Label 1003: @33502
    GIM_Reject,
    // Label 890: @33503
    GIM_Try, /*On fail goto*//*Label 1006*/ GIMT_Encode4(33617),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1007*/ GIMT_Encode4(33571), // Rule ID 48905 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48905,
        GIR_EraseRootFromParent_Done,
      // Label 1007: @33571
      GIM_Try, /*On fail goto*//*Label 1008*/ GIMT_Encode4(33616), // Rule ID 48906 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48906,
        GIR_EraseRootFromParent_Done,
      // Label 1008: @33616
      GIM_Reject,
    // Label 1006: @33617
    GIM_Reject,
    // Label 891: @33618
    GIM_Try, /*On fail goto*//*Label 1009*/ GIMT_Encode4(33732),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 1010*/ GIMT_Encode4(33686), // Rule ID 48949 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (and:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48949,
        GIR_EraseRootFromParent_Done,
      // Label 1010: @33686
      GIM_Try, /*On fail goto*//*Label 1011*/ GIMT_Encode4(33731), // Rule ID 48950 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (and:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48950,
        GIR_EraseRootFromParent_Done,
      // Label 1011: @33731
      GIM_Reject,
    // Label 1009: @33732
    GIM_Reject,
    // Label 892: @33733
    GIM_Try, /*On fail goto*//*Label 1012*/ GIMT_Encode4(34343),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1013*/ GIMT_Encode4(33814), // Rule ID 71917 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } (xor:{ *:[nxv4i1] } (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv4i1] }:$rs2), VR:{ *:[nxv4i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71917,
        GIR_EraseRootFromParent_Done,
      // Label 1013: @33814
      GIM_Try, /*On fail goto*//*Label 1014*/ GIMT_Encode4(33880), // Rule ID 71918 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } (xor:{ *:[nxv4i1] } (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv4i1] }:$rs2), VR:{ *:[nxv4i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71918,
        GIR_EraseRootFromParent_Done,
      // Label 1014: @33880
      GIM_Try, /*On fail goto*//*Label 1015*/ GIMT_Encode4(33946), // Rule ID 71915 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv4i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71915,
        GIR_EraseRootFromParent_Done,
      // Label 1015: @33946
      GIM_Try, /*On fail goto*//*Label 1016*/ GIMT_Encode4(34012), // Rule ID 71916 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv4i1] }:$rs1)  =>  (PseudoVMANDN_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71916,
        GIR_EraseRootFromParent_Done,
      // Label 1016: @34012
      GIM_Try, /*On fail goto*//*Label 1017*/ GIMT_Encode4(34078), // Rule ID 71913 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, (xor:{ *:[nxv4i1] } (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv4i1] }:$rs2))  =>  (PseudoVMANDN_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71913,
        GIR_EraseRootFromParent_Done,
      // Label 1017: @34078
      GIM_Try, /*On fail goto*//*Label 1018*/ GIMT_Encode4(34144), // Rule ID 71914 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, (xor:{ *:[nxv4i1] } (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv4i1] }:$rs2))  =>  (PseudoVMANDN_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71914,
        GIR_EraseRootFromParent_Done,
      // Label 1018: @34144
      GIM_Try, /*On fail goto*//*Label 1019*/ GIMT_Encode4(34210), // Rule ID 54425 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54425,
        GIR_EraseRootFromParent_Done,
      // Label 1019: @34210
      GIM_Try, /*On fail goto*//*Label 1020*/ GIMT_Encode4(34276), // Rule ID 54426 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54426,
        GIR_EraseRootFromParent_Done,
      // Label 1020: @34276
      GIM_Try, /*On fail goto*//*Label 1021*/ GIMT_Encode4(34309), // Rule ID 54413 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMAND_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54413,
        GIR_EraseRootFromParent_Done,
      // Label 1021: @34309
      GIM_Try, /*On fail goto*//*Label 1022*/ GIMT_Encode4(34342), // Rule ID 54414 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMAND_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54414,
        GIR_EraseRootFromParent_Done,
      // Label 1022: @34342
      GIM_Reject,
    // Label 1012: @34343
    GIM_Reject,
    // Label 893: @34344
    GIM_Try, /*On fail goto*//*Label 1023*/ GIMT_Encode4(34458),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1024*/ GIMT_Encode4(34412), // Rule ID 48881 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48881,
        GIR_EraseRootFromParent_Done,
      // Label 1024: @34412
      GIM_Try, /*On fail goto*//*Label 1025*/ GIMT_Encode4(34457), // Rule ID 48882 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48882,
        GIR_EraseRootFromParent_Done,
      // Label 1025: @34457
      GIM_Reject,
    // Label 1023: @34458
    GIM_Reject,
    // Label 894: @34459
    GIM_Try, /*On fail goto*//*Label 1026*/ GIMT_Encode4(34573),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1027*/ GIMT_Encode4(34527), // Rule ID 48901 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48901,
        GIR_EraseRootFromParent_Done,
      // Label 1027: @34527
      GIM_Try, /*On fail goto*//*Label 1028*/ GIMT_Encode4(34572), // Rule ID 48902 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48902,
        GIR_EraseRootFromParent_Done,
      // Label 1028: @34572
      GIM_Reject,
    // Label 1026: @34573
    GIM_Reject,
    // Label 895: @34574
    GIM_Try, /*On fail goto*//*Label 1029*/ GIMT_Encode4(34688),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 1030*/ GIMT_Encode4(34642), // Rule ID 48937 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48937,
        GIR_EraseRootFromParent_Done,
      // Label 1030: @34642
      GIM_Try, /*On fail goto*//*Label 1031*/ GIMT_Encode4(34687), // Rule ID 48938 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48938,
        GIR_EraseRootFromParent_Done,
      // Label 1031: @34687
      GIM_Reject,
    // Label 1029: @34688
    GIM_Reject,
    // Label 896: @34689
    GIM_Try, /*On fail goto*//*Label 1032*/ GIMT_Encode4(34803),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 1033*/ GIMT_Encode4(34757), // Rule ID 48953 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (and:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48953,
        GIR_EraseRootFromParent_Done,
      // Label 1033: @34757
      GIM_Try, /*On fail goto*//*Label 1034*/ GIMT_Encode4(34802), // Rule ID 48954 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (and:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48954,
        GIR_EraseRootFromParent_Done,
      // Label 1034: @34802
      GIM_Reject,
    // Label 1032: @34803
    GIM_Reject,
    // Label 897: @34804
    GIM_Try, /*On fail goto*//*Label 1035*/ GIMT_Encode4(35414),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1036*/ GIMT_Encode4(34885), // Rule ID 71945 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } (xor:{ *:[nxv8i1] } (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv8i1] }:$rs2), VR:{ *:[nxv8i1] }:$rs1)  =>  (PseudoVMANDN_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71945,
        GIR_EraseRootFromParent_Done,
      // Label 1036: @34885
      GIM_Try, /*On fail goto*//*Label 1037*/ GIMT_Encode4(34951), // Rule ID 71946 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } (xor:{ *:[nxv8i1] } (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv8i1] }:$rs2), VR:{ *:[nxv8i1] }:$rs1)  =>  (PseudoVMANDN_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71946,
        GIR_EraseRootFromParent_Done,
      // Label 1037: @34951
      GIM_Try, /*On fail goto*//*Label 1038*/ GIMT_Encode4(35017), // Rule ID 71943 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv8i1] }:$rs1)  =>  (PseudoVMANDN_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71943,
        GIR_EraseRootFromParent_Done,
      // Label 1038: @35017
      GIM_Try, /*On fail goto*//*Label 1039*/ GIMT_Encode4(35083), // Rule ID 71944 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv8i1] }:$rs1)  =>  (PseudoVMANDN_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71944,
        GIR_EraseRootFromParent_Done,
      // Label 1039: @35083
      GIM_Try, /*On fail goto*//*Label 1040*/ GIMT_Encode4(35149), // Rule ID 71941 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, (xor:{ *:[nxv8i1] } (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv8i1] }:$rs2))  =>  (PseudoVMANDN_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71941,
        GIR_EraseRootFromParent_Done,
      // Label 1040: @35149
      GIM_Try, /*On fail goto*//*Label 1041*/ GIMT_Encode4(35215), // Rule ID 71942 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, (xor:{ *:[nxv8i1] } (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv8i1] }:$rs2))  =>  (PseudoVMANDN_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71942,
        GIR_EraseRootFromParent_Done,
      // Label 1041: @35215
      GIM_Try, /*On fail goto*//*Label 1042*/ GIMT_Encode4(35281), // Rule ID 54443 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54443,
        GIR_EraseRootFromParent_Done,
      // Label 1042: @35281
      GIM_Try, /*On fail goto*//*Label 1043*/ GIMT_Encode4(35347), // Rule ID 54444 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54444,
        GIR_EraseRootFromParent_Done,
      // Label 1043: @35347
      GIM_Try, /*On fail goto*//*Label 1044*/ GIMT_Encode4(35380), // Rule ID 54431 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMAND_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54431,
        GIR_EraseRootFromParent_Done,
      // Label 1044: @35380
      GIM_Try, /*On fail goto*//*Label 1045*/ GIMT_Encode4(35413), // Rule ID 54432 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMAND_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54432,
        GIR_EraseRootFromParent_Done,
      // Label 1045: @35413
      GIM_Reject,
    // Label 1035: @35414
    GIM_Reject,
    // Label 898: @35415
    GIM_Try, /*On fail goto*//*Label 1046*/ GIMT_Encode4(35529),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1047*/ GIMT_Encode4(35483), // Rule ID 48897 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48897,
        GIR_EraseRootFromParent_Done,
      // Label 1047: @35483
      GIM_Try, /*On fail goto*//*Label 1048*/ GIMT_Encode4(35528), // Rule ID 48898 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48898,
        GIR_EraseRootFromParent_Done,
      // Label 1048: @35528
      GIM_Reject,
    // Label 1046: @35529
    GIM_Reject,
    // Label 899: @35530
    GIM_Try, /*On fail goto*//*Label 1049*/ GIMT_Encode4(35644),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 1050*/ GIMT_Encode4(35598), // Rule ID 48925 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48925,
        GIR_EraseRootFromParent_Done,
      // Label 1050: @35598
      GIM_Try, /*On fail goto*//*Label 1051*/ GIMT_Encode4(35643), // Rule ID 48926 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48926,
        GIR_EraseRootFromParent_Done,
      // Label 1051: @35643
      GIM_Reject,
    // Label 1049: @35644
    GIM_Reject,
    // Label 900: @35645
    GIM_Try, /*On fail goto*//*Label 1052*/ GIMT_Encode4(35759),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 1053*/ GIMT_Encode4(35713), // Rule ID 48941 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48941,
        GIR_EraseRootFromParent_Done,
      // Label 1053: @35713
      GIM_Try, /*On fail goto*//*Label 1054*/ GIMT_Encode4(35758), // Rule ID 48942 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48942,
        GIR_EraseRootFromParent_Done,
      // Label 1054: @35758
      GIM_Reject,
    // Label 1052: @35759
    GIM_Reject,
    // Label 901: @35760
    GIM_Try, /*On fail goto*//*Label 1055*/ GIMT_Encode4(35874),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 1056*/ GIMT_Encode4(35828), // Rule ID 48957 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (and:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48957,
        GIR_EraseRootFromParent_Done,
      // Label 1056: @35828
      GIM_Try, /*On fail goto*//*Label 1057*/ GIMT_Encode4(35873), // Rule ID 48958 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (and:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48958,
        GIR_EraseRootFromParent_Done,
      // Label 1057: @35873
      GIM_Reject,
    // Label 1055: @35874
    GIM_Reject,
    // Label 902: @35875
    GIM_Try, /*On fail goto*//*Label 1058*/ GIMT_Encode4(36485),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1059*/ GIMT_Encode4(35956), // Rule ID 71973 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } (xor:{ *:[nxv16i1] } (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv16i1] }:$rs2), VR:{ *:[nxv16i1] }:$rs1)  =>  (PseudoVMANDN_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71973,
        GIR_EraseRootFromParent_Done,
      // Label 1059: @35956
      GIM_Try, /*On fail goto*//*Label 1060*/ GIMT_Encode4(36022), // Rule ID 71974 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } (xor:{ *:[nxv16i1] } (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv16i1] }:$rs2), VR:{ *:[nxv16i1] }:$rs1)  =>  (PseudoVMANDN_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71974,
        GIR_EraseRootFromParent_Done,
      // Label 1060: @36022
      GIM_Try, /*On fail goto*//*Label 1061*/ GIMT_Encode4(36088), // Rule ID 71971 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv16i1] }:$rs1)  =>  (PseudoVMANDN_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71971,
        GIR_EraseRootFromParent_Done,
      // Label 1061: @36088
      GIM_Try, /*On fail goto*//*Label 1062*/ GIMT_Encode4(36154), // Rule ID 71972 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv16i1] }:$rs1)  =>  (PseudoVMANDN_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71972,
        GIR_EraseRootFromParent_Done,
      // Label 1062: @36154
      GIM_Try, /*On fail goto*//*Label 1063*/ GIMT_Encode4(36220), // Rule ID 71969 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, (xor:{ *:[nxv16i1] } (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv16i1] }:$rs2))  =>  (PseudoVMANDN_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71969,
        GIR_EraseRootFromParent_Done,
      // Label 1063: @36220
      GIM_Try, /*On fail goto*//*Label 1064*/ GIMT_Encode4(36286), // Rule ID 71970 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, (xor:{ *:[nxv16i1] } (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv16i1] }:$rs2))  =>  (PseudoVMANDN_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71970,
        GIR_EraseRootFromParent_Done,
      // Label 1064: @36286
      GIM_Try, /*On fail goto*//*Label 1065*/ GIMT_Encode4(36352), // Rule ID 54461 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54461,
        GIR_EraseRootFromParent_Done,
      // Label 1065: @36352
      GIM_Try, /*On fail goto*//*Label 1066*/ GIMT_Encode4(36418), // Rule ID 54462 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54462,
        GIR_EraseRootFromParent_Done,
      // Label 1066: @36418
      GIM_Try, /*On fail goto*//*Label 1067*/ GIMT_Encode4(36451), // Rule ID 54449 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMAND_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54449,
        GIR_EraseRootFromParent_Done,
      // Label 1067: @36451
      GIM_Try, /*On fail goto*//*Label 1068*/ GIMT_Encode4(36484), // Rule ID 54450 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMAND_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54450,
        GIR_EraseRootFromParent_Done,
      // Label 1068: @36484
      GIM_Reject,
    // Label 1058: @36485
    GIM_Reject,
    // Label 903: @36486
    GIM_Try, /*On fail goto*//*Label 1069*/ GIMT_Encode4(36600),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 1070*/ GIMT_Encode4(36554), // Rule ID 48913 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48913,
        GIR_EraseRootFromParent_Done,
      // Label 1070: @36554
      GIM_Try, /*On fail goto*//*Label 1071*/ GIMT_Encode4(36599), // Rule ID 48914 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48914,
        GIR_EraseRootFromParent_Done,
      // Label 1071: @36599
      GIM_Reject,
    // Label 1069: @36600
    GIM_Reject,
    // Label 904: @36601
    GIM_Try, /*On fail goto*//*Label 1072*/ GIMT_Encode4(36715),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 1073*/ GIMT_Encode4(36669), // Rule ID 48929 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48929,
        GIR_EraseRootFromParent_Done,
      // Label 1073: @36669
      GIM_Try, /*On fail goto*//*Label 1074*/ GIMT_Encode4(36714), // Rule ID 48930 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48930,
        GIR_EraseRootFromParent_Done,
      // Label 1074: @36714
      GIM_Reject,
    // Label 1072: @36715
    GIM_Reject,
    // Label 905: @36716
    GIM_Try, /*On fail goto*//*Label 1075*/ GIMT_Encode4(36830),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 1076*/ GIMT_Encode4(36784), // Rule ID 48945 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48945,
        GIR_EraseRootFromParent_Done,
      // Label 1076: @36784
      GIM_Try, /*On fail goto*//*Label 1077*/ GIMT_Encode4(36829), // Rule ID 48946 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48946,
        GIR_EraseRootFromParent_Done,
      // Label 1077: @36829
      GIM_Reject,
    // Label 1075: @36830
    GIM_Reject,
    // Label 906: @36831
    GIM_Try, /*On fail goto*//*Label 1078*/ GIMT_Encode4(37441),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1079*/ GIMT_Encode4(36912), // Rule ID 72001 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } (xor:{ *:[nxv32i1] } (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv32i1] }:$rs2), VR:{ *:[nxv32i1] }:$rs1)  =>  (PseudoVMANDN_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72001,
        GIR_EraseRootFromParent_Done,
      // Label 1079: @36912
      GIM_Try, /*On fail goto*//*Label 1080*/ GIMT_Encode4(36978), // Rule ID 72002 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } (xor:{ *:[nxv32i1] } (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv32i1] }:$rs2), VR:{ *:[nxv32i1] }:$rs1)  =>  (PseudoVMANDN_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72002,
        GIR_EraseRootFromParent_Done,
      // Label 1080: @36978
      GIM_Try, /*On fail goto*//*Label 1081*/ GIMT_Encode4(37044), // Rule ID 71999 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv32i1] }:$rs1)  =>  (PseudoVMANDN_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71999,
        GIR_EraseRootFromParent_Done,
      // Label 1081: @37044
      GIM_Try, /*On fail goto*//*Label 1082*/ GIMT_Encode4(37110), // Rule ID 72000 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv32i1] }:$rs1)  =>  (PseudoVMANDN_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72000,
        GIR_EraseRootFromParent_Done,
      // Label 1082: @37110
      GIM_Try, /*On fail goto*//*Label 1083*/ GIMT_Encode4(37176), // Rule ID 71997 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, (xor:{ *:[nxv32i1] } (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv32i1] }:$rs2))  =>  (PseudoVMANDN_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71997,
        GIR_EraseRootFromParent_Done,
      // Label 1083: @37176
      GIM_Try, /*On fail goto*//*Label 1084*/ GIMT_Encode4(37242), // Rule ID 71998 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, (xor:{ *:[nxv32i1] } (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv32i1] }:$rs2))  =>  (PseudoVMANDN_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 71998,
        GIR_EraseRootFromParent_Done,
      // Label 1084: @37242
      GIM_Try, /*On fail goto*//*Label 1085*/ GIMT_Encode4(37308), // Rule ID 54479 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54479,
        GIR_EraseRootFromParent_Done,
      // Label 1085: @37308
      GIM_Try, /*On fail goto*//*Label 1086*/ GIMT_Encode4(37374), // Rule ID 54480 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54480,
        GIR_EraseRootFromParent_Done,
      // Label 1086: @37374
      GIM_Try, /*On fail goto*//*Label 1087*/ GIMT_Encode4(37407), // Rule ID 54467 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMAND_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54467,
        GIR_EraseRootFromParent_Done,
      // Label 1087: @37407
      GIM_Try, /*On fail goto*//*Label 1088*/ GIMT_Encode4(37440), // Rule ID 54468 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMAND_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54468,
        GIR_EraseRootFromParent_Done,
      // Label 1088: @37440
      GIM_Reject,
    // Label 1078: @37441
    GIM_Reject,
    // Label 907: @37442
    GIM_Try, /*On fail goto*//*Label 1089*/ GIMT_Encode4(37556),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 1090*/ GIMT_Encode4(37510), // Rule ID 48917 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48917,
        GIR_EraseRootFromParent_Done,
      // Label 1090: @37510
      GIM_Try, /*On fail goto*//*Label 1091*/ GIMT_Encode4(37555), // Rule ID 48918 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48918,
        GIR_EraseRootFromParent_Done,
      // Label 1091: @37555
      GIM_Reject,
    // Label 1089: @37556
    GIM_Reject,
    // Label 908: @37557
    GIM_Try, /*On fail goto*//*Label 1092*/ GIMT_Encode4(37671),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 1093*/ GIMT_Encode4(37625), // Rule ID 48933 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48933,
        GIR_EraseRootFromParent_Done,
      // Label 1093: @37625
      GIM_Try, /*On fail goto*//*Label 1094*/ GIMT_Encode4(37670), // Rule ID 48934 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48934,
        GIR_EraseRootFromParent_Done,
      // Label 1094: @37670
      GIM_Reject,
    // Label 1092: @37671
    GIM_Reject,
    // Label 909: @37672
    GIM_Try, /*On fail goto*//*Label 1095*/ GIMT_Encode4(38282),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1096*/ GIMT_Encode4(37753), // Rule ID 72029 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } (xor:{ *:[nxv64i1] } (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv64i1] }:$rs2), VR:{ *:[nxv64i1] }:$rs1)  =>  (PseudoVMANDN_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72029,
        GIR_EraseRootFromParent_Done,
      // Label 1096: @37753
      GIM_Try, /*On fail goto*//*Label 1097*/ GIMT_Encode4(37819), // Rule ID 72030 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } (xor:{ *:[nxv64i1] } (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv64i1] }:$rs2), VR:{ *:[nxv64i1] }:$rs1)  =>  (PseudoVMANDN_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72030,
        GIR_EraseRootFromParent_Done,
      // Label 1097: @37819
      GIM_Try, /*On fail goto*//*Label 1098*/ GIMT_Encode4(37885), // Rule ID 72027 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv64i1] }:$rs1)  =>  (PseudoVMANDN_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72027,
        GIR_EraseRootFromParent_Done,
      // Label 1098: @37885
      GIM_Try, /*On fail goto*//*Label 1099*/ GIMT_Encode4(37951), // Rule ID 72028 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv64i1] }:$rs1)  =>  (PseudoVMANDN_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72028,
        GIR_EraseRootFromParent_Done,
      // Label 1099: @37951
      GIM_Try, /*On fail goto*//*Label 1100*/ GIMT_Encode4(38017), // Rule ID 72025 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, (xor:{ *:[nxv64i1] } (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv64i1] }:$rs2))  =>  (PseudoVMANDN_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72025,
        GIR_EraseRootFromParent_Done,
      // Label 1100: @38017
      GIM_Try, /*On fail goto*//*Label 1101*/ GIMT_Encode4(38083), // Rule ID 72026 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, (xor:{ *:[nxv64i1] } (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv64i1] }:$rs2))  =>  (PseudoVMANDN_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72026,
        GIR_EraseRootFromParent_Done,
      // Label 1101: @38083
      GIM_Try, /*On fail goto*//*Label 1102*/ GIMT_Encode4(38149), // Rule ID 54497 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54497,
        GIR_EraseRootFromParent_Done,
      // Label 1102: @38149
      GIM_Try, /*On fail goto*//*Label 1103*/ GIMT_Encode4(38215), // Rule ID 54498 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54498,
        GIR_EraseRootFromParent_Done,
      // Label 1103: @38215
      GIM_Try, /*On fail goto*//*Label 1104*/ GIMT_Encode4(38248), // Rule ID 54485 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMAND_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54485,
        GIR_EraseRootFromParent_Done,
      // Label 1104: @38248
      GIM_Try, /*On fail goto*//*Label 1105*/ GIMT_Encode4(38281), // Rule ID 54486 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMAND_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54486,
        GIR_EraseRootFromParent_Done,
      // Label 1105: @38281
      GIM_Reject,
    // Label 1095: @38282
    GIM_Reject,
    // Label 910: @38283
    GIM_Try, /*On fail goto*//*Label 1106*/ GIMT_Encode4(38397),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 1107*/ GIMT_Encode4(38351), // Rule ID 48921 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48921,
        GIR_EraseRootFromParent_Done,
      // Label 1107: @38351
      GIM_Try, /*On fail goto*//*Label 1108*/ GIMT_Encode4(38396), // Rule ID 48922 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48922,
        GIR_EraseRootFromParent_Done,
      // Label 1108: @38396
      GIM_Reject,
    // Label 1106: @38397
    GIM_Reject,
    // Label 911: @38398
    GIM_Reject,
    // Label 8: @38399
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 1140*/ GIMT_Encode4(46329),
    /*GILLT_s32*//*Label 1109*/ GIMT_Encode4(38534),
    /*GILLT_s64*//*Label 1110*/ GIMT_Encode4(39230),
    /*GILLT_nxv1s1*//*Label 1111*/ GIMT_Encode4(39522),
    /*GILLT_nxv1s8*//*Label 1112*/ GIMT_Encode4(40133),
    /*GILLT_nxv1s16*//*Label 1113*/ GIMT_Encode4(40248),
    /*GILLT_nxv1s32*//*Label 1114*/ GIMT_Encode4(40363),
    /*GILLT_nxv1s64*//*Label 1115*/ GIMT_Encode4(40478),
    /*GILLT_nxv2s1*//*Label 1116*/ GIMT_Encode4(40593),
    /*GILLT_nxv2s8*//*Label 1117*/ GIMT_Encode4(41204),
    /*GILLT_nxv2s16*//*Label 1118*/ GIMT_Encode4(41319),
    /*GILLT_nxv2s32*//*Label 1119*/ GIMT_Encode4(41434),
    /*GILLT_nxv2s64*//*Label 1120*/ GIMT_Encode4(41549),
    /*GILLT_nxv4s1*//*Label 1121*/ GIMT_Encode4(41664),
    /*GILLT_nxv4s8*//*Label 1122*/ GIMT_Encode4(42275),
    /*GILLT_nxv4s16*//*Label 1123*/ GIMT_Encode4(42390),
    /*GILLT_nxv4s32*//*Label 1124*/ GIMT_Encode4(42505),
    /*GILLT_nxv4s64*//*Label 1125*/ GIMT_Encode4(42620),
    /*GILLT_nxv8s1*//*Label 1126*/ GIMT_Encode4(42735),
    /*GILLT_nxv8s8*//*Label 1127*/ GIMT_Encode4(43346),
    /*GILLT_nxv8s16*//*Label 1128*/ GIMT_Encode4(43461),
    /*GILLT_nxv8s32*//*Label 1129*/ GIMT_Encode4(43576),
    /*GILLT_nxv8s64*//*Label 1130*/ GIMT_Encode4(43691),
    /*GILLT_nxv16s1*//*Label 1131*/ GIMT_Encode4(43806),
    /*GILLT_nxv16s8*//*Label 1132*/ GIMT_Encode4(44417),
    /*GILLT_nxv16s16*//*Label 1133*/ GIMT_Encode4(44532),
    /*GILLT_nxv16s32*//*Label 1134*/ GIMT_Encode4(44647),
    /*GILLT_nxv32s1*//*Label 1135*/ GIMT_Encode4(44762),
    /*GILLT_nxv32s8*//*Label 1136*/ GIMT_Encode4(45373),
    /*GILLT_nxv32s16*//*Label 1137*/ GIMT_Encode4(45488),
    /*GILLT_nxv64s1*//*Label 1138*/ GIMT_Encode4(45603),
    /*GILLT_nxv64s8*//*Label 1139*/ GIMT_Encode4(46214),
    // Label 1109: @38534
    GIM_Try, /*On fail goto*//*Label 1141*/ GIMT_Encode4(39229),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1142*/ GIMT_Encode4(38604), // Rule ID 3218 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (or:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), GPR:{ *:[i32] }:$rs1)  =>  (BSET:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BSET),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3218,
        GIR_EraseRootFromParent_Done,
      // Label 1142: @38604
      GIM_Try, /*On fail goto*//*Label 1143*/ GIMT_Encode4(38659), // Rule ID 3443 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (or:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), GPR:{ *:[i32] }:$rs1)  =>  (BSET:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BSET),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3443,
        GIR_EraseRootFromParent_Done,
      // Label 1143: @38659
      GIM_Try, /*On fail goto*//*Label 1144*/ GIMT_Encode4(38714), // Rule ID 65797 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode