/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	storagev1 "k8s.io/api/storage/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// CSIDriverLister helps list CSIDrivers.
// All objects returned here must be treated as read-only.
type CSIDriverLister interface {
	// List lists all CSIDrivers in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*storagev1.CSIDriver, err error)
	// Get retrieves the CSIDriver from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*storagev1.CSIDriver, error)
	CSIDriverListerExpansion
}

// cSIDriverLister implements the CSIDriverLister interface.
type cSIDriverLister struct {
	listers.ResourceIndexer[*storagev1.CSIDriver]
}

// NewCSIDriverLister returns a new CSIDriverLister.
func NewCSIDriverLister(indexer cache.Indexer) CSIDriverLister {
	return &cSIDriverLister{listers.New[*storagev1.CSIDriver](indexer, storagev1.Resource("csidriver"))}
}
