// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: google/cloud/bigquery/storage/v1/storage.proto
// Original file comments:
// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#ifndef GRPC_google_2fcloud_2fbigquery_2fstorage_2fv1_2fstorage_2eproto__INCLUDED
#define GRPC_google_2fcloud_2fbigquery_2fstorage_2fv1_2fstorage_2eproto__INCLUDED

#include "google/cloud/bigquery/storage/v1/storage.pb.h"

#include <functional>
#include <grpcpp/generic/async_generic_service.h>
#include <grpcpp/support/async_stream.h>
#include <grpcpp/support/async_unary_call.h>
#include <grpcpp/support/client_callback.h>
#include <grpcpp/client_context.h>
#include <grpcpp/completion_queue.h>
#include <grpcpp/support/message_allocator.h>
#include <grpcpp/support/method_handler.h>
#include <grpcpp/impl/proto_utils.h>
#include <grpcpp/impl/rpc_method.h>
#include <grpcpp/support/server_callback.h>
#include <grpcpp/impl/server_callback_handlers.h>
#include <grpcpp/server_context.h>
#include <grpcpp/impl/service_type.h>
#include <grpcpp/support/status.h>
#include <grpcpp/support/stub_options.h>
#include <grpcpp/support/sync_stream.h>
#include <grpcpp/ports_def.inc>

namespace google {
namespace cloud {
namespace bigquery {
namespace storage {
namespace v1 {

// BigQuery Read API.
//
// The Read API can be used to read data from BigQuery.
class BigQueryRead final {
 public:
  static constexpr char const* service_full_name() {
    return "google.cloud.bigquery.storage.v1.BigQueryRead";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Creates a new read session. A read session divides the contents of a
    // BigQuery table into one or more streams, which can then be used to read
    // data from the table. The read session also specifies properties of the
    // data to be read, such as a list of columns or a push-down filter describing
    // the rows to be returned.
    //
    // A particular row can be read by at most one stream. When the caller has
    // reached the end of each stream in the session, then all the data in the
    // table has been read.
    //
    // Data is assigned to each stream such that roughly the same number of
    // rows can be read from each stream. Because the server-side unit for
    // assigning data is collections of rows, the API does not guarantee that
    // each stream will return the same number or rows. Additionally, the
    // limits are enforced based on the number of pre-filtered rows, so some
    // filters can lead to lopsided assignments.
    //
    // Read sessions automatically expire 6 hours after they are created and do
    // not require manual clean-up by the caller.
    virtual ::grpc::Status CreateReadSession(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest& request, ::google::cloud::bigquery::storage::v1::ReadSession* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::ReadSession>> AsyncCreateReadSession(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::ReadSession>>(AsyncCreateReadSessionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::ReadSession>> PrepareAsyncCreateReadSession(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::ReadSession>>(PrepareAsyncCreateReadSessionRaw(context, request, cq));
    }
    // Reads rows from the stream in the format prescribed by the ReadSession.
    // Each response contains one or more table rows, up to a maximum of 100 MiB
    // per response; read requests which attempt to read individual rows larger
    // than 100 MiB will fail.
    //
    // Each request also returns a set of stream statistics reflecting the current
    // state of the stream.
    std::unique_ptr< ::grpc::ClientReaderInterface< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>> ReadRows(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest& request) {
      return std::unique_ptr< ::grpc::ClientReaderInterface< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>>(ReadRowsRaw(context, request));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>> AsyncReadRows(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest& request, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>>(AsyncReadRowsRaw(context, request, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>> PrepareAsyncReadRows(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>>(PrepareAsyncReadRowsRaw(context, request, cq));
    }
    // Splits a given `ReadStream` into two `ReadStream` objects. These
    // `ReadStream` objects are referred to as the primary and the residual
    // streams of the split. The original `ReadStream` can still be read from in
    // the same manner as before. Both of the returned `ReadStream` objects can
    // also be read from, and the rows returned by both child streams will be
    // the same as the rows read from the original stream.
    //
    // Moreover, the two child streams will be allocated back-to-back in the
    // original `ReadStream`. Concretely, it is guaranteed that for streams
    // original, primary, and residual, that original[0-j] = primary[0-j] and
    // original[j-n] = residual[0-m] once the streams have been read to
    // completion.
    virtual ::grpc::Status SplitReadStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest& request, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>> AsyncSplitReadStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>>(AsyncSplitReadStreamRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>> PrepareAsyncSplitReadStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>>(PrepareAsyncSplitReadStreamRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Creates a new read session. A read session divides the contents of a
      // BigQuery table into one or more streams, which can then be used to read
      // data from the table. The read session also specifies properties of the
      // data to be read, such as a list of columns or a push-down filter describing
      // the rows to be returned.
      //
      // A particular row can be read by at most one stream. When the caller has
      // reached the end of each stream in the session, then all the data in the
      // table has been read.
      //
      // Data is assigned to each stream such that roughly the same number of
      // rows can be read from each stream. Because the server-side unit for
      // assigning data is collections of rows, the API does not guarantee that
      // each stream will return the same number or rows. Additionally, the
      // limits are enforced based on the number of pre-filtered rows, so some
      // filters can lead to lopsided assignments.
      //
      // Read sessions automatically expire 6 hours after they are created and do
      // not require manual clean-up by the caller.
      virtual void CreateReadSession(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest* request, ::google::cloud::bigquery::storage::v1::ReadSession* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateReadSession(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest* request, ::google::cloud::bigquery::storage::v1::ReadSession* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Reads rows from the stream in the format prescribed by the ReadSession.
      // Each response contains one or more table rows, up to a maximum of 100 MiB
      // per response; read requests which attempt to read individual rows larger
      // than 100 MiB will fail.
      //
      // Each request also returns a set of stream statistics reflecting the current
      // state of the stream.
      virtual void ReadRows(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest* request, ::grpc::ClientReadReactor< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>* reactor) = 0;
      // Splits a given `ReadStream` into two `ReadStream` objects. These
      // `ReadStream` objects are referred to as the primary and the residual
      // streams of the split. The original `ReadStream` can still be read from in
      // the same manner as before. Both of the returned `ReadStream` objects can
      // also be read from, and the rows returned by both child streams will be
      // the same as the rows read from the original stream.
      //
      // Moreover, the two child streams will be allocated back-to-back in the
      // original `ReadStream`. Concretely, it is guaranteed that for streams
      // original, primary, and residual, that original[0-j] = primary[0-j] and
      // original[j-n] = residual[0-m] once the streams have been read to
      // completion.
      virtual void SplitReadStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest* request, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void SplitReadStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest* request, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::ReadSession>* AsyncCreateReadSessionRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::ReadSession>* PrepareAsyncCreateReadSessionRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientReaderInterface< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>* ReadRowsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest& request) = 0;
    virtual ::grpc::ClientAsyncReaderInterface< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>* AsyncReadRowsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest& request, ::grpc::CompletionQueue* cq, void* tag) = 0;
    virtual ::grpc::ClientAsyncReaderInterface< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>* PrepareAsyncReadRowsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>* AsyncSplitReadStreamRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>* PrepareAsyncSplitReadStreamRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status CreateReadSession(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest& request, ::google::cloud::bigquery::storage::v1::ReadSession* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::ReadSession>> AsyncCreateReadSession(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::ReadSession>>(AsyncCreateReadSessionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::ReadSession>> PrepareAsyncCreateReadSession(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::ReadSession>>(PrepareAsyncCreateReadSessionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientReader< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>> ReadRows(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest& request) {
      return std::unique_ptr< ::grpc::ClientReader< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>>(ReadRowsRaw(context, request));
    }
    std::unique_ptr< ::grpc::ClientAsyncReader< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>> AsyncReadRows(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest& request, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReader< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>>(AsyncReadRowsRaw(context, request, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReader< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>> PrepareAsyncReadRows(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReader< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>>(PrepareAsyncReadRowsRaw(context, request, cq));
    }
    ::grpc::Status SplitReadStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest& request, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>> AsyncSplitReadStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>>(AsyncSplitReadStreamRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>> PrepareAsyncSplitReadStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>>(PrepareAsyncSplitReadStreamRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void CreateReadSession(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest* request, ::google::cloud::bigquery::storage::v1::ReadSession* response, std::function<void(::grpc::Status)>) override;
      void CreateReadSession(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest* request, ::google::cloud::bigquery::storage::v1::ReadSession* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ReadRows(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest* request, ::grpc::ClientReadReactor< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>* reactor) override;
      void SplitReadStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest* request, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse* response, std::function<void(::grpc::Status)>) override;
      void SplitReadStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest* request, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::ReadSession>* AsyncCreateReadSessionRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::ReadSession>* PrepareAsyncCreateReadSessionRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientReader< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>* ReadRowsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest& request) override;
    ::grpc::ClientAsyncReader< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>* AsyncReadRowsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest& request, ::grpc::CompletionQueue* cq, void* tag) override;
    ::grpc::ClientAsyncReader< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>* PrepareAsyncReadRowsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>* AsyncSplitReadStreamRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>* PrepareAsyncSplitReadStreamRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_CreateReadSession_;
    const ::grpc::internal::RpcMethod rpcmethod_ReadRows_;
    const ::grpc::internal::RpcMethod rpcmethod_SplitReadStream_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Creates a new read session. A read session divides the contents of a
    // BigQuery table into one or more streams, which can then be used to read
    // data from the table. The read session also specifies properties of the
    // data to be read, such as a list of columns or a push-down filter describing
    // the rows to be returned.
    //
    // A particular row can be read by at most one stream. When the caller has
    // reached the end of each stream in the session, then all the data in the
    // table has been read.
    //
    // Data is assigned to each stream such that roughly the same number of
    // rows can be read from each stream. Because the server-side unit for
    // assigning data is collections of rows, the API does not guarantee that
    // each stream will return the same number or rows. Additionally, the
    // limits are enforced based on the number of pre-filtered rows, so some
    // filters can lead to lopsided assignments.
    //
    // Read sessions automatically expire 6 hours after they are created and do
    // not require manual clean-up by the caller.
    virtual ::grpc::Status CreateReadSession(::grpc::ServerContext* context, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest* request, ::google::cloud::bigquery::storage::v1::ReadSession* response);
    // Reads rows from the stream in the format prescribed by the ReadSession.
    // Each response contains one or more table rows, up to a maximum of 100 MiB
    // per response; read requests which attempt to read individual rows larger
    // than 100 MiB will fail.
    //
    // Each request also returns a set of stream statistics reflecting the current
    // state of the stream.
    virtual ::grpc::Status ReadRows(::grpc::ServerContext* context, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest* request, ::grpc::ServerWriter< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>* writer);
    // Splits a given `ReadStream` into two `ReadStream` objects. These
    // `ReadStream` objects are referred to as the primary and the residual
    // streams of the split. The original `ReadStream` can still be read from in
    // the same manner as before. Both of the returned `ReadStream` objects can
    // also be read from, and the rows returned by both child streams will be
    // the same as the rows read from the original stream.
    //
    // Moreover, the two child streams will be allocated back-to-back in the
    // original `ReadStream`. Concretely, it is guaranteed that for streams
    // original, primary, and residual, that original[0-j] = primary[0-j] and
    // original[j-n] = residual[0-m] once the streams have been read to
    // completion.
    virtual ::grpc::Status SplitReadStream(::grpc::ServerContext* context, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest* request, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateReadSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateReadSession() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_CreateReadSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateReadSession(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest* /*request*/, ::google::cloud::bigquery::storage::v1::ReadSession* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateReadSession(::grpc::ServerContext* context, ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::storage::v1::ReadSession>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ReadRows : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ReadRows() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_ReadRows() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ReadRows(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest* /*request*/, ::grpc::ServerWriter< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestReadRows(::grpc::ServerContext* context, ::google::cloud::bigquery::storage::v1::ReadRowsRequest* request, ::grpc::ServerAsyncWriter< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>* writer, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncServerStreaming(1, context, request, writer, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_SplitReadStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_SplitReadStream() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_SplitReadStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SplitReadStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSplitReadStream(::grpc::ServerContext* context, ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_CreateReadSession<WithAsyncMethod_ReadRows<WithAsyncMethod_SplitReadStream<Service > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_CreateReadSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateReadSession() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest, ::google::cloud::bigquery::storage::v1::ReadSession>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest* request, ::google::cloud::bigquery::storage::v1::ReadSession* response) { return this->CreateReadSession(context, request, response); }));}
    void SetMessageAllocatorFor_CreateReadSession(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest, ::google::cloud::bigquery::storage::v1::ReadSession>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest, ::google::cloud::bigquery::storage::v1::ReadSession>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateReadSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateReadSession(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest* /*request*/, ::google::cloud::bigquery::storage::v1::ReadSession* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateReadSession(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest* /*request*/, ::google::cloud::bigquery::storage::v1::ReadSession* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ReadRows : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ReadRows() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackServerStreamingHandler< ::google::cloud::bigquery::storage::v1::ReadRowsRequest, ::google::cloud::bigquery::storage::v1::ReadRowsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest* request) { return this->ReadRows(context, request); }));
    }
    ~WithCallbackMethod_ReadRows() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ReadRows(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest* /*request*/, ::grpc::ServerWriter< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerWriteReactor< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>* ReadRows(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest* /*request*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_SplitReadStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_SplitReadStream() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest* request, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse* response) { return this->SplitReadStream(context, request, response); }));}
    void SetMessageAllocatorFor_SplitReadStream(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_SplitReadStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SplitReadStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SplitReadStream(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_CreateReadSession<WithCallbackMethod_ReadRows<WithCallbackMethod_SplitReadStream<Service > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_CreateReadSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateReadSession() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_CreateReadSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateReadSession(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest* /*request*/, ::google::cloud::bigquery::storage::v1::ReadSession* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ReadRows : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ReadRows() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_ReadRows() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ReadRows(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest* /*request*/, ::grpc::ServerWriter< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_SplitReadStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_SplitReadStream() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_SplitReadStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SplitReadStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateReadSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateReadSession() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_CreateReadSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateReadSession(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest* /*request*/, ::google::cloud::bigquery::storage::v1::ReadSession* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateReadSession(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ReadRows : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ReadRows() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_ReadRows() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ReadRows(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest* /*request*/, ::grpc::ServerWriter< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestReadRows(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncWriter< ::grpc::ByteBuffer>* writer, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncServerStreaming(1, context, request, writer, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_SplitReadStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_SplitReadStream() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_SplitReadStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SplitReadStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSplitReadStream(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateReadSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateReadSession() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateReadSession(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateReadSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateReadSession(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest* /*request*/, ::google::cloud::bigquery::storage::v1::ReadSession* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateReadSession(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ReadRows : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ReadRows() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackServerStreamingHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const::grpc::ByteBuffer* request) { return this->ReadRows(context, request); }));
    }
    ~WithRawCallbackMethod_ReadRows() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ReadRows(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest* /*request*/, ::grpc::ServerWriter< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerWriteReactor< ::grpc::ByteBuffer>* ReadRows(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_SplitReadStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_SplitReadStream() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->SplitReadStream(context, request, response); }));
    }
    ~WithRawCallbackMethod_SplitReadStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SplitReadStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SplitReadStream(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateReadSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateReadSession() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest, ::google::cloud::bigquery::storage::v1::ReadSession>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest, ::google::cloud::bigquery::storage::v1::ReadSession>* streamer) {
                       return this->StreamedCreateReadSession(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateReadSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateReadSession(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest* /*request*/, ::google::cloud::bigquery::storage::v1::ReadSession* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateReadSession(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::storage::v1::CreateReadSessionRequest,::google::cloud::bigquery::storage::v1::ReadSession>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_SplitReadStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_SplitReadStream() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>* streamer) {
                       return this->StreamedSplitReadStream(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_SplitReadStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status SplitReadStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::SplitReadStreamResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedSplitReadStream(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::storage::v1::SplitReadStreamRequest,::google::cloud::bigquery::storage::v1::SplitReadStreamResponse>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_CreateReadSession<WithStreamedUnaryMethod_SplitReadStream<Service > > StreamedUnaryService;
  template <class BaseClass>
  class WithSplitStreamingMethod_ReadRows : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithSplitStreamingMethod_ReadRows() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::SplitServerStreamingHandler<
          ::google::cloud::bigquery::storage::v1::ReadRowsRequest, ::google::cloud::bigquery::storage::v1::ReadRowsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerSplitStreamer<
                     ::google::cloud::bigquery::storage::v1::ReadRowsRequest, ::google::cloud::bigquery::storage::v1::ReadRowsResponse>* streamer) {
                       return this->StreamedReadRows(context,
                         streamer);
                  }));
    }
    ~WithSplitStreamingMethod_ReadRows() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ReadRows(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::ReadRowsRequest* /*request*/, ::grpc::ServerWriter< ::google::cloud::bigquery::storage::v1::ReadRowsResponse>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with split streamed
    virtual ::grpc::Status StreamedReadRows(::grpc::ServerContext* context, ::grpc::ServerSplitStreamer< ::google::cloud::bigquery::storage::v1::ReadRowsRequest,::google::cloud::bigquery::storage::v1::ReadRowsResponse>* server_split_streamer) = 0;
  };
  typedef WithSplitStreamingMethod_ReadRows<Service > SplitStreamedService;
  typedef WithStreamedUnaryMethod_CreateReadSession<WithSplitStreamingMethod_ReadRows<WithStreamedUnaryMethod_SplitReadStream<Service > > > StreamedService;
};

// BigQuery Write API.
//
// The Write API can be used to write data to BigQuery.
//
// For supplementary information about the Write API, see:
// https://cloud.google.com/bigquery/docs/write-api
class BigQueryWrite final {
 public:
  static constexpr char const* service_full_name() {
    return "google.cloud.bigquery.storage.v1.BigQueryWrite";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Creates a write stream to the given table.
    // Additionally, every table has a special stream named '_default'
    // to which data can be written. This stream doesn't need to be created using
    // CreateWriteStream. It is a stream that can be used simultaneously by any
    // number of clients. Data written to this stream is considered committed as
    // soon as an acknowledgement is received.
    virtual ::grpc::Status CreateWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest& request, ::google::cloud::bigquery::storage::v1::WriteStream* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::WriteStream>> AsyncCreateWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::WriteStream>>(AsyncCreateWriteStreamRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::WriteStream>> PrepareAsyncCreateWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::WriteStream>>(PrepareAsyncCreateWriteStreamRaw(context, request, cq));
    }
    // Appends data to the given stream.
    //
    // If `offset` is specified, the `offset` is checked against the end of
    // stream. The server returns `OUT_OF_RANGE` in `AppendRowsResponse` if an
    // attempt is made to append to an offset beyond the current end of the stream
    // or `ALREADY_EXISTS` if user provides an `offset` that has already been
    // written to. User can retry with adjusted offset within the same RPC
    // connection. If `offset` is not specified, append happens at the end of the
    // stream.
    //
    // The response contains an optional offset at which the append
    // happened.  No offset information will be returned for appends to a
    // default stream.
    //
    // Responses are received in the same order in which requests are sent.
    // There will be one response for each successful inserted request.  Responses
    // may optionally embed error information if the originating AppendRequest was
    // not successfully processed.
    //
    // The specifics of when successfully appended data is made visible to the
    // table are governed by the type of stream:
    //
    // * For COMMITTED streams (which includes the default stream), data is
    // visible immediately upon successful append.
    //
    // * For BUFFERED streams, data is made visible via a subsequent `FlushRows`
    // rpc which advances a cursor to a newer offset in the stream.
    //
    // * For PENDING streams, data is not made visible until the stream itself is
    // finalized (via the `FinalizeWriteStream` rpc), and the stream is explicitly
    // committed via the `BatchCommitWriteStreams` rpc.
    std::unique_ptr< ::grpc::ClientReaderWriterInterface< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>> AppendRows(::grpc::ClientContext* context) {
      return std::unique_ptr< ::grpc::ClientReaderWriterInterface< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>>(AppendRowsRaw(context));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>> AsyncAppendRows(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>>(AsyncAppendRowsRaw(context, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>> PrepareAsyncAppendRows(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>>(PrepareAsyncAppendRowsRaw(context, cq));
    }
    // Gets information about a write stream.
    virtual ::grpc::Status GetWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest& request, ::google::cloud::bigquery::storage::v1::WriteStream* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::WriteStream>> AsyncGetWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::WriteStream>>(AsyncGetWriteStreamRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::WriteStream>> PrepareAsyncGetWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::WriteStream>>(PrepareAsyncGetWriteStreamRaw(context, request, cq));
    }
    // Finalize a write stream so that no new data can be appended to the
    // stream. Finalize is not supported on the '_default' stream.
    virtual ::grpc::Status FinalizeWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest& request, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>> AsyncFinalizeWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>>(AsyncFinalizeWriteStreamRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>> PrepareAsyncFinalizeWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>>(PrepareAsyncFinalizeWriteStreamRaw(context, request, cq));
    }
    // Atomically commits a group of `PENDING` streams that belong to the same
    // `parent` table.
    //
    // Streams must be finalized before commit and cannot be committed multiple
    // times. Once a stream is committed, data in the stream becomes available
    // for read operations.
    virtual ::grpc::Status BatchCommitWriteStreams(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest& request, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>> AsyncBatchCommitWriteStreams(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>>(AsyncBatchCommitWriteStreamsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>> PrepareAsyncBatchCommitWriteStreams(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>>(PrepareAsyncBatchCommitWriteStreamsRaw(context, request, cq));
    }
    // Flushes rows to a BUFFERED stream.
    //
    // If users are appending rows to BUFFERED stream, flush operation is
    // required in order for the rows to become available for reading. A
    // Flush operation flushes up to any previously flushed offset in a BUFFERED
    // stream, to the offset specified in the request.
    //
    // Flush is not supported on the _default stream, since it is not BUFFERED.
    virtual ::grpc::Status FlushRows(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest& request, ::google::cloud::bigquery::storage::v1::FlushRowsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::FlushRowsResponse>> AsyncFlushRows(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::FlushRowsResponse>>(AsyncFlushRowsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::FlushRowsResponse>> PrepareAsyncFlushRows(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::FlushRowsResponse>>(PrepareAsyncFlushRowsRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Creates a write stream to the given table.
      // Additionally, every table has a special stream named '_default'
      // to which data can be written. This stream doesn't need to be created using
      // CreateWriteStream. It is a stream that can be used simultaneously by any
      // number of clients. Data written to this stream is considered committed as
      // soon as an acknowledgement is received.
      virtual void CreateWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest* request, ::google::cloud::bigquery::storage::v1::WriteStream* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest* request, ::google::cloud::bigquery::storage::v1::WriteStream* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Appends data to the given stream.
      //
      // If `offset` is specified, the `offset` is checked against the end of
      // stream. The server returns `OUT_OF_RANGE` in `AppendRowsResponse` if an
      // attempt is made to append to an offset beyond the current end of the stream
      // or `ALREADY_EXISTS` if user provides an `offset` that has already been
      // written to. User can retry with adjusted offset within the same RPC
      // connection. If `offset` is not specified, append happens at the end of the
      // stream.
      //
      // The response contains an optional offset at which the append
      // happened.  No offset information will be returned for appends to a
      // default stream.
      //
      // Responses are received in the same order in which requests are sent.
      // There will be one response for each successful inserted request.  Responses
      // may optionally embed error information if the originating AppendRequest was
      // not successfully processed.
      //
      // The specifics of when successfully appended data is made visible to the
      // table are governed by the type of stream:
      //
      // * For COMMITTED streams (which includes the default stream), data is
      // visible immediately upon successful append.
      //
      // * For BUFFERED streams, data is made visible via a subsequent `FlushRows`
      // rpc which advances a cursor to a newer offset in the stream.
      //
      // * For PENDING streams, data is not made visible until the stream itself is
      // finalized (via the `FinalizeWriteStream` rpc), and the stream is explicitly
      // committed via the `BatchCommitWriteStreams` rpc.
      virtual void AppendRows(::grpc::ClientContext* context, ::grpc::ClientBidiReactor< ::google::cloud::bigquery::storage::v1::AppendRowsRequest,::google::cloud::bigquery::storage::v1::AppendRowsResponse>* reactor) = 0;
      // Gets information about a write stream.
      virtual void GetWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest* request, ::google::cloud::bigquery::storage::v1::WriteStream* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest* request, ::google::cloud::bigquery::storage::v1::WriteStream* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Finalize a write stream so that no new data can be appended to the
      // stream. Finalize is not supported on the '_default' stream.
      virtual void FinalizeWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest* request, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void FinalizeWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest* request, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Atomically commits a group of `PENDING` streams that belong to the same
      // `parent` table.
      //
      // Streams must be finalized before commit and cannot be committed multiple
      // times. Once a stream is committed, data in the stream becomes available
      // for read operations.
      virtual void BatchCommitWriteStreams(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest* request, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void BatchCommitWriteStreams(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest* request, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Flushes rows to a BUFFERED stream.
      //
      // If users are appending rows to BUFFERED stream, flush operation is
      // required in order for the rows to become available for reading. A
      // Flush operation flushes up to any previously flushed offset in a BUFFERED
      // stream, to the offset specified in the request.
      //
      // Flush is not supported on the _default stream, since it is not BUFFERED.
      virtual void FlushRows(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest* request, ::google::cloud::bigquery::storage::v1::FlushRowsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void FlushRows(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest* request, ::google::cloud::bigquery::storage::v1::FlushRowsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::WriteStream>* AsyncCreateWriteStreamRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::WriteStream>* PrepareAsyncCreateWriteStreamRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientReaderWriterInterface< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>* AppendRowsRaw(::grpc::ClientContext* context) = 0;
    virtual ::grpc::ClientAsyncReaderWriterInterface< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>* AsyncAppendRowsRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) = 0;
    virtual ::grpc::ClientAsyncReaderWriterInterface< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>* PrepareAsyncAppendRowsRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::WriteStream>* AsyncGetWriteStreamRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::WriteStream>* PrepareAsyncGetWriteStreamRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>* AsyncFinalizeWriteStreamRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>* PrepareAsyncFinalizeWriteStreamRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>* AsyncBatchCommitWriteStreamsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>* PrepareAsyncBatchCommitWriteStreamsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::FlushRowsResponse>* AsyncFlushRowsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::storage::v1::FlushRowsResponse>* PrepareAsyncFlushRowsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status CreateWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest& request, ::google::cloud::bigquery::storage::v1::WriteStream* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::WriteStream>> AsyncCreateWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::WriteStream>>(AsyncCreateWriteStreamRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::WriteStream>> PrepareAsyncCreateWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::WriteStream>>(PrepareAsyncCreateWriteStreamRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientReaderWriter< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>> AppendRows(::grpc::ClientContext* context) {
      return std::unique_ptr< ::grpc::ClientReaderWriter< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>>(AppendRowsRaw(context));
    }
    std::unique_ptr<  ::grpc::ClientAsyncReaderWriter< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>> AsyncAppendRows(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriter< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>>(AsyncAppendRowsRaw(context, cq, tag));
    }
    std::unique_ptr<  ::grpc::ClientAsyncReaderWriter< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>> PrepareAsyncAppendRows(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriter< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>>(PrepareAsyncAppendRowsRaw(context, cq));
    }
    ::grpc::Status GetWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest& request, ::google::cloud::bigquery::storage::v1::WriteStream* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::WriteStream>> AsyncGetWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::WriteStream>>(AsyncGetWriteStreamRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::WriteStream>> PrepareAsyncGetWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::WriteStream>>(PrepareAsyncGetWriteStreamRaw(context, request, cq));
    }
    ::grpc::Status FinalizeWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest& request, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>> AsyncFinalizeWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>>(AsyncFinalizeWriteStreamRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>> PrepareAsyncFinalizeWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>>(PrepareAsyncFinalizeWriteStreamRaw(context, request, cq));
    }
    ::grpc::Status BatchCommitWriteStreams(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest& request, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>> AsyncBatchCommitWriteStreams(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>>(AsyncBatchCommitWriteStreamsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>> PrepareAsyncBatchCommitWriteStreams(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>>(PrepareAsyncBatchCommitWriteStreamsRaw(context, request, cq));
    }
    ::grpc::Status FlushRows(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest& request, ::google::cloud::bigquery::storage::v1::FlushRowsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::FlushRowsResponse>> AsyncFlushRows(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::FlushRowsResponse>>(AsyncFlushRowsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::FlushRowsResponse>> PrepareAsyncFlushRows(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::FlushRowsResponse>>(PrepareAsyncFlushRowsRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void CreateWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest* request, ::google::cloud::bigquery::storage::v1::WriteStream* response, std::function<void(::grpc::Status)>) override;
      void CreateWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest* request, ::google::cloud::bigquery::storage::v1::WriteStream* response, ::grpc::ClientUnaryReactor* reactor) override;
      void AppendRows(::grpc::ClientContext* context, ::grpc::ClientBidiReactor< ::google::cloud::bigquery::storage::v1::AppendRowsRequest,::google::cloud::bigquery::storage::v1::AppendRowsResponse>* reactor) override;
      void GetWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest* request, ::google::cloud::bigquery::storage::v1::WriteStream* response, std::function<void(::grpc::Status)>) override;
      void GetWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest* request, ::google::cloud::bigquery::storage::v1::WriteStream* response, ::grpc::ClientUnaryReactor* reactor) override;
      void FinalizeWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest* request, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse* response, std::function<void(::grpc::Status)>) override;
      void FinalizeWriteStream(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest* request, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void BatchCommitWriteStreams(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest* request, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse* response, std::function<void(::grpc::Status)>) override;
      void BatchCommitWriteStreams(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest* request, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void FlushRows(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest* request, ::google::cloud::bigquery::storage::v1::FlushRowsResponse* response, std::function<void(::grpc::Status)>) override;
      void FlushRows(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest* request, ::google::cloud::bigquery::storage::v1::FlushRowsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::WriteStream>* AsyncCreateWriteStreamRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::WriteStream>* PrepareAsyncCreateWriteStreamRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientReaderWriter< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>* AppendRowsRaw(::grpc::ClientContext* context) override;
    ::grpc::ClientAsyncReaderWriter< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>* AsyncAppendRowsRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) override;
    ::grpc::ClientAsyncReaderWriter< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>* PrepareAsyncAppendRowsRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::WriteStream>* AsyncGetWriteStreamRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::WriteStream>* PrepareAsyncGetWriteStreamRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>* AsyncFinalizeWriteStreamRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>* PrepareAsyncFinalizeWriteStreamRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>* AsyncBatchCommitWriteStreamsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>* PrepareAsyncBatchCommitWriteStreamsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::FlushRowsResponse>* AsyncFlushRowsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::storage::v1::FlushRowsResponse>* PrepareAsyncFlushRowsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_CreateWriteStream_;
    const ::grpc::internal::RpcMethod rpcmethod_AppendRows_;
    const ::grpc::internal::RpcMethod rpcmethod_GetWriteStream_;
    const ::grpc::internal::RpcMethod rpcmethod_FinalizeWriteStream_;
    const ::grpc::internal::RpcMethod rpcmethod_BatchCommitWriteStreams_;
    const ::grpc::internal::RpcMethod rpcmethod_FlushRows_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Creates a write stream to the given table.
    // Additionally, every table has a special stream named '_default'
    // to which data can be written. This stream doesn't need to be created using
    // CreateWriteStream. It is a stream that can be used simultaneously by any
    // number of clients. Data written to this stream is considered committed as
    // soon as an acknowledgement is received.
    virtual ::grpc::Status CreateWriteStream(::grpc::ServerContext* context, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest* request, ::google::cloud::bigquery::storage::v1::WriteStream* response);
    // Appends data to the given stream.
    //
    // If `offset` is specified, the `offset` is checked against the end of
    // stream. The server returns `OUT_OF_RANGE` in `AppendRowsResponse` if an
    // attempt is made to append to an offset beyond the current end of the stream
    // or `ALREADY_EXISTS` if user provides an `offset` that has already been
    // written to. User can retry with adjusted offset within the same RPC
    // connection. If `offset` is not specified, append happens at the end of the
    // stream.
    //
    // The response contains an optional offset at which the append
    // happened.  No offset information will be returned for appends to a
    // default stream.
    //
    // Responses are received in the same order in which requests are sent.
    // There will be one response for each successful inserted request.  Responses
    // may optionally embed error information if the originating AppendRequest was
    // not successfully processed.
    //
    // The specifics of when successfully appended data is made visible to the
    // table are governed by the type of stream:
    //
    // * For COMMITTED streams (which includes the default stream), data is
    // visible immediately upon successful append.
    //
    // * For BUFFERED streams, data is made visible via a subsequent `FlushRows`
    // rpc which advances a cursor to a newer offset in the stream.
    //
    // * For PENDING streams, data is not made visible until the stream itself is
    // finalized (via the `FinalizeWriteStream` rpc), and the stream is explicitly
    // committed via the `BatchCommitWriteStreams` rpc.
    virtual ::grpc::Status AppendRows(::grpc::ServerContext* context, ::grpc::ServerReaderWriter< ::google::cloud::bigquery::storage::v1::AppendRowsResponse, ::google::cloud::bigquery::storage::v1::AppendRowsRequest>* stream);
    // Gets information about a write stream.
    virtual ::grpc::Status GetWriteStream(::grpc::ServerContext* context, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest* request, ::google::cloud::bigquery::storage::v1::WriteStream* response);
    // Finalize a write stream so that no new data can be appended to the
    // stream. Finalize is not supported on the '_default' stream.
    virtual ::grpc::Status FinalizeWriteStream(::grpc::ServerContext* context, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest* request, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse* response);
    // Atomically commits a group of `PENDING` streams that belong to the same
    // `parent` table.
    //
    // Streams must be finalized before commit and cannot be committed multiple
    // times. Once a stream is committed, data in the stream becomes available
    // for read operations.
    virtual ::grpc::Status BatchCommitWriteStreams(::grpc::ServerContext* context, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest* request, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse* response);
    // Flushes rows to a BUFFERED stream.
    //
    // If users are appending rows to BUFFERED stream, flush operation is
    // required in order for the rows to become available for reading. A
    // Flush operation flushes up to any previously flushed offset in a BUFFERED
    // stream, to the offset specified in the request.
    //
    // Flush is not supported on the _default stream, since it is not BUFFERED.
    virtual ::grpc::Status FlushRows(::grpc::ServerContext* context, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest* request, ::google::cloud::bigquery::storage::v1::FlushRowsResponse* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateWriteStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateWriteStream() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_CreateWriteStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateWriteStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::WriteStream* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateWriteStream(::grpc::ServerContext* context, ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::storage::v1::WriteStream>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_AppendRows : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_AppendRows() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_AppendRows() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status AppendRows(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::google::cloud::bigquery::storage::v1::AppendRowsResponse, ::google::cloud::bigquery::storage::v1::AppendRowsRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestAppendRows(::grpc::ServerContext* context, ::grpc::ServerAsyncReaderWriter< ::google::cloud::bigquery::storage::v1::AppendRowsResponse, ::google::cloud::bigquery::storage::v1::AppendRowsRequest>* stream, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncBidiStreaming(1, context, stream, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetWriteStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetWriteStream() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_GetWriteStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetWriteStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::WriteStream* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetWriteStream(::grpc::ServerContext* context, ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::storage::v1::WriteStream>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_FinalizeWriteStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_FinalizeWriteStream() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_FinalizeWriteStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status FinalizeWriteStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestFinalizeWriteStream(::grpc::ServerContext* context, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_BatchCommitWriteStreams : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_BatchCommitWriteStreams() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_BatchCommitWriteStreams() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status BatchCommitWriteStreams(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest* /*request*/, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestBatchCommitWriteStreams(::grpc::ServerContext* context, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_FlushRows : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_FlushRows() {
      ::grpc::Service::MarkMethodAsync(5);
    }
    ~WithAsyncMethod_FlushRows() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status FlushRows(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest* /*request*/, ::google::cloud::bigquery::storage::v1::FlushRowsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestFlushRows(::grpc::ServerContext* context, ::google::cloud::bigquery::storage::v1::FlushRowsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::storage::v1::FlushRowsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_CreateWriteStream<WithAsyncMethod_AppendRows<WithAsyncMethod_GetWriteStream<WithAsyncMethod_FinalizeWriteStream<WithAsyncMethod_BatchCommitWriteStreams<WithAsyncMethod_FlushRows<Service > > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_CreateWriteStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateWriteStream() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest, ::google::cloud::bigquery::storage::v1::WriteStream>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest* request, ::google::cloud::bigquery::storage::v1::WriteStream* response) { return this->CreateWriteStream(context, request, response); }));}
    void SetMessageAllocatorFor_CreateWriteStream(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest, ::google::cloud::bigquery::storage::v1::WriteStream>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest, ::google::cloud::bigquery::storage::v1::WriteStream>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateWriteStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateWriteStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::WriteStream* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateWriteStream(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::WriteStream* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_AppendRows : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_AppendRows() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackBidiHandler< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context) { return this->AppendRows(context); }));
    }
    ~WithCallbackMethod_AppendRows() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status AppendRows(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::google::cloud::bigquery::storage::v1::AppendRowsResponse, ::google::cloud::bigquery::storage::v1::AppendRowsRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerBidiReactor< ::google::cloud::bigquery::storage::v1::AppendRowsRequest, ::google::cloud::bigquery::storage::v1::AppendRowsResponse>* AppendRows(
      ::grpc::CallbackServerContext* /*context*/)
      { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetWriteStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetWriteStream() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest, ::google::cloud::bigquery::storage::v1::WriteStream>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest* request, ::google::cloud::bigquery::storage::v1::WriteStream* response) { return this->GetWriteStream(context, request, response); }));}
    void SetMessageAllocatorFor_GetWriteStream(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest, ::google::cloud::bigquery::storage::v1::WriteStream>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest, ::google::cloud::bigquery::storage::v1::WriteStream>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetWriteStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetWriteStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::WriteStream* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetWriteStream(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::WriteStream* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_FinalizeWriteStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_FinalizeWriteStream() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest* request, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse* response) { return this->FinalizeWriteStream(context, request, response); }));}
    void SetMessageAllocatorFor_FinalizeWriteStream(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_FinalizeWriteStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status FinalizeWriteStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* FinalizeWriteStream(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_BatchCommitWriteStreams : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_BatchCommitWriteStreams() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest* request, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse* response) { return this->BatchCommitWriteStreams(context, request, response); }));}
    void SetMessageAllocatorFor_BatchCommitWriteStreams(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_BatchCommitWriteStreams() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status BatchCommitWriteStreams(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest* /*request*/, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* BatchCommitWriteStreams(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest* /*request*/, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_FlushRows : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_FlushRows() {
      ::grpc::Service::MarkMethodCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::storage::v1::FlushRowsRequest, ::google::cloud::bigquery::storage::v1::FlushRowsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest* request, ::google::cloud::bigquery::storage::v1::FlushRowsResponse* response) { return this->FlushRows(context, request, response); }));}
    void SetMessageAllocatorFor_FlushRows(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::storage::v1::FlushRowsRequest, ::google::cloud::bigquery::storage::v1::FlushRowsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(5);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::storage::v1::FlushRowsRequest, ::google::cloud::bigquery::storage::v1::FlushRowsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_FlushRows() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status FlushRows(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest* /*request*/, ::google::cloud::bigquery::storage::v1::FlushRowsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* FlushRows(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest* /*request*/, ::google::cloud::bigquery::storage::v1::FlushRowsResponse* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_CreateWriteStream<WithCallbackMethod_AppendRows<WithCallbackMethod_GetWriteStream<WithCallbackMethod_FinalizeWriteStream<WithCallbackMethod_BatchCommitWriteStreams<WithCallbackMethod_FlushRows<Service > > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_CreateWriteStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateWriteStream() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_CreateWriteStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateWriteStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::WriteStream* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_AppendRows : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_AppendRows() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_AppendRows() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status AppendRows(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::google::cloud::bigquery::storage::v1::AppendRowsResponse, ::google::cloud::bigquery::storage::v1::AppendRowsRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetWriteStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetWriteStream() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_GetWriteStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetWriteStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::WriteStream* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_FinalizeWriteStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_FinalizeWriteStream() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_FinalizeWriteStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status FinalizeWriteStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_BatchCommitWriteStreams : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_BatchCommitWriteStreams() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_BatchCommitWriteStreams() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status BatchCommitWriteStreams(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest* /*request*/, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_FlushRows : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_FlushRows() {
      ::grpc::Service::MarkMethodGeneric(5);
    }
    ~WithGenericMethod_FlushRows() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status FlushRows(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest* /*request*/, ::google::cloud::bigquery::storage::v1::FlushRowsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateWriteStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateWriteStream() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_CreateWriteStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateWriteStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::WriteStream* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateWriteStream(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_AppendRows : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_AppendRows() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_AppendRows() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status AppendRows(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::google::cloud::bigquery::storage::v1::AppendRowsResponse, ::google::cloud::bigquery::storage::v1::AppendRowsRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestAppendRows(::grpc::ServerContext* context, ::grpc::ServerAsyncReaderWriter< ::grpc::ByteBuffer, ::grpc::ByteBuffer>* stream, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncBidiStreaming(1, context, stream, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetWriteStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetWriteStream() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_GetWriteStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetWriteStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::WriteStream* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetWriteStream(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_FinalizeWriteStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_FinalizeWriteStream() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_FinalizeWriteStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status FinalizeWriteStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestFinalizeWriteStream(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_BatchCommitWriteStreams : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_BatchCommitWriteStreams() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_BatchCommitWriteStreams() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status BatchCommitWriteStreams(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest* /*request*/, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestBatchCommitWriteStreams(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_FlushRows : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_FlushRows() {
      ::grpc::Service::MarkMethodRaw(5);
    }
    ~WithRawMethod_FlushRows() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status FlushRows(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest* /*request*/, ::google::cloud::bigquery::storage::v1::FlushRowsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestFlushRows(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateWriteStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateWriteStream() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateWriteStream(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateWriteStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateWriteStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::WriteStream* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateWriteStream(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_AppendRows : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_AppendRows() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackBidiHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context) { return this->AppendRows(context); }));
    }
    ~WithRawCallbackMethod_AppendRows() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status AppendRows(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::google::cloud::bigquery::storage::v1::AppendRowsResponse, ::google::cloud::bigquery::storage::v1::AppendRowsRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerBidiReactor< ::grpc::ByteBuffer, ::grpc::ByteBuffer>* AppendRows(
      ::grpc::CallbackServerContext* /*context*/)
      { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetWriteStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetWriteStream() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetWriteStream(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetWriteStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetWriteStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::WriteStream* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetWriteStream(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_FinalizeWriteStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_FinalizeWriteStream() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->FinalizeWriteStream(context, request, response); }));
    }
    ~WithRawCallbackMethod_FinalizeWriteStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status FinalizeWriteStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* FinalizeWriteStream(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_BatchCommitWriteStreams : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_BatchCommitWriteStreams() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->BatchCommitWriteStreams(context, request, response); }));
    }
    ~WithRawCallbackMethod_BatchCommitWriteStreams() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status BatchCommitWriteStreams(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest* /*request*/, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* BatchCommitWriteStreams(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_FlushRows : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_FlushRows() {
      ::grpc::Service::MarkMethodRawCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->FlushRows(context, request, response); }));
    }
    ~WithRawCallbackMethod_FlushRows() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status FlushRows(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest* /*request*/, ::google::cloud::bigquery::storage::v1::FlushRowsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* FlushRows(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateWriteStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateWriteStream() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest, ::google::cloud::bigquery::storage::v1::WriteStream>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest, ::google::cloud::bigquery::storage::v1::WriteStream>* streamer) {
                       return this->StreamedCreateWriteStream(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateWriteStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateWriteStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::WriteStream* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateWriteStream(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::storage::v1::CreateWriteStreamRequest,::google::cloud::bigquery::storage::v1::WriteStream>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetWriteStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetWriteStream() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest, ::google::cloud::bigquery::storage::v1::WriteStream>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest, ::google::cloud::bigquery::storage::v1::WriteStream>* streamer) {
                       return this->StreamedGetWriteStream(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetWriteStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetWriteStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::WriteStream* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetWriteStream(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::storage::v1::GetWriteStreamRequest,::google::cloud::bigquery::storage::v1::WriteStream>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_FinalizeWriteStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_FinalizeWriteStream() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>* streamer) {
                       return this->StreamedFinalizeWriteStream(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_FinalizeWriteStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status FinalizeWriteStream(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest* /*request*/, ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedFinalizeWriteStream(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest,::google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_BatchCommitWriteStreams : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_BatchCommitWriteStreams() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>* streamer) {
                       return this->StreamedBatchCommitWriteStreams(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_BatchCommitWriteStreams() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status BatchCommitWriteStreams(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest* /*request*/, ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedBatchCommitWriteStreams(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest,::google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_FlushRows : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_FlushRows() {
      ::grpc::Service::MarkMethodStreamed(5,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::storage::v1::FlushRowsRequest, ::google::cloud::bigquery::storage::v1::FlushRowsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::storage::v1::FlushRowsRequest, ::google::cloud::bigquery::storage::v1::FlushRowsResponse>* streamer) {
                       return this->StreamedFlushRows(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_FlushRows() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status FlushRows(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::storage::v1::FlushRowsRequest* /*request*/, ::google::cloud::bigquery::storage::v1::FlushRowsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedFlushRows(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::storage::v1::FlushRowsRequest,::google::cloud::bigquery::storage::v1::FlushRowsResponse>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_CreateWriteStream<WithStreamedUnaryMethod_GetWriteStream<WithStreamedUnaryMethod_FinalizeWriteStream<WithStreamedUnaryMethod_BatchCommitWriteStreams<WithStreamedUnaryMethod_FlushRows<Service > > > > > StreamedUnaryService;
  typedef Service SplitStreamedService;
  typedef WithStreamedUnaryMethod_CreateWriteStream<WithStreamedUnaryMethod_GetWriteStream<WithStreamedUnaryMethod_FinalizeWriteStream<WithStreamedUnaryMethod_BatchCommitWriteStreams<WithStreamedUnaryMethod_FlushRows<Service > > > > > StreamedService;
};

}  // namespace v1
}  // namespace storage
}  // namespace bigquery
}  // namespace cloud
}  // namespace google


#include <grpcpp/ports_undef.inc>
#endif  // GRPC_google_2fcloud_2fbigquery_2fstorage_2fv1_2fstorage_2eproto__INCLUDED
