/* Plug.c generated by valac 0.56.17, the Vala compiler
 * generated from Plug.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2014-2023 elementary, Inc. (https://elementary.io)
 * Authored by: Corentin Noël <tintou@mailoo.org>
 */

#include "security-privacy.h"
#include <gtk/gtk.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gmodule.h>

#define SECURITY_PRIVACY_PLUG_FIREWALL "firewall"
#define SECURITY_PRIVACY_PLUG_HOUSEKEEPING "housekeeping"
#define SECURITY_PRIVACY_PLUG_HISTORY "tracking"
#define SECURITY_PRIVACY_PLUG_LOCKING "locking"
#define SECURITY_PRIVACY_PLUG_LOCATION "location"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SECURITY_PRIVACY_PLUG_0_PROPERTY,
	SECURITY_PRIVACY_PLUG_NUM_PROPERTIES
};
static GParamSpec* security_privacy_plug_properties[SECURITY_PRIVACY_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SecurityPrivacyPlugSearchData SecurityPrivacyPlugSearchData;

struct _SecurityPrivacyPlugPrivate {
	GtkPaned* paned;
	GtkStack* stack;
};

struct _SecurityPrivacyPlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SecurityPrivacyPlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* map;
	GeeTreeMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
};

static gint SecurityPrivacyPlug_private_offset;
static gpointer security_privacy_plug_parent_class = NULL;

static GtkWidget* security_privacy_plug_real_get_widget (SwitchboardPlug* base);
static void security_privacy_plug_real_shown (SwitchboardPlug* base);
static void security_privacy_plug_real_hidden (SwitchboardPlug* base);
static void security_privacy_plug_real_search_callback (SwitchboardPlug* base,
                                                 const gchar* location);
static void security_privacy_plug_real_search_data_free (gpointer _data);
static void security_privacy_plug_real_search (SwitchboardPlug* base,
                                        const gchar* search,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gboolean security_privacy_plug_real_search_co (SecurityPrivacyPlugSearchData* _data_);
static void security_privacy_plug_finalize (GObject * obj);
static GType security_privacy_plug_get_type_once (void);

static inline gpointer
security_privacy_plug_get_instance_private (SecurityPrivacyPlug* self)
{
	return G_STRUCT_MEMBER_P (self, SecurityPrivacyPlug_private_offset);
}

SecurityPrivacyPlug*
security_privacy_plug_construct (GType object_type)
{
	SecurityPrivacyPlug * self = NULL;
	GeeTreeMap* _tmp0_;
	GeeTreeMap* _tmp1_;
	GeeTreeMap* _tmp2_;
	GeeTreeMap* _tmp3_;
	GeeTreeMap* _tmp4_;
	GeeTreeMap* _tmp5_;
	GeeTreeMap* _tmp6_;
	GeeTreeMap* _tmp7_;
	GeeTreeMap* _tmp8_;
	GeeTreeMap* _tmp9_;
	GeeTreeMap* _tmp10_;
	GeeTreeMap* _tmp11_;
	GeeTreeMap* _tmp12_;
	GeeTreeMap* _tmp13_;
	GeeTreeMap* _tmp14_;
	GeeTreeMap* _tmp15_;
	GeeTreeMap* _tmp16_;
	GeeTreeMap* _tmp17_;
	GeeTreeMap* _tmp18_;
	GeeTreeMap* _tmp19_;
	GeeTreeMap* _tmp20_;
	GeeTreeMap* _tmp21_;
	bindtextdomain (BUILD_GETTEXT_PACKAGE, BUILD_LOCALEDIR);
	bind_textdomain_codeset (BUILD_GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	self = (SecurityPrivacyPlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_PERSONAL, "code-name", "io.elementary.settings.security-privacy", "display-name", _ ("Security & Privacy"), "description", _ ("Configure firewall, screen lock, and activity information"), "icon", "preferences-system-privacy", "supported-settings", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = switchboard_plug_get_supported_settings ((SwitchboardPlug*) self);
	_tmp3_ = _tmp2_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, "privacy", SECURITY_PRIVACY_PLUG_HISTORY);
	_tmp4_ = switchboard_plug_get_supported_settings ((SwitchboardPlug*) self);
	_tmp5_ = _tmp4_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, "privacy/location", SECURITY_PRIVACY_PLUG_LOCATION);
	_tmp6_ = switchboard_plug_get_supported_settings ((SwitchboardPlug*) self);
	_tmp7_ = _tmp6_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp7_, "privacy/trash", SECURITY_PRIVACY_PLUG_HOUSEKEEPING);
	_tmp8_ = switchboard_plug_get_supported_settings ((SwitchboardPlug*) self);
	_tmp9_ = _tmp8_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, "security/firewall", SECURITY_PRIVACY_PLUG_FIREWALL);
	_tmp10_ = switchboard_plug_get_supported_settings ((SwitchboardPlug*) self);
	_tmp11_ = _tmp10_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, "security/locking", SECURITY_PRIVACY_PLUG_LOCKING);
	_tmp12_ = switchboard_plug_get_supported_settings ((SwitchboardPlug*) self);
	_tmp13_ = _tmp12_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, "security", NULL);
	_tmp14_ = switchboard_plug_get_supported_settings ((SwitchboardPlug*) self);
	_tmp15_ = _tmp14_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, "security/housekeeping", SECURITY_PRIVACY_PLUG_HOUSEKEEPING);
	_tmp16_ = switchboard_plug_get_supported_settings ((SwitchboardPlug*) self);
	_tmp17_ = _tmp16_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, "security/privacy", SECURITY_PRIVACY_PLUG_HISTORY);
	_tmp18_ = switchboard_plug_get_supported_settings ((SwitchboardPlug*) self);
	_tmp19_ = _tmp18_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, "security/privacy/location", SECURITY_PRIVACY_PLUG_LOCATION);
	_tmp20_ = switchboard_plug_get_supported_settings ((SwitchboardPlug*) self);
	_tmp21_ = _tmp20_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, "security/screensaver", SECURITY_PRIVACY_PLUG_LOCKING);
	return self;
}

SecurityPrivacyPlug*
security_privacy_plug_new (void)
{
	return security_privacy_plug_construct (SECURITY_PRIVACY_TYPE_PLUG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
security_privacy_plug_real_get_widget (SwitchboardPlug* base)
{
	SecurityPrivacyPlug * self;
	GtkPaned* _tmp0_;
	GtkPaned* _tmp24_;
	GtkWidget* _tmp25_;
	GtkWidget* result;
	self = (SecurityPrivacyPlug*) base;
	_tmp0_ = self->priv->paned;
	if (_tmp0_ == NULL) {
		SecurityPrivacyTrackPanel* tracking = NULL;
		SecurityPrivacyTrackPanel* _tmp1_;
		SecurityPrivacyLockPanel* locking = NULL;
		SecurityPrivacyLockPanel* _tmp2_;
		SecurityPrivacyFirewallPanel* firewall = NULL;
		SecurityPrivacyFirewallPanel* _tmp3_;
		SecurityPrivacyHouseKeepingPanel* housekeeping = NULL;
		SecurityPrivacyHouseKeepingPanel* _tmp4_;
		SecurityPrivacyLocationPanel* location = NULL;
		SecurityPrivacyLocationPanel* _tmp5_;
		GtkStack* _tmp6_;
		GtkStack* _tmp7_;
		SecurityPrivacyTrackPanel* _tmp8_;
		GtkStack* _tmp9_;
		SecurityPrivacyLockPanel* _tmp10_;
		GtkStack* _tmp11_;
		SecurityPrivacyFirewallPanel* _tmp12_;
		GtkStack* _tmp13_;
		SecurityPrivacyHouseKeepingPanel* _tmp14_;
		GtkStack* _tmp15_;
		SecurityPrivacyLocationPanel* _tmp16_;
		SwitchboardSettingsSidebar* settings_sidebar = NULL;
		GtkStack* _tmp17_;
		SwitchboardSettingsSidebar* _tmp18_ = NULL;
		SwitchboardSettingsSidebar* _tmp19_;
		GtkWidget* _tmp20_;
		GtkStack* _tmp21_;
		GtkWidget* _tmp22_;
		GtkPaned* _tmp23_ = NULL;
		_tmp1_ = security_privacy_track_panel_new ();
		g_object_ref_sink (_tmp1_);
		tracking = _tmp1_;
		_tmp2_ = security_privacy_lock_panel_new ();
		g_object_ref_sink (_tmp2_);
		locking = _tmp2_;
		_tmp3_ = security_privacy_firewall_panel_new ();
		g_object_ref_sink (_tmp3_);
		firewall = _tmp3_;
		_tmp4_ = security_privacy_house_keeping_panel_new ();
		g_object_ref_sink (_tmp4_);
		housekeeping = _tmp4_;
		_tmp5_ = security_privacy_location_panel_new ();
		g_object_ref_sink (_tmp5_);
		location = _tmp5_;
		_tmp6_ = (GtkStack*) gtk_stack_new ();
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (self->priv->stack);
		self->priv->stack = _tmp6_;
		_tmp7_ = self->priv->stack;
		_tmp8_ = tracking;
		gtk_stack_add_titled (_tmp7_, (GtkWidget*) _tmp8_, SECURITY_PRIVACY_PLUG_HISTORY, _ ("Privacy"));
		_tmp9_ = self->priv->stack;
		_tmp10_ = locking;
		gtk_stack_add_titled (_tmp9_, (GtkWidget*) _tmp10_, SECURITY_PRIVACY_PLUG_LOCKING, _ ("Locking"));
		_tmp11_ = self->priv->stack;
		_tmp12_ = firewall;
		gtk_stack_add_titled (_tmp11_, (GtkWidget*) _tmp12_, SECURITY_PRIVACY_PLUG_FIREWALL, _ ("Firewall"));
		_tmp13_ = self->priv->stack;
		_tmp14_ = housekeeping;
		gtk_stack_add_titled (_tmp13_, (GtkWidget*) _tmp14_, SECURITY_PRIVACY_PLUG_HOUSEKEEPING, _ ("Housekeeping"));
		_tmp15_ = self->priv->stack;
		_tmp16_ = location;
		gtk_stack_add_titled (_tmp15_, (GtkWidget*) _tmp16_, SECURITY_PRIVACY_PLUG_LOCATION, _ ("Location Services"));
		_tmp17_ = self->priv->stack;
		_tmp18_ = switchboard_settings_sidebar_new (_tmp17_);
		switchboard_settings_sidebar_set_show_title_buttons (_tmp18_, TRUE);
		g_object_ref_sink (_tmp18_);
		settings_sidebar = _tmp18_;
		_tmp19_ = settings_sidebar;
		_tmp20_ = _g_object_ref0 ((GtkWidget*) _tmp19_);
		_tmp21_ = self->priv->stack;
		_tmp22_ = _g_object_ref0 ((GtkWidget*) _tmp21_);
		_tmp23_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
		gtk_paned_set_start_child (_tmp23_, _tmp20_);
		_g_object_unref0 (_tmp20_);
		gtk_paned_set_end_child (_tmp23_, _tmp22_);
		_g_object_unref0 (_tmp22_);
		gtk_paned_set_shrink_start_child (_tmp23_, FALSE);
		gtk_paned_set_shrink_end_child (_tmp23_, FALSE);
		gtk_paned_set_resize_start_child (_tmp23_, FALSE);
		g_object_ref_sink (_tmp23_);
		_g_object_unref0 (self->priv->paned);
		self->priv->paned = _tmp23_;
		_g_object_unref0 (settings_sidebar);
		_g_object_unref0 (location);
		_g_object_unref0 (housekeeping);
		_g_object_unref0 (firewall);
		_g_object_unref0 (locking);
		_g_object_unref0 (tracking);
	}
	_tmp24_ = self->priv->paned;
	_tmp25_ = _g_object_ref0 ((GtkWidget*) _tmp24_);
	result = _tmp25_;
	return result;
}

static void
security_privacy_plug_real_shown (SwitchboardPlug* base)
{
	SecurityPrivacyPlug * self;
	self = (SecurityPrivacyPlug*) base;
}

static void
security_privacy_plug_real_hidden (SwitchboardPlug* base)
{
	SecurityPrivacyPlug * self;
	self = (SecurityPrivacyPlug*) base;
}

static void
security_privacy_plug_real_search_callback (SwitchboardPlug* base,
                                            const gchar* location)
{
	SecurityPrivacyPlug * self;
	GtkStack* _tmp0_;
	self = (SecurityPrivacyPlug*) base;
	g_return_if_fail (location != NULL);
	_tmp0_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp0_, location);
}

static void
security_privacy_plug_real_search_data_free (gpointer _data)
{
	SecurityPrivacyPlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SecurityPrivacyPlugSearchData, _data_);
}

static void
security_privacy_plug_real_search (SwitchboardPlug* base,
                                   const gchar* search,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	SecurityPrivacyPlug * self;
	SecurityPrivacyPlugSearchData* _data_;
	SecurityPrivacyPlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (SecurityPrivacyPlug*) base;
	_data_ = g_slice_new0 (SecurityPrivacyPlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, security_privacy_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	security_privacy_plug_real_search_co (_data_);
}

static GeeTreeMap*
security_privacy_plug_search_finish (SwitchboardPlug* base,
                                     GAsyncResult* _res_)
{
	GeeTreeMap* result;
	SecurityPrivacyPlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
security_privacy_plug_real_search_co (SecurityPrivacyPlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->map = _data_->_tmp0_;
	_data_->_tmp1_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_strdup_printf ("%s → %s", _data_->_tmp2_, _ ("History"));
	_data_->_tmp4_ = _data_->_tmp3_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->map, _data_->_tmp4_, SECURITY_PRIVACY_PLUG_HISTORY);
	_g_free0 (_data_->_tmp4_);
	_data_->_tmp5_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp6_, _ ("History"), _ ("Clear History"));
	_data_->_tmp8_ = _data_->_tmp7_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->map, _data_->_tmp8_, SECURITY_PRIVACY_PLUG_HISTORY);
	_g_free0 (_data_->_tmp8_);
	_data_->_tmp9_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = g_strdup_printf ("%s → %s", _data_->_tmp10_, _ ("Locking"));
	_data_->_tmp12_ = _data_->_tmp11_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->map, _data_->_tmp12_, SECURITY_PRIVACY_PLUG_LOCKING);
	_g_free0 (_data_->_tmp12_);
	_data_->_tmp13_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp15_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp14_, _ ("Locking"), _ ("Lock on sleep"));
	_data_->_tmp16_ = _data_->_tmp15_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->map, _data_->_tmp16_, SECURITY_PRIVACY_PLUG_HISTORY);
	_g_free0 (_data_->_tmp16_);
	_data_->_tmp17_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp18_, _ ("Locking"), _ ("Lock after sceen turns off"));
	_data_->_tmp20_ = _data_->_tmp19_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->map, _data_->_tmp20_, SECURITY_PRIVACY_PLUG_HISTORY);
	_g_free0 (_data_->_tmp20_);
	_data_->_tmp21_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_tmp23_ = g_strdup_printf ("%s → %s", _data_->_tmp22_, _ ("Firewall"));
	_data_->_tmp24_ = _data_->_tmp23_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->map, _data_->_tmp24_, SECURITY_PRIVACY_PLUG_FIREWALL);
	_g_free0 (_data_->_tmp24_);
	_data_->_tmp25_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp26_ = _data_->_tmp25_;
	_data_->_tmp27_ = g_strdup_printf ("%s → %s", _data_->_tmp26_, _ ("Housekeeping"));
	_data_->_tmp28_ = _data_->_tmp27_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->map, _data_->_tmp28_, SECURITY_PRIVACY_PLUG_HOUSEKEEPING);
	_g_free0 (_data_->_tmp28_);
	_data_->_tmp29_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp30_ = _data_->_tmp29_;
	_data_->_tmp31_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp30_, _ ("Housekeeping"), _ ("Automatically delete old temporary files"));
	_data_->_tmp32_ = _data_->_tmp31_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->map, _data_->_tmp32_, SECURITY_PRIVACY_PLUG_HOUSEKEEPING);
	_g_free0 (_data_->_tmp32_);
	_data_->_tmp33_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp34_ = _data_->_tmp33_;
	_data_->_tmp35_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp34_, _ ("Housekeeping"), _ ("Automatically delete old screenshot files"));
	_data_->_tmp36_ = _data_->_tmp35_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->map, _data_->_tmp36_, SECURITY_PRIVACY_PLUG_HOUSEKEEPING);
	_g_free0 (_data_->_tmp36_);
	_data_->_tmp37_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp38_ = _data_->_tmp37_;
	_data_->_tmp39_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp38_, _ ("Housekeeping"), _ ("Automatically delete old trashed files"));
	_data_->_tmp40_ = _data_->_tmp39_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->map, _data_->_tmp40_, SECURITY_PRIVACY_PLUG_HOUSEKEEPING);
	_g_free0 (_data_->_tmp40_);
	_data_->_tmp41_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp42_ = _data_->_tmp41_;
	_data_->_tmp43_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp42_, _ ("Housekeeping"), _ ("Number of days to keep trashed and temporary files"));
	_data_->_tmp44_ = _data_->_tmp43_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->map, _data_->_tmp44_, SECURITY_PRIVACY_PLUG_HOUSEKEEPING);
	_g_free0 (_data_->_tmp44_);
	_data_->_tmp45_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp46_ = _data_->_tmp45_;
	_data_->_tmp47_ = g_strdup_printf ("%s → %s", _data_->_tmp46_, _ ("Location Services"));
	_data_->_tmp48_ = _data_->_tmp47_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->map, _data_->_tmp48_, SECURITY_PRIVACY_PLUG_LOCATION);
	_g_free0 (_data_->_tmp48_);
	_data_->result = _data_->map;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
security_privacy_plug_class_init (SecurityPrivacyPlugClass * klass,
                                  gpointer klass_data)
{
	security_privacy_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SecurityPrivacyPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) security_privacy_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) security_privacy_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) security_privacy_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) security_privacy_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) security_privacy_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) security_privacy_plug_search_finish;
	G_OBJECT_CLASS (klass)->finalize = security_privacy_plug_finalize;
}

static void
security_privacy_plug_instance_init (SecurityPrivacyPlug * self,
                                     gpointer klass)
{
	self->priv = security_privacy_plug_get_instance_private (self);
}

static void
security_privacy_plug_finalize (GObject * obj)
{
	SecurityPrivacyPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SECURITY_PRIVACY_TYPE_PLUG, SecurityPrivacyPlug);
	_g_object_unref0 (self->priv->paned);
	_g_object_unref0 (self->priv->stack);
	G_OBJECT_CLASS (security_privacy_plug_parent_class)->finalize (obj);
}

static GType
security_privacy_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SecurityPrivacyPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) security_privacy_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SecurityPrivacyPlug), 0, (GInstanceInitFunc) security_privacy_plug_instance_init, NULL };
	GType security_privacy_plug_type_id;
	security_privacy_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "SecurityPrivacyPlug", &g_define_type_info, 0);
	SecurityPrivacyPlug_private_offset = g_type_add_instance_private (security_privacy_plug_type_id, sizeof (SecurityPrivacyPlugPrivate));
	return security_privacy_plug_type_id;
}

GType
security_privacy_plug_get_type (void)
{
	static volatile gsize security_privacy_plug_type_id__once = 0;
	if (g_once_init_enter (&security_privacy_plug_type_id__once)) {
		GType security_privacy_plug_type_id;
		security_privacy_plug_type_id = security_privacy_plug_get_type_once ();
		g_once_init_leave (&security_privacy_plug_type_id__once, security_privacy_plug_type_id);
	}
	return security_privacy_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	SecurityPrivacyPlug* plug = NULL;
	SecurityPrivacyPlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Plug.vala:117: Activating Security & Privacy plug");
	_tmp0_ = security_privacy_plug_new ();
	plug = _tmp0_;
	result = (SwitchboardPlug*) plug;
	return result;
}

