/* PrinterList.c generated by valac 0.56.17, the Vala compiler
 * generated from PrinterList.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2015-2023 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "io.elementary.settings.printers.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <adwaita.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PRINTERS_PRINTER_LIST_0_PROPERTY,
	PRINTERS_PRINTER_LIST_STACK_PROPERTY,
	PRINTERS_PRINTER_LIST_HAS_CHILD_PROPERTY,
	PRINTERS_PRINTER_LIST_NUM_PROPERTIES
};
static GParamSpec* printers_printer_list_properties[PRINTERS_PRINTER_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
enum  {
	PRINTERS_PRINTER_LIST_NEW_PRINTER_PAGE_SIGNAL,
	PRINTERS_PRINTER_LIST_NUM_SIGNALS
};
static guint printers_printer_list_signals[PRINTERS_PRINTER_LIST_NUM_SIGNALS] = {0};

struct _PrintersPrinterListPrivate {
	GtkStack* _stack;
	gboolean _has_child;
	GtkListBox* list_box;
};

struct _Block2Data {
	int _ref_count_;
	PrintersPrinterList* self;
	PrintersPrinterRow* row;
};

static gint PrintersPrinterList_private_offset;
static gpointer printers_printer_list_parent_class = NULL;

static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void printers_printer_list_set_has_child (PrintersPrinterList* self,
                                          gboolean value);
static void __lambda26_ (Block2Data* _data2_);
static void ___lambda26__gtk_widget_destroy (GtkWidget* _sender,
                                      gpointer self);
static GObject * printers_printer_list_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void _printers_printer_list___lambda27_ (PrintersPrinterList* self,
                                         GtkListBoxRow* row);
static void __printers_printer_list___lambda27__gtk_list_box_row_selected (GtkListBox* _sender,
                                                                    GtkListBoxRow* row,
                                                                    gpointer self);
static void _printers_printer_list___lambda28_ (PrintersPrinterList* self);
static void __printers_printer_list___lambda28__gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void _printers_printer_list___lambda45_ (PrintersPrinterList* self,
                                         PrintersPrinter* printer);
static void __printers_printer_list___lambda45__printers_printer_manager_printer_added (PrintersPrinterManager* _sender,
                                                                                 PrintersPrinter* printer,
                                                                                 gpointer self);
static void printers_printer_list_finalize (GObject * obj);
static GType printers_printer_list_get_type_once (void);
static void _vala_printers_printer_list_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_printers_printer_list_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
printers_printer_list_get_instance_private (PrintersPrinterList* self)
{
	return G_STRUCT_MEMBER_P (self, PrintersPrinterList_private_offset);
}

PrintersPrinterList*
printers_printer_list_construct (GType object_type,
                                 GtkStack* stack)
{
	PrintersPrinterList * self = NULL;
	g_return_val_if_fail (stack != NULL, NULL);
	self = (PrintersPrinterList*) g_object_new (object_type, "stack", stack, NULL);
	return self;
}

PrintersPrinterList*
printers_printer_list_new (GtkStack* stack)
{
	return printers_printer_list_construct (PRINTERS_TYPE_PRINTER_LIST, stack);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		PrintersPrinterList* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->row);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda26_ (Block2Data* _data2_)
{
	PrintersPrinterList* self;
	GtkListBox* _tmp0_;
	PrintersPrinterRow* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBoxRow* _tmp3_;
	self = _data2_->self;
	_tmp0_ = self->priv->list_box;
	_tmp1_ = _data2_->row;
	gtk_list_box_remove (_tmp0_, (GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->list_box;
	_tmp3_ = gtk_list_box_get_row_at_index (_tmp2_, 0);
	printers_printer_list_set_has_child (self, _tmp3_ != NULL);
}

static void
___lambda26__gtk_widget_destroy (GtkWidget* _sender,
                                 gpointer self)
{
	__lambda26_ (self);
}

void
printers_printer_list_add_printer (PrintersPrinterList* self,
                                   PrintersPrinter* printer)
{
	Block2Data* _data2_;
	PrintersPrinterRow* _tmp0_;
	GtkListBox* _tmp1_;
	PrintersPrinterRow* _tmp2_;
	GtkStack* _tmp3_;
	PrintersPrinterRow* _tmp4_;
	PrintersPrinterPage* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	PrintersPrinterRow* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (printer != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = printers_printer_row_new (printer);
	g_object_ref_sink (_tmp0_);
	_data2_->row = _tmp0_;
	_tmp1_ = self->priv->list_box;
	_tmp2_ = _data2_->row;
	gtk_list_box_append (_tmp1_, (GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->_stack;
	_tmp4_ = _data2_->row;
	_tmp5_ = _tmp4_->page;
	gtk_stack_add_child (_tmp3_, (GtkWidget*) _tmp5_);
	_tmp6_ = printers_printer_get_is_default (printer);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		GtkListBox* _tmp8_;
		PrintersPrinterRow* _tmp9_;
		_tmp8_ = self->priv->list_box;
		_tmp9_ = _data2_->row;
		gtk_list_box_select_row (_tmp8_, (GtkListBoxRow*) _tmp9_);
	}
	printers_printer_list_set_has_child (self, TRUE);
	_tmp10_ = _data2_->row;
	g_signal_connect_data ((GtkWidget*) _tmp10_, "destroy", (GCallback) ___lambda26__gtk_widget_destroy, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

GtkStack*
printers_printer_list_get_stack (PrintersPrinterList* self)
{
	GtkStack* result;
	GtkStack* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_stack;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
printers_printer_list_set_stack (PrintersPrinterList* self,
                                 GtkStack* value)
{
	GtkStack* old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_printer_list_get_stack (self);
	if (old_value != value) {
		GtkStack* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_stack);
		self->priv->_stack = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, printers_printer_list_properties[PRINTERS_PRINTER_LIST_STACK_PROPERTY]);
	}
}

gboolean
printers_printer_list_get_has_child (PrintersPrinterList* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_child;
	return result;
}

static void
printers_printer_list_set_has_child (PrintersPrinterList* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_printer_list_get_has_child (self);
	if (old_value != value) {
		self->priv->_has_child = value;
		g_object_notify_by_pspec ((GObject *) self, printers_printer_list_properties[PRINTERS_PRINTER_LIST_HAS_CHILD_PROPERTY]);
	}
}

static void
_printers_printer_list___lambda27_ (PrintersPrinterList* self,
                                    GtkListBoxRow* row)
{
	if (row != NULL) {
		GtkStack* _tmp0_;
		PrintersPrinterPage* _tmp1_;
		_tmp0_ = self->priv->_stack;
		_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (row, PRINTERS_TYPE_PRINTER_ROW, PrintersPrinterRow)->page;
		gtk_stack_set_visible_child (_tmp0_, (GtkWidget*) _tmp1_);
	}
}

static void
__printers_printer_list___lambda27__gtk_list_box_row_selected (GtkListBox* _sender,
                                                               GtkListBoxRow* row,
                                                               gpointer self)
{
	_printers_printer_list___lambda27_ ((PrintersPrinterList*) self, row);
}

static void
_printers_printer_list___lambda28_ (PrintersPrinterList* self)
{
	PrintersAddDialog* add_dialog = NULL;
	GtkRoot* _tmp0_;
	GtkWindow* _tmp1_;
	PrintersAddDialog* _tmp2_ = NULL;
	PrintersAddDialog* _tmp3_;
	_tmp0_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow));
	_tmp2_ = printers_add_dialog_new ();
	gtk_window_set_modal ((GtkWindow*) _tmp2_, TRUE);
	gtk_window_set_transient_for ((GtkWindow*) _tmp2_, _tmp1_);
	_g_object_unref0 (_tmp1_);
	g_object_ref_sink (_tmp2_);
	add_dialog = _tmp2_;
	_tmp3_ = add_dialog;
	gtk_window_present ((GtkWindow*) _tmp3_);
	_g_object_unref0 (add_dialog);
}

static void
__printers_printer_list___lambda28__gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
	_printers_printer_list___lambda28_ ((PrintersPrinterList*) self);
}

static void
_printers_printer_list___lambda45_ (PrintersPrinterList* self,
                                    PrintersPrinter* printer)
{
	g_return_if_fail (printer != NULL);
	printers_printer_list_add_printer (self, printer);
}

static void
__printers_printer_list___lambda45__printers_printer_manager_printer_added (PrintersPrinterManager* _sender,
                                                                            PrintersPrinter* printer,
                                                                            gpointer self)
{
	_printers_printer_list___lambda45_ ((PrintersPrinterList*) self, printer);
}

static GObject *
printers_printer_list_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PrintersPrinterList * self;
	AdwHeaderBar* headerbar = NULL;
	AdwHeaderBar* _tmp0_ = NULL;
	GtkListBox* _tmp1_;
	GtkScrolledWindow* scrolled = NULL;
	GtkListBox* _tmp2_;
	GtkWidget* _tmp3_;
	GtkScrolledWindow* _tmp4_ = NULL;
	GtkBox* add_button_box = NULL;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkImage* _tmp7_;
	GtkImage* _tmp8_;
	GtkBox* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkButton* add_button = NULL;
	GtkBox* _tmp12_;
	GtkWidget* _tmp13_;
	GtkButton* _tmp14_ = NULL;
	GtkActionBar* actionbar = NULL;
	GtkActionBar* _tmp15_;
	GtkActionBar* _tmp16_;
	GtkButton* _tmp17_;
	AdwToolbarView* toolbarview = NULL;
	GtkScrolledWindow* _tmp18_;
	GtkWidget* _tmp19_;
	AdwToolbarView* _tmp20_ = NULL;
	AdwToolbarView* _tmp21_;
	AdwHeaderBar* _tmp22_;
	AdwToolbarView* _tmp23_;
	GtkActionBar* _tmp24_;
	AdwToolbarView* _tmp25_;
	GtkListBox* _tmp26_;
	GtkButton* _tmp27_;
	PrintersPrinterManager* manager = NULL;
	PrintersPrinterManager* _tmp28_;
	PrintersPrinterManager* _tmp39_;
	parent_class = G_OBJECT_CLASS (printers_printer_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_TYPE_PRINTER_LIST, PrintersPrinterList);
	_tmp0_ = (AdwHeaderBar*) adw_header_bar_new ();
	adw_header_bar_set_show_end_title_buttons (_tmp0_, FALSE);
	adw_header_bar_set_show_title (_tmp0_, FALSE);
	g_object_ref_sink (_tmp0_);
	headerbar = _tmp0_;
	_tmp1_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->list_box);
	self->priv->list_box = _tmp1_;
	_tmp2_ = self->priv->list_box;
	_tmp3_ = _g_object_ref0 ((GtkWidget*) _tmp2_);
	_tmp4_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp4_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	g_object_set (_tmp4_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp4_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp4_, TRUE);
	g_object_ref_sink (_tmp4_);
	scrolled = _tmp4_;
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp5_);
	add_button_box = _tmp5_;
	_tmp6_ = add_button_box;
	_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic");
	g_object_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	gtk_box_append (_tmp6_, (GtkWidget*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = add_button_box;
	_tmp10_ = (GtkLabel*) gtk_label_new (_ ("Add Printer…"));
	g_object_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	gtk_box_append (_tmp9_, (GtkWidget*) _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = add_button_box;
	_tmp13_ = _g_object_ref0 ((GtkWidget*) _tmp12_);
	_tmp14_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp14_, _tmp13_);
	_g_object_unref0 (_tmp13_);
	gtk_button_set_has_frame (_tmp14_, FALSE);
	g_object_ref_sink (_tmp14_);
	add_button = _tmp14_;
	_tmp15_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp15_);
	actionbar = _tmp15_;
	_tmp16_ = actionbar;
	_tmp17_ = add_button;
	gtk_action_bar_pack_start (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = scrolled;
	_tmp19_ = _g_object_ref0 ((GtkWidget*) _tmp18_);
	_tmp20_ = (AdwToolbarView*) adw_toolbar_view_new ();
	adw_toolbar_view_set_content (_tmp20_, _tmp19_);
	_g_object_unref0 (_tmp19_);
	adw_toolbar_view_set_top_bar_style (_tmp20_, ADW_TOOLBAR_FLAT);
	adw_toolbar_view_set_bottom_bar_style (_tmp20_, ADW_TOOLBAR_RAISED);
	g_object_ref_sink (_tmp20_);
	toolbarview = _tmp20_;
	_tmp21_ = toolbarview;
	_tmp22_ = headerbar;
	adw_toolbar_view_add_top_bar (_tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = toolbarview;
	_tmp24_ = actionbar;
	adw_toolbar_view_add_bottom_bar (_tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = toolbarview;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp25_);
	gtk_widget_add_css_class ((GtkWidget*) self, GRANITE_STYLE_CLASS_SIDEBAR);
	_tmp26_ = self->priv->list_box;
	g_signal_connect_object (_tmp26_, "row-selected", (GCallback) __printers_printer_list___lambda27__gtk_list_box_row_selected, self, 0);
	_tmp27_ = add_button;
	g_signal_connect_object (_tmp27_, "clicked", (GCallback) __printers_printer_list___lambda28__gtk_button_clicked, self, 0);
	_tmp28_ = printers_printer_manager_get_default ();
	manager = _tmp28_;
	{
		GeeLinkedList* _printer_list = NULL;
		PrintersPrinterManager* _tmp29_;
		GeeLinkedList* _tmp30_;
		gint _printer_size = 0;
		GeeLinkedList* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gint _printer_index = 0;
		_tmp29_ = manager;
		_tmp30_ = printers_printer_manager_get_printers (_tmp29_);
		_printer_list = _tmp30_;
		_tmp31_ = _printer_list;
		_tmp32_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp31_);
		_tmp33_ = _tmp32_;
		_printer_size = _tmp33_;
		_printer_index = -1;
		while (TRUE) {
			gint _tmp34_;
			gint _tmp35_;
			PrintersPrinter* printer = NULL;
			GeeLinkedList* _tmp36_;
			gpointer _tmp37_;
			PrintersPrinter* _tmp38_;
			_printer_index = _printer_index + 1;
			_tmp34_ = _printer_index;
			_tmp35_ = _printer_size;
			if (!(_tmp34_ < _tmp35_)) {
				break;
			}
			_tmp36_ = _printer_list;
			_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, _printer_index);
			printer = (PrintersPrinter*) _tmp37_;
			_tmp38_ = printer;
			printers_printer_list_add_printer (self, _tmp38_);
			_g_object_unref0 (printer);
		}
	}
	_tmp39_ = manager;
	g_signal_connect_object (_tmp39_, "printer-added", (GCallback) __printers_printer_list___lambda45__printers_printer_manager_printer_added, self, 0);
	_g_object_unref0 (toolbarview);
	_g_object_unref0 (actionbar);
	_g_object_unref0 (add_button);
	_g_object_unref0 (add_button_box);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (headerbar);
	return obj;
}

static void
printers_printer_list_base_init (PrintersPrinterListClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "settingssidebar");
}

static void
printers_printer_list_class_init (PrintersPrinterListClass * klass,
                                  gpointer klass_data)
{
	printers_printer_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PrintersPrinterList_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_printers_printer_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_printers_printer_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = printers_printer_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = printers_printer_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_PRINTER_LIST_STACK_PROPERTY, printers_printer_list_properties[PRINTERS_PRINTER_LIST_STACK_PROPERTY] = g_param_spec_object ("stack", "stack", "stack", gtk_stack_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_PRINTER_LIST_HAS_CHILD_PROPERTY, printers_printer_list_properties[PRINTERS_PRINTER_LIST_HAS_CHILD_PROPERTY] = g_param_spec_boolean ("has-child", "has-child", "has-child", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	printers_printer_list_signals[PRINTERS_PRINTER_LIST_NEW_PRINTER_PAGE_SIGNAL] = g_signal_new ("new-printer-page", PRINTERS_TYPE_PRINTER_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, gtk_widget_get_type ());
}

static void
printers_printer_list_instance_init (PrintersPrinterList * self,
                                     gpointer klass)
{
	self->priv = printers_printer_list_get_instance_private (self);
	self->priv->_has_child = FALSE;
}

static void
printers_printer_list_finalize (GObject * obj)
{
	PrintersPrinterList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_TYPE_PRINTER_LIST, PrintersPrinterList);
	_g_object_unref0 (self->priv->_stack);
	_g_object_unref0 (self->priv->list_box);
	G_OBJECT_CLASS (printers_printer_list_parent_class)->finalize (obj);
}

static GType
printers_printer_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrintersPrinterListClass), (GBaseInitFunc) printers_printer_list_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) printers_printer_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintersPrinterList), 0, (GInstanceInitFunc) printers_printer_list_instance_init, NULL };
	GType printers_printer_list_type_id;
	printers_printer_list_type_id = g_type_register_static (gtk_box_get_type (), "PrintersPrinterList", &g_define_type_info, 0);
	PrintersPrinterList_private_offset = g_type_add_instance_private (printers_printer_list_type_id, sizeof (PrintersPrinterListPrivate));
	return printers_printer_list_type_id;
}

GType
printers_printer_list_get_type (void)
{
	static volatile gsize printers_printer_list_type_id__once = 0;
	if (g_once_init_enter (&printers_printer_list_type_id__once)) {
		GType printers_printer_list_type_id;
		printers_printer_list_type_id = printers_printer_list_get_type_once ();
		g_once_init_leave (&printers_printer_list_type_id__once, printers_printer_list_type_id);
	}
	return printers_printer_list_type_id__once;
}

static void
_vala_printers_printer_list_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	PrintersPrinterList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PRINTERS_TYPE_PRINTER_LIST, PrintersPrinterList);
	switch (property_id) {
		case PRINTERS_PRINTER_LIST_STACK_PROPERTY:
		g_value_set_object (value, printers_printer_list_get_stack (self));
		break;
		case PRINTERS_PRINTER_LIST_HAS_CHILD_PROPERTY:
		g_value_set_boolean (value, printers_printer_list_get_has_child (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_printers_printer_list_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	PrintersPrinterList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PRINTERS_TYPE_PRINTER_LIST, PrintersPrinterList);
	switch (property_id) {
		case PRINTERS_PRINTER_LIST_STACK_PROPERTY:
		printers_printer_list_set_stack (self, g_value_get_object (value));
		break;
		case PRINTERS_PRINTER_LIST_HAS_CHILD_PROPERTY:
		printers_printer_list_set_has_child (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

