/* TimeRestriction.c generated by valac 0.56.17, the Vala compiler
 * generated from TimeRestriction.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2016 Adam Bieńkowski (https://launchpad.net/switchboard-plug-parental-controls)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define PC_DAEMON_TIME_RESTRICTION_MINUTE_INTERVAL 60
#define PC_DAEMON_TIME_RESTRICTION_HOUR_INTERVAL 3600
#define PC_DAEMON_TIME_RESTRICTION_UPDATE_THROTTLE_INTERVAL ((guint) 3000)
#define PC_CONSTANTS_PAM_TIME_CONF_PATH "/etc/security/time.conf"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PC_DAEMON_TYPE_RESTRICTION (pc_daemon_restriction_get_type ())
#define PC_DAEMON_RESTRICTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_RESTRICTION, PCDaemonRestriction))
#define PC_DAEMON_RESTRICTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_DAEMON_TYPE_RESTRICTION, PCDaemonRestrictionClass))
#define PC_DAEMON_IS_RESTRICTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_RESTRICTION))
#define PC_DAEMON_IS_RESTRICTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_DAEMON_TYPE_RESTRICTION))
#define PC_DAEMON_RESTRICTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_DAEMON_TYPE_RESTRICTION, PCDaemonRestrictionClass))

typedef struct _PCDaemonRestriction PCDaemonRestriction;
typedef struct _PCDaemonRestrictionClass PCDaemonRestrictionClass;
typedef struct _PCDaemonRestrictionPrivate PCDaemonRestrictionPrivate;

#define PC_DAEMON_TYPE_USER_CONFIG (pc_daemon_user_config_get_type ())
#define PC_DAEMON_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_USER_CONFIG, PCDaemonUserConfig))
#define PC_DAEMON_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_DAEMON_TYPE_USER_CONFIG, PCDaemonUserConfigClass))
#define PC_DAEMON_IS_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_USER_CONFIG))
#define PC_DAEMON_IS_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_DAEMON_TYPE_USER_CONFIG))
#define PC_DAEMON_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_DAEMON_TYPE_USER_CONFIG, PCDaemonUserConfigClass))

typedef struct _PCDaemonUserConfig PCDaemonUserConfig;
typedef struct _PCDaemonUserConfigClass PCDaemonUserConfigClass;

#define PC_DAEMON_TYPE_TIME_RESTRICTION (pc_daemon_time_restriction_get_type ())
#define PC_DAEMON_TIME_RESTRICTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_TIME_RESTRICTION, PCDaemonTimeRestriction))
#define PC_DAEMON_TIME_RESTRICTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_DAEMON_TYPE_TIME_RESTRICTION, PCDaemonTimeRestrictionClass))
#define PC_DAEMON_IS_TIME_RESTRICTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_TIME_RESTRICTION))
#define PC_DAEMON_IS_TIME_RESTRICTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_DAEMON_TYPE_TIME_RESTRICTION))
#define PC_DAEMON_TIME_RESTRICTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_DAEMON_TYPE_TIME_RESTRICTION, PCDaemonTimeRestrictionClass))

typedef struct _PCDaemonTimeRestriction PCDaemonTimeRestriction;
typedef struct _PCDaemonTimeRestrictionClass PCDaemonTimeRestrictionClass;
typedef struct _PCDaemonTimeRestrictionPrivate PCDaemonTimeRestrictionPrivate;
enum  {
	PC_DAEMON_TIME_RESTRICTION_0_PROPERTY,
	PC_DAEMON_TIME_RESTRICTION_NUM_PROPERTIES
};
static GParamSpec* pc_daemon_time_restriction_properties[PC_DAEMON_TIME_RESTRICTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define PC_PAM_TYPE_TOKEN (pc_pam_token_get_type ())
#define PC_PAM_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_PAM_TYPE_TOKEN, PCPAMToken))
#define PC_PAM_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_PAM_TYPE_TOKEN, PCPAMTokenClass))
#define PC_PAM_IS_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_PAM_TYPE_TOKEN))
#define PC_PAM_IS_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_PAM_TYPE_TOKEN))
#define PC_PAM_TOKEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_PAM_TYPE_TOKEN, PCPAMTokenClass))

typedef struct _PCPAMToken PCPAMToken;
typedef struct _PCPAMTokenClass PCPAMTokenClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define PC_PAM_TYPE_TIME_INFO (pc_pam_time_info_get_type ())
#define PC_PAM_TIME_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_PAM_TYPE_TIME_INFO, PCPAMTimeInfo))
#define PC_PAM_TIME_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_PAM_TYPE_TIME_INFO, PCPAMTimeInfoClass))
#define PC_PAM_IS_TIME_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_PAM_TYPE_TIME_INFO))
#define PC_PAM_IS_TIME_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_PAM_TYPE_TIME_INFO))
#define PC_PAM_TIME_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_PAM_TYPE_TIME_INFO, PCPAMTimeInfoClass))

typedef struct _PCPAMTimeInfo PCPAMTimeInfo;
typedef struct _PCPAMTimeInfoClass PCPAMTimeInfoClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _PCPAMTimeInfoPrivate PCPAMTimeInfoPrivate;
typedef enum  {
	PC_PAM_DAY_TYPE_UNKNOWN,
	PC_PAM_DAY_TYPE_ALL,
	PC_PAM_DAY_TYPE_WEEKDAY,
	PC_PAM_DAY_TYPE_WEEKEND
} PCPAMDayType;

#define PC_PAM_TYPE_DAY_TYPE (pc_pam_day_type_get_type ())
#define _pc_pam_time_info_unref0(var) ((var == NULL) ? NULL : (var = (pc_pam_time_info_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;

#define PC_DAEMON_TYPE_SERVER (pc_daemon_server_get_type ())
#define PC_DAEMON_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_SERVER, PCDaemonServer))
#define PC_DAEMON_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_DAEMON_TYPE_SERVER, PCDaemonServerClass))
#define PC_DAEMON_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_SERVER))
#define PC_DAEMON_IS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_DAEMON_TYPE_SERVER))
#define PC_DAEMON_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_DAEMON_TYPE_SERVER, PCDaemonServerClass))

typedef struct _PCDaemonServer PCDaemonServer;
typedef struct _PCDaemonServerClass PCDaemonServerClass;
enum  {
	PC_DAEMON_TIME_RESTRICTION_TERMINATE_SIGNAL,
	PC_DAEMON_TIME_RESTRICTION_NUM_SIGNALS
};
static guint pc_daemon_time_restriction_signals[PC_DAEMON_TIME_RESTRICTION_NUM_SIGNALS] = {0};

struct _PCDaemonRestriction {
	GObject parent_instance;
	PCDaemonRestrictionPrivate * priv;
	PCDaemonUserConfig* config;
};

struct _PCDaemonRestrictionClass {
	GObjectClass parent_class;
	void (*start) (PCDaemonRestriction* self);
	void (*stop) (PCDaemonRestriction* self);
};

struct _PCDaemonTimeRestriction {
	PCDaemonRestriction parent_instance;
	PCDaemonTimeRestrictionPrivate * priv;
};

struct _PCDaemonTimeRestrictionClass {
	PCDaemonRestrictionClass parent_class;
};

struct _PCDaemonTimeRestrictionPrivate {
	GFile* time_file;
	GFileMonitor* monitor;
	GeeArrayList* timeout_ids;
	guint update_timeout_id;
};

struct _PCPAMTimeInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PCPAMTimeInfoPrivate * priv;
	PCPAMDayType day_type;
	gchar* from;
	gchar* to;
};

struct _PCPAMTimeInfoClass {
	GTypeClass parent_class;
	void (*finalize) (PCPAMTimeInfo *self);
};

struct _Block4Data {
	int _ref_count_;
	PCDaemonTimeRestriction* self;
	guint tid;
	gint minutes;
};

static gint PCDaemonTimeRestriction_private_offset;
static gpointer pc_daemon_time_restriction_parent_class = NULL;

VALA_EXTERN GType pc_daemon_restriction_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonRestriction, g_object_unref)
VALA_EXTERN GType pc_daemon_user_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonUserConfig, g_object_unref)
VALA_EXTERN GType pc_daemon_time_restriction_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonTimeRestriction, g_object_unref)
VALA_EXTERN void pc_daemon_restriction_start (PCDaemonRestriction* self);
VALA_EXTERN void pc_daemon_restriction_stop (PCDaemonRestriction* self);
VALA_EXTERN PCDaemonTimeRestriction* pc_daemon_time_restriction_new (PCDaemonUserConfig* config);
VALA_EXTERN PCDaemonTimeRestriction* pc_daemon_time_restriction_construct (GType object_type,
                                                               PCDaemonUserConfig* config);
VALA_EXTERN PCDaemonRestriction* pc_daemon_restriction_construct (GType object_type,
                                                      PCDaemonUserConfig* config);
static void pc_daemon_time_restriction_real_start (PCDaemonRestriction* base);
VALA_EXTERN GType pc_pam_token_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCPAMToken, g_object_unref)
VALA_EXTERN PCPAMToken* pc_pam_reader_get_token_for_user (const gchar* filename,
                                              const gchar* username);
VALA_EXTERN const gchar* pc_daemon_user_config_get_username (PCDaemonUserConfig* self);
static void pc_daemon_time_restriction_process_token (PCDaemonTimeRestriction* self,
                                               PCPAMToken* token);
static void pc_daemon_time_restriction_on_time_file_changed (PCDaemonTimeRestriction* self,
                                                      GFile* file,
                                                      GFile* other,
                                                      GFileMonitorEvent type);
static void _pc_daemon_time_restriction_on_time_file_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                              GFile* file,
                                                                              GFile* other_file,
                                                                              GFileMonitorEvent event_type,
                                                                              gpointer self);
static void pc_daemon_time_restriction_real_stop (PCDaemonRestriction* base);
static void pc_daemon_time_restriction_update (PCDaemonTimeRestriction* self);
static gboolean __lambda7_ (PCDaemonTimeRestriction* self);
static gboolean ___lambda7__gsource_func (gpointer self);
VALA_EXTERN gpointer pc_pam_time_info_ref (gpointer instance);
VALA_EXTERN void pc_pam_time_info_unref (gpointer instance);
VALA_EXTERN GParamSpec* pc_pam_param_spec_time_info (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void pc_pam_value_set_time_info (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void pc_pam_value_take_time_info (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer pc_pam_value_get_time_info (const GValue* value);
VALA_EXTERN GType pc_pam_time_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCPAMTimeInfo, pc_pam_time_info_unref)
VALA_EXTERN GList* pc_pam_token_get_times_info (PCPAMToken* self);
static void _pc_pam_time_info_unref0_ (gpointer var);
static inline void _g_list_free__pc_pam_time_info_unref0_ (GList* self);
VALA_EXTERN GType pc_pam_day_type_get_type (void) G_GNUC_CONST ;
static GTimeSpan pc_daemon_time_restriction_get_difference_span (PCDaemonTimeRestriction* self,
                                                          const gchar* estimated_time_str);
static void pc_daemon_time_restriction_start_loop (PCDaemonTimeRestriction* self,
                                            gint minutes);
static gboolean __lambda6_ (PCDaemonTimeRestriction* self);
static gboolean ___lambda6__gsource_func (gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN GType pc_daemon_server_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonServer, g_object_unref)
VALA_EXTERN guint pc_daemon_server_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN PCDaemonServer* pc_daemon_server_get_default (void);
static gboolean __lambda5_ (Block4Data* _data4_);
static gboolean ___lambda5__gsource_func (gpointer self);
static void pc_daemon_time_restriction_finalize (GObject * obj);
static GType pc_daemon_time_restriction_get_type_once (void);

static inline gpointer
pc_daemon_time_restriction_get_instance_private (PCDaemonTimeRestriction* self)
{
	return G_STRUCT_MEMBER_P (self, PCDaemonTimeRestriction_private_offset);
}

PCDaemonTimeRestriction*
pc_daemon_time_restriction_construct (GType object_type,
                                      PCDaemonUserConfig* config)
{
	PCDaemonTimeRestriction * self = NULL;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (config != NULL, NULL);
	self = (PCDaemonTimeRestriction*) pc_daemon_restriction_construct (object_type, config);
	_tmp0_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->timeout_ids);
	self->priv->timeout_ids = _tmp0_;
	return self;
}

PCDaemonTimeRestriction*
pc_daemon_time_restriction_new (PCDaemonUserConfig* config)
{
	return pc_daemon_time_restriction_construct (PC_DAEMON_TYPE_TIME_RESTRICTION, config);
}

static void
_pc_daemon_time_restriction_on_time_file_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                         GFile* file,
                                                                         GFile* other_file,
                                                                         GFileMonitorEvent event_type,
                                                                         gpointer self)
{
	pc_daemon_time_restriction_on_time_file_changed ((PCDaemonTimeRestriction*) self, file, other_file, event_type);
}

static void
pc_daemon_time_restriction_real_start (PCDaemonRestriction* base)
{
	PCDaemonTimeRestriction * self;
	GFile* _tmp0_;
	PCPAMToken* token = NULL;
	PCDaemonUserConfig* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	PCPAMToken* _tmp5_;
	PCPAMToken* _tmp6_;
	GError* _inner_error0_ = NULL;
	self = (PCDaemonTimeRestriction*) base;
	_tmp0_ = self->priv->time_file;
	if (_tmp0_ == NULL) {
		GFile* _tmp1_;
		_tmp1_ = g_file_new_for_path (PC_CONSTANTS_PAM_TIME_CONF_PATH);
		_g_object_unref0 (self->priv->time_file);
		self->priv->time_file = _tmp1_;
	}
	_tmp2_ = ((PCDaemonRestriction*) self)->config;
	_tmp3_ = pc_daemon_user_config_get_username (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = pc_pam_reader_get_token_for_user (PC_CONSTANTS_PAM_TIME_CONF_PATH, _tmp4_);
	token = _tmp5_;
	_tmp6_ = token;
	if (_tmp6_ != NULL) {
		PCPAMToken* _tmp7_;
		_tmp7_ = token;
		pc_daemon_time_restriction_process_token (self, _tmp7_);
	}
	{
		GFileMonitor* _tmp8_ = NULL;
		GFile* _tmp9_;
		GFileMonitor* _tmp10_;
		GFileMonitor* _tmp11_;
		GFileMonitor* _tmp12_;
		_tmp9_ = self->priv->time_file;
		_tmp10_ = g_file_monitor (_tmp9_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		_g_object_unref0 (self->priv->monitor);
		self->priv->monitor = _tmp11_;
		_tmp12_ = self->priv->monitor;
		g_signal_connect_object (_tmp12_, "changed", (GCallback) _pc_daemon_time_restriction_on_time_file_changed_g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp8_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_critical ("TimeRestriction.vala:55: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (token);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (token);
}

static void
pc_daemon_time_restriction_real_stop (PCDaemonRestriction* base)
{
	PCDaemonTimeRestriction * self;
	GFileMonitor* _tmp0_;
	GeeArrayList* _tmp10_;
	self = (PCDaemonTimeRestriction*) base;
	_tmp0_ = self->priv->monitor;
	if (_tmp0_ != NULL) {
		GFileMonitor* _tmp1_;
		_tmp1_ = self->priv->monitor;
		g_file_monitor_cancel (_tmp1_);
	}
	{
		GeeArrayList* _timeout_id_list = NULL;
		GeeArrayList* _tmp2_;
		gint _timeout_id_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _timeout_id_index = 0;
		_tmp2_ = self->priv->timeout_ids;
		_timeout_id_list = _tmp2_;
		_tmp3_ = _timeout_id_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_timeout_id_size = _tmp5_;
		_timeout_id_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			guint timeout_id = 0U;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			_timeout_id_index = _timeout_id_index + 1;
			_tmp6_ = _timeout_id_index;
			_tmp7_ = _timeout_id_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _timeout_id_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _timeout_id_index);
			timeout_id = (guint) ((guintptr) _tmp9_);
			g_source_remove (timeout_id);
		}
	}
	_tmp10_ = self->priv->timeout_ids;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp10_);
	self->priv->update_timeout_id = 0U;
}

static void
pc_daemon_time_restriction_update (PCDaemonTimeRestriction* self)
{
	g_return_if_fail (self != NULL);
	pc_daemon_restriction_stop ((PCDaemonRestriction*) self);
	pc_daemon_restriction_start ((PCDaemonRestriction*) self);
}

static gboolean
__lambda7_ (PCDaemonTimeRestriction* self)
{
	gboolean result;
	self->priv->update_timeout_id = 0U;
	pc_daemon_time_restriction_update (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda7_ ((PCDaemonTimeRestriction*) self);
	return result;
}

static void
pc_daemon_time_restriction_on_time_file_changed (PCDaemonTimeRestriction* self,
                                                 GFile* file,
                                                 GFile* other,
                                                 GFileMonitorEvent type)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	if (type != G_FILE_MONITOR_EVENT_CHANGED) {
		_tmp0_ = type != G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	g_source_remove (self->priv->update_timeout_id);
	self->priv->update_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, PC_DAEMON_TIME_RESTRICTION_UPDATE_THROTTLE_INTERVAL, ___lambda7__gsource_func, g_object_ref (self), g_object_unref);
}

static void
_pc_pam_time_info_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (pc_pam_time_info_unref (var), NULL));
}

static inline void
_g_list_free__pc_pam_time_info_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _pc_pam_time_info_unref0_);
}

static gpointer
_pc_pam_time_info_ref0 (gpointer self)
{
	return self ? pc_pam_time_info_ref (self) : NULL;
}

static gboolean
__lambda6_ (PCDaemonTimeRestriction* self)
{
	gboolean result;
	pc_daemon_restriction_stop ((PCDaemonRestriction*) self);
	pc_daemon_restriction_start ((PCDaemonRestriction*) self);
	result = TRUE;
	return result;
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ ((PCDaemonTimeRestriction*) self);
	return result;
}

static void
pc_daemon_time_restriction_process_token (PCDaemonTimeRestriction* self,
                                          PCPAMToken* token)
{
	GList* times_info = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	PCPAMTimeInfo* current = NULL;
	gint day_of_week = 0;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gint _tmp4_;
	GList* _tmp5_;
	PCPAMTimeInfo* _tmp16_;
	GTimeSpan span = 0LL;
	PCPAMTimeInfo* _tmp17_;
	const gchar* _tmp18_;
	gint minutes = 0;
	guint tid = 0U;
	GeeArrayList* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (token != NULL);
	_tmp0_ = pc_pam_token_get_times_info (token);
	times_info = _tmp0_;
	_tmp1_ = times_info;
	if (g_list_length (_tmp1_) == ((guint) 0)) {
		(times_info == NULL) ? NULL : (times_info = (_g_list_free__pc_pam_time_info_unref0_ (times_info), NULL));
		return;
	}
	current = NULL;
	_tmp2_ = g_date_time_new_now_local ();
	_tmp3_ = _tmp2_;
	_tmp4_ = g_date_time_get_day_of_week (_tmp3_);
	_g_date_time_unref0 (_tmp3_);
	day_of_week = _tmp4_;
	_tmp5_ = times_info;
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp5_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			PCPAMTimeInfo* _tmp6_;
			PCPAMTimeInfo* info = NULL;
			_tmp6_ = _pc_pam_time_info_ref0 ((PCPAMTimeInfo*) info_it->data);
			info = _tmp6_;
			{
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				if (day_of_week < 6) {
					PCPAMTimeInfo* _tmp10_;
					_tmp10_ = info;
					_tmp9_ = _tmp10_->day_type == PC_PAM_DAY_TYPE_WEEKDAY;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					_tmp8_ = TRUE;
				} else {
					gboolean _tmp11_ = FALSE;
					if (day_of_week >= 6) {
						PCPAMTimeInfo* _tmp12_;
						_tmp12_ = info;
						_tmp11_ = _tmp12_->day_type == PC_PAM_DAY_TYPE_WEEKEND;
					} else {
						_tmp11_ = FALSE;
					}
					_tmp8_ = _tmp11_;
				}
				if (_tmp8_) {
					_tmp7_ = TRUE;
				} else {
					PCPAMTimeInfo* _tmp13_;
					_tmp13_ = info;
					_tmp7_ = _tmp13_->day_type == PC_PAM_DAY_TYPE_ALL;
				}
				if (_tmp7_) {
					PCPAMTimeInfo* _tmp14_;
					PCPAMTimeInfo* _tmp15_;
					_tmp14_ = info;
					_tmp15_ = _pc_pam_time_info_ref0 (_tmp14_);
					_pc_pam_time_info_unref0 (current);
					current = _tmp15_;
					_pc_pam_time_info_unref0 (info);
					break;
				}
				_pc_pam_time_info_unref0 (info);
			}
		}
	}
	_tmp16_ = current;
	if (_tmp16_ == NULL) {
		_pc_pam_time_info_unref0 (current);
		(times_info == NULL) ? NULL : (times_info = (_g_list_free__pc_pam_time_info_unref0_ (times_info), NULL));
		return;
	}
	_tmp17_ = current;
	_tmp18_ = _tmp17_->to;
	span = pc_daemon_time_restriction_get_difference_span (self, _tmp18_);
	minutes = abs ((gint) (span / G_TIME_SPAN_MINUTE));
	if (minutes > 0) {
		pc_daemon_time_restriction_start_loop (self, minutes);
	} else {
		g_signal_emit (self, pc_daemon_time_restriction_signals[PC_DAEMON_TIME_RESTRICTION_TERMINATE_SIGNAL], 0);
	}
	tid = 0U;
	tid = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) (PC_DAEMON_TIME_RESTRICTION_HOUR_INTERVAL * 24), ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
	_tmp19_ = self->priv->timeout_ids;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, (gpointer) ((guintptr) tid));
	_pc_pam_time_info_unref0 (current);
	(times_info == NULL) ? NULL : (times_info = (_g_list_free__pc_pam_time_info_unref0_ (times_info), NULL));
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static GTimeSpan
pc_daemon_time_restriction_get_difference_span (PCDaemonTimeRestriction* self,
                                                const gchar* estimated_time_str)
{
	gint hour = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint minute = 0;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	GDateTime* current_date = NULL;
	GDateTime* _tmp6_;
	gint _tmp7_ = 0;
	GDateTime* _tmp8_;
	GDateTime* estimated_date = NULL;
	GDateTime* _tmp9_;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_;
	GTimeSpan result;
	g_return_val_if_fail (self != NULL, 0LL);
	g_return_val_if_fail (estimated_time_str != NULL, 0LL);
	_tmp0_ = string_slice (estimated_time_str, (glong) 0, (glong) 2);
	_tmp1_ = _tmp0_;
	_tmp2_ = atoi (_tmp1_);
	_g_free0 (_tmp1_);
	hour = _tmp2_;
	_tmp3_ = string_substring (estimated_time_str, (glong) 2, (glong) -1);
	_tmp4_ = _tmp3_;
	_tmp5_ = atoi (_tmp4_);
	_g_free0 (_tmp4_);
	minute = _tmp5_;
	if (hour == 24) {
		hour = 0;
	}
	_tmp6_ = g_date_time_new_now_local ();
	current_date = _tmp6_;
	_tmp8_ = current_date;
	if (hour < g_date_time_get_hour (_tmp8_)) {
		_tmp7_ = 1;
	} else {
		_tmp7_ = 0;
	}
	_tmp9_ = current_date;
	_tmp10_ = current_date;
	_tmp11_ = current_date;
	_tmp12_ = g_date_time_add_full (_tmp9_, 0, 0, _tmp7_, hour - g_date_time_get_hour (_tmp10_), minute - g_date_time_get_minute (_tmp11_), (gdouble) 0);
	estimated_date = _tmp12_;
	_tmp13_ = current_date;
	result = g_date_time_difference (estimated_date, _tmp13_);
	_g_date_time_unref0 (estimated_date);
	_g_date_time_unref0 (current_date);
	return result;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		PCDaemonTimeRestriction* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gboolean
__lambda5_ (Block4Data* _data4_)
{
	PCDaemonTimeRestriction* self;
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GeeArrayList* _tmp6_;
	gboolean result;
	self = _data4_->self;
	_tmp0_ = _data4_->minutes;
	_data4_->minutes = _tmp0_ - 1;
	if (_data4_->minutes == PC_DAEMON_TIME_RESTRICTION_MINUTE_INTERVAL) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = _data4_->minutes == 10;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = _data4_->minutes == 5;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = _data4_->minutes == 1;
	}
	if (_tmp1_) {
		PCDaemonServer* _tmp4_;
		PCDaemonServer* _tmp5_;
		_tmp4_ = pc_daemon_server_get_default ();
		_tmp5_ = _tmp4_;
		g_signal_emit_by_name (_tmp5_, "show-timeout", _data4_->minutes / PC_DAEMON_TIME_RESTRICTION_MINUTE_INTERVAL, _data4_->minutes % PC_DAEMON_TIME_RESTRICTION_MINUTE_INTERVAL);
		_g_object_unref0 (_tmp5_);
	}
	if (_data4_->minutes == 0) {
		g_signal_emit (self, pc_daemon_time_restriction_signals[PC_DAEMON_TIME_RESTRICTION_TERMINATE_SIGNAL], 0);
	} else {
		if (_data4_->minutes > 0) {
			result = TRUE;
			return result;
		}
	}
	_tmp6_ = self->priv->timeout_ids;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp6_, (gpointer) ((guintptr) _data4_->tid));
	result = FALSE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ (self);
	return result;
}

static void
pc_daemon_time_restriction_start_loop (PCDaemonTimeRestriction* self,
                                       gint minutes)
{
	Block4Data* _data4_;
	PCDaemonServer* _tmp0_;
	PCDaemonServer* _tmp1_;
	GeeArrayList* _tmp2_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->minutes = minutes;
	_tmp0_ = pc_daemon_server_get_default ();
	_tmp1_ = _tmp0_;
	g_signal_emit_by_name (_tmp1_, "show-timeout", _data4_->minutes / PC_DAEMON_TIME_RESTRICTION_MINUTE_INTERVAL, _data4_->minutes % PC_DAEMON_TIME_RESTRICTION_MINUTE_INTERVAL);
	_g_object_unref0 (_tmp1_);
	_data4_->tid = 0U;
	_data4_->tid = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) PC_DAEMON_TIME_RESTRICTION_MINUTE_INTERVAL, ___lambda5__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	_tmp2_ = self->priv->timeout_ids;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, (gpointer) ((guintptr) _data4_->tid));
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
pc_daemon_time_restriction_class_init (PCDaemonTimeRestrictionClass * klass,
                                       gpointer klass_data)
{
	pc_daemon_time_restriction_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PCDaemonTimeRestriction_private_offset);
	((PCDaemonRestrictionClass *) klass)->start = (void (*) (PCDaemonRestriction*)) pc_daemon_time_restriction_real_start;
	((PCDaemonRestrictionClass *) klass)->stop = (void (*) (PCDaemonRestriction*)) pc_daemon_time_restriction_real_stop;
	G_OBJECT_CLASS (klass)->finalize = pc_daemon_time_restriction_finalize;
	pc_daemon_time_restriction_signals[PC_DAEMON_TIME_RESTRICTION_TERMINATE_SIGNAL] = g_signal_new ("terminate", PC_DAEMON_TYPE_TIME_RESTRICTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
pc_daemon_time_restriction_instance_init (PCDaemonTimeRestriction * self,
                                          gpointer klass)
{
	self->priv = pc_daemon_time_restriction_get_instance_private (self);
	self->priv->update_timeout_id = 0U;
}

static void
pc_daemon_time_restriction_finalize (GObject * obj)
{
	PCDaemonTimeRestriction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_DAEMON_TYPE_TIME_RESTRICTION, PCDaemonTimeRestriction);
	_g_object_unref0 (self->priv->time_file);
	_g_object_unref0 (self->priv->monitor);
	_g_object_unref0 (self->priv->timeout_ids);
	G_OBJECT_CLASS (pc_daemon_time_restriction_parent_class)->finalize (obj);
}

static GType
pc_daemon_time_restriction_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCDaemonTimeRestrictionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_daemon_time_restriction_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PCDaemonTimeRestriction), 0, (GInstanceInitFunc) pc_daemon_time_restriction_instance_init, NULL };
	GType pc_daemon_time_restriction_type_id;
	pc_daemon_time_restriction_type_id = g_type_register_static (PC_DAEMON_TYPE_RESTRICTION, "PCDaemonTimeRestriction", &g_define_type_info, 0);
	PCDaemonTimeRestriction_private_offset = g_type_add_instance_private (pc_daemon_time_restriction_type_id, sizeof (PCDaemonTimeRestrictionPrivate));
	return pc_daemon_time_restriction_type_id;
}

GType
pc_daemon_time_restriction_get_type (void)
{
	static volatile gsize pc_daemon_time_restriction_type_id__once = 0;
	if (g_once_init_enter (&pc_daemon_time_restriction_type_id__once)) {
		GType pc_daemon_time_restriction_type_id;
		pc_daemon_time_restriction_type_id = pc_daemon_time_restriction_get_type_once ();
		g_once_init_leave (&pc_daemon_time_restriction_type_id__once, pc_daemon_time_restriction_type_id);
	}
	return pc_daemon_time_restriction_type_id__once;
}

